/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.oracle;

import com.huawei.db.migration.database.bo.IQueryPatternsBO;
import com.huawei.db.migration.exception.MigrationServiceException;
import com.huawei.db.migration.interfaces.IMigrationParser;
import com.huawei.db.migration.interfaces.IReplacerMap;
import com.huawei.db.migration.util.ErrorLoggerUtility;
import com.huawei.db.migration.util.MessageLoader;
import com.huawei.db.migration.util.QueryConversionUtility;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OracleParser
implements IMigrationParser {
    private static final Logger logger = LogManager.getLogger(OracleParser.class);

    @Override
    public IReplacerMap doParsing(String sqlQuery, IQueryPatternsBO mapper, IReplacerMap parserMap) throws MigrationServiceException {
        Pattern oraclePattern = Pattern.compile(mapper.getFinderPattern(), 2);
        Matcher oracleMatcher = oraclePattern.matcher(sqlQuery);
        boolean isExcludeValidation = QueryConversionUtility.excludePatternValidation(mapper.getExcludePattern(), sqlQuery);
        Map<String, String> tokens = mapper.getReplacementMapAtt();
        if (oracleMatcher.find() && isExcludeValidation) {
            logger.debug("Query Pattern Match Found - Pattern Name: {}", (Object)mapper.getName());
            String oracleKey = null;
            String queryGrp = null;
            for (Map.Entry<String, String> token : tokens.entrySet()) {
                oracleKey = token.getKey();
                int group = 0;
                try {
                    group = Integer.parseInt(token.getValue());
                }
                catch (NumberFormatException e) {
                    logger.error(ErrorLoggerUtility.getExceptionDetails(e) + " Error while converting from string to int for value=" + token.getValue());
                    throw new MigrationServiceException("[DSC_ERR_004_018] " + MessageLoader.getMessage("DSC_ERR_004_018"));
                }
                queryGrp = oracleMatcher.group(group);
                if (queryGrp != null) {
                    parserMap.put(oracleKey, queryGrp.trim());
                    continue;
                }
                parserMap.put(oracleKey, "");
            }
            parserMap.put("sqlquery", sqlQuery);
        }
        return parserMap;
    }
}

