/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.oracle;

import com.huawei.db.migration.oracle.OracleBLogicHandler;
import com.huawei.db.migration.oracle.OracleUtility;
import com.huawei.db.migration.services.OracleMigrationService;
import com.huawei.db.migration.util.ColumnSplitter;
import com.huawei.db.migration.util.ErrorLoggerUtility;
import com.huawei.db.migration.util.FeatureLoader;
import com.huawei.db.migration.util.FeatureLoaderExtended;
import com.huawei.db.migration.util.IGaussDBConstants;
import com.huawei.db.migration.util.QueryConversionUtility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OraclePostMigrationHandler {
    private static final Logger logger = LogManager.getLogger(OraclePostMigrationHandler.class);
    private static final Pattern PAT_REF_CURSOR = Pattern.compile("(?i)CREATE\\s*OR\\s*REPLACE\\s*(?:FUNCTION|PACKAGE|PROCEDURE)(.*?)(?:(?<!\\w)(?:AS|IS)(?!\\w|\\s+function|\\s+procedure))(.*?)((?:#S#\\d+#E#\\s*)*(?<!\\w)BEGIN(?!\\w).*?(?<!\\w)END(?!\\w).*?\\;.*?\\s*\\/)");
    private static final Pattern FUNCTION_PROCEDURE_PAT = Pattern.compile("(?i)(FUNCTION|PROCEDURE)");
    private static final Pattern BEGIN_PAT = Pattern.compile("(?i).*?(?<!\\w)(?:as|is)(?!\\w)(.*?)(?<!\\w)(begin)(?!\\w).*");
    private static final Pattern RETURN_STMT_PAT = Pattern.compile("(?i)(?<!\\w)return(?!\\w).*?;");
    private static final Pattern END_PAT = Pattern.compile("(?i)(.*)end\\s*(\\w+)?;\\s*(?:#s#\\d+#e#\\s*)*?\\/");
    private static final Pattern END_WITH_SEMICOLON_PAT = Pattern.compile("(?i)(.*)end\\s*(?:\\w+\\s*)?;\\s*(?:#s#\\d+#e#\\s*)*?");
    private static final Pattern EXCEPTION_PATTERN = Pattern.compile("(?i)(?<!\\w)(begin|exception|end\\s*;)(?!\\w)");
    private static final Pattern WHEN_THEN_PAT = Pattern.compile("(?i)(WHEN(.*?)THEN).*");
    private static final Pattern TYPE_PATTERN = Pattern.compile("(?i)((?<!\\*)(\\w+)\\s+(\\w+\\.?\\w*).*?)");
    private static final Pattern PAT_SELECT_FROM = Pattern.compile("(?i)(?<!\\w)select(?!\\w).*(?<!\\w)into(?!\\w).*?(?<!\\w)from");
    private static final Pattern PAT_DML = Pattern.compile("(?i)(.*?)((?<!\\w)select\\s+.*)");
    private List<String> outputList = null;
    private String pkgReplacement = null;
    private String varName;
    private String schemaNme = null;
    private String pkgNme;
    private boolean processPkgFlag;

    public List<String> doPostProcess(String fileName, List<String> inputList, Set<String> packageName, String task) {
        this.pkgReplacement = null;
        this.outputList = new ArrayList<String>(inputList.size());
        StringBuffer grantSb = new StringBuffer();
        boolean grantRequired = this.grantRequired(inputList, task);
        Iterator<String> iterator = inputList.iterator();
        while (iterator.hasNext()) {
            String input;
            String output = input = iterator.next();
            try {
                if ("bulk".equalsIgnoreCase(task)) {
                    output = this.doPrimaryKeyConstraint(inputList, output);
                } else {
                    Matcher matchPkg = Pattern.compile("(?i)(?<!\\w)create\\s+or\\s+replace\\s+(?:(?:FUNCTION|PROCEDURE)\\s+(?:\\w+\\.)?(\\w+)(?:\\.|#)\\w+|(?:PACKAGE\\s+BODY)\\s+\\w+\\.(\\w+)).*?\\/").matcher(output);
                    this.pkgNme = "";
                    if (matchPkg.find()) {
                        this.pkgNme = matchPkg.group(1);
                        if (this.pkgNme == null || this.pkgNme.isEmpty()) {
                            this.pkgNme = matchPkg.group(2);
                        }
                    }
                    if (QueryConversionUtility.isGaus100() && !FeatureLoaderExtended.getBooleanProperty("supportPkgSplitDBT")) {
                        List<String> procs = OraclePostMigrationHandler.getSubProc(output);
                        for (String proc : procs) {
                            String procOut = this.doGetFinalOut(packageName, task, proc, this.pkgNme);
                            output = output.replace(proc, procOut);
                        }
                    } else if (!output.matches("(?i)(?<!\\w)grant\\s+execute\\s+on\\s+function.*;")) {
                        output = this.doGetFinalOut(packageName, task, output, this.pkgNme);
                    }
                    this.addGrant(grantSb, grantRequired, output);
                }
                this.outputList.add(output);
            }
            catch (RuntimeException e) {
                logger.error(ErrorLoggerUtility.getExceptionDetails(e) + " Error occured in post processing. " + e.getMessage());
                this.outputList.add(output);
            }
        }
        if (grantRequired) {
            this.outputList.add(grantSb.toString());
        }
        return this.outputList;
    }

    private static List<String> getSubProc(String input) {
        ArrayList<String> list = new ArrayList<String>();
        Matcher matcher = FUNCTION_PROCEDURE_PAT.matcher(input);
        int prevIndex = -1;
        while (matcher.find()) {
            int index = matcher.start();
            if (prevIndex != -1) {
                list.add(input.substring(prevIndex, index));
            }
            prevIndex = index;
        }
        if (prevIndex != -1) {
            String proc = input.substring(prevIndex).replaceFirst("(?i)\\s*END\\s+\\w*\\s*;\\s*\\/", "");
            proc = proc.replace(IGaussDBConstants.NEW_LINE, "");
            list.add(proc);
        }
        return list;
    }

    public String doGetFinalOut(Set<String> packageName, String task, String input, String pkgNme) {
        String output = input;
        if (!"none".equalsIgnoreCase(FeatureLoader.getStringProperty("pkgvariable"))) {
            if (QueryConversionUtility.equalCheck(FeatureLoader.getStringProperty("plsqlCollection"), "VARRAY") || QueryConversionUtility.isGaus100()) {
                for (String pkg : packageName) {
                    this.pkgReplacement = this.getPkgReplacementVal(task, output, pkg);
                    if (this.pkgReplacement == null) continue;
                    if (this.pkgReplacement.equals("SYS_REFCURSOR")) {
                        output = this.handleRefCursor(pkg, output);
                    } else if (this.pkgReplacement.trim().matches("(?i)(subtype\\s+(\\w+)\\s+(?:is|as)\\s+(.*?)(;|$))")) {
                        output = this.handleSubType(pkg, output);
                    }
                    output = OraclePostMigrationHandler.doTypeRefCursor(output, pkg, this.pkgReplacement);
                }
            }
            output = this.getFinalOutput(packageName, task, output, pkgNme);
        }
        return output;
    }

    private void addGrant(StringBuffer grantSb, boolean grantRequired, String input) {
        if (grantRequired) {
            OracleBLogicHandler handler = new OracleBLogicHandler();
            String temp = handler.handleGrant(input, false);
            grantSb.append(temp.replace(input, ""));
        }
    }

    private boolean grantRequired(List<String> inputList, String task) {
        boolean grantRequired = false;
        if (!"bulk".equalsIgnoreCase(task) && inputList.size() > 1) {
            String last = inputList.get(inputList.size() - 1);
            grantRequired = !FeatureLoaderExtended.getBooleanProperty("addPackageNameList") ? !last.startsWith("GRANT EXECUTE ON FUNCTION ") : !last.startsWith("reset package_name_list ; GRANT EXECUTE ON FUNCTION ");
        }
        return grantRequired;
    }

    private String handleSubType(String pkg, String input) {
        String output = input;
        Pattern pattern = Pattern.compile("(?i)(subtype\\s+(\\w+)\\s+(?:is|as)\\s+(.*?)(;|$))");
        Matcher matcher = pattern.matcher(this.pkgReplacement);
        this.varName = "";
        String datatype = "";
        if (matcher.find()) {
            this.varName = matcher.group(2);
            datatype = matcher.group(3);
        }
        pattern = Pattern.compile("(?i).*?(?<!\\w)(?:as|is)(?!\\w)(.*?)(?<!\\w)(begin)(?!\\w).*");
        matcher = pattern.matcher(output);
        StringBuffer sb = new StringBuffer();
        if (matcher.find()) {
            int startIndex = matcher.start(1);
            String declareOp = matcher.group(1);
            int endIndex = startIndex;
            sb.append(output.substring(0, startIndex));
            if (QueryConversionUtility.containsCheck(declareOp, this.varName)) {
                endIndex = this.getEndIndex(pkg, datatype, sb, declareOp, endIndex);
            }
            sb.append(" ").append(output.substring(endIndex));
            output = sb.toString();
        }
        return output;
    }

    private int getEndIndex(String pkg, String datatype, StringBuffer sb, String declareOp, int endIdx) {
        int endIndex = endIdx;
        List<String> colList = Arrays.asList(declareOp.split(";"));
        for (String declareStr : colList) {
            if (!declareStr.trim().isEmpty() && !QueryConversionUtility.containsCheck(declareStr, "MIGORAEXT.MIG_FN_GET_PKG_VARIABLE")) {
                if (!declareStr.trim().startsWith("TYPE")) {
                    String[] pkgArr = pkg.split("\\.");
                    this.pkgNme = "";
                    if (pkgArr.length > 1) {
                        this.pkgNme = pkgArr[pkgArr.length - 2];
                    }
                    this.pkgNme = this.pkgNme.isEmpty() ? "" : this.pkgNme + ".";
                    sb.append(" ").append(QueryConversionUtility.replaceAll(declareStr, "(?i)\\s+(" + this.pkgNme + ")?" + QueryConversionUtility.santizePattern(this.varName) + "\\s*(?=(;|:=|$))", " " + datatype + " ")).append(";");
                }
                ++endIndex;
            } else {
                sb.append(declareStr);
                if (!declareStr.trim().isEmpty()) {
                    sb.append(";");
                    ++endIndex;
                }
            }
            endIndex += declareStr.length();
        }
        return endIndex;
    }

    private String handleRefCursor(String pkg, String input) {
        String output = input;
        Matcher matcher = PAT_REF_CURSOR.matcher(output);
        matcher = OraclePostMigrationHandler.migGaussDBT(output, matcher);
        int endIndex = 0;
        int startIndex = 0;
        int beginIndex = 0;
        StringBuffer buffer = new StringBuffer();
        String matcherStr = null;
        while (matcher.find()) {
            beginIndex = matcher.start();
            endIndex = matcher.end();
            buffer.append(output.substring(startIndex, beginIndex));
            matcherStr = output.substring(beginIndex, endIndex);
            String replacementString = null;
            if (matcher.group(1) != null) {
                replacementString = matcher.group(1);
                replacementString = replacementString.replaceAll("(?i)((out|in|inout|return)\\s+)(\\w*\\.)?(?<!\\w)" + QueryConversionUtility.santizePattern(pkg) + "(?!\\w)", "$1" + this.pkgReplacement);
                matcherStr = matcherStr.replace(matcher.group(1), replacementString);
            }
            if (matcher.group(3) != null) {
                replacementString = matcher.group(3);
                replacementString = replacementString.replaceAll("(?i)((out|in|inout)\\s+)(\\w*\\.)?(?<!\\w)" + QueryConversionUtility.santizePattern(pkg) + "(?!\\w)", "$1" + this.pkgReplacement);
                matcherStr = matcherStr.replace(matcher.group(3), replacementString);
            }
            buffer.append(matcherStr);
            startIndex = endIndex;
        }
        output = buffer.append(output.substring(endIndex)).toString();
        return output;
    }

    private String getFinalOutput(Set<String> packageName, String task, String input, String pkgNme) {
        String output = input;
        if (!QueryConversionUtility.equalCheck(FeatureLoader.getStringProperty("pkgvariable"), "none")) {
            HashSet<String> getVars = new HashSet<String>(10);
            for (String pkg : packageName) {
                if (!QueryConversionUtility.containsCheck(pkg, pkgNme) && !QueryConversionUtility.containsCheck(input, pkg)) continue;
                this.pkgReplacement = this.getPkgReplacementVal(task, output, pkg);
                if (this.pkgReplacement == null || !this.pkgReplacement.contains("-")) continue;
                output = this.processPackageHypen(pkg, getVars, output);
            }
            output = this.addGetAndSetVars(getVars, output);
        }
        return output;
    }

    private String addGetAndSetVars(Set<String> getVars, String input) {
        String outputQry = input;
        Pattern beginPat = BEGIN_PAT;
        if (QueryConversionUtility.isGaus100() && !FeatureLoaderExtended.getBooleanProperty("supportPkgSplitDBT")) {
            beginPat = Pattern.compile("(?i).*?(?<!\\w)(?:procedure|function).*?(?:as|is)(?!\\w)(.*?)(?<!\\w)(begin)(?!\\w).*");
        }
        Matcher beginMatch = beginPat.matcher(input);
        String variablePart = null;
        StringBuffer migIntoVar = new StringBuffer(" ");
        if (beginMatch.find()) {
            variablePart = beginMatch.group(1).trim();
            migIntoVar.append(variablePart).append(" ");
            StringBuffer setVar = new StringBuffer(" ");
            for (String varRpl : getVars) {
                if (varRpl.endsWith("EXCEPTION;")) {
                    migIntoVar.append(varRpl);
                    continue;
                }
                this.getSetVar(migIntoVar, setVar, varRpl);
            }
            outputQry = input.substring(0, beginMatch.start(1)) + migIntoVar.toString() + " " + input.substring(beginMatch.start(2));
            outputQry = this.addSetFunctionForPkgVar(outputQry, setVar.toString());
        }
        return outputQry;
    }

    private void getSetVar(StringBuffer migIntoVar, StringBuffer setVar, String varRpl) {
        int index = varRpl.indexOf("~~");
        if (index != -1 && index + 2 <= varRpl.length()) {
            StringBuffer getVar = new StringBuffer(" ");
            String varValue = varRpl.substring(0, index);
            String vars = "MIG_PV_VAL_DUMMY_" + QueryConversionUtility.toUpper(varRpl.substring(0, index));
            String rpl = varRpl.substring(index + 2);
            String pkgName = null;
            int indexDoubleColon = rpl.indexOf("::");
            if (indexDoubleColon != -1 && indexDoubleColon + 2 < rpl.length()) {
                String dataType = rpl.substring(indexDoubleColon + 2);
                getVar.append(vars).append(" ").append(dataType).append(" ").append(":=").append(" ").append(rpl).append(" ").append(";").append(" ");
                migIntoVar.insert(0, getVar);
            }
            if (QueryConversionUtility.equalCheck(FeatureLoader.getStringProperty("pkgvariable"), "localtable") || QueryConversionUtility.isGaus100()) {
                pkgName = rpl.split(",")[1];
                setVar.append("MIG_ORA_EXT.").append("MIG_FN_SET_PKG_VARIABLE").append("(");
                String schemaName = QueryConversionUtility.finderGroup(rpl, "(?i)MIG_ORA_EXT\\.MIG_FN_GET_PKG_VARIABLE\\s*\\((.*?),", 1);
                setVar.append(schemaName);
                setVar.append(",");
            } else if (QueryConversionUtility.equalCheck(FeatureLoader.getStringProperty("pkgvariable"), "sys_set_context")) {
                pkgName = rpl.substring(rpl.indexOf("(") + 1).split(",")[0];
                setVar.append("DBMS_SESSION.SET_CONTEXT").append("(");
            }
            setVar.append(pkgName).append(",").append("'").append(varValue).append("'").append(",").append(vars).append(")").append(";");
        }
    }

    private String addSetFunctionForPkgVar(String input, String setVar) {
        String outputQry = input;
        Pattern patternType = Pattern.compile("(?i)(.*?(?<!\\w)declare|.*?(?<!\\w)(?:as|is)(?!\\w))(?!\\w)(.*?)((?<!\\w)begin(?!\\w).*)");
        Matcher matcherType = patternType.matcher(input);
        Pattern excePat = null;
        if (matcherType.find()) {
            String header = matcherType.group(1);
            String declare = matcherType.group(2);
            String begin = matcherType.group(3);
            if (begin != null) {
                HashMap<String, String> quoteList = new HashMap<String, String>(10);
                begin = QueryConversionUtility.getSingleOrDoubleQuoteMap(begin, quoteList, "'", "\\'.*?\\'", "~#~~#~~");
                Matcher matcher = RETURN_STMT_PAT.matcher(begin);
                StringBuffer sb = new StringBuffer();
                int startIdx = 0;
                int tempIdx = 0;
                while (matcher.find()) {
                    startIdx = matcher.start();
                    sb = sb.append(begin.substring(tempIdx, startIdx)).append(setVar).append(" ");
                    tempIdx = startIdx;
                }
                sb.append(begin.substring(tempIdx));
                excePat = sb.toString().matches("(?i).*(?<!\\w)return(?!\\w)(?:(?!;).)*?;\\s*(#S#\\d+#E#\\s*)*end\\s*;.*") ? null : END_PAT;
                if (QueryConversionUtility.isGaus100() && !FeatureLoaderExtended.getBooleanProperty("supportPkgSplitDBT") && excePat != null) {
                    excePat = END_WITH_SEMICOLON_PAT;
                }
                if (QueryConversionUtility.containsCheck(begin = this.doAddSetPckgVar(setVar, excePat, sb.toString()), "EXCEPTION")) {
                    begin = this.doAddSetPckgVarInExcptnBlock(begin, setVar);
                }
                begin = QueryConversionUtility.getRplFromMap(begin, quoteList, "(~#~~#~~\\d+#)");
            }
            outputQry = header + " " + declare + " " + begin;
        }
        return outputQry;
    }

    private String doAddSetPckgVarInExcptnBlock(String begin, String setVar) {
        String beginOutput = begin;
        Matcher matcher = EXCEPTION_PATTERN.matcher(begin);
        StringBuffer beginBuffer = new StringBuffer();
        int beginCount = 0;
        int index = -1;
        while (matcher.find()) {
            String word = matcher.group();
            if ("BEGIN".equalsIgnoreCase(word)) {
                ++beginCount;
                continue;
            }
            if (QueryConversionUtility.toUpper(word).startsWith("END")) {
                --beginCount;
                continue;
            }
            if (beginCount != 1 && !"exception".equalsIgnoreCase(word)) continue;
            index = matcher.start();
        }
        if (index != -1) {
            beginBuffer.append(begin.substring(0, index));
            String exceptionBlock = begin.substring(index);
            exceptionBlock = QueryConversionUtility.doGetPatternMatch("(?i)EXCEPTION\\s*(?:\\s*#S#\\d+#E#)?\\s*WHEN.*?;(\\s*#S#\\d+#E#)?(?=\\s*END\\s*;)", exceptionBlock);
            index += exceptionBlock.length();
            exceptionBlock = this.doHandlePkgVarInExceptionBlock(exceptionBlock, setVar);
            beginBuffer.append(setVar).append(exceptionBlock).append(begin.substring(index));
            beginOutput = beginBuffer.toString();
        }
        return beginOutput;
    }

    private String doHandlePkgVarInExceptionBlock(String exceptionBlock, String setVar) {
        Pattern exceptionPattern = Pattern.compile("(?i)WHEN(.*?)THEN.*?;\\s*(\\s*#S#\\d+#E#)?(?=\\s*(WHEN|$))");
        Matcher matcher = exceptionPattern.matcher(exceptionBlock);
        StringBuffer beginBuffer = new StringBuffer();
        int tempIndex = 0;
        while (matcher.find()) {
            int startIndex = matcher.start();
            int endIndex = matcher.end();
            beginBuffer.append(exceptionBlock.substring(tempIndex, startIndex));
            String exception = matcher.group();
            if (!QueryConversionUtility.containsCheck(exception, setVar)) {
                exception = this.doAddSetPckgVar(setVar, WHEN_THEN_PAT, exception);
            }
            beginBuffer.append(exception);
            tempIndex = endIndex;
        }
        beginBuffer.append(exceptionBlock.substring(tempIndex));
        return beginBuffer.toString();
    }

    private String doAddSetPckgVar(String setVar, Pattern excePat, String beginQry) {
        Matcher exceMatch;
        String begin = beginQry;
        if (excePat != null && (exceMatch = excePat.matcher(begin)).find()) {
            int startIndex = exceMatch.end(1);
            begin = begin.substring(0, startIndex) + setVar + " " + begin.substring(startIndex);
        }
        return begin;
    }

    private static String doTypeRefCursor(String outputQry, String pkg, String packageRpl) {
        String pkgReplacementIn = packageRpl;
        String output = outputQry;
        Matcher refCursorMatcher = PAT_REF_CURSOR.matcher(output);
        refCursorMatcher = OraclePostMigrationHandler.migGaussDBT(output, refCursorMatcher);
        while (refCursorMatcher.find()) {
            String typeQuery = refCursorMatcher.group(2);
            int endIndex = 0;
            String subQry = null;
            StringBuffer totalQry = new StringBuffer();
            ArrayList<String> refCursorVars = new ArrayList<String>(10);
            if (refCursorMatcher.group(2) != null) {
                while ((endIndex = typeQuery.indexOf(";")) != -1) {
                    subQry = typeQuery.substring(0, endIndex + 1);
                    Matcher typeMatcher = TYPE_PATTERN.matcher(subQry);
                    if (typeMatcher.find()) {
                        String refCursorVar = typeMatcher.group(3);
                        boolean isRefCursor = false;
                        if (QueryConversionUtility.equalCheck(refCursorVar.trim(), pkg.trim())) {
                            if (output.trim().matches("(?i).*CREATE\\s*OR\\s*REPLACE\\s*(?:FUNCTION|PROCEDURE)(.*?)(?:(?<!\\w)(?:AS|IS)(?!\\w))(.*?)((?<!\\w)BEGIN(?!\\w).*?(?<!\\w)END(?!\\w).*?\\;.*?\\s*\\/)") && FeatureLoader.getBooleanProperty("pkgSchemaNaming") || QueryConversionUtility.isGaus100()) {
                                refCursorVar = OraclePostMigrationHandler.getRefCurVar(refCursorVar);
                                subQry = subQry.replace(typeMatcher.group(3).trim(), refCursorVar);
                            }
                            if (isRefCursor = OraclePostMigrationHandler.getFlagForRefCur(refCursorVars, refCursorVar, isRefCursor)) {
                                Pattern varrayPat = Pattern.compile("(?i)type\\s+\\w+\\s+(?:is|as)\\s+(?:table|varray\\s*\\(\\s*\\d+\\s*\\))\\s+OF\\s+(.*?)\\/?;");
                                Matcher varrayMat = varrayPat.matcher(pkgReplacementIn);
                                if (varrayMat.find()) {
                                    pkgReplacementIn = OraclePostMigrationHandler.getPkgReplacement(pkgReplacementIn, varrayMat);
                                    subQry = OraclePostMigrationHandler.getSubQry(output, pkgReplacementIn, subQry);
                                } else if (pkgReplacementIn.trim().matches("(?i)(?<!\\w)SYS_REFCURSOR(?!\\w)") && !subQry.matches("(?i)\\s*type\\s+" + pkg + "\\s+is\\s+ref\\s+cursor\\s*;")) {
                                    subQry = OraclePostMigrationHandler.getSubQry(subQry, refCursorVar);
                                }
                                refCursorVars.add(refCursorVar);
                            }
                        }
                    }
                    totalQry.append(subQry);
                    typeQuery = typeQuery.substring(endIndex + 1);
                }
            }
            output = OraclePostMigrationHandler.getOutQry(output, refCursorMatcher, totalQry);
        }
        return output;
    }

    private static String getRefCurVar(String input) {
        String refCursorVar = input;
        if (refCursorVar.contains(".")) {
            refCursorVar = refCursorVar.substring(refCursorVar.indexOf(".") + 1);
        }
        return refCursorVar;
    }

    private static String getOutQry(String outQry, Matcher refCursorMatcher, StringBuffer totalQry) {
        String output = outQry;
        if (totalQry.length() > 0) {
            output = output.replace(refCursorMatcher.group(2).trim(), totalQry.toString().trim());
        }
        return output;
    }

    private static String getSubQry(String query, String refCursorVar) {
        String subQry = query;
        subQry = " TYPE " + refCursorVar + " " + QueryConversionUtility.toUpper("is") + " " + "REF" + " " + "CURSOR" + ";" + subQry;
        return subQry;
    }

    private static boolean getFlagForRefCur(List<String> refCursorVars, String refCursorVar, boolean flag) {
        boolean isRefCursor = flag;
        if (refCursorVars.size() == 0) {
            isRefCursor = true;
        } else {
            for (int iIndex = 0; iIndex < refCursorVars.size(); ++iIndex) {
                if (refCursorVar.equalsIgnoreCase(refCursorVars.get(iIndex))) continue;
                isRefCursor = true;
            }
        }
        return isRefCursor;
    }

    private static Matcher migGaussDBT(String output, Matcher refCursorMatcher) {
        if (QueryConversionUtility.isGaus100() && !FeatureLoaderExtended.getBooleanProperty("supportPkgSplitDBT")) {
            refCursorMatcher = Pattern.compile("(?i)(?:FUNCTION|PROCEDURE)(.*?)(?:(?<!\\w)(?:AS|IS)(?!\\w|\\s+function|\\s+procedure))(.*?)((?:#S#\\d+#E#\\s*)*(?<!\\w)BEGIN(?!\\w).*?(?<!\\w)END(?!\\w)\\s+\\w+\\s*\\;)").matcher(output);
        }
        return refCursorMatcher;
    }

    private static String getSubQry(String output, String pkgReplacement, String subQuery) {
        String subQry = subQuery;
        if (!QueryConversionUtility.containsCheck(output.replace(" ", ""), pkgReplacement.replace(" ", ""))) {
            subQry = " " + pkgReplacement + subQry;
        }
        return subQry;
    }

    private static String getPkgReplacement(String pkgRpl, Matcher varrayMat) {
        String pkgReplacementIn = pkgRpl;
        if (pkgReplacementIn.trim().matches("(?i).*table.*")) {
            String varrayDataType = varrayMat.group(1).replaceFirst("(?i)index\\s*by\\s*BINARY_INTEGER", "").trim();
            OracleUtility oracleUtil = new OracleUtility();
            String varraySize = oracleUtil.doGetVarraySize(varrayDataType);
            pkgReplacementIn = pkgReplacementIn.replaceFirst("(?i) table ", " VARRAY(" + varraySize + ")" + " ");
            pkgReplacementIn = pkgReplacementIn.replaceFirst("(?i)index\\s*by\\s*BINARY_INTEGER", "");
        }
        return pkgReplacementIn;
    }

    private String processPackageHypen(String packageNme, Set<String> getVars, String input) {
        String output = input;
        LinkedHashMap<String, String> quoteMap = new LinkedHashMap<String, String>(10);
        this.pkgNme = "";
        output = QueryConversionUtility.getSingleDoubleQuoteMap(output, quoteMap);
        output = output.replaceAll("\\s*(<|>|!|=)\\s*", "$1");
        output = QueryConversionUtility.getRplFromMap(output, quoteMap, "(##QUOTE##\\d+#)");
        boolean flag = false;
        String pkg = packageNme;
        if (pkg.contains(".")) {
            String schemaProcName = QueryConversionUtility.finderGroup(output, "(?i)(?<!\\w)(?:procedure|function)\\s+(?:\\w+\\.)?((\\w+)[\\.#]\\w+)\\s+", 2);
            String[] pkgArr = pkg.split("\\.");
            if (pkgArr.length > 1) {
                this.pkgNme = pkgArr[pkgArr.length - 2];
            }
            String pkgVarNme = pkgArr[pkgArr.length - 1];
            if (this.pkgNme.equalsIgnoreCase(schemaProcName) && this.checkPkgVarMatchesLocalVariable(output, pkgVarNme)) {
                pkg = pkgVarNme;
                flag = true;
            }
            if (QueryConversionUtility.isGaus100() && !FeatureLoaderExtended.getBooleanProperty("supportPkgSplitDBT")) {
                pkg = pkgVarNme;
                flag = true;
            }
        }
        if (pkg.contains(".") || this.checkPkgVarMatchesLocalVariable(output, pkg)) {
            Pattern pat = Pattern.compile("(?i)(?<!\\w|\\.|\\')(\"?\\w+\"?\\s*\\.\\s*)?" + QueryConversionUtility.santizePattern(pkg) + "(?!\\w)");
            Matcher match = pat.matcher(output);
            String tempOp = output;
            String tempPkgVarSubStr = "";
            while (match.find()) {
                String[] values = QueryConversionUtility.doGetArrSplit(this.pkgReplacement, "-");
                String dataType = values[2];
                if (!dataType.equalsIgnoreCase("EXCEPTION")) {
                    int index = match.start();
                    String pkgVarSubStr = this.getPkgVarStr(tempOp, index);
                    if (!tempPkgVarSubStr.isEmpty() && (tempPkgVarSubStr.isEmpty() || tempPkgVarSubStr.equalsIgnoreCase(pkgVarSubStr))) continue;
                    output = this.processPackage(pkg, pkgVarSubStr, getVars, flag, output);
                    continue;
                }
                getVars.add(pkg + " " + dataType + ";");
            }
        }
        return output;
    }

    private boolean checkPkgVarMatchesLocalVariable(String input, String pkg) {
        String grp;
        boolean flag = true;
        String declareOp = QueryConversionUtility.finderGroup(input, "(?i).*?(?<!\\w)(?:as|is)(?!\\w)(.*?)(?<!\\w)(begin)(?!\\w).*", 1);
        if ((declareOp = QueryConversionUtility.replaceAll(declareOp, "(?i)(?<!\\w)CURSOR(?!\\w).*?;", "")) != null && !(declareOp = declareOp.trim()).isEmpty() && (grp = QueryConversionUtility.finderGroup(declareOp, "(?i)(?<!\\w)" + pkg + "(?!\\w)", 0)) != null) {
            flag = false;
        }
        return flag;
    }

    private String processPackage(String pkg, String pkgVarSubString, Set<String> getVars, boolean flag, String input) {
        Pattern patVar;
        Matcher matchVar;
        int commentLen;
        int commentIndex;
        String pkgVarSubStr;
        String tempPkgVarSubStr = pkgVarSubStr = pkgVarSubString;
        this.processPkgFlag = flag;
        String startCmnt = "";
        String endCmnt = "";
        if (pkgVarSubStr.startsWith("#S#") && (commentIndex = pkgVarSubStr.indexOf(startCmnt = QueryConversionUtility.doGetStartCmnts(pkgVarSubStr))) + (commentLen = startCmnt.length()) <= pkgVarSubStr.length()) {
            pkgVarSubStr = pkgVarSubStr.substring(commentIndex + commentLen);
        }
        if (pkgVarSubStr.endsWith("#E#")) {
            endCmnt = QueryConversionUtility.doGetEndCmnts(pkgVarSubStr);
            pkgVarSubStr = pkgVarSubStr.substring(0, pkgVarSubStr.lastIndexOf(endCmnt));
        }
        if ((matchVar = (patVar = Pattern.compile("(?i)((?<!\\w|\\.|into\\s)(\"?\\w+\"?\\s*\\.\\s*)?" + QueryConversionUtility.santizePattern(pkg) + "(?!\\w)\\s*:=(.*)(;))")).matcher(pkgVarSubStr)).find()) {
            pkgVarSubStr = this.matchIntoPattern(pkg, pkgVarSubStr, matchVar, getVars, flag);
        }
        pkgVarSubStr = this.matchSelectFromPattern(pkg, pkgVarSubStr, getVars, flag);
        pkgVarSubStr = this.noMatchInto(pkg, pkgVarSubStr, getVars, flag);
        String output = input.replace(tempPkgVarSubStr, startCmnt + pkgVarSubStr + endCmnt);
        return output;
    }

    private String matchSelectFromPattern(String pkg, String pkgVarSubString, Set<String> getVars, boolean flag) {
        String pkgVarSubStr = pkgVarSubString;
        Matcher matSelectFrom = PAT_SELECT_FROM.matcher(pkgVarSubStr);
        int tempIndex = 0;
        StringBuffer sb = new StringBuffer();
        while (matSelectFrom.find()) {
            int startIndex = matSelectFrom.start();
            int endIndex = matSelectFrom.end();
            sb.append(pkgVarSubStr.substring(tempIndex, startIndex));
            String selectStr = matSelectFrom.group();
            selectStr = this.matchSelectFrom(pkg, selectStr, getVars, flag);
            sb.append(selectStr);
            tempIndex = endIndex;
        }
        sb.append(pkgVarSubStr.substring(tempIndex));
        pkgVarSubStr = sb.toString();
        return pkgVarSubStr;
    }

    private String noMatchInto(String pkgName, String pkgVarSubString, Set<String> getVars, boolean flag) {
        Matcher matchDML;
        String pkgVarSubStr = pkgVarSubString;
        String pkg = pkgName;
        String pkgVarSubStrDml = null;
        if (QueryConversionUtility.equalCheck("TYPE", pkg)) {
            return pkgVarSubStr;
        }
        if (QueryConversionUtility.toLower(pkgVarSubStr).startsWith("insert ") && (matchDML = PAT_DML.matcher(pkgVarSubStr)).find()) {
            pkgVarSubStrDml = matchDML.group(1);
            pkgVarSubStr = matchDML.group(2);
        }
        Pattern patGet = this.getPkg(pkgVarSubStr, pkg);
        Matcher matchGet = patGet.matcher(pkgVarSubStr);
        while (matchGet.find()) {
            String[] values = QueryConversionUtility.doGetArrSplit(this.pkgReplacement, "-");
            String schemaNmePtrn = matchGet.group(2);
            this.schemaNme = this.getSchName(values, schemaNmePtrn);
            if (values.length < 3) {
                return pkgVarSubString;
            }
            this.pkgNme = values[1];
            String dataType = values[2];
            int getValueIdx = matchGet.start(1);
            int getValuseEndIdx = matchGet.end(1);
            String setReplacement = this.doGetReplaceValue(pkg, "", "", dataType, false);
            String replc = this.doGetReplaceValue(pkg, "", "", dataType, true);
            pkg = this.getPkgName(pkg);
            String rplStr = pkg + "~~" + replc;
            getVars.add(rplStr);
            pkgVarSubStr = pkgVarSubStr.substring(0, getValueIdx) + setReplacement + pkgVarSubStr.substring(getValuseEndIdx);
            matchGet = patGet.matcher(pkgVarSubStr);
        }
        if (pkgVarSubStrDml != null) {
            pkgVarSubStr = pkgVarSubStrDml + pkgVarSubStr;
        }
        return pkgVarSubStr;
    }

    private Pattern getPkg(String pkgVarSubStr, String pkg) {
        Pattern patGet = null;
        patGet = pkgVarSubStr.matches("(?i).*(if|when|elsif|while).*") ? Pattern.compile("(?i)((?<!\\w|\\.|\\')(\"?\\w+\"?\\s*\\.\\s*)?" + QueryConversionUtility.santizePattern(pkg) + "(?!\\w))") : Pattern.compile("(?i)((?<!\\w|\\.|\\')(\"?\\w+\"?\\s*\\.\\s*)?" + QueryConversionUtility.santizePattern(pkg) + "(?!\\w|(?:<|>|=|!)))");
        return patGet;
    }

    private String matchSelectFrom(String pkgName, String pkgVarSubString, Set<String> getVars, boolean flag) {
        String pkgVarSubStr = pkgVarSubString;
        String pkg = pkgName;
        Pattern setPattern = Pattern.compile("(?i).*(?<!\\w)select(?!\\w)(.*?)(?<!\\w)into(?!\\w)(.*?(?<!\\w)(\"?\\w+\"?\\.\\s*)?(\"?\\w+\"?\\s*\\.\\s*)?" + QueryConversionUtility.santizePattern(pkg) + "(?!\\w).*?)(?<!\\w)(from).*");
        Matcher setMatch = setPattern.matcher(pkgVarSubStr);
        if (setMatch.find()) {
            String[] values = QueryConversionUtility.doGetArrSplit(this.pkgReplacement, "-");
            String schemaNmePtrn = setMatch.group(3);
            this.schemaNme = this.getSchName(values, schemaNmePtrn);
            if (values.length < 3) {
                return pkgVarSubString;
            }
            this.pkgNme = values[1];
            String dataType = values[2];
            String selectClause = setMatch.group(1);
            int selectClauseIdx = setMatch.start(1);
            String intoClause = setMatch.group(2);
            int fromIdx = setMatch.start(5);
            ColumnSplitter splitter = new ColumnSplitter();
            List<String> columnsLst = splitter.doGetAllColumns(selectClause);
            List<String> varsLst = QueryConversionUtility.getLstFrmStringWithComma(intoClause, false);
            for (int iIndex = 0; iIndex < varsLst.size(); ++iIndex) {
                String var = varsLst.get(iIndex).trim();
                if (!QueryConversionUtility.containsCheck(QueryConversionUtility.toLower(var), pkg)) continue;
                varsLst.set(iIndex, "MIG_PV_VAL_DUMMY_" + QueryConversionUtility.toUpper(pkg));
                String replc = this.doGetReplaceValue(pkg, "", "", dataType, true);
                pkg = this.getPkgName(pkg);
                String rplStr = pkg + "~~" + replc;
                getVars.add(rplStr);
            }
            pkgVarSubStr = pkgVarSubStr.substring(0, selectClauseIdx) + " " + QueryConversionUtility.doGetStrFrmListWithComma(columnsLst) + " " + "INTO" + " " + QueryConversionUtility.doGetStrFrmListWithComma(varsLst) + " " + pkgVarSubStr.substring(fromIdx);
        }
        return pkgVarSubStr;
    }

    private String getPkgName(String packageName) {
        String pkg = packageName;
        if (pkg.contains(".")) {
            int idx = pkg.lastIndexOf(46);
            pkg = pkg.substring(idx + 1).trim();
        }
        return pkg;
    }

    private String getSchName(String[] values, String schName) {
        String schemaNmePtrn = schName;
        this.schemaNme = schemaNmePtrn != null ? (schemaNmePtrn = schemaNmePtrn.substring(0, schemaNmePtrn.length() - 1)) : values[0];
        return this.schemaNme;
    }

    private String matchIntoPattern(String pkgName, String pkgVarSubString, Matcher matchVar, Set<String> getVars, boolean flag) {
        String[] values = QueryConversionUtility.doGetArrSplit(this.pkgReplacement, "-");
        String schemaNmePtrn = matchVar.group(2);
        this.schemaNme = this.getSchName(values, schemaNmePtrn);
        if (values.length < 3) {
            return pkgVarSubString;
        }
        this.pkgNme = values[1];
        String dataType = values[2];
        String setValue = "";
        setValue = " := ";
        setValue = setValue + matchVar.group(3);
        String semiColon = matchVar.group(4);
        String pkg = pkgName;
        String setReplacement = this.doGetReplaceValue(pkg, setValue, semiColon, "", false);
        String replc = this.doGetReplaceValue(pkg, "", "", dataType, true);
        pkg = this.getPkgName(pkg);
        String rplStr = pkg + "~~" + replc;
        getVars.add(rplStr);
        String pkgVarSubStr = pkgVarSubString;
        pkgVarSubStr = setReplacement = pkgVarSubStr.substring(0, matchVar.start(1)) + setReplacement + pkgVarSubStr.substring(matchVar.end(1));
        return pkgVarSubStr;
    }

    private String getPkgVarStr(String tempOp, int index) {
        String pkgVarSubStr = "";
        if (index != -1) {
            String subStr2;
            int semiColonIdx2;
            String subStr1 = tempOp.substring(0, index);
            int semiColonIdx = subStr1.lastIndexOf(59);
            if (semiColonIdx == -1) {
                semiColonIdx = QueryConversionUtility.toLower(subStr1).indexOf(" begin ") + 6;
            }
            if (QueryConversionUtility.toLower(pkgVarSubStr = tempOp.substring(semiColonIdx + 1, index + (semiColonIdx2 = (subStr2 = tempOp.substring(index, tempOp.length())).indexOf(59)) + 1).trim()).startsWith("begin")) {
                pkgVarSubStr = pkgVarSubStr.substring(6).trim();
            }
        }
        return pkgVarSubStr;
    }

    private String getPkgReplacementVal(String task, String outputQry, String pkg) {
        String currPkgNme = null;
        if (QueryConversionUtility.equalCheck("PKG_VAR", task) && !pkg.contains(".")) {
            String patten = FeatureLoader.getBooleanProperty("pkgSchemaNaming") ? "(?i).*?(?<!\\w)(?:function|procedure)\\s+.*?(\"?\\w+)\\.\\w+\"?(?!\\w).*" : "(?i).*?(?<!\\w)(?:function|procedure)\\s+.*?(\"?\\w+)\\#\\w+\"?(?!\\w).*";
            Pattern pkgNmeFind = Pattern.compile(patten);
            Matcher matchFind = pkgNmeFind.matcher(outputQry);
            if (matchFind.find()) {
                currPkgNme = matchFind.group(1);
                if (currPkgNme.startsWith("\"")) {
                    currPkgNme = currPkgNme + "\"";
                }
                this.pkgReplacement = OracleMigrationService.getPackageReplacement(QueryConversionUtility.toLower(currPkgNme) + "." + pkg);
            }
        } else {
            this.pkgReplacement = OracleMigrationService.getPackageReplacement(pkg);
        }
        return this.pkgReplacement;
    }

    private String doGetReplaceValue(String pkgVar, String setValue, String semiColon, String dataType, boolean getFullRpl) {
        String setString = null;
        String getString = null;
        StringBuffer setReplacement = new StringBuffer();
        String pkgVariable = pkgVar;
        if (pkgVar.contains(".")) {
            int idx = pkgVar.lastIndexOf(46);
            pkgVariable = pkgVar.substring(idx + 1).trim();
        }
        if (getFullRpl) {
            if (QueryConversionUtility.equalCheck(FeatureLoader.getStringProperty("pkgvariable"), "localtable") || QueryConversionUtility.isGaus100()) {
                setString = "MIG_FN_SET_PKG_VARIABLE";
                getString = "MIG_FN_GET_PKG_VARIABLE";
                setReplacement.append("MIG_ORA_EXT.");
            } else if (QueryConversionUtility.equalCheck(FeatureLoader.getStringProperty("pkgvariable"), "sys_set_context")) {
                setString = "DBMS_SESSION.SET_CONTEXT";
                getString = "SYS_CONTEXT";
            }
        } else {
            setString = "MIG_PV_VAL_DUMMY_" + QueryConversionUtility.toUpper(pkgVariable);
            getString = "MIG_PV_VAL_DUMMY_" + QueryConversionUtility.toUpper(pkgVariable);
        }
        if (dataType.isEmpty()) {
            setReplacement.append(setString);
        } else {
            setReplacement.append(getString);
        }
        if (getFullRpl) {
            this.getReplacement(setValue, semiColon, dataType, setReplacement, pkgVariable);
        } else {
            setReplacement.append(setValue).append(semiColon);
        }
        return setReplacement.toString();
    }

    private StringBuffer getReplacement(String setValue, String semiColon, String dataType, StringBuffer setReplacement, String pkgVariable) {
        setReplacement.append("(");
        if (QueryConversionUtility.equalCheck(FeatureLoader.getStringProperty("pkgvariable"), "localtable")) {
            if (this.schemaNme.equalsIgnoreCase("current_user") || this.processPkgFlag) {
                if (FeatureLoader.getBooleanProperty("pkgSchemaNaming")) {
                    setReplacement.append("current_user");
                } else if (this.schemaNme.equalsIgnoreCase("current_user")) {
                    setReplacement.append("current_schema()");
                } else {
                    setReplacement.append("'").append(this.schemaNme).append("'");
                }
            } else {
                setReplacement.append("'").append(this.schemaNme).append("'");
            }
            setReplacement.append(",");
        }
        if (QueryConversionUtility.isGaus100() && FeatureLoader.getStringProperty("pkgvariable100").equalsIgnoreCase("localtable")) {
            if (this.schemaNme.equalsIgnoreCase("current_user") || this.processPkgFlag) {
                if (this.schemaNme.equalsIgnoreCase("current_user")) {
                    setReplacement.append("current_schema()");
                } else {
                    setReplacement.append("'").append(this.schemaNme).append("'");
                }
            } else {
                setReplacement.append("'").append(this.schemaNme).append("'");
            }
            setReplacement.append(",");
        }
        setReplacement.append("'").append(this.pkgNme).append("'").append(",");
        setReplacement.append("'").append(pkgVariable).append("'");
        if (dataType.isEmpty()) {
            setReplacement.append(",");
            setReplacement.append("(");
            setReplacement.append(setValue).append(")").append(":").append(":").append("TEXT");
            setReplacement.append(")").append(semiColon);
        } else {
            setReplacement.append(")").append(":").append(":").append(dataType);
        }
        return setReplacement;
    }

    private String doPrimaryKeyConstraint(List<String> outputList, String output) {
        Set<String> primaryKeySet;
        String outputQry = output;
        String schemaTableNme = null;
        Matcher matcher = null;
        Pattern pattern = null;
        if (QueryConversionUtility.isExactMatch(outputQry, "CREATE") && !outputQry.matches(".*(?<!\\w)ALTER(?!\\w).*(?<!\\w)CREATE\\s+UNIQUE\\s+INDEX(?!\\w).*")) {
            Set<String> primaryKeySet2;
            pattern = Pattern.compile("(?i)(?<!\\w)CREATE(?!\\w).*?(?<!\\w)TABLE(?!\\w).*?(\\w*\\.?\\w+).*?;");
            matcher = pattern.matcher(outputQry);
            if (matcher.find() && (schemaTableNme = QueryConversionUtility.toLower(matcher.group(1))) != null && (primaryKeySet2 = OracleMigrationService.getPrimaryKeyAlter(schemaTableNme)) != null) {
                String[] primaryKeyArray = primaryKeySet2.toArray(new String[0]);
                String primaryKey = primaryKeyArray[0];
                String primaryKeyIndex = primaryKeyArray[1];
                outputQry = this.doPrimaryKeyConstraintSub(outputQry, schemaTableNme, primaryKeySet2, primaryKey, primaryKeyIndex);
            }
        } else if (QueryConversionUtility.isExactMatch(outputQry, "alter") && (matcher = (pattern = Pattern.compile("(?i).*alter.*(?<!\\w)table\\s+(\\w*\\.?\\w+)(?:(?!add).)*?(?:(?<!\\w)add(?!\\w))?\\s*\\(?((?:(?!add).)*?(?:(?<!\\w)primary\\s+key(?!\\w)|(?<!\\w)unique(?!\\w))\\s*\\(.*?\\))\\s*((?<!\\w)using\\s+index(?:\\s+tablespace\\s+\\w+\\s+)?)?")).matcher(outputQry)).find() && (primaryKeySet = OracleMigrationService.getPrimaryKeyAlter(schemaTableNme = QueryConversionUtility.toLower(matcher.group(1).trim()))) != null) {
            outputQry = "";
        }
        return outputQry;
    }

    private String doPrimaryKeyConstraintSub(String output, String schemaTableNme, Set<String> primaryKeySet, String primaryKeyParam, String primaryKeyIndex) {
        String sub;
        int subLen;
        String outputQry = output;
        String primaryKey = primaryKeyParam;
        int idx = outputQry.indexOf(40);
        if (!(idx == -1 || idx + (subLen = (sub = QueryConversionUtility.doGetReplaceString(outputQry.substring(idx))).length()) > outputQry.length() || QueryConversionUtility.containsCheck(sub, "primary key") || QueryConversionUtility.containsCheck(sub, "unique") && QueryConversionUtility.containsCheck(primaryKey, "unique"))) {
            sub = sub.substring(0, sub.length() - 1);
            primaryKey = "," + primaryKey;
            sub = QueryConversionUtility.doCommentPatternGrp(sub, "(?i),\\s*((?:(?!,).)*?(?:(?<!\\w)unique(?!\\w))\\s*\\(.*?\\))", 0);
            if (QueryConversionUtility.containsCheck(primaryKey, "primary key")) {
                primaryKey = QueryConversionUtility.doCommentPatternGrp(primaryKey, "(?i),\\s*((?:(?!,).)*?(?:(?<!\\w)unique(?!\\w))\\s*\\(.*?\\))", 0);
            }
            primaryKey = this.getPrimaryKey(schemaTableNme, primaryKey);
            String remainingStr = outputQry.substring(idx + subLen);
            StringBuffer sb = new StringBuffer();
            sb.append(outputQry.substring(0, idx)).append(sub).append(primaryKey).append(primaryKeyIndex).append(")").append(remainingStr);
            outputQry = sb.toString();
            primaryKeySet.remove("false");
            primaryKeySet.add("true");
        }
        return outputQry;
    }

    private String getPrimaryKey(String schemaTableNme, String primaryKeyInp) {
        String primaryKey = primaryKeyInp;
        if (QueryConversionUtility.containsCheckCollec(OracleMigrationService.getConstraintWithPartition(), schemaTableNme) && FeatureLoader.getStringProperty("uniqueConsForPartitonedTable").equalsIgnoreCase("comment_unique")) {
            primaryKey = "/*" + primaryKey + "*/";
        }
        return primaryKey;
    }
}

