/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.oracle;

import com.huawei.db.migration.exception.MigrationServiceException;
import com.huawei.db.migration.replacer.ReplacerMap;
import com.huawei.db.migration.util.DBPropertyLoader;
import com.huawei.db.migration.util.QueryConversionUtility;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OracleRowId {
    private static final Logger logger = LogManager.getLogger(OracleRowId.class);
    private int index;

    public String doRplRowID(String input, Map<String, String> subQueryTrackMap) {
        String inputQry = input;
        if (QueryConversionUtility.containsCheck(inputQry = inputQry.replaceAll("\\s+,\\s+|\\s+,|,\\s+", ","), "ROWIDTOCHAR")) {
            inputQry = this.doRplROWIDToChar(subQueryTrackMap, inputQry);
        }
        if (inputQry.matches("(?i).*(?<!\\w)rowid(?!\\w).*")) {
            inputQry = this.doReplaceROWID(subQueryTrackMap, inputQry);
        }
        return inputQry;
    }

    private String doReplaceROWID(Map<String, String> subQueryTrackMap, String input) {
        String inputQry = input;
        this.index = 0;
        inputQry = inputQry.replaceAll("\\s*\\.\\s*", ".");
        StringBuffer inputQuery = new StringBuffer(inputQry);
        String inputSubStr = inputQry.substring(this.index);
        while (QueryConversionUtility.containsCheck(inputSubStr, "rowid") && QueryConversionUtility.isContainsExactMatch(inputSubStr, "rowid") && inputSubStr.matches("(?i).*(?<!\\w)rowid(?!\\w).*")) {
            this.index = QueryConversionUtility.getStartIndex(inputQry, "(?i)(?<!\\w)ROWID(?!\\w)", 0);
            int fromIndex = QueryConversionUtility.getIndex(inputQry, "from", this.index);
            String fromTable = inputQry.substring(fromIndex + 4).trim();
            if (this.index < fromIndex) {
                String tabName = "";
                String rowIdStr = inputQry.substring(this.index, this.index + 5);
                if (inputQry.charAt(this.index - 1) == '.') {
                    String subStr = inputQry.substring(0, this.index + 5);
                    int separatorIdx = 0;
                    separatorIdx = !QueryConversionUtility.containsCheck("row_number", subStr) ? QueryConversionUtility.getStartIndex(subStr, "(?i)((\\w+|\"\\w+\")\\.)?(?<!\\w)ROWID(?!\\w)", 0) - 1 : subStr.lastIndexOf(32);
                    rowIdStr = subStr.substring(separatorIdx + 1);
                    tabName = rowIdStr.substring(0, rowIdStr.indexOf(46) + 1);
                }
                this.doReplaceROWIDDotSubQuery(subQueryTrackMap, inputQry, fromIndex, fromTable, tabName, inputQuery, rowIdStr);
            } else {
                this.doReplaceROWIDDot(inputQry, inputQuery);
            }
            inputQry = inputQuery.toString();
            inputSubStr = inputQry.substring(this.index);
        }
        return inputQry;
    }

    private void doReplaceROWIDDotSubQuery(Map<String, String> subQueryTrackMap, String inputQry, int fromIndex, String fromTable, String tableName, StringBuffer inputQuery, String rowIdString) {
        String rowIdStr = rowIdString;
        String tabName = tableName;
        int temp = tabName.length();
        String tempTab = tabName;
        tabName = this.doRplRowIdCols(tabName);
        tabName = this.getRowIdWithAlias(inputQry, this.index, rowIdStr.length() - temp, tabName, fromIndex, "rowid");
        if ((rowIdStr = this.getColumnWithAlias(inputQry, this.index, rowIdStr.length() - temp, rowIdStr, fromIndex)).contains(".")) {
            inputQuery.delete(this.index - temp, this.index + rowIdStr.length() - temp);
            this.index -= temp;
        } else {
            inputQuery.delete(this.index, this.index + rowIdStr.length() - temp);
        }
        if (fromTable.startsWith("##SUBQUERY##")) {
            if (tabName.contains("rowid")) {
                tabName = tabName.replace("rowid", "row_id");
                rowIdStr = "row_id as rowid";
            } else if (tabName.contains("ROWID_ALIAS")) {
                rowIdStr = rowIdStr.replace("ROWID", "ROWID_ALIAS");
            } else {
                int indexOfSpace = rowIdStr.lastIndexOf(32);
                if (indexOfSpace != -1) {
                    rowIdStr = rowIdStr.substring(indexOfSpace);
                }
            }
            tabName = tabName.replace(tempTab, "");
            String subQry = fromTable.substring(0, fromTable.indexOf(95)) + "__";
            this.updateSubQry(subQueryTrackMap, tabName, subQry);
            if (inputQuery.charAt(this.index - 2) == '*') {
                inputQuery.delete(this.index - 1, this.index);
            } else {
                inputQuery.insert(this.index, rowIdStr);
            }
            this.index += rowIdStr.length();
        } else {
            inputQuery.insert(this.index, tabName);
            this.index += tabName.length();
        }
    }

    private void doReplaceROWIDDot(String inputQry, StringBuffer inputQuery) {
        if (inputQry.matches("(?i).*(:=\\s*\\w*\\.?ROWID).*")) {
            return;
        }
        String replacement = this.doRplRowIdCols("");
        int idxShift = 0;
        String tabName = null;
        if (inputQry.charAt(this.index - 1) == '.') {
            int previousSepIdx = -1;
            int previousCommaIdx = inputQry.lastIndexOf(44, this.index);
            int previousSpaceIdx = inputQry.lastIndexOf(32, this.index);
            previousSepIdx = previousSpaceIdx > previousCommaIdx ? previousSpaceIdx : previousCommaIdx;
            if (previousSepIdx != -1) {
                String rowIdStr = inputQry.substring(previousSepIdx + 1, this.index);
                tabName = rowIdStr.substring(0, rowIdStr.indexOf(46) + 1);
                replacement = this.doRplRowIdCols(tabName);
                idxShift = this.index - previousSepIdx - 1;
                this.index = previousSepIdx + 1;
            }
        }
        inputQuery.delete(this.index, this.index + 5 + idxShift);
        inputQuery.insert(this.index, replacement);
    }

    private String doRplROWIDToChar(Map<String, String> subQueryTrackMap, String input) {
        String inputQry = input;
        StringBuffer inputBuf = new StringBuffer(inputQry);
        int indexChar = 0;
        while (QueryConversionUtility.containsCheck(inputQry, "ROWIDTOCHAR")) {
            indexChar = QueryConversionUtility.getIndex(inputQry, "ROWIDTOCHAR", indexChar);
            String tabName = "";
            int fromIndex = QueryConversionUtility.getIndex(inputQry, "from", indexChar);
            String fromTable = inputQry.substring(fromIndex + 4).trim();
            String column = QueryConversionUtility.doGetReplaceString(inputQry.substring(indexChar));
            int idx = column.indexOf(40);
            if (column.contains(".")) {
                tabName = column.substring(idx + 1, column.lastIndexOf(46) + 1);
            }
            this.doRplROWIDToCharSubQuery(subQueryTrackMap, inputQry, fromIndex, fromTable, inputBuf, indexChar, tabName, column);
            inputQry = inputBuf.toString();
        }
        return inputQry;
    }

    private void doRplROWIDToCharSubQuery(Map<String, String> subQueryTrackMap, String inputQry, int fromIndex, String fromTable, StringBuffer inputBuf, int indexParam, String tableName, String colNme) {
        String tabName;
        String column = colNme;
        String tempTab = tabName = tableName;
        tabName = this.doRplRowIdCols(tabName);
        tabName = this.getRowIdWithAlias(inputQry, indexParam, column.length(), tabName, fromIndex, "row_id");
        column = this.getColumnWithAlias(inputQry, indexParam, column.length(), column, fromIndex);
        if (fromTable.startsWith("##SUBQUERY##")) {
            String subQry = fromTable.substring(0, fromTable.indexOf(95)) + "__";
            tabName = tabName.replace(tempTab, "");
            this.updateSubQry(subQueryTrackMap, tabName, subQry);
            inputBuf.delete(indexParam, indexParam + column.length());
            int charIndex = tabName.lastIndexOf(32);
            if (charIndex != -1) {
                column = tabName.substring(charIndex);
            }
            if (inputBuf.charAt(indexParam - 2) == '*') {
                inputBuf.delete(indexParam - 1, indexParam);
            } else {
                inputBuf.insert(indexParam, column);
            }
        } else {
            inputBuf.delete(indexParam, indexParam + column.length());
            inputBuf.insert(indexParam, tabName);
        }
    }

    private String getRowIdWithAlias(String inputQry, int indexParam, int strLen, String tabName, int fromIndex, String alias) {
        String aliasChecker = "";
        int inputQryLen = inputQry.length();
        if (indexParam + strLen < inputQryLen && fromIndex <= inputQryLen) {
            aliasChecker = inputQry.substring(indexParam + strLen, fromIndex).trim();
        }
        StringBuffer tableName = new StringBuffer(tabName);
        if (aliasChecker.contains(",")) {
            if (!(aliasChecker = aliasChecker.startsWith(")") ? aliasChecker.substring(0, aliasChecker.indexOf(44) + 1).trim() : aliasChecker.substring(0, aliasChecker.indexOf(44)).trim()).isEmpty()) {
                tableName.append(" ").append(aliasChecker);
            }
        } else if (!aliasChecker.isEmpty() && QueryConversionUtility.toLower(aliasChecker).startsWith("as ")) {
            if (aliasChecker.matches("(?i)(?<!\\w)into(?!\\w).*")) {
                tableName.append(" as ").append("ROWID_ALIAS");
            } else {
                tableName.append(" ").append(aliasChecker);
            }
        }
        if (aliasChecker.isEmpty()) {
            tableName.append(" as ").append(alias);
        }
        if (QueryConversionUtility.containsCheck(inputQry, "##SUBQUERY##") && QueryConversionUtility.containsCheck(aliasChecker, "INTO")) {
            tableName.append(" ").append("AS").append(" ").append("rowid");
        }
        return tableName.toString();
    }

    private String getColumnWithAlias(String inputQry, int indexParam, int strLen, String tabName, int fromIndex) {
        String aliasChecker = "";
        int inputQryLen = inputQry.length();
        if (indexParam + strLen < inputQryLen && fromIndex <= inputQryLen) {
            aliasChecker = inputQry.substring(indexParam + strLen, fromIndex).trim();
        }
        StringBuffer tableNameBuff = new StringBuffer(tabName);
        if (aliasChecker.contains(",")) {
            if (!(aliasChecker = aliasChecker.substring(0, aliasChecker.indexOf(44)).trim()).isEmpty()) {
                tableNameBuff.append(" ").append(aliasChecker);
            }
        } else if (!aliasChecker.isEmpty() && QueryConversionUtility.toLower(aliasChecker).startsWith("as ")) {
            tableNameBuff.append(" ").append(aliasChecker);
        }
        return tableNameBuff.toString();
    }

    private void updateSubQry(Map<String, String> subQueryTrackMap, String tabName, String subQry) {
        String qry = subQueryTrackMap.get(subQry);
        qry = qry.replaceAll("(?i)(?<!\\w)select(?!\\w)", "select " + tabName + ",");
        subQueryTrackMap.put(subQry, qry);
    }

    private String doRplRowIdCols(String tableNme) {
        String tabName = tableNme;
        try {
            ReplacerMap tabDetails = new ReplacerMap();
            tabDetails.put("tabName", tabName);
            tabName = tabDetails.doSqlReplacement(DBPropertyLoader.getStringProperty("rowIDReplace"));
        }
        catch (MigrationServiceException e) {
            logger.error("Errored out while replacing ROWID in Query.");
        }
        return tabName;
    }
}

