/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.oracle;

import com.huawei.db.migration.exception.MigrationServiceException;
import com.huawei.db.migration.util.ColumnSplitter;
import com.huawei.db.migration.util.QueryConversionUtility;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OracleRownum {
    private static final Pattern ORDER_BY_DESC_ASC = Pattern.compile("(?i)(?<!\\w)desc|asc(?!\\w)");
    private static final Pattern ORDER_BY_PATTERN = Pattern.compile("((\\w+\\.?)\\w*)\\s*\\w*");
    private Pattern rownumPat = Pattern.compile("(?i)(?<!\\w)SELECT(?!\\w)(.*?)FROM\\s+.*?(?<!\\w)order\\s+by(?!\\w)(.*?)(?:(?<!\\w)where(?!\\w)|(?<!\\w)having(?!\\w)|(?<!\\w)group\\s+by(?!\\w)|$)");
    private ColumnSplitter splitter = new ColumnSplitter();
    private Map<String, String> subQueryTrackMap;
    private String alias;
    private String selectColumnBuf;
    private String orderByColumn;
    private String selectColumn;
    private String orderByStarCol;
    private String orderByCol;

    public String doProcessRowNumber(String inputSql, String subQry, Map<String, String> subQueryMap, String aliasParam) {
        this.subQueryTrackMap = subQueryMap;
        this.alias = aliasParam;
        String outputSql = inputSql;
        String subQueryVal = "";
        boolean containsSubQry = true;
        if (outputSql.contains("##SUBQUERY##") && subQry != null) {
            Matcher subQryMatcher;
            if (this.alias != null && (QueryConversionUtility.equalCheck(this.alias, "") || this.alias.matches("(?i)(?<!\\w)(LIMIT|WHERE|having|group|order)(?!\\w)"))) {
                this.alias = null;
            }
            outputSql = (subQryMatcher = this.rownumPat.matcher(subQueryVal = this.subQueryTrackMap.get(subQry))).find() ? this.doWithSubQryOrderBy(subQryMatcher, outputSql, subQueryVal, subQry) : this.doWithoutSubQryOrderBy(outputSql, containsSubQry);
        } else {
            containsSubQry = false;
            outputSql = this.doWithoutSubQryOrderBy(outputSql, containsSubQry);
        }
        return outputSql;
    }

    private String doWithSubQryOrderBy(Matcher subQryMatcher, String output, String subQueryVal, String subQry) {
        String outputSql = output;
        String subQrySelCols = subQryMatcher.group(1);
        String subQryOrderByCols = subQryMatcher.group(2);
        if (subQryOrderByCols != null) {
            if (!subQryOrderByCols.contains("(") && subQryOrderByCols.trim().endsWith(")")) {
                subQryOrderByCols = subQryOrderByCols.replace(")", "");
            }
            outputSql = this.doSelAndOrderByCols(subQryOrderByCols, subQrySelCols, outputSql, subQueryVal, subQry);
        }
        return outputSql;
    }

    private String doWithoutSubQryOrderBy(String output, boolean containsSubQry) {
        String outputSql = output;
        Matcher qryMatcher = this.rownumPat.matcher(outputSql);
        if (qryMatcher.find()) {
            String subQryOrderByCols = qryMatcher.group(2);
            String subQryOrderBy = "ORDER BY ";
            if (subQryOrderByCols != null) {
                if (!subQryOrderByCols.contains("(") && subQryOrderByCols.trim().endsWith(")")) {
                    subQryOrderByCols = subQryOrderByCols.replace(")", "");
                } else if (subQryOrderByCols.trim().endsWith(";")) {
                    subQryOrderByCols = subQryOrderByCols.substring(0, subQryOrderByCols.lastIndexOf(";"));
                }
                List<String> orderByColNames = this.splitter.doGetAllColumns(subQryOrderByCols.trim());
                String updtedSubQryOrderByCols = this.doGetOrderByCols(orderByColNames);
                subQryOrderBy = subQryOrderBy + updtedSubQryOrderByCols;
                outputSql = QueryConversionUtility.replace(outputSql, "(?i)row_number\\s*\\(\\s*\\)\\s+over\\s*\\(\\s*\\)", "ROW_NUMBER() OVER (" + subQryOrderBy + ")", true);
            }
        }
        return outputSql;
    }

    private String doGetOrderByCols(List<String> orderByColNames) {
        StringBuffer updtedSubQryOrderByCols = new StringBuffer();
        String commaOrEmpty = "";
        String columOrder = "";
        for (String orderByCln : orderByColNames) {
            columOrder = "";
            commaOrEmpty = QueryConversionUtility.equalCheck(updtedSubQryOrderByCols.toString(), "") ? "" : ",";
            if (!orderByCln.contains("(")) {
                if (orderByCln.trim().endsWith(")") || orderByCln.trim().endsWith("),")) {
                    orderByCln = orderByCln.replace("),", "").replace(")", "");
                }
                updtedSubQryOrderByCols = updtedSubQryOrderByCols.append(commaOrEmpty).append(orderByCln);
                continue;
            }
            Matcher orderByMatcher = ORDER_BY_DESC_ASC.matcher(orderByCln);
            if (orderByMatcher.find()) {
                columOrder = orderByMatcher.group();
            }
            updtedSubQryOrderByCols = updtedSubQryOrderByCols.append(commaOrEmpty).append(QueryConversionUtility.doGetReplaceString(orderByCln)).append(columOrder);
        }
        return updtedSubQryOrderByCols.toString();
    }

    private String doSelAndOrderByCols(String subQryOrderByCols, String subQrySelCoumnls, String rownumQry, String subQueryVal, String subQry) {
        String subQrySelCols = subQrySelCoumnls;
        List<String> orderByColNames = this.splitter.doGetAllColumns(subQryOrderByCols.trim());
        String updtedSubQryOrderByCols = this.doGetOrderByCols(orderByColNames);
        String subQryOrderBy = "ORDER BY " + updtedSubQryOrderByCols;
        List<String> updOrderByColNames = this.splitter.doGetAllColumns(updtedSubQryOrderByCols);
        List<String> selectColNames = this.splitter.doGetAllColumns(subQrySelCols);
        List<String> aliasColumns = QueryConversionUtility.doGetAliasList(selectColNames);
        int count = 1;
        String rownumQryRpl = rownumQry;
        for (String orderByColumns : updOrderByColNames) {
            this.selectColumnBuf = "";
            this.orderByColumn = "";
            this.selectColumn = "";
            this.orderByStarCol = "";
            this.orderByCol = "";
            this.doGetNonFuncColsOfOrderBy(orderByColumns);
            boolean orderByColWithDot = this.orderByColumn.endsWith(".");
            this.orderByCol = this.selectColumn;
            if (orderByColWithDot) {
                this.orderByStarCol = this.orderByColumn + "*";
                String columnWithoutAlias = this.selectColumn.replace(this.orderByColumn, "");
                count = this.checkOrderByColInSelCols(selectColNames, aliasColumns, count, columnWithoutAlias);
            } else if (!(selectColNames.contains(this.selectColumn) || selectColNames.contains("*") || aliasColumns.contains(this.selectColumn))) {
                String aliasOrSelCol = this.doCheckOrderByColsInSelectCols(selectColNames);
                if (QueryConversionUtility.equalCheck(this.selectColumn, aliasOrSelCol)) {
                    this.selectColumnBuf = this.selectColumnBuf + "," + this.selectColumn + " " + "AS" + " " + "MIG_ROW_ALIAS" + count;
                    this.orderByCol = "MIG_ROW_ALIAS" + count;
                    ++count;
                } else {
                    this.orderByCol = aliasOrSelCol;
                }
            }
            if (!QueryConversionUtility.equalCheck(this.selectColumnBuf, ",")) {
                subQrySelCols = subQrySelCols + this.selectColumnBuf;
            }
            this.orderByCol = this.doPlaceAliasInOrderByCols();
            subQryOrderBy = subQryOrderBy.replace(this.selectColumn, this.orderByCol + " ");
        }
        rownumQryRpl = this.doPutOrderByAndSelectColsInQry(rownumQryRpl, subQueryVal, subQryOrderBy, subQrySelCols, subQry);
        return rownumQryRpl;
    }

    private int checkOrderByColInSelCols(List<String> selectColNames, List<String> aliasColumns, int countVal, String columnWithoutAlias) {
        ArrayList<String> orderBycols = new ArrayList<String>(10);
        orderBycols.add(this.orderByStarCol);
        orderBycols.add(this.selectColumn);
        orderBycols.add("*");
        orderBycols.add(columnWithoutAlias);
        HashSet<String> commonOrderBySelCols = new HashSet<String>(selectColNames);
        commonOrderBySelCols.retainAll(orderBycols);
        int count = countVal;
        if (commonOrderBySelCols.size() == 0 && !aliasColumns.contains(this.selectColumn) && !aliasColumns.contains(columnWithoutAlias)) {
            String aliasOrSelCol = this.doCheckOrderByColsInSelectCols(selectColNames);
            if (QueryConversionUtility.equalCheck(this.selectColumn, aliasOrSelCol)) {
                this.selectColumnBuf = this.selectColumnBuf + "," + this.selectColumn + " " + "AS" + " " + "MIG_ROW_ALIAS" + count;
                this.orderByCol = "MIG_ROW_ALIAS" + count;
                ++count;
            } else {
                this.orderByCol = aliasOrSelCol;
            }
        }
        return count;
    }

    private void doGetNonFuncColsOfOrderBy(String orderByColumns) {
        if (!QueryConversionUtility.containsCheck(orderByColumns, "(")) {
            Matcher orderByMatcher = ORDER_BY_PATTERN.matcher(orderByColumns);
            if (orderByMatcher.find()) {
                this.selectColumn = orderByMatcher.group(1).trim();
                this.orderByColumn = orderByMatcher.group(2).trim();
            }
        } else {
            this.selectColumn = this.doGetOnlyFuncColsOfOrderByCols(orderByColumns);
        }
    }

    private String doGetOnlyFuncColsOfOrderByCols(String orderByColumns) {
        Matcher orderByMatcher = ORDER_BY_DESC_ASC.matcher(orderByColumns);
        this.selectColumn = orderByMatcher.find() ? orderByColumns.substring(0, orderByMatcher.start()) : orderByColumns;
        return this.selectColumn;
    }

    private String doPutOrderByAndSelectColsInQry(String rownumQryReplace, String subQryValue, String orderBy, String selColsClause, String subQry) {
        String subQueryVal = subQryValue;
        String rownumQryRpl = rownumQryReplace;
        rownumQryRpl = QueryConversionUtility.replace(rownumQryRpl, "(?i)row_number\\s*\\(\\s*\\)\\s+over\\s*\\(\\s*\\)", "ROW_NUMBER() OVER (" + orderBy + ")", true);
        int index = QueryConversionUtility.toLower(subQueryVal).indexOf("select");
        if ((index += 6) <= subQueryVal.length()) {
            subQueryVal = QueryConversionUtility.replace(subQueryVal, "(?i)\\(\\s*(#S#\\d+#E#)?\\s*SELECT(.*?)FROM", subQueryVal.substring(0, index) + selColsClause + " FROM ", true);
        }
        this.subQueryTrackMap.put(subQry, subQueryVal);
        return rownumQryRpl;
    }

    private String doPlaceAliasInOrderByCols() {
        if (this.alias != null) {
            this.orderByCol = this.orderByCol.indexOf(".") != -1 ? this.orderByCol.replace(this.orderByCol.substring(0, this.orderByCol.indexOf(".") + 1), this.alias + ".") : this.alias + "." + this.orderByCol;
        } else if (this.orderByCol.contains(".")) {
            this.orderByCol = QueryConversionUtility.replace(this.orderByCol, "(?i)" + this.orderByCol.substring(0, this.orderByCol.indexOf(".") + 1), " ", true);
        }
        return this.orderByCol;
    }

    private String doCheckOrderByColsInSelectCols(List<String> selectColumns) {
        String selColm = "";
        List<String> aliasColumns = QueryConversionUtility.doGetAliasList(selectColumns);
        String aliasOrSelCol = this.selectColumn;
        String colWithoutAlias = "";
        if (this.selectColumn.indexOf(".") != -1) {
            colWithoutAlias = this.selectColumn.substring(this.selectColumn.indexOf(".") + 1);
        }
        for (int index = 0; index < selectColumns.size(); ++index) {
            selColm = selectColumns.get(index);
            String[] selClmnSplit = selColm.split(" ");
            if (this.selectColumn.contains(".")) {
                if ((selClmnSplit.length <= 0 || !QueryConversionUtility.equalCheck(selClmnSplit[0], this.selectColumn)) && !QueryConversionUtility.equalCheck(selClmnSplit[0], colWithoutAlias)) continue;
                aliasOrSelCol = this.getElementFromList(aliasColumns, index);
                break;
            }
            if (selClmnSplit.length <= 0 || !QueryConversionUtility.equalCheck(selClmnSplit[0], this.selectColumn)) continue;
            aliasOrSelCol = this.getElementFromList(aliasColumns, index);
            break;
        }
        return aliasOrSelCol;
    }

    private String getElementFromList(List<String> aliasColumns, int index) {
        if (index < aliasColumns.size()) {
            return aliasColumns.get(index);
        }
        throw new MigrationServiceException("Incorrect List size");
    }
}

