/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.oracle;

import com.huawei.db.migration.exception.MigrationServiceException;
import com.huawei.db.migration.oracle.OraclePreQueryProcessing;
import com.huawei.db.migration.oracle.OracleQueryKeywordReplacerExt;
import com.huawei.db.migration.oracle.OracleUtility;
import com.huawei.db.migration.util.ErrorLoggerUtility;
import com.huawei.db.migration.util.FeatureLoader;
import com.huawei.db.migration.util.MessageLoader;
import com.huawei.db.migration.util.QueryConversionUtility;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OracleSchemaHandler {
    private static final Logger logger = LogManager.getLogger(OracleSchemaHandler.class);

    public List<String> doSchemaProcess(List<String> inputList, String fileName, List<?> patterns, Set<String> uniqueConsPartition) throws MigrationServiceException {
        String output = null;
        int position = 0;
        ArrayList<String> outputList = new ArrayList<String>(10);
        for (String input : inputList) {
            try {
                String[] inputSplit;
                ++position;
                if (input.contains("~#~") && (inputSplit = input.split("~#~")).length > 1) {
                    input = inputSplit[0];
                    position = Integer.parseInt(inputSplit[1].trim());
                }
                output = input = QueryConversionUtility.doRemoveExtraSpace(input);
                if (QueryConversionUtility.containsCheck(input, "session")) {
                    output = this.getOutQry(output, input);
                }
                LinkedHashMap<String, String> quoteMap = new LinkedHashMap<String, String>(10);
                output = this.doChangesOnSchema(fileName, uniqueConsPartition, output, quoteMap);
                outputList.add(output);
            }
            catch (MigrationServiceException e) {
                ErrorLoggerUtility.failedQryCnt();
                outputList.add(output);
                ErrorLoggerUtility.failedFileCnt(fileName);
                logger.error(MessageLoader.getMessage("queryProcessingError") + " " + fileName + " " + MessageLoader.getMessage("queryPosInfo") + position);
                logger.error(e.getMessage());
            }
            catch (RuntimeException e) {
                ErrorLoggerUtility.failedQryCnt();
                ErrorLoggerUtility.failedFileCnt(fileName);
                outputList.add(output);
                logger.error(ErrorLoggerUtility.getExceptionDetails(e) + " " + MessageLoader.getMessage("queryProcessingError") + " " + fileName + " " + MessageLoader.getMessage("queryPosInfo") + position);
            }
        }
        return outputList;
    }

    private String doChangesOnSchema(String fileName, Set<String> uniqueConsPartition, String input, Map<String, String> quoteMap) {
        String output = input;
        if (QueryConversionUtility.containsCheck(output = QueryConversionUtility.getSingleDoubleQuoteMap(output, quoteMap), "ALTER ".trim()) && QueryConversionUtility.containsCheck(output, "modify") && !FeatureLoader.getBooleanProperty("MigSupForAlterTableModify")) {
            output = this.alterTblModify(output);
        }
        if (QueryConversionUtility.containsCheck(output, "CURRVAL") || QueryConversionUtility.containsCheck(output, "NEXTVAL")) {
            output = OracleUtility.doChangeNextCurrVal(output);
        }
        if (QueryConversionUtility.containsCheck(output, "PCTINCREASE ")) {
            output = output.replaceAll("(?i)(?<!\\w)PCTINCREASE\\s+\\d+", "");
        }
        if (output.matches("(?i).*(?<!\\w)create(?!\\w).*(?<!\\w)sequence(?!\\w).*")) {
            output = OraclePreQueryProcessing.doPreSequenceChanges(output);
        } else if (output.matches("(?i).*(?<!\\w)(?:create|alter).*?(?<!\\w)(?:table|index|unique\\s+index)(?!\\w).*")) {
            output = QueryConversionUtility.getRplFromMap(output, quoteMap, "(##QUOTE##\\d+#)");
            output = OracleQueryKeywordReplacerExt.doPreSchemaKeywordChanges(output, uniqueConsPartition);
        }
        if (output.matches("(?i).*(?<!\\w)(?:create|alter).*?(?<!\\w)(?:index|unique\\s+index)(?!\\w).*")) {
            output = OracleQueryKeywordReplacerExt.doPreIndexChanges(output, fileName);
        }
        output = QueryConversionUtility.getRplFromMap(output, quoteMap, "(##QUOTE##\\d+#)");
        return output;
    }

    private String getOutQry(String outQry, String input) {
        String output = outQry;
        String inputWOCmnt = input.replaceAll("(?i)#S#\\d+#E#", "").trim();
        if (inputWOCmnt.matches("(?i).*(alter\\s+session\\s+(?:ADVISE\\s+(?:COMMIT|ROLLBACK|NOTHING)|CLOSE\\s+DATABASE\\s+LINK|(?:ENABLE|DISABLE)\\s+(?:RESUMABLE|COMMIT\\s+IN\\s+PROCEDURE|GUARD|PARALLEL\\s+(?:DML|DDL|QUERY))|FORCE\\s+PARALLEL\\s+(?:DML|DDL|QUERY)).*)")) {
            output = QueryConversionUtility.containsCheck(inputWOCmnt, "'") && QueryConversionUtility.containsCheck(inputWOCmnt, "||") && inputWOCmnt.endsWith(";") ? "/*" + input.substring(0, input.indexOf(59)) + " " + "|" + "|" + " " + "'" + "*/" + "'" + ";" : "/*" + input + "*/";
        }
        return output;
    }

    private String alterTblModify(String input) {
        String output = input;
        Pattern alterTblModify = Pattern.compile("(?i).*?((?<!\\w)alter(?!\\w)\\s+table(?!\\w))(.*?)(?<!\\w)modify\\s*\\((.*?)((?:not\\s+null)|null)(?:\\s+enable)?\\s*\\).*");
        Matcher alterTblModifyMatch = alterTblModify.matcher(output);
        String alter = null;
        String table = null;
        String var = null;
        String nullVal = null;
        StringBuffer sb = new StringBuffer();
        while (alterTblModifyMatch.find()) {
            alter = alterTblModifyMatch.group(1);
            table = alterTblModifyMatch.group(2);
            var = alterTblModifyMatch.group(3);
            nullVal = alterTblModifyMatch.group(4);
            sb.append(alter).append(table).append("ALTER ");
            sb.append(" ").append(var).append(" ").append("SET");
            sb.append(" ").append(nullVal).append(";");
        }
        if (!sb.toString().equals("")) {
            output = sb.toString();
        }
        return output;
    }
}

