/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.oracle;

import com.huawei.db.migration.exception.MigrationServiceException;
import com.huawei.db.migration.oracle.OracleMapHelper;
import com.huawei.db.migration.oracle.OracleQueryKeywordReplacerExt;
import com.huawei.db.migration.services.OracleMigrationService;
import com.huawei.db.migration.util.ColumnSplitter;
import com.huawei.db.migration.util.FeatureLoader;
import com.huawei.db.migration.util.IGaussDBConstants;
import com.huawei.db.migration.util.MessageLoader;
import com.huawei.db.migration.util.QueryConversionUtility;
import com.huawei.db.migration.util.QueryUtilityExt;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OracleUtility {
    private static final Pattern DBMS_LOB_PAT = Pattern.compile("(?i)dbms_lob.substr\\s*\\(");
    private static final Pattern APPEND_PAT = Pattern.compile("(?i)(?<!\\w)((?:sys\\.)?dbms_lob\\.append\\s*\\()");
    private static final Pattern TYPE_PAT = Pattern.compile("(?i)(?<!\\w)\\w*(\\.\\s*)?\\w+\\.\\s*\\w+%TYPE(?!\\w)");
    private Map<String, String> createTypeMap = OracleMigrationService.getCreateTypeMap();

    public String stringFunctions(String outputQry) {
        String output = outputQry;
        output = output.replaceAll("(?i)\\w+\\.instr\\s*\\(", "INSTR(");
        if (FeatureLoader.getBooleanProperty("MigDbmsLob")) {
            Matcher dbmsLobMat = DBMS_LOB_PAT.matcher(output);
            while (dbmsLobMat.find()) {
                ColumnSplitter colSplitter = new ColumnSplitter();
                String dbmsLobStr = output.substring(dbmsLobMat.start());
                dbmsLobStr = QueryConversionUtility.doGetReplaceString(dbmsLobStr);
                String dbmsLobArgs = dbmsLobStr.substring(dbmsLobStr.indexOf(40) + 1, dbmsLobStr.lastIndexOf(41));
                List<String> args = colSplitter.doGetAllColumns(dbmsLobArgs);
                StringBuffer replacement = new StringBuffer(dbmsLobStr.substring(9, dbmsLobStr.indexOf(40) + 1));
                if (args.size() == 2) {
                    args.add("1");
                }
                if (args.size() == 3) {
                    replacement.append(args.get(0)).append(",").append(args.get(2)).append(",").append(args.get(1)).append(")");
                } else {
                    replacement.append(dbmsLobArgs).append(")");
                }
                output = output.replace(dbmsLobStr, replacement);
                dbmsLobMat = DBMS_LOB_PAT.matcher(output);
            }
        }
        return output;
    }

    public String tempFunctionCursor(String input) throws MigrationServiceException {
        String output = QueryConversionUtility.doCommentSpecificGrp(input, "(?i)(DBMS_LOB\\.CREATETEMPORARY.*?;)", 1);
        output = QueryConversionUtility.doReplaceSpecificGrp(output, "(?i)(DBMS_LOB\\.FREETEMPORARY\\s*\\(\\s*(.*?)\\s*\\)\\s*;)", "/*", "*/ null;", 1, true);
        return output;
    }

    public String doReplaceClob(String inputSql) throws MigrationServiceException {
        String outputSql = inputSql;
        Pattern clobPattern = Pattern.compile("(?i)(?<!\\w|\\.)TO_CLOB\\s*\\(");
        Matcher clobMatcher = clobPattern.matcher(inputSql);
        while (clobMatcher.find()) {
            StringBuffer replaceBuf = new StringBuffer();
            String function = QueryConversionUtility.doGetReplaceString(inputSql.substring(clobMatcher.start()));
            String errStr = function.substring(function.indexOf(40) + 1, function.length() - 1);
            if (errStr.trim().isEmpty()) {
                throw new MigrationServiceException("[DSC_ERR_002_006] CLOB" + MessageLoader.getMessage("DSC_ERR_002_006"));
            }
            ColumnSplitter splitter = new ColumnSplitter();
            List<String> errorCheck = splitter.doGetAllColumns(errStr);
            if (errorCheck.size() > 1) {
                throw new MigrationServiceException("[DSC_ERR_002_006] CLOB" + MessageLoader.getMessage("DSC_ERR_002_006"));
            }
            replaceBuf.append("cast").append("(");
            replaceBuf.append(function.substring(function.indexOf(40) + 1));
            replaceBuf.deleteCharAt(replaceBuf.length() - 1);
            replaceBuf.append(" as CLOB)");
            outputSql = outputSql.replace(function, replaceBuf.toString());
        }
        return outputSql;
    }

    public String doMigrateHeaderStmt(String input) {
        String output = input;
        LinkedHashMap<String, String> quoteMap = new LinkedHashMap<String, String>(10);
        output = QueryConversionUtility.getSingleDoubleQuoteMap(output, quoteMap);
        output = this.doConvertLongDT(output);
        output = this.doConvertLongRawDT(output);
        output = QueryConversionUtility.getRplFromMap(output, quoteMap, "(##QUOTE##\\d+#)");
        return output;
    }

    private String doConvertLongDT(String input) {
        String output = input.replaceAll("(?i)(?<!\\w)LONG(?!\\s+RAW|\\w)", "TEXT");
        return output;
    }

    private String doConvertLongRawDT(String input) {
        String output = input.replaceAll("(?i)(?<!\\w)LONG\\s+RAW(?!\\w)", "BYTEA");
        return output;
    }

    public String doRplParallelEnable(String input) {
        String output = input;
        if (input.matches("(?i).*?((?<!\\w)return(?!\\w)).*")) {
            int index = QueryConversionUtility.getStartIndex(input, "(?i).*?((?<!\\w)return(?!\\w)).*", 1);
            String subStr = input.substring(0, index);
            String reqStr = input.substring(index);
            Pattern pattern = Pattern.compile("(?i)(?<!\\w)parallel_enable\\s*\\(");
            Matcher matcher = pattern.matcher(reqStr);
            String tempFunction = null;
            if (matcher.find()) {
                tempFunction = QueryConversionUtility.doGetReplaceString(reqStr.substring(matcher.start()));
                reqStr = reqStr.replace(tempFunction, "");
            } else {
                reqStr = QueryConversionUtility.doReplaceExactStr("parallel_enable", "", reqStr);
            }
            output = subStr + reqStr;
        }
        return output;
    }

    public String doMigrateDeclareStmt(String input, StringBuffer varrayDecVars) {
        String output = input;
        LinkedHashMap<String, String> quoteMap = new LinkedHashMap<String, String>(10);
        output = QueryConversionUtility.getSingleDoubleQuoteMap(output, quoteMap);
        output = this.doConvertLongDT(output);
        output = this.doConvertLongRawDT(output);
        output = QueryConversionUtility.getRplFromMap(output, quoteMap, "(##QUOTE##\\d+#)");
        if (QueryConversionUtility.equalCheck(FeatureLoader.getStringProperty("plsqlCollection"), "VARRAY")) {
            output = this.commentVarryRecordInit(output, varrayDecVars);
        }
        return output;
    }

    private String commentVarryRecordInit(String outputQry, StringBuffer varrayDecVars) {
        String output = outputQry;
        Map<String, String> createTypesDDL = OracleMigrationService.getCreateTypeMap();
        Map<String, String> packageTypesDDL = OracleMigrationService.getPackageNameMap();
        Pattern cmntType = Pattern.compile("(?i)\\s*(?<varname>\\w+)\\s+(?<vartype>\\w*\\.?\\w+)\\s*(?<varval>:=.*?);");
        Matcher cmntMatch = cmntType.matcher(output);
        StringBuffer sb = new StringBuffer();
        int startIdx = 0;
        int tempIdx = 0;
        int endIdx = 0;
        String value = null;
        while (cmntMatch.find()) {
            String key = cmntMatch.group("vartype");
            String rplWOCmnt = cmntMatch.group("varval");
            String rplCmnt = "/*" + rplWOCmnt + "*/";
            if (key != null && !key.isEmpty()) {
                if (!key.contains(".")) {
                    String table = QueryConversionUtility.toUpper(key) + "_VARRAY";
                    value = createTypesDDL.get(table);
                    if (value == null) {
                        table = QueryConversionUtility.toUpper(key + "_" + "record");
                        value = createTypesDDL.get(table);
                    }
                } else {
                    value = packageTypesDDL.get(key);
                }
            }
            tempIdx = cmntMatch.start("varval");
            endIdx = cmntMatch.end("varval");
            if (value != null && !value.startsWith("SUBTYPE")) {
                sb.append(output.substring(startIdx, tempIdx));
                sb.append(rplCmnt);
                varrayDecVars.append(cmntMatch.group("varname")).append(" ").append(rplWOCmnt).append(";");
            } else {
                sb.append(output.substring(startIdx, endIdx));
            }
            startIdx = endIdx;
        }
        if (!sb.toString().isEmpty()) {
            sb.append(output.substring(endIdx));
            output = sb.toString();
        }
        return output;
    }

    public String appendFunction(String inputSql, String caller) throws MigrationServiceException {
        String output = inputSql;
        Matcher matcher = APPEND_PAT.matcher(inputSql);
        String function = null;
        List<String> colList = null;
        String errCheck = null;
        ColumnSplitter splitter = new ColumnSplitter();
        while (matcher.find()) {
            function = QueryConversionUtility.doGetReplaceString(inputSql.substring(matcher.start(1)));
            errCheck = function.substring(function.indexOf(40) + 1, function.length() - 1);
            colList = splitter.doGetAllColumns(errCheck);
            if (errCheck.trim().isEmpty() || colList.size() < 2) {
                throw new MigrationServiceException("[DSC_ERR_002_006] DBMS_LOB.APPEND" + MessageLoader.getMessage("DSC_ERR_002_006"));
            }
            if (colList.size() > 2) {
                throw new MigrationServiceException("[DSC_ERR_002_006] DBMS_LOB.APPEND" + MessageLoader.getMessage("DSC_ERR_002_006"));
            }
            StringBuffer outFunc = new StringBuffer();
            if (caller.equals("blogic")) {
                outFunc.append(colList.get(0)).append(" := ");
            }
            outFunc.append("CONCAT(").append(errCheck).append(")");
            output = output.replace(function, outFunc.toString());
        }
        return output;
    }

    public static String doChangeDefaultFunctions(String declaredPkgVariables) throws MigrationServiceException {
        String declaredPkgVars = declaredPkgVariables;
        if (QueryConversionUtility.containsCheck(declaredPkgVars, "SYSTIMESTAMP")) {
            declaredPkgVars = declaredPkgVars.replaceAll("(?i)(?<!\\w)SYSTIMESTAMP(?!\\w)", "CURRENT_TIMESTAMP");
        }
        if (QueryConversionUtility.containsCheck(declaredPkgVars, "nvl2")) {
            declaredPkgVars = OracleQueryKeywordReplacerExt.doReplaceNVLFn(declaredPkgVars);
        }
        declaredPkgVars = OracleQueryKeywordReplacerExt.doAppendSchemaInFnNme(declaredPkgVars, "ADD_MONTHS");
        OracleUtility util = new OracleUtility();
        if (QueryConversionUtility.containsCheck(declaredPkgVars, "LAST_DAY") && !QueryConversionUtility.isGaus100()) {
            declaredPkgVars = util.doAddSchemaInFunctionNme(declaredPkgVars, "(?i).*?(?<!function\\s|procedure\\s|table\\s|insert\\sinto\\s|update\\s|view\\s|\\.|\\w|#)(LAST_DAY\\s*\\()", "LAST_DAY", 1, 1, "LAST_DAY");
        }
        if (QueryConversionUtility.containsCheck(declaredPkgVars, "MONTHS_BETWEEN")) {
            declaredPkgVars = util.doAddSchemaInFunctionNme(declaredPkgVars, "(?i).*?(?<!function\\s|procedure\\s|table\\s|insert\\sinto\\s|update\\s|view\\s|\\.|\\w|#)(MONTHS_BETWEEN\\s*\\()", "MONTHS_BETWEEN", 2, 2, "MONTHS_BETWEEN");
        }
        if (QueryConversionUtility.containsCheck(declaredPkgVars, "to_clob")) {
            declaredPkgVars = util.doReplaceClob(declaredPkgVars);
        }
        if (QueryConversionUtility.containsCheck(declaredPkgVars, "dbms_lob")) {
            declaredPkgVars = util.stringFunctions(declaredPkgVars);
        }
        if (QueryConversionUtility.toUpper(declaredPkgVars).contains("REPLACE")) {
            declaredPkgVars = util.doModifyReplaceFunction(declaredPkgVars);
        }
        return declaredPkgVars;
    }

    public static String doChangeDataType(String declaredPkgVariables) {
        String declaredPkgVars = declaredPkgVariables;
        if (QueryConversionUtility.containsCheck(declaredPkgVars, "String")) {
            declaredPkgVars = QueryConversionUtility.doReplaceExactStr("String", "varchar", declaredPkgVars);
        }
        if (QueryConversionUtility.containsCheck(declaredPkgVars, "Long")) {
            declaredPkgVars = declaredPkgVars.replaceAll("(?i)(?<!\\w)LONG(?!\\s+RAW|\\w)", "TEXT");
        }
        return declaredPkgVars;
    }

    public String doModifyReplaceFunction(String inputSql) throws MigrationServiceException {
        String tempSQL;
        String output = tempSQL = inputSql.replaceAll("\\s+,\\s+|\\s+,|,\\s+", ",");
        Pattern replaceFnPattern = Pattern.compile("(?i)(?<!function\\s|procedure\\s|table\\s|insert\\sinto\\s|update\\s|view\\s|\\.|\\w)(replace\\s*\\()");
        Matcher replaceFnMatch = replaceFnPattern.matcher(tempSQL);
        String tempFunction = null;
        String replaceFnStr = null;
        String replaceFnParams = null;
        List<String> replaceFnParamsLst = null;
        StringBuffer replacementString = null;
        ColumnSplitter splitter = new ColumnSplitter();
        while (replaceFnMatch.find()) {
            replacementString = new StringBuffer();
            replaceFnStr = QueryConversionUtility.doGetReplaceString(tempSQL.substring(replaceFnMatch.start(1)));
            replaceFnParams = QueryConversionUtility.removeParenthesis(replaceFnStr);
            replaceFnParamsLst = splitter.doGetAllColumns(replaceFnParams);
            if (replaceFnParamsLst.size() < 2) {
                throw new MigrationServiceException("[DSC_ERR_002_006] REPLACE" + MessageLoader.getMessage("DSC_ERR_002_006"));
            }
            if (replaceFnParamsLst.size() > 3) {
                throw new MigrationServiceException("[DSC_ERR_002_006] REPLACE" + MessageLoader.getMessage("DSC_ERR_002_006"));
            }
            if (replaceFnParamsLst.size() == 2) {
                replaceFnParamsLst.add("''");
            }
            replacementString.append(QueryConversionUtility.toUpper("Replace")).append("(").append(QueryConversionUtility.doGetStrFrmListWithSeparator(replaceFnParamsLst, ",")).append(")");
            tempFunction = replacementString.toString().replaceAll("\\s+,\\s+|\\s+,|,\\s+", ",");
            output = output.replace(replaceFnStr, tempFunction);
        }
        return output;
    }

    public String doAddSchemaInFunctionNme(String inputSql, String functionPattern, String functionNme, int minParam, int maxParam, String newFnNme) throws MigrationServiceException {
        String tempSQL;
        String output = tempSQL = inputSql.replaceAll("\\s+,\\s+|\\s+,|,\\s+", ",");
        Pattern funcPattern = Pattern.compile(functionPattern);
        Matcher funMatch = funcPattern.matcher(output);
        while (funMatch.find()) {
            StringBuffer replacementString = new StringBuffer();
            String functionStr = QueryConversionUtility.doGetReplaceString(output.substring(funMatch.start(1)));
            String functionParams = QueryConversionUtility.removeParenthesis(functionStr).trim();
            if (functionParams.isEmpty()) {
                throw new MigrationServiceException("[DSC_ERR_002_006] " + functionStr + MessageLoader.getMessage("DSC_ERR_002_006"));
            }
            ColumnSplitter splitter = new ColumnSplitter();
            List<String> functionParamsLst = splitter.doGetAllColumns(functionParams);
            if (functionParamsLst.size() < minParam) {
                throw new MigrationServiceException("[DSC_ERR_002_006] " + functionStr + MessageLoader.getMessage("DSC_ERR_002_006"));
            }
            if (functionParamsLst.size() > maxParam) {
                if (functionNme.equals("REGEXP_INSTR") && functionParamsLst.size() == 7) {
                    throw new MigrationServiceException("[DSC_ERR_002_006] " + functionStr + MessageLoader.getMessage("DSC_ERR_002_006"));
                }
                if (functionNme.equals("REGEXP_SUBSTR") && functionParamsLst.size() == 6) {
                    throw new MigrationServiceException("[DSC_ERR_002_006] " + functionStr + MessageLoader.getMessage("DSC_ERR_002_006"));
                }
                throw new MigrationServiceException("[DSC_ERR_002_006] " + functionStr + MessageLoader.getMessage("DSC_ERR_002_006"));
            }
            replacementString.append("MIG_ORA_EXT.").append(newFnNme).append("(").append(functionParams).append(")");
            String tempFunction = replacementString.toString().replaceAll("\\s+,\\s+|\\s+,|,\\s+", ",");
            output = output.replace(functionStr, tempFunction);
            funMatch = funcPattern.matcher(output);
        }
        return output;
    }

    public static String doCommentSubPartClause(String input) {
        int srtIndex;
        String output = input;
        if (QueryConversionUtility.containsCheck(output, "SUBPARTITION")) {
            if (output.matches("(?i).*(?<!\\w)SUBPARTITION\\s+BY\\s+LIST(?!\\w).*") && !"false".equalsIgnoreCase(FeatureLoader.getStringProperty("RemoveListSubPartition"))) {
                output = OracleMapHelper.doReplaceSubpartitionFn(output, "(?i)(?<!\\w)(SUBPARTITION\\s+BY\\s+LIST)(?!\\w)");
                output = OracleUtility.doChangeSubpartition(output);
            } else if (output.matches("(?i).*(?<!\\w)SUBPARTITION\\s+BY\\s+HASH(?!\\w).*") && !"false".equalsIgnoreCase(FeatureLoader.getStringProperty("RemoveHashSubPartition"))) {
                output = OracleMapHelper.doReplaceSubpartitionFn(output, "(?i)(?<!\\w)(SUBPARTITION\\s+BY\\s+HASH)(?!\\w)");
                output = OracleUtility.doChangeSubpartition(output);
            } else if (output.matches("(?i).*(?<!\\w)SUBPARTITION\\s+BY\\s+RANGE(?!\\w).*") && !"false".equalsIgnoreCase(FeatureLoader.getStringProperty("RemoveRangeSubPartition"))) {
                output = OracleMapHelper.doReplaceSubpartitionFn(output, "(?i)(?<!\\w)(SUBPARTITION\\s+BY\\s+RANGE)(?!\\w)");
                output = OracleUtility.doChangeSubpartition(output);
            }
        } else if ((QueryConversionUtility.containsCheck(output, "NUMTODSINTERVAL") || QueryConversionUtility.containsCheck(output, "NUMTOYMINTERVAL")) && (srtIndex = QueryConversionUtility.getEndIndex(output, "(?i)PARTITION\\s+BY\\s+RANGE(?:.*?)INTERVAL\\s*\\(?\\s*(?:NUMTODSINTERVAL|NUMTOYMINTERVAL)\\(", 0)) != -1) {
            int stIndex = output.indexOf("(", srtIndex);
            if (srtIndex != -1) {
                String[] strArr = QueryUtilityExt.doGetStringFromGivenIndexAndGetEndIndex(stIndex, output);
                int endIndex = Integer.parseInt(strArr[1]);
                String outputlower = QueryConversionUtility.toLower(output);
                int partindex = outputlower.lastIndexOf("partition", srtIndex);
                String tobeComnted = output.substring(partindex, endIndex + 1);
                output = output.replace(tobeComnted, "/*" + tobeComnted + "*/");
            }
        }
        return output;
    }

    private static String doChangeSubpartition(String input) {
        String output = input;
        output = QueryConversionUtility.doReplaceSpecificGrp(output, "(?i)(?<!\\w)(SUBPARTITIONS\\s+\\d+\\s+STORE\\s+IN\\s+\\w+)", "/*", "*/", 1, true);
        output = OracleMapHelper.doReplaceSubpartitionFn(output, "(?i)(?<!\\w)(SUBPARTITIONS\\s+\\d+\\s+STORE\\s+IN\\s*\\()");
        output = OracleMapHelper.doReplaceSubpartitionFn(output, "(?i)(?<!\\w)(SUBPARTITION\\s+TEMPLATE)(?!\\w)");
        output = QueryConversionUtility.doReplaceSpecificGrp(output, "(?i)(?<!\\w|\\/\\*)(SUBPARTITIONS\\s+\\d+\\s*)(?!\\w)", "/*", "*/", 1, true);
        output = OracleMapHelper.doReplaceSubpartitionFn(output, "(?i)(\\(\\s*SUBPARTITION)(?!\\w)");
        return output;
    }

    public static String doChangeAlterSubpartition(String input) {
        String output = input;
        if (input.matches("(?i).*?(?<!\\w)SUBPARTITION\\s+\\w+\\s+VALUES\\s+LESS\\s+THAN(?!\\w).*") && !"false".equalsIgnoreCase(FeatureLoader.getStringProperty("RemoveRangeSubPartition"))) {
            output = OracleUtility.doChangeSubpartition(input);
        } else if (input.matches("(?i).*?(?<!\\w)SUBPARTITION\\s+\\w+\\s+VALUES(?!\\w).*") && !"false".equalsIgnoreCase(FeatureLoader.getStringProperty("RemoveListSubPartition"))) {
            output = OracleUtility.doChangeSubpartition(input);
        } else if (!"false".equalsIgnoreCase(FeatureLoader.getStringProperty("RemoveHashSubPartition"))) {
            output = OracleUtility.doChangeSubpartition(input);
        }
        return output;
    }

    public static String doCommentPartition(String outputQry, String pattern, String partitionNme) {
        String output = outputQry;
        output = !"false".equalsIgnoreCase(FeatureLoader.getStringProperty(partitionNme)) ? QueryConversionUtility.doReplaceSpecificGrp(output, pattern, "/*", "*/", 1, true) : OracleUtility.doCommentSubPartClause(output);
        return output;
    }

    public static String doCommentTableSpace(String outputQry) {
        String output = outputQry;
        output = OracleUtility.doCommentTableSpaceList(output);
        output = OracleUtility.doCommentTableSpaceHash(output);
        output = OracleUtility.doCommentTableSpaceRange(output);
        return output;
    }

    private static String doCommentTableSpaceRange(String outputQry) {
        String output = outputQry;
        if (output.matches("(?i).*(?<!\\w)PARTITION\\s+BY\\s+RANGE(?!\\w).*")) {
            HashMap<String, String> functionMap = new HashMap<String, String>(5);
            output = OracleMapHelper.doReplaceSubPartitionClause(output, functionMap);
            output = QueryConversionUtility.doReplaceSpecificGrp(output, "(?i)(?<!\\w)(tablespace\\s+.*?)(;|,|\\)|\\s)", "/*", "*/", 1, true);
            output = QueryConversionUtility.doReplaceFunctionVariables(output, functionMap, "##SUBPART##").trim();
        }
        return output;
    }

    private static String doCommentTableSpaceHash(String outputQry) {
        String output = outputQry;
        if (output.matches("(?i).*(?<!\\w)PARTITION\\s+BY\\s+HASH(?!\\w).*") && "false".equalsIgnoreCase(FeatureLoader.getStringProperty("RemoveHashPartition"))) {
            HashMap<String, String> functionMap = new HashMap<String, String>(5);
            output = OracleMapHelper.doReplaceSubPartitionClause(output, functionMap);
            QueryConversionUtility.setPattern("(?i).*(?<!\\w)PARTITION\\s+BY\\s+HASH(?!\\w).*");
            output = QueryConversionUtility.doCommentTableSpaceListHash(output, "/*", "*/", 1, true);
            output = QueryConversionUtility.doReplaceFunctionVariables(output, functionMap, "##SUBPART##").trim();
        }
        return output;
    }

    private static String doCommentTableSpaceList(String outputQry) {
        String output = outputQry;
        if (output.matches("(?i).*(?<!\\w)PARTITION\\s+BY\\s+LIST(?!\\w).*") && "false".equalsIgnoreCase(FeatureLoader.getStringProperty("RemoveListPartition"))) {
            HashMap<String, String> functionMap = new HashMap<String, String>(5);
            output = OracleMapHelper.doReplaceSubPartitionClause(output, functionMap);
            QueryConversionUtility.setPattern("(?i).*(?<!\\w)PARTITION\\s+BY\\s+LIST(?!\\w).*");
            output = QueryConversionUtility.doCommentTableSpaceListHash(output, "/*", "*/", 1, true);
            output = QueryConversionUtility.doReplaceFunctionVariables(output, functionMap, "##SUBPART##").trim();
        }
        return output;
    }

    public static String doCmntAlterTblPartition(String outputQry, String partitionName) {
        String output = outputQry;
        output = !"false".equalsIgnoreCase(FeatureLoader.getStringProperty(partitionName)) ? "/*" + output + "*/" : OracleUtility.doChangeAlterSubpartition(output);
        return output;
    }

    public static String doChangeRatioToReport(String input) {
        String output = input;
        Pattern ratioPat = Pattern.compile("(?i)(?<!\\w)(RATIO_TO_REPORT\\s*\\(.*?)(over\\s*\\()");
        Matcher ratioMatch = ratioPat.matcher(output);
        String ratioToReport = null;
        String over = null;
        String ratioColumn = null;
        StringBuffer replacementStr = null;
        while (ratioMatch.find()) {
            replacementStr = new StringBuffer();
            ratioToReport = ratioMatch.group(1);
            ratioColumn = QueryConversionUtility.removeParenthesis(ratioToReport).trim();
            over = QueryConversionUtility.doGetReplaceString(output.substring(ratioMatch.start(2)));
            replacementStr.append(ratioColumn).append("/");
            replacementStr.append("NULLIF").append("(");
            replacementStr.append(QueryConversionUtility.toUpper("sum")).append("(").append(ratioColumn).append(")").append(" ");
            replacementStr.append(over).append(",").append(0).append(")");
            output = output.replaceAll(Pattern.quote(ratioToReport + over), replacementStr.toString());
            ratioMatch = ratioPat.matcher(output);
        }
        return output;
    }

    public static String doCheckRatioToReport(String input) throws MigrationServiceException {
        String output = input;
        Pattern ratioPat = Pattern.compile("(?i)(?<!\\w)(RATIO_TO_REPORT\\s*\\(.*?)(over\\s*\\()");
        Matcher ratioMatch = ratioPat.matcher(output);
        String ratioToReport = null;
        String ratioColumn = null;
        List<String> paramsLst = null;
        ColumnSplitter splitter = new ColumnSplitter();
        while (ratioMatch.find()) {
            ratioToReport = ratioMatch.group(1);
            ratioColumn = QueryConversionUtility.removeParenthesis(ratioToReport).trim();
            if (ratioColumn.isEmpty()) {
                throw new MigrationServiceException("[DSC_ERR_002_006] RATIO_TO_REPORT" + MessageLoader.getMessage("DSC_ERR_002_006"));
            }
            paramsLst = splitter.doGetAllColumns(ratioColumn);
            if (paramsLst.size() > 1) {
                throw new MigrationServiceException("[DSC_ERR_002_006] RATIO_TO_REPORT" + MessageLoader.getMessage("DSC_ERR_002_006"));
            }
            if (!ratioColumn.contains("(") || ratioColumn.matches("(?i).*(?<!\\w)(MAX|MIN|SUM|AVG|COUNT|STDDEV)\\s*\\(.*")) continue;
            throw new MigrationServiceException("[DSC_ERR_002_007] " + MessageLoader.getMessage("DSC_ERR_002_007"));
        }
        return output;
    }

    private static String getSequenceMatchGrpVal(String input, String paramString, int grpNo) {
        String value = null;
        Pattern pattern = Pattern.compile("(?i)(?<!\\w)" + paramString + "\\s+(-?\\s*\\d+)");
        Matcher matcher = pattern.matcher(input);
        if (matcher.find()) {
            value = matcher.group(grpNo).replace(" ", "");
        }
        return value;
    }

    public static String doChangeNextCurrVal(String input) {
        String output = input;
        Pattern patternVal = Pattern.compile("(?i)(\\w*\\.?\\w+)\\.(?<!MIG_ORA_EXT\\.)((?:NEXTVAL|CURRVAL)(?:\\s*\\(\\s*\\))?)(?!\\w|\\('?\\w+\\)?)");
        Matcher matcherVal = patternVal.matcher(output);
        String nextCurrVal = null;
        String nextVal = null;
        String schemaSeq = null;
        StringBuffer replacementVal = null;
        while (matcherVal.find()) {
            replacementVal = new StringBuffer();
            schemaSeq = matcherVal.group(1);
            nextCurrVal = matcherVal.group(2);
            nextVal = nextCurrVal != null && nextCurrVal.endsWith(")") ? nextCurrVal.substring(0, nextCurrVal.indexOf(40)) : nextCurrVal;
            replacementVal.append(nextVal).append("(");
            replacementVal.append("'").append(schemaSeq).append("'");
            replacementVal.append(")");
            if (!"false".equalsIgnoreCase(FeatureLoader.getStringProperty("MigSupportSequence"))) {
                replacementVal.insert(0, "MIG_ORA_EXT.");
            }
            String strInput = schemaSeq + "." + nextCurrVal;
            output = output.replaceAll(Pattern.quote(strInput), replacementVal.toString());
            matcherVal = patternVal.matcher(output);
        }
        return output;
    }

    public static String doChangeSequence(String input) throws MigrationServiceException {
        String output = input;
        String schemaNme = null;
        String sequenceNme = null;
        String comment = null;
        if (QueryConversionUtility.containsCheck(output, "#S#")) {
            List<String> cmntLst = OracleUtility.getCmntList(output);
            comment = QueryConversionUtility.doGetStrFrmListWithSeparator(cmntLst, "");
            output = output.replaceAll("(?i)#S#\\d+#E#", "");
        }
        Pattern patternSeq = Pattern.compile("(?i).*CREATE\\s+SEQUENCE\\s+(\\w*\\.?\\w+|##QUOTE##\\d+#).*?(;|$)");
        Matcher matcherSeq = patternSeq.matcher(output);
        String semicolon = null;
        if (matcherSeq.find()) {
            String schemaSeqNme = matcherSeq.group(1);
            semicolon = matcherSeq.group(2);
            if (schemaSeqNme.contains(".")) {
                int idx = QueryConversionUtility.getLastIndexForSymbols(schemaSeqNme, ".");
                sequenceNme = schemaSeqNme.substring(idx);
                schemaNme = "'" + schemaSeqNme.substring(0, idx - 1) + "'";
            } else {
                sequenceNme = schemaSeqNme;
                schemaNme = "current_user";
            }
        }
        String maxVal = OracleUtility.getMaxValue(output, null, QueryConversionUtility.isExactMatch(output, "NOMAXVALUE"));
        String minVal = OracleUtility.getMinValue(output, null, QueryConversionUtility.isExactMatch(output, "NOMINVALUE"));
        String startWith = OracleUtility.getSequenceMatchGrpVal(output, "START\\s+WITH", 1);
        ArrayList<String> list = OracleUtility.doChangeSequenceIncrement(OracleUtility.getIncrementValue(output), QueryConversionUtility.isExactMatch(output, "NOMAXVALUE"), maxVal, minVal, startWith);
        minVal = list.remove(0);
        maxVal = list.remove(0);
        startWith = list.remove(0);
        if (sequenceNme != null) {
            StringBuffer insertSeqInTbl = OracleUtility.appendInsrtTbl(comment);
            boolean cycle = QueryConversionUtility.isExactMatch(output, "CYCLE");
            OracleUtility.doChangeInsertSeqInTab(insertSeqInTbl, cycle, minVal, maxVal, startWith, schemaNme, sequenceNme, OracleUtility.getIncrementValue(output), semicolon);
            output = insertSeqInTbl.toString();
        }
        return output;
    }

    private static StringBuffer appendInsrtTbl(String comment) {
        StringBuffer insertSeqInTbl = new StringBuffer();
        if (comment != null) {
            insertSeqInTbl.append(comment).append(IGaussDBConstants.NEW_LINE);
        }
        return insertSeqInTbl;
    }

    private static List<String> getCmntList(String output) {
        List<String> cmntLst = new ArrayList<String>(10);
        cmntLst = QueryConversionUtility.getMatchedGrpsInLst(output, "(?i)#S#\\d+#E#", 0, cmntLst);
        return cmntLst;
    }

    private static String getIncrementValue(String output) {
        String incrementBy = OracleUtility.getSequenceMatchGrpVal(output, "INCREMENT\\s+BY", 1);
        if (incrementBy == null) {
            incrementBy = "1";
        }
        return incrementBy;
    }

    private static String getMinValue(String output, String min, boolean maxBoolean) {
        String minVal = min;
        if (!maxBoolean) {
            minVal = OracleUtility.getSequenceMatchGrpVal(output, "MINVALUE", 1);
        }
        return minVal;
    }

    private static String getMaxValue(String output, String max, boolean minBoolean) {
        String maxVal = max;
        if (!minBoolean) {
            maxVal = OracleUtility.getSequenceMatchGrpVal(output, "MAXVALUE", 1);
        }
        return maxVal;
    }

    private static ArrayList<String> doChangeSequenceIncrement(String incrementBy, boolean noMaxBoolean, String maxValue, String minValue, String strt) throws MigrationServiceException {
        String maxVal = maxValue;
        String minVal = minValue;
        String startWith = strt;
        if ("0".equals(incrementBy)) {
            throw new MigrationServiceException("[DSC_ERR_002_008] " + MessageLoader.getMessage("DSC_ERR_002_008"));
        }
        if (Integer.parseInt(incrementBy) > 0) {
            if (noMaxBoolean || maxVal == null) {
                maxVal = "999999999999999999999999999";
            }
            if (noMaxBoolean || minVal == null) {
                minVal = "1";
            }
            if (startWith == null) {
                startWith = minVal;
            }
        } else if (Integer.parseInt(incrementBy) < 0) {
            if (noMaxBoolean || maxVal == null) {
                maxVal = "-1";
            }
            if (noMaxBoolean || minVal == null) {
                minVal = "-99999999999999999999999999";
            }
            if (startWith == null) {
                startWith = maxVal;
            }
        }
        ArrayList<String> list = new ArrayList<String>(3);
        list.add(minVal);
        list.add(maxVal);
        list.add(startWith);
        return list;
    }

    private static void doChangeInsertSeqInTab(StringBuffer insertSeqInTbl, boolean cycle, String minVal, String maxVal, String startWith, String schemaNme, String sequenceNme, String incrementBy, String semicolon) {
        insertSeqInTbl.append("INSERT INTO ").append("MIG_ORA_EXT.").append("MIG_SEQ_TABLE");
        insertSeqInTbl.append("(").append(QueryConversionUtility.toUpper("schema")).append("_").append(QueryConversionUtility.toUpper("name"));
        insertSeqInTbl.append(",").append("SEQUENCE").append("_").append(QueryConversionUtility.toUpper("name"));
        insertSeqInTbl.append(",").append("START_WITH").append(",").append("INCREMENT_BY");
        insertSeqInTbl.append(",").append("MIN_VALUE").append(",").append("MAX_VALUE");
        insertSeqInTbl.append(",").append("CYCLE_I").append(",").append("CACHE");
        insertSeqInTbl.append(",").append("ORDER_I").append(")");
        insertSeqInTbl.append(QueryConversionUtility.toUpper("values")).append("(");
        insertSeqInTbl.append("UPPER(");
        insertSeqInTbl.append(schemaNme).append(")").append(",");
        insertSeqInTbl.append("UPPER(").append("'").append(sequenceNme).append("'").append(")").append(",");
        insertSeqInTbl.append(startWith).append(",").append(incrementBy).append(",");
        insertSeqInTbl.append(minVal).append(",").append(maxVal).append(",");
        insertSeqInTbl.append(cycle).append(",").append(20).append(",").append(false).append(")").append(semicolon);
    }

    public String doRplSchemaInTruncTab(String input, String schemaName) {
        String output = input;
        Pattern truncPat = Pattern.compile("(?i)((?<!\\w)truncate\\s+table\\s*(\".*?\"\\s*.\\s*\".*?\"|\".*?\"\\s*\\.\\s*\\w+|\\w+\\s*\\.\\s*\".*?\"|\".*?\"|\\w*\\.?\\w+))");
        Matcher truncMatch = truncPat.matcher(output);
        String replaceStr = null;
        String truncStr = null;
        String tabName = null;
        while (truncMatch.find()) {
            tabName = truncMatch.group(2);
            truncStr = truncMatch.group(1);
            if (tabName.contains(".")) continue;
            replaceStr = QueryConversionUtility.doReplaceExactStr(tabName, schemaName + "." + tabName, truncStr);
            output = output.replace(truncStr, replaceStr);
        }
        return output;
    }

    public static String doAddSchemaInUserEnvFun(String inputSql, String functionPattern, String functionNme, int minParam, int maxParam, String newFnNme) throws MigrationServiceException {
        String tempSQL;
        String output = tempSQL = inputSql.replaceAll("\\s+,\\s+|\\s+,|,\\s+", ",");
        Pattern funcPattern = Pattern.compile(functionPattern);
        Matcher funMatch = funcPattern.matcher(output);
        while (funMatch.find()) {
            StringBuffer replacementString = new StringBuffer();
            String functionStr = QueryConversionUtility.doGetReplaceString(output.substring(funMatch.start(1)));
            String functionParams = QueryConversionUtility.removeParenthesis(functionStr).trim();
            ColumnSplitter splitter = new ColumnSplitter();
            List<String> functionParamsLst = splitter.doGetAllColumns(functionParams);
            if (functionParams.isEmpty()) {
                throw new MigrationServiceException("[DSC_ERR_002_006] USERENV" + MessageLoader.getMessage("DSC_ERR_002_006"));
            }
            if (!functionParams.startsWith("'")) {
                throw new MigrationServiceException("[DSC_ERR_002_009] " + functionNme + MessageLoader.getMessage("DSC_ERR_002_009"));
            }
            String argument = functionParams.substring(1, functionParams.length() - 1);
            if (argument.isEmpty()) {
                throw new MigrationServiceException("[DSC_ERR_002_006] USERENV" + MessageLoader.getMessage("DSC_ERR_002_006"));
            }
            if (functionParamsLst.size() > maxParam) {
                throw new MigrationServiceException("[DSC_ERR_002_006] USERENV" + MessageLoader.getMessage("DSC_ERR_002_006"));
            }
            if (!(argument.equalsIgnoreCase("SID") || argument.equalsIgnoreCase("INSTANCE") || argument.equalsIgnoreCase("client_info"))) {
                throw new MigrationServiceException("[DSC_ERR_002_010] " + argument + " " + MessageLoader.getMessage("DSC_ERR_002_010") + functionNme);
            }
            replacementString.append("MIG_ORA_EXT.").append(newFnNme).append("(").append(functionParams).append(")");
            String tempFunction = replacementString.toString().replaceAll("\\s+,\\s+|\\s+,|,\\s+", ",");
            output = output.replace(functionStr, tempFunction);
            funMatch = funcPattern.matcher(output);
        }
        return output;
    }

    public String doGetVarraySize(String tableDataType) {
        String varrayType = tableDataType;
        String varraySize = "";
        String vrrayTyp = this.createTypeMap.get(QueryConversionUtility.toUpper(varrayType.trim() + "_" + "record"));
        if (vrrayTyp == null) {
            vrrayTyp = this.createTypeMap.get(QueryConversionUtility.toUpper(varrayType.trim() + "_VARRAY"));
        }
        varraySize = vrrayTyp != null || QueryConversionUtility.toUpper(varrayType).trim().endsWith("%ROWTYPE") ? FeatureLoader.getStringProperty("varrayObjectSize") : FeatureLoader.getStringProperty("varraySize");
        return varraySize;
    }

    public String doRplPercentageType(String recordTypesDec, String schemaName) {
        String outputSql = recordTypesDec;
        Matcher percentgeTypeMat = TYPE_PAT.matcher(recordTypesDec);
        while (percentgeTypeMat.find()) {
            String replacemnt;
            String dataType = percentgeTypeMat.group();
            if (dataType == null) continue;
            String replacement = this.createTypeMap.get(QueryConversionUtility.toUpper(dataType.replace("%", "_data").replace(" ", "")));
            if (replacement != null) {
                outputSql = outputSql.replace(dataType, replacement);
                continue;
            }
            if (schemaName.isEmpty() || (replacemnt = this.createTypeMap.get(QueryConversionUtility.toUpper(schemaName + dataType.replace("%", "_data").replace(" ", "")))) == null) continue;
            outputSql = outputSql.replace(dataType, replacemnt);
        }
        return outputSql;
    }
}

