/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.parser;

import com.huawei.db.migration.database.bo.BulkSplitPatternsBO;
import com.huawei.db.migration.database.bo.IBulkSplitPatternsBO;
import com.huawei.db.migration.database.bo.IQueryPatternsBO;
import com.huawei.db.migration.database.bo.IQuerySplitterPatternsBO;
import com.huawei.db.migration.database.bo.QueryPatternsBO;
import com.huawei.db.migration.database.bo.QuerySplitterPatternsBO;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class JSONBOObjectConstructor {
    private static Logger logger = LogManager.getLogger(JSONBOObjectConstructor.class);

    public List<?> getJSONObjectBOList(String parserType, JSONArray objJSONArray) {
        List<Object> boList = new ArrayList(10);
        if (parserType.startsWith("teradata")) {
            boList = this.getTeradataParserBO(parserType, objJSONArray, boList);
        } else if (parserType.startsWith("oracle")) {
            boList = this.getOracleParserBO(parserType, objJSONArray, boList);
        } else if (parserType.startsWith("netezza")) {
            boList = this.getNetezzaParserBO(parserType, objJSONArray, boList);
        } else if (parserType.startsWith("db2")) {
            boList = this.getDB2ParserBO(parserType, objJSONArray, boList);
        } else {
            logger.debug("Invalid JSON parser type : " + parserType);
        }
        return boList;
    }

    private List<?> getTeradataParserBO(String parserType, JSONArray objJSONArray, List<?> boList) {
        if (parserType.equals("teradata-query")) {
            boList = this.getParserBO(objJSONArray);
        } else if (parserType.equals("teradata-query-splitter")) {
            boList = this.getQuerySplitterParserBO(objJSONArray);
        } else if (parserType.equals("teradata-schema")) {
            boList = this.getParserBO(objJSONArray);
        } else if (parserType.equals("teradata-bulk")) {
            boList = this.getSplitterPatternsBO(objJSONArray);
        } else {
            logger.debug("Invalid JSON parser type : " + parserType);
        }
        return boList;
    }

    private List<?> getOracleParserBO(String parserType, JSONArray objJSONArray, List<?> boList) {
        if (parserType.equals("oracle-query")) {
            boList = this.getParserBO(objJSONArray);
        } else if (parserType.equals("oracle-query-splitter")) {
            boList = this.getQuerySplitterParserBO(objJSONArray);
        } else if (parserType.equals("oracle-bulk")) {
            boList = this.getSplitterPatternsBO(objJSONArray);
        } else if (parserType.equals("oracle-schema")) {
            boList = this.getParserBO(objJSONArray);
        } else if (parserType.equals("oracle-blogic")) {
            boList = this.getSplitterPatternsBO(objJSONArray);
        } else if (parserType.equals("oracle-blogic-splitter")) {
            boList = this.getSplitterPatternsBO(objJSONArray);
        } else {
            logger.debug("Invalid JSON parser type : " + parserType);
        }
        return boList;
    }

    private List<?> getNetezzaParserBO(String parserType, JSONArray objJSONArray, List<?> boList) {
        if (parserType.equals("netezza-query")) {
            boList = this.getParserBO(objJSONArray);
        } else if (parserType.equals("netezza-query-splitter")) {
            boList = this.getQuerySplitterParserBO(objJSONArray);
        } else if (parserType.equals("netezza-bulk")) {
            boList = this.getSplitterPatternsBO(objJSONArray);
        } else if (parserType.equals("netezza-schema")) {
            boList = this.getParserBO(objJSONArray);
        } else if (parserType.equals("netezza-blogic")) {
            boList = this.getSplitterPatternsBO(objJSONArray);
        } else if (parserType.equals("netezza-blogic-splitter")) {
            boList = this.getSplitterPatternsBO(objJSONArray);
        } else {
            logger.debug("Invalid JSON parser type : " + parserType);
        }
        return boList;
    }

    private List<?> getDB2ParserBO(String parserType, JSONArray objJSONArray, List<?> boList) {
        if (parserType.equals("db2-query")) {
            boList = this.getParserBO(objJSONArray);
        } else if (parserType.equals("db2-query-splitter")) {
            boList = this.getQuerySplitterParserBO(objJSONArray);
        } else if (parserType.equals("db2-bulk")) {
            boList = this.getSplitterPatternsBO(objJSONArray);
        } else if (parserType.equals("db2-schema")) {
            boList = this.getParserBO(objJSONArray);
        } else if (parserType.equals("db2-blogic")) {
            boList = this.getSplitterPatternsBO(objJSONArray);
        } else if (parserType.equals("db2-blogic-splitter")) {
            boList = this.getSplitterPatternsBO(objJSONArray);
        } else {
            logger.debug("Invalid JSON parser type : " + parserType);
        }
        return boList;
    }

    private List<IQuerySplitterPatternsBO> getQuerySplitterParserBO(JSONArray objJSONArray) {
        ArrayList<IQuerySplitterPatternsBO> splitterPatternList = new ArrayList<IQuerySplitterPatternsBO>(objJSONArray.length());
        for (Object obj : objJSONArray) {
            QuerySplitterPatternsBO splitterPatternBo = new QuerySplitterPatternsBO();
            JSONObject jObject = (JSONObject)obj;
            String name = (String)jObject.get("name");
            splitterPatternBo.setName(name);
            String splitterPattern = (String)jObject.get("splitterPattern");
            splitterPatternBo.setSplitterPattern(splitterPattern);
            String finalReplacementPattern = (String)jObject.get("finalReplacementPattern");
            splitterPatternBo.setFinalReplacementPattern(finalReplacementPattern);
            String migrationToolInput = (String)jObject.get("migrationToolInput");
            splitterPatternBo.setMigrationToolInput(migrationToolInput);
            JSONArray splitterMap = (JSONArray)jObject.get("splitterMapAtt");
            LinkedHashMap<String, String> splitterAttMap = new LinkedHashMap<String, String>(10);
            for (Object cObj : splitterMap) {
                String[] mapVal = ((String)cObj).split(":");
                if (mapVal.length <= 1) continue;
                splitterAttMap.put(mapVal[0], mapVal[1]);
            }
            splitterPatternBo.setSplitterMapAtt(splitterAttMap);
            JSONArray outputChkList = (JSONArray)jObject.get("outputCheck");
            ArrayList<String> cntChkList = new ArrayList<String>(10);
            for (Object cObj : outputChkList) {
                cntChkList.add((String)cObj);
            }
            splitterPatternBo.setOutputCheckList(cntChkList);
            splitterPatternList.add(splitterPatternBo);
        }
        return splitterPatternList;
    }

    private List<IQueryPatternsBO> getParserBO(JSONArray objJSONArray) {
        ArrayList<IQueryPatternsBO> patternList = new ArrayList<IQueryPatternsBO>(objJSONArray.length());
        for (Object obj : objJSONArray) {
            QueryPatternsBO pattenReplaceBo = new QueryPatternsBO();
            JSONObject patternObj = (JSONObject)obj;
            String name = (String)patternObj.get("name");
            pattenReplaceBo.setName(name);
            String finderPattern = (String)patternObj.get("finderPattern");
            pattenReplaceBo.setFinderPattern(finderPattern);
            String replacePattern = (String)patternObj.get("replacementPattern");
            pattenReplaceBo.setReplacementPattern(replacePattern);
            String alternateReplacePattern = (String)patternObj.get("alternateReplacementPattern");
            pattenReplaceBo.setAlternateReplacementPattern(alternateReplacePattern);
            JSONArray replaceMap = (JSONArray)patternObj.get("replacementMapAtt");
            LinkedHashMap<String, String> replaceAttMap = new LinkedHashMap<String, String>(replaceMap.length());
            for (Object cObj : replaceMap) {
                String[] mapVal = ((String)cObj).split(":");
                if (mapVal.length <= 1) continue;
                replaceAttMap.put(mapVal[0], mapVal[1]);
            }
            pattenReplaceBo.setReplacementMapAtt(replaceAttMap);
            boolean constraintFlag = Boolean.parseBoolean((String)patternObj.get("constraintFlag"));
            JSONArray excludePatternObject = (JSONArray)patternObj.get("excludePattern");
            ArrayList<String> excludePatternList = new ArrayList<String>(10);
            for (Object cObject : excludePatternObject) {
                excludePatternList.add((String)cObject);
            }
            pattenReplaceBo.setExcludePattern(excludePatternList);
            if (constraintFlag) {
                pattenReplaceBo.setConstraintFlag(constraintFlag);
                pattenReplaceBo.setConstraintPattern((String)patternObj.get("constraintPattern"));
                pattenReplaceBo.setConstraintInput((String)patternObj.get("constraintInput"));
                Object constraintCheck = patternObj.get("constraintCheck");
                JSONArray constrainstChkList = null;
                if (constraintCheck != null && constraintCheck instanceof JSONArray) {
                    constrainstChkList = (JSONArray)constraintCheck;
                }
                ArrayList<String> cntChkList = new ArrayList<String>(10);
                if (constrainstChkList != null) {
                    for (Object consObj : constrainstChkList) {
                        cntChkList.add((String)consObj);
                    }
                }
                pattenReplaceBo.setConstraintList(cntChkList);
            }
            patternList.add(pattenReplaceBo);
        }
        return patternList;
    }

    private List<IBulkSplitPatternsBO> getSplitterPatternsBO(JSONArray objJSONArray) {
        ArrayList<IBulkSplitPatternsBO> splitPatternList = new ArrayList<IBulkSplitPatternsBO>(objJSONArray.length());
        for (Object obj : objJSONArray) {
            BulkSplitPatternsBO pattenBo = new BulkSplitPatternsBO();
            JSONObject patternObj = null;
            if (obj != null && obj instanceof JSONObject) {
                patternObj = (JSONObject)obj;
            }
            Object nameValue = null;
            if (patternObj != null) {
                nameValue = patternObj.get("name");
            }
            String name = null;
            if (nameValue != null && nameValue instanceof String) {
                name = (String)nameValue;
            }
            if (name != null) {
                pattenBo.setName(name);
            }
            Object objPattern = null;
            if (patternObj != null) {
                objPattern = patternObj.get("finderPattern");
            }
            String finderPattern = "";
            if (objPattern != null && objPattern instanceof String) {
                finderPattern = (String)objPattern;
            }
            pattenBo.setFinderPattern(finderPattern);
            Object excludePattern = null;
            if (patternObj != null) {
                excludePattern = patternObj.get("excludePattern");
            }
            JSONArray excludePatternObject = null;
            if (excludePattern != null && excludePattern instanceof JSONArray) {
                excludePatternObject = (JSONArray)excludePattern;
            }
            ArrayList<String> excludePatternList = new ArrayList<String>(10);
            if (excludePatternObject != null) {
                for (Object excPatrnObj : excludePatternObject) {
                    if (excPatrnObj == null || !(excPatrnObj instanceof String)) continue;
                    excludePatternList.add((String)excPatrnObj);
                }
            }
            pattenBo.setExcludePattern(excludePatternList);
            splitPatternList.add(pattenBo);
        }
        return splitPatternList;
    }
}

