/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.replacer;

import com.huawei.db.migration.exception.MigrationServiceException;
import com.huawei.db.migration.replacer.ITokenResolver;
import com.huawei.db.migration.util.MessageLoader;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;

public class TokenReplacingReader
extends Reader {
    private PushbackReader pushbackReader = null;
    private ITokenResolver tknResolver = null;
    private StringBuffer tknNameBuf = new StringBuffer();
    private String tknVal = null;
    private int tknValIndex = 0;

    public TokenReplacingReader(Reader source, ITokenResolver resolver) {
        this.pushbackReader = new PushbackReader(source, 2);
        this.tknResolver = resolver;
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        return this.read(cbuf, 0, cbuf.length);
    }

    @Override
    public int read() throws IOException {
        if (this.tknVal != null && this.tknVal.length() > this.tknValIndex) {
            return this.tknVal.charAt(this.tknValIndex++);
        }
        if (this.tknVal != null && this.tknValIndex == this.tknVal.length()) {
            this.tknVal = null;
            this.tknValIndex = 0;
        }
        return this.reader();
    }

    private int reader() throws IOException {
        int eachChar = this.pushbackReader.read();
        if (36 != eachChar) {
            return eachChar;
        }
        eachChar = this.pushbackReader.read();
        if (123 != eachChar) {
            this.pushbackReader.unread(eachChar);
            return 36;
        }
        this.tknNameBuf.delete(0, this.tknNameBuf.length());
        eachChar = this.pushbackReader.read();
        int charMaxVal = 65535;
        while (125 != eachChar) {
            if (eachChar <= charMaxVal) {
                this.tknNameBuf.append((char)eachChar);
            }
            eachChar = this.pushbackReader.read();
        }
        this.tknVal = this.tknResolver.resolveToken(this.tknNameBuf.toString());
        if (this.tknVal == null) {
            this.tknVal = "${" + this.tknNameBuf.toString() + "}";
        }
        if (this.tknVal.length() == 0) {
            return this.read();
        }
        return this.getaCharAtPosition();
    }

    private char getaCharAtPosition() {
        if (this.tknValIndex < this.tknVal.length()) {
            return this.tknVal.charAt(this.tknValIndex++);
        }
        throw new MigrationServiceException("[DSC_ERR_004_008] " + MessageLoader.getMessage("DSC_ERR_004_008"));
    }

    @Override
    public void close() throws IOException {
        this.pushbackReader.close();
    }

    @Override
    public int read(char[] charBuff, int off, int len) throws IOException {
        int chRead = 0;
        int charMaxVal = 65535;
        for (int iIndex = 0; iIndex < len; ++iIndex) {
            int nxtchr = this.read();
            if (nxtchr == -1) {
                if (chRead != 0) break;
                chRead = -1;
                break;
            }
            chRead = iIndex + 1;
            if (nxtchr > charMaxVal) continue;
            charBuff[off + iIndex] = (char)nxtchr;
        }
        return chRead;
    }

    @Override
    public boolean ready() throws IOException {
        return this.pushbackReader.ready();
    }
}

