/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.services;

import com.huawei.db.migration.bo.IMigrationInputBO;
import com.huawei.db.migration.common.handlers.FileHandler;
import com.huawei.db.migration.exception.FileException;
import com.huawei.db.migration.exception.MigrationServiceException;
import com.huawei.db.migration.util.ApplicationPropertyLoader;
import com.huawei.db.migration.util.ErrorLoggerUtility;
import com.huawei.db.migration.util.IGaussDBConstants;
import com.huawei.db.migration.util.MessageLoader;
import com.huawei.db.migration.util.QueryConversionUtility;
import com.huawei.db.migration.util.SetFilePermission;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileSystemUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MigrationValidatorService {
    private static final Logger logger = LogManager.getLogger(MigrationValidatorService.class);
    private static final Pattern MEMORY_SIZE = Pattern.compile("(\\d+)\\s*(GB|MB|KB|B)");

    public void doPreApplicationValidation(IMigrationInputBO objInputData) throws MigrationServiceException, FileException {
        String logPath = System.getProperty("LOGFILE_PATH");
        this.doValidateLogDir(logPath);
        this.doValidateMigType(objInputData.getMigTaskName());
        this.doValidateSrcDir(objInputData.getSourceFolderLoc());
        this.doValidateTarDir(objInputData.getTargetFolderLoc());
        this.checkSupportDB(objInputData.getSourceDb());
    }

    private void doValidateLogDir(String logPath) throws FileException {
        String logFolder = null;
        try {
            logFolder = new File(logPath).getCanonicalPath();
        }
        catch (IOException e) {
            throw new FileException(MessageLoader.getMessage("migLogDirError"));
        }
        if (logFolder != null) {
            File logDir = new File(logFolder);
            if (!logDir.isDirectory()) {
                throw new FileException(MessageLoader.getMessage("migLogDirError"));
            }
        } else {
            throw new FileException(MessageLoader.getMessage("migLogDirError"));
        }
    }

    public void folderAccessPrivilegeChk(IMigrationInputBO objInputData) throws MigrationServiceException {
        String sourceFolder = FilenameUtils.normalize((String)objInputData.getSourceFolderLoc());
        if (sourceFolder == null || !FileHandler.isInSecureDir(Paths.get(sourceFolder, new String[0]))) {
            throw new MigrationServiceException("[DSC_ERR_004_012] " + MessageLoader.getMessage("DSC_ERR_004_012") + " " + objInputData.getSourceFolderLoc());
        }
        String targetFolder = FilenameUtils.normalize((String)objInputData.getTargetFolderLoc());
        if (targetFolder == null || !FileHandler.isInSecureDir(Paths.get(targetFolder, new String[0]))) {
            throw new MigrationServiceException("[DSC_ERR_004_013] " + MessageLoader.getMessage("DSC_ERR_004_013") + " " + objInputData.getTargetFolderLoc());
        }
    }

    public void freeDiskSpaceChk(Map<String, String> files, String targetFolder) throws MigrationServiceException {
        Long folderFreeSpace = null;
        int size = 0;
        String byteVal = null;
        ArrayList<String> filesLst = new ArrayList<String>(10);
        this.checkMaxFileSize(files);
        String maxSize = QueryConversionUtility.toUpper(ApplicationPropertyLoader.getStringProperty("MaxFileSizeWarning")).trim();
        Matcher match = MEMORY_SIZE.matcher(maxSize);
        if (match.find()) {
            size = Integer.parseInt(match.group(1));
            byteVal = match.group(2);
        } else {
            this.logErrorInvalidVal();
            size = 10;
            byteVal = "MB";
        }
        if (byteVal.equals("GB")) {
            if (size > 1) {
                QueryConversionUtility.printConsoleMessage("MaxFileSizeWarning size is out of range. Hence setting the default file size as 10MB.");
                size = 10;
                byteVal = "MB";
            }
        } else if (!(byteVal.equals("B") || byteVal.equals("KB") || byteVal.equals("MB"))) {
            this.logErrorOutOfRange();
            size = 10;
            byteVal = "MB";
        }
        try {
            folderFreeSpace = FileSystemUtils.freeSpaceKb((String)targetFolder);
            Long fileSize = this.doGetFilesSize(files, size, byteVal, filesLst);
            this.getFileSize(folderFreeSpace, fileSize);
            this.showWarningfiles(size, byteVal, filesLst);
        }
        catch (IOException e) {
            logger.error(ErrorLoggerUtility.getExceptionDetails(e) + " Error occurred while calculating free space in disk.");
        }
    }

    private void getFileSize(Long folderFreeSpace, Long fileSize) {
        fileSize = fileSize * 4L;
        if ((fileSize = Long.valueOf(fileSize / 1024L)) > folderFreeSpace) {
            throw new MigrationServiceException("[DSC_ERR_004_014] " + MessageLoader.getMessage("DSC_ERR_004_014"));
        }
    }

    private void logErrorOutOfRange() {
        QueryConversionUtility.printConsoleMessage("MaxFileSizeWarning size is out of range. Hence setting the default file size as 10MB.");
        logger.info("MaxFileSizeWarning size is out of range.{}", (Object)" Hence setting the default file size as 10MB.");
    }

    private void logErrorInvalidVal() {
        QueryConversionUtility.printConsoleMessage("Invalid Value Specified for MaxFileSizeWarning configuration. Hence setting the default file size as 10MB.");
        logger.info("Invalid Value Specified for MaxFileSizeWarning configuration. {}", (Object)" Hence setting the default file size as 10MB.");
    }

    private void checkMaxFileSize(Map<String, String> files) {
        int size = 0;
        String byteVal = null;
        ArrayList<String> fileMaxSizeExceedList = new ArrayList<String>(10);
        String maxSize = QueryConversionUtility.toUpper(ApplicationPropertyLoader.getStringProperty("MaxFileSize")).trim();
        Matcher match = MEMORY_SIZE.matcher(maxSize);
        if (match.find()) {
            size = Integer.parseInt(match.group(1));
            byteVal = match.group(2);
        } else {
            QueryConversionUtility.printConsoleMessage("Invalid Value Specified for MaxFileSize configuration. Hence setting the default max file size as 20MB.");
            logger.info("Invalid Value Specified for MaxFileSize configuration. {}", (Object)" Hence setting the default max file size as 20MB.");
            size = 20;
            byteVal = "MB";
        }
        if (byteVal.equals("GB")) {
            if (size > 1) {
                QueryConversionUtility.printConsoleMessage("MaxFileSize size is out of range. Hence setting the default max file size as 20MB.");
                size = 20;
                byteVal = "MB";
            }
        } else if (!(byteVal.equals("B") || byteVal.equals("KB") || byteVal.equals("MB"))) {
            QueryConversionUtility.printConsoleMessage("MaxFileSize size is out of range. Hence setting the default max file size as 20MB.");
            logger.info("MaxFileSize size is out of range.{}", (Object)" Hence setting the default max file size as 20MB.");
            size = 20;
            byteVal = "MB";
        }
        this.getMaxFileSizeExceedList(files, size, byteVal, fileMaxSizeExceedList);
        this.showMaxSizeExceedfiles(size, byteVal, fileMaxSizeExceedList);
    }

    private void showMaxSizeExceedfiles(int size, String byteVal, List<String> filesLst) {
        if (!filesLst.isEmpty()) {
            QueryConversionUtility.printConsoleMessage("\n--------------------------------------------------------------------------");
            QueryConversionUtility.printConsoleMessage("[INFO]: DSC of the following files exceeds the max file size:" + size + byteVal + ", these files will not be migrated");
            logger.info("DSC of the following files exceeds the max file size: {} {} , these files will not be migrated", (Object)size, (Object)byteVal);
            for (String fStr : filesLst) {
                QueryConversionUtility.printConsoleMessage(fStr);
                logger.info(fStr);
            }
            QueryConversionUtility.printConsoleMessage("--------------------------------------------------------------------------\n");
        }
    }

    private void getMaxFileSizeExceedList(Map<String, String> files, int size, String byteVal, List<String> filesLst) {
        Long fsize = null;
        Long byteSize = null;
        Iterator<Map.Entry<String, String>> it = files.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> file = it.next();
            fsize = FileUtils.sizeOf((File)new File(file.getValue()));
            byteSize = this.doGetFileSize(fsize, byteVal);
            if (byteSize <= (long)size) continue;
            filesLst.add(file.getValue());
            it.remove();
        }
    }

    private Long doGetFilesSize(Map<String, String> files, int size, String byteVal, List<String> filesLst) {
        Long fsize = null;
        Long byteSize = null;
        Long fileSize = 0L;
        for (Map.Entry<String, String> file : files.entrySet()) {
            fsize = FileUtils.sizeOf((File)new File(file.getValue()));
            byteSize = this.doGetFileSize(fsize, byteVal);
            if (byteSize > (long)size) {
                filesLst.add(file.getValue());
            }
            fileSize = fileSize + fsize;
        }
        return fileSize;
    }

    private void showWarningfiles(int size, String byteVal, List<String> filesLst) {
        if (!filesLst.isEmpty()) {
            QueryConversionUtility.printConsoleMessage("\n--------------------------------------------------------------------------");
            QueryConversionUtility.printConsoleMessage("[WARNING]: DSC of the following files(>" + size + byteVal + ") will take more time:");
            logger.info("[WARNING]: DSC of the following files(> {} {} ) will take more time:", (Object)size, (Object)byteVal);
            for (String fStr : filesLst) {
                QueryConversionUtility.printConsoleMessage(fStr);
                logger.info(fStr);
            }
            QueryConversionUtility.printConsoleMessage("--------------------------------------------------------------------------\n");
        }
    }

    private Long doGetFileSize(Long fsize, String byteVal) {
        Long byteSize = 0L;
        switch (byteVal) {
            case "KB": {
                byteSize = fsize / 1024L;
                break;
            }
            case "MB": {
                byteSize = fsize / 1024L;
                byteSize = byteSize / 1024L;
                break;
            }
            case "GB": {
                byteSize = fsize / 1024L;
                byteSize = byteSize / 1024L;
                byteSize = byteSize / 1024L;
                break;
            }
            default: {
                byteSize = fsize;
            }
        }
        return byteSize;
    }

    public void freeDiskSpaceChkFile(String file, String tarFolder) throws MigrationServiceException {
        block5: {
            Long fileSize = 0L;
            Long folderFreeSpace = null;
            try {
                File fileObj = new File(file);
                if (fileObj.exists()) {
                    fileSize = fileSize + FileUtils.sizeOf((File)fileObj);
                    folderFreeSpace = FileSystemUtils.freeSpaceKb((String)tarFolder);
                    fileSize = fileSize * 4L;
                    if ((fileSize = Long.valueOf(fileSize / 1024L)) > folderFreeSpace) {
                        if (logger.isInfoEnabled()) {
                            logger.info("[DSC_ERR_004_014] " + MessageLoader.getMessage("DSC_ERR_004_014"));
                        }
                        throw new MigrationServiceException("[DSC_ERR_004_014] " + MessageLoader.getMessage("DSC_ERR_004_014"));
                    }
                    break block5;
                }
                throw new MigrationServiceException("[DSC_ERR_004_044] " + MessageLoader.getMessage("DSC_ERR_004_044"));
            }
            catch (IOException e) {
                throw new MigrationServiceException("[DSC_ERR_004_043] " + MessageLoader.getMessage("DSC_ERR_004_043"));
            }
        }
    }

    private void doValidateMigType(String migType) throws MigrationServiceException {
        if (!migType.equalsIgnoreCase("bulk") && !migType.equalsIgnoreCase("blogic")) {
            logger.error(MessageLoader.getMessage("migrationTypeError") + " " + MessageLoader.getMessage("migrationAppError"));
            throw new MigrationServiceException(MessageLoader.getMessage("migrationTypeError"));
        }
    }

    private void checkSupportDB(String sourceDb) throws MigrationServiceException {
        if (!(sourceDb.equalsIgnoreCase("teradata") || sourceDb.equalsIgnoreCase("oracle") || sourceDb.equalsIgnoreCase("netezza") || sourceDb.equalsIgnoreCase("db2"))) {
            throw new MigrationServiceException("Currently we are not supporting this Database : " + sourceDb);
        }
    }

    private void doValidateSrcDir(String srcDir) throws MigrationServiceException {
        String srcDirectory = FilenameUtils.normalize((String)srcDir);
        if (srcDirectory != null) {
            File file = new File(srcDirectory);
            if (!file.isDirectory()) {
                logger.error(MessageLoader.getMessage("migSrcDirError") + " " + MessageLoader.getMessage("migrationAppError"));
                throw new MigrationServiceException(MessageLoader.getMessage("migSrcDirError"));
            }
        } else {
            logger.error(MessageLoader.getMessage("migSrcDirError") + " " + MessageLoader.getMessage("migrationAppError"));
            throw new MigrationServiceException(MessageLoader.getMessage("migSrcDirError"));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void doValidateTarDir(String targetDir) throws MigrationServiceException, FileException {
        String targetDirectory = FilenameUtils.normalize((String)targetDir);
        if (targetDirectory == null) {
            logger.error(MessageLoader.getMessage("migTargetDirWriteError") + " " + MessageLoader.getMessage("migrationAppError"));
            throw new MigrationServiceException(MessageLoader.getMessage("migTargetDirWriteError"));
        }
        File file = new File(targetDirectory);
        if (!file.isDirectory()) {
            this.doCheckTargetParentDir(file);
            return;
        }
        if (file.canWrite()) {
            File[] filesInTarget = file.listFiles();
            if (filesInTarget == null) return;
            if (filesInTarget.length == 0) return;
            String operation = QueryConversionUtility.toLower(ApplicationPropertyLoader.getStringProperty("target_files"));
            this.doCheckTargetFile(filesInTarget, operation);
            return;
        }
        logger.error(MessageLoader.getMessage("migTargetDirWriteError") + " " + MessageLoader.getMessage("migrationAppError"));
        throw new MigrationServiceException(MessageLoader.getMessage("migTargetDirWriteError"));
    }

    private void doCheckTargetParentDir(File file) throws MigrationServiceException, FileException {
        SetFilePermission filePer = new SetFilePermission();
        boolean isFolCreated = false;
        try {
            isFolCreated = QueryConversionUtility.containsCheck(System.getProperty("os.name"), "win") ? filePer.createFolderWithPermissionInWin(file.getCanonicalPath(), false) : filePer.createFolderWithPermissionInLinux(file.getCanonicalPath(), false);
        }
        catch (IOException e) {
            logger.error(ErrorLoggerUtility.getExceptionDetails(e) + " Error occurred while getting path of the file:" + file.toString());
        }
        if (!isFolCreated) {
            logger.error(MessageLoader.getMessage("migParentDirOfTarget") + " " + MessageLoader.getMessage("migrationAppError"));
            QueryConversionUtility.printConsoleMessage("Could not create parent directory of the target directory path doesn't exist in the system hence not able to create target directory here." + IGaussDBConstants.NEW_LINE + "Therefore the application can not process further..");
            throw new MigrationServiceException(MessageLoader.getMessage("migParentDirOfTarget"));
        }
        logger.debug("Folder has been created:{}", (Object)file.toString());
    }

    public void doCheckTargetFile(File[] filesInTarget, String operation) throws MigrationServiceException {
        switch (operation) {
            case "delete": {
                for (File filename : filesInTarget) {
                    this.deleteFile(filename);
                }
                logger.info(MessageLoader.getMessage("migTargetDirFilesDelete"), (Object)System.getProperty("user.name"));
                break;
            }
            case "cancel": {
                logger.error(MessageLoader.getMessage("migTargetDirFilesCancel") + System.getProperty("user.name"));
                throw new MigrationServiceException("[DSC_ERR_004_015] " + MessageLoader.getMessage("DSC_ERR_004_015") + " " + System.getProperty("user.name"));
            }
            default: {
                logger.info(MessageLoader.getMessage("migTargetDirFilesOvewrite"), (Object)System.getProperty("user.name"));
            }
        }
    }

    private void deleteFile(File filename) {
        if (filename.isDirectory()) {
            File[] filesInTarget = filename.listFiles();
            if (filesInTarget != null && filesInTarget.length > 0) {
                this.targetDirFileDelete(filesInTarget);
            }
            if (filename.delete()) {
                logger.info("File directory has been deleted:{}", (Object)filename.toString());
            }
        } else if (filename.delete()) {
            logger.info("File has been deleted:{}", (Object)filename.toString());
        }
    }

    private void targetDirFileDelete(File[] filesInTarget) {
        for (File file : filesInTarget) {
            if (file.isDirectory()) {
                this.deleteFile(file);
            }
            if (!file.delete()) continue;
            logger.info("File has been deleted:{}", (Object)file.toString());
        }
    }
}

