/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.services;

import com.huawei.db.migration.bo.IMigrationInputBO;
import com.huawei.db.migration.common.handlers.MigrationPostProcessor;
import com.huawei.db.migration.common.handlers.MigrationProcessor;
import com.huawei.db.migration.common.handlers.RunFileUtility;
import com.huawei.db.migration.exception.MigrationServiceException;
import com.huawei.db.migration.services.DBMigrationService;
import com.huawei.db.migration.util.ApplicationProperty;
import com.huawei.db.migration.util.ColumnSplitter;
import com.huawei.db.migration.util.FeatureLoader;
import com.huawei.db.migration.util.MessageLoader;
import com.huawei.db.migration.util.ProgressUtil;
import com.huawei.db.migration.util.PropertyLoader;
import com.huawei.db.migration.util.QueryConversionUtility;
import com.huawei.db.migration.util.QueryUtilityExt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TeradataMigrationService
extends DBMigrationService {
    private static final Logger logger = LogManager.getLogger(TeradataMigrationService.class);
    private static final Map<String, List<String>> SET_TABLE = new ConcurrentHashMap<String, List<String>>();
    private static final Map<String, Set<String>> SET_TABLE_NAMES = new ConcurrentHashMap<String, Set<String>>();
    private static final Map<String, Set<String>> SET_TEMP_TABLES = new ConcurrentHashMap<String, Set<String>>();
    private static final Map<String, Set<String>> MSET_TEMPTBLS = new ConcurrentHashMap<String, Set<String>>();
    private static final Map<String, Set<String>> SEL_DATE_COLS = new ConcurrentHashMap<String, Set<String>>();
    private static final Map<String, List<String>> DATE_COLUMNS = new ConcurrentHashMap<String, List<String>>();
    private static final Map<String, String> CREATE_TYPE_MAP = new ConcurrentHashMap<String, String>(10);
    private static final Map<String, String> DSQL_SET_MAP = new ConcurrentHashMap<String, String>(10);
    private static final Map<String, String> DSQL_SCRIPT_FILE_PATH = new ConcurrentHashMap<String, String>(10);
    private static final Set<String> RUN_FILE_CONTAIN_LIST = new HashSet<String>(10);
    private Collection<String> fileset = null;
    private Collection<String> filesetdsql = null;
    private Collection<String> runFileset = null;
    private Map<String, String> RUN_FILE_SCRIPT_PATH = new ConcurrentHashMap<String, String>();

    public static Map<String, String> getCreateTypeMap() {
        return CREATE_TYPE_MAP;
    }

    public static Set<String> getRunFileContainList() {
        return RUN_FILE_CONTAIN_LIST;
    }

    public static void setRunFileContainList(String fileName) {
        RUN_FILE_CONTAIN_LIST.add(fileName);
    }

    public static void addCreateTypeMap(String userDataType, String dataType) {
        CREATE_TYPE_MAP.put(userDataType, dataType);
    }

    public static Map<String, String> getDSQLSetMap() {
        return DSQL_SET_MAP;
    }

    public static void addDSQLSetMap(String setKey, String replaceValue) {
        DSQL_SET_MAP.put(setKey, replaceValue);
    }

    public static Map<String, String> getDSQLScriptFilePath() {
        return DSQL_SCRIPT_FILE_PATH;
    }

    public static void addMultiSetTempTblsMap(String fileName, String tableName) {
        Set<String> tableNameSet = MSET_TEMPTBLS.get(fileName);
        if (tableNameSet == null) {
            tableNameSet = new HashSet<String>(10);
            tableNameSet.add(tableName);
            MSET_TEMPTBLS.put(fileName, tableNameSet);
        } else {
            tableNameSet.add(tableName);
            MSET_TEMPTBLS.put(fileName, tableNameSet);
        }
    }

    public static void addSetTempTblsMap(String fileName, String tableName) {
        Set<String> tableNameSet = SET_TEMP_TABLES.get(fileName);
        if (tableNameSet == null) {
            tableNameSet = new HashSet<String>(10);
            tableNameSet.add(tableName);
            SET_TEMP_TABLES.put(fileName, tableNameSet);
        } else {
            tableNameSet.add(tableName);
            SET_TEMP_TABLES.put(fileName, tableNameSet);
        }
    }

    public static void addSetTableNameColListToMap(String fname, boolean isVolatile, String tableName, List<String> columnList) {
        String tableNameTmp = tableName;
        if (isVolatile) {
            tableNameTmp = fname + "-" + tableName;
        }
        SET_TABLE.put(tableNameTmp, columnList);
    }

    public static List<String> getSetTableColumns(String fname, boolean isVolatile, String tableName) {
        String tableNameTmp = tableName;
        if (isVolatile) {
            tableNameTmp = fname + "-" + tableName;
        }
        return new ArrayList<String>((Collection)SET_TABLE.get(tableNameTmp));
    }

    public static boolean chkContainsTbl(String fname, boolean isVolatile, String tableName) {
        String tableNameTmp = tableName;
        if (isVolatile) {
            tableNameTmp = fname + "-" + tableName;
        }
        return SET_TABLE.containsKey(tableNameTmp);
    }

    public static boolean chkContainsTempTbl(String fname, String tableName) {
        ArrayList tables;
        return SET_TEMP_TABLES.containsKey(fname) && (tables = new ArrayList(SET_TEMP_TABLES.get(fname))).contains(tableName);
    }

    public static boolean chkContainsMultiSetTempTbl(String fname, String tableName) {
        ArrayList tables;
        return MSET_TEMPTBLS.containsKey(fname) && (tables = new ArrayList(MSET_TEMPTBLS.get(fname))).contains(tableName);
    }

    public static boolean chkDateFormattblContains(String tableName) {
        return DATE_COLUMNS.containsKey(tableName);
    }

    public static void addPackageNameMap(String fileName, String tableName) {
        Set<String> tableNameSet = SET_TABLE_NAMES.get(fileName);
        if (tableNameSet == null) {
            tableNameSet = new HashSet<String>(10);
            tableNameSet.add(tableName);
            SET_TABLE_NAMES.put(fileName, tableNameSet);
        } else {
            tableNameSet.add(tableName);
            SET_TABLE_NAMES.put(fileName, tableNameSet);
        }
    }

    public static void addDateColumn(String tableNameIn, String dateColumn) {
        String tableName = tableNameIn;
        tableName = tableName.replaceAll("\\s*\\.\\s*", ".");
        List<String> dateColumnSet = DATE_COLUMNS.get(tableName = QueryConversionUtility.toUpper(tableName));
        if (dateColumnSet == null) {
            dateColumnSet = new ArrayList<String>(10);
            dateColumnSet.add(dateColumn);
            DATE_COLUMNS.put(tableName, dateColumnSet);
        } else {
            String col = dateColumn.split("--")[0];
            Iterator<String> colWithFormat = dateColumnSet.iterator();
            while (colWithFormat.hasNext()) {
                String oldCol;
                String oldColStr = colWithFormat.next();
                if (oldColStr.isEmpty()) {
                    colWithFormat.remove();
                }
                if (!(oldCol = oldColStr.split("--")[0]).equalsIgnoreCase(col)) continue;
                colWithFormat.remove();
            }
            if (!dateColumnSet.contains(dateColumn)) {
                dateColumnSet.add(dateColumn);
                DATE_COLUMNS.put(tableName, dateColumnSet);
            }
        }
    }

    public static List<String> getDateColumn(String tableName) {
        return DATE_COLUMNS.get(tableName);
    }

    @Override
    public void handleMigration(Map<String, String> fileMap, IMigrationInputBO objInputData) throws MigrationServiceException {
        try {
            String filePath;
            this.setTableAndDateColumnMap();
            CREATE_TYPE_MAP.putAll(PropertyLoader.loadPropertyFile("teradata-types-UDT"));
            DSQL_SET_MAP.putAll(PropertyLoader.loadPropertyFile("teradata-dsql-set"));
            if (FeatureLoader.getBooleanProperty("terdataUtilities") && ApplicationProperty.getStringProperty("SourceDB").equalsIgnoreCase("teradata") && (filePath = FeatureLoader.getStringProperty("enviroment_file_path")) != null && !filePath.isEmpty()) {
                DSQL_SCRIPT_FILE_PATH.putAll(PropertyLoader.loadEnviromentFile(filePath));
            }
            super.handleMigration(fileMap, objInputData);
            this.fileset = fileMap.values();
            this.filesetdsql = fileMap.values();
            this.RUN_FILE_SCRIPT_PATH = RunFileUtility.getRunFileScriptPath();
            if (this.RUN_FILE_SCRIPT_PATH.size() > 0) {
                this.runFileset = this.RUN_FILE_SCRIPT_PATH.values();
                ProgressUtil.setRunFileBarStatus(true);
                super.handleMigration(this.RUN_FILE_SCRIPT_PATH, objInputData);
            }
            this.handlePostProcessing(objInputData);
            this.writePropertiesData();
        }
        catch (MigrationServiceException objExp) {
            logger.error("[DSC_ERR_004_009] " + MessageLoader.getMessage("DSC_ERR_004_009"));
        }
        catch (InterruptedException objExp) {
            QueryUtilityExt.handleInterruptedException(objExp);
            MigrationProcessor.interrupt();
        }
    }

    @Override
    public void writePropertiesData() {
        try {
            PropertyLoader.writeListValuesToPropertyFile("teradata-set-table", SET_TABLE);
            PropertyLoader.writeListValuesToPropertyFile("teradata-date-format", DATE_COLUMNS);
            PropertyLoader.writePropertyFile("teradata-types-UDT", CREATE_TYPE_MAP);
            PropertyLoader.writePropertyFile("teradata-dsql-set", DSQL_SET_MAP);
        }
        catch (MigrationServiceException migExp) {
            logger.error("Errored out while saving create type names of UDT.");
        }
    }

    private void setTableAndDateColumnMap() throws MigrationServiceException {
        LinkedHashMap<String, String> tempSetTabMap = new LinkedHashMap<String, String>(10);
        LinkedHashMap<String, String> dateMap = new LinkedHashMap<String, String>(10);
        tempSetTabMap.putAll(PropertyLoader.loadPropertyFile("teradata-set-table"));
        dateMap.putAll(PropertyLoader.loadPropertyFile("teradata-date-format"));
        List<String> tempList = null;
        String columns = null;
        ColumnSplitter splitter = new ColumnSplitter();
        for (Map.Entry setTab : tempSetTabMap.entrySet()) {
            columns = (String)setTab.getValue();
            if (columns.length() > 1) {
                columns = columns.substring(1, columns.length() - 1);
            }
            tempList = splitter.doGetAllColumns(columns);
            SET_TABLE.put((String)setTab.getKey(), tempList);
        }
        for (Map.Entry dateTab : dateMap.entrySet()) {
            columns = (String)dateTab.getValue();
            if (columns.length() > 1) {
                columns = columns.substring(1, columns.length() - 1);
            }
            tempList = splitter.doGetAllColumns(columns);
            DATE_COLUMNS.put((String)dateTab.getKey(), tempList);
        }
    }

    @Override
    public void handlePostProcessing(IMigrationInputBO objInputData) throws InterruptedException {
        ExecutorService teradataExecutor = this.getExecutorService();
        QueryConversionUtility.printConsoleMessage("--------------------------------------------------------------------------");
        QueryConversionUtility.printConsoleMessage("Started post processing");
        ArrayList futureList = new ArrayList(10);
        for (Map.Entry<String, Set<String>> setTabName : SET_TABLE_NAMES.entrySet()) {
            this.getOutList(objInputData, teradataExecutor, futureList, setTabName);
        }
        this.clearExecutorService(teradataExecutor, futureList);
        teradataExecutor = this.getExecutorService();
        this.submitParallelTasks(objInputData, teradataExecutor, futureList);
        this.clearExecutorService(teradataExecutor, futureList);
        teradataExecutor = this.getExecutorService();
        this.submitParallelTasksforType(this.fileset, objInputData, teradataExecutor, futureList);
        this.clearExecutorService(teradataExecutor, futureList);
        this.doPostMigrationRunFileScript(objInputData, futureList);
        QueryConversionUtility.printConsoleMessage("Completed post processing");
    }

    private void getOutList(IMigrationInputBO objInputData, ExecutorService teradataExecutor, ArrayList<Future<?>> futureList, Map.Entry<String, Set<String>> setTabName) {
        HashSet<String> setTbls = null;
        Set<String> insertTbls = null;
        Set<String> tempTbls = null;
        String fileNme = null;
        setTbls = new HashSet<String>(SET_TABLE.keySet());
        insertTbls = setTabName.getValue();
        ArrayList<String> insertTblLst = new ArrayList<String>(insertTbls);
        fileNme = setTabName.getKey();
        tempTbls = SET_TEMP_TABLES.get(fileNme);
        if (tempTbls != null) {
            tempTbls.retainAll(insertTbls);
            if (!tempTbls.isEmpty()) {
                String insTbl = null;
                for (String tbl : tempTbls) {
                    for (int tIndex = 0; tIndex < insertTblLst.size(); ++tIndex) {
                        insTbl = ((String)insertTblLst.get(tIndex)).trim();
                        if (!QueryConversionUtility.equalCheck(tbl.trim(), insTbl)) continue;
                        insertTblLst.set(tIndex, fileNme + "-" + insTbl);
                    }
                }
            }
            insertTbls = new HashSet<String>(insertTblLst);
        }
        setTbls.retainAll(insertTbls);
        if (!setTbls.isEmpty()) {
            String key = setTabName.getKey();
            String keyValue = "";
            if (key instanceof String) {
                keyValue = key;
            }
            futureList.add(teradataExecutor.submit(new MigrationPostProcessor(keyValue, objInputData, setTbls, "Set")));
        }
    }

    private void doPostMigrationRunFileScript(IMigrationInputBO objInputData, ArrayList<Future<?>> futureList) throws InterruptedException {
        boolean runFileFlag;
        boolean bl = runFileFlag = FeatureLoader.getBooleanProperty("terdataUtilities") && "teradata".equalsIgnoreCase(ApplicationProperty.getStringProperty("SourceDB"));
        if (runFileFlag) {
            this.doRunFilePostMigration(objInputData, futureList);
        }
    }

    private void doRunFilePostMigration(IMigrationInputBO objInputData, ArrayList<Future<?>> futureList) throws InterruptedException {
        ExecutorService teradataExecutor = this.getExecutorService();
        RunFileUtility runFileUtility = new RunFileUtility();
        runFileUtility.submitParallelTaskForRunFileReplacement(this.runFileset, objInputData, teradataExecutor, futureList, this.filesetdsql);
        runFileUtility.getReplaceProcName(this.filesetdsql, objInputData);
        this.clearExecutorService(teradataExecutor, futureList);
    }

    private void submitParallelTasksforType(Collection<String> fileList, IMigrationInputBO objInputData, ExecutorService teradataExecutor, ArrayList<Future<?>> futureList) {
        if (CREATE_TYPE_MAP.size() != 0) {
            for (String fileName : fileList) {
                futureList.add(teradataExecutor.submit(new MigrationPostProcessor(fileName, objInputData, new HashSet<String>(), "createtype")));
            }
        }
    }

    private void submitParallelTasks(IMigrationInputBO objInputData, ExecutorService teradataExecutor, ArrayList<Future<?>> futureList) {
        TreeSet<String> dateTbls = null;
        Set<String> insertDateTbls = null;
        for (Map.Entry<String, Set<String>> setTabName : SEL_DATE_COLS.entrySet()) {
            dateTbls = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            dateTbls.addAll(DATE_COLUMNS.keySet());
            insertDateTbls = setTabName.getValue();
            dateTbls.retainAll(insertDateTbls);
            String objKey = setTabName.getKey();
            String keyVal = "";
            if (objKey instanceof String) {
                keyVal = objKey;
            }
            if (dateTbls.isEmpty()) continue;
            futureList.add(teradataExecutor.submit(new MigrationPostProcessor(keyVal, objInputData, dateTbls, "dateformat")));
        }
    }
}

