/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.splitter;

import com.huawei.db.migration.splitter.BulkBaseListener;
import com.huawei.db.migration.splitter.BulkParser;
import com.huawei.db.migration.splitter.CustomFileWriter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.TokenStreamRewriter;

public class BulkCustomListener
extends BulkBaseListener {
    private List<String> lineRangeList = new ArrayList<String>();
    private String charSet;
    private Path outPath;
    private TokenStreamRewriter rewriter = null;

    public BulkCustomListener(CommonTokenStream tokenStream, String charSet, Path outPath) {
        this.rewriter = new TokenStreamRewriter((TokenStream)tokenStream);
        this.charSet = charSet;
        this.outPath = outPath;
    }

    @Override
    public void enterSingle_statement(BulkParser.Single_statementContext ctx) {
        String sql = this.rewriter.getText(ctx.getSourceInterval()).trim();
        if (sql.isEmpty() || sql.matches("(^(?i)(set|prompt|spool)(?!\\w).*$)")) {
            return;
        }
        int startLine = ctx.getStart().getLine();
        int endLine = ctx.getStop().getLine();
        String lineRange = startLine + "," + endLine;
        this.lineRangeList.add(lineRange);
    }

    @Override
    public void exitSql_script(BulkParser.Sql_scriptContext ctx) {
        CustomFileWriter.writeContent(this.lineRangeList, this.outPath, this.charSet);
    }
}

