/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.splitter;

import com.huawei.db.migration.util.ErrorLoggerUtility;
import com.huawei.db.migration.util.MessageLoader;
import com.huawei.db.migration.util.QueryConversionUtility;
import com.huawei.db.migration.util.SetFilePermission;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.file.Path;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CustomFileWriter {
    private static final Logger logger = LogManager.getLogger(CustomFileWriter.class);

    public static void writeContent(List<String> lineRangeList, Path outPath, String charsetName) {
        CustomFileWriter.writeContent(lineRangeList, outPath, charsetName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeContent(List<String> lineRangeList, Path outPath, String charsetName, boolean isAppend) {
        boolean isFileCreated = false;
        SetFilePermission filePer = new SetFilePermission();
        File targetFile = new File(outPath.toString());
        isFileCreated = QueryConversionUtility.containsCheck(System.getProperty("os.name"), "win") ? filePer.createFileWithPermissionInWin(targetFile.getPath()) : filePer.createFileWithPermissionInLinux(targetFile.getPath());
        if (!isFileCreated && targetFile.exists()) {
            logger.info("{} - File already exists/Failed to create target file", (Object)targetFile);
        }
        BufferedWriter writer = null;
        FileOutputStream fout = null;
        try {
            if (targetFile.exists() && targetFile.canWrite()) {
                fout = new FileOutputStream(targetFile, isAppend);
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fout, charsetName));
                for (String lineRange : lineRangeList) {
                    writer.write(lineRange);
                    writer.newLine();
                }
                writer.flush();
            } else {
                logger.error("Target File :" + targetFile + " has no write permissions");
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.error("Exception while writing data to out file{}", (Object)outPath);
        }
        catch (FileNotFoundException e) {
            logger.error("Exception while writing data to out file{}", (Object)outPath);
        }
        catch (IOException e) {
            logger.error("Exception while writing data to out file{}", (Object)outPath);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
                if (fout != null) {
                    fout.close();
                }
            }
            catch (IOException e) {
                logger.error(ErrorLoggerUtility.getExceptionDetails(e) + " IOException occurred. [DSC_ERR_004_043] " + MessageLoader.getMessage("DSC_ERR_004_043") + " " + targetFile.getName());
            }
        }
    }
}

