/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.splitter;

import com.huawei.db.migration.common.handlers.FileHandler;
import com.huawei.db.migration.splitter.IStatementSplitter;
import com.huawei.db.migration.splitter.StatementSplitterFactory;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SqlSplitProcessor
implements Runnable {
    private static final Logger logger = LogManager.getLogger(SqlSplitProcessor.class);
    private Path inPath;
    private Path outPath;
    private String migrationType;
    private boolean isFileSplitter;

    public SqlSplitProcessor(Path inPath, Path outPath, String migrationType, boolean isFileSplitter) {
        this.inPath = inPath;
        this.outPath = outPath;
        this.migrationType = migrationType;
        this.isFileSplitter = isFileSplitter;
    }

    @Override
    public void run() {
        String inputFile = this.inPath.toString();
        String charsetName = new FileHandler().getEncodingFormat(new File(inputFile));
        CharStream inputStream = null;
        try {
            inputStream = CharStreams.fromFileName((String)inputFile, (Charset)Charset.forName(charsetName));
            IStatementSplitter splitter = StatementSplitterFactory.createSplitter(this.migrationType);
            splitter.split(inputStream, this.outPath, this.isFileSplitter, charsetName);
        }
        catch (IOException e) {
            logger.error("IOException while opening the charstream on inputfile{}, exception is{}", (Object)inputFile, (Object)e.getMessage());
        }
    }
}

