/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.splitter;

import com.huawei.db.migration.common.handlers.MigrationProcessor;
import com.huawei.db.migration.splitter.DirWalker;
import com.huawei.db.migration.splitter.SplitterProgressUtil;
import com.huawei.db.migration.splitter.SqlSplitProcessor;
import com.huawei.db.migration.util.QueryConversionUtility;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SqlStatementRangeGenerator {
    private static final Logger logger = LogManager.getLogger(SqlStatementRangeGenerator.class);

    public static void generateSqlStatementRanges(String targetFolderPath, String migrationType) {
        logger.debug("Started generating the Statement Line Range Mapping");
        String inPathStr = targetFolderPath + File.separator + "output";
        String outPathStr = targetFolderPath + File.separator + "rangeMapper";
        Path inPath = Paths.get(inPathStr, new String[0]).normalize();
        Path outPath = Paths.get(outPathStr, new String[0]).normalize();
        DirWalker fileCollection = new DirWalker(inPath, outPath);
        try {
            Files.walkFileTree(inPath, fileCollection);
        }
        catch (IOException e) {
            logger.error("Exception while fetching the files in the output folder:{}, exception is:{}", (Object)inPathStr, (Object)e.getMessage());
        }
        Map<Path, Path> files = fileCollection.getFilesMap();
        if (files.size() == 0) {
            logger.debug("No sql files found in the output folder:{}", (Object)inPathStr);
            return;
        }
        SplitterProgressUtil.getInstance().setTotalFileCount(files.size());
        SplitterProgressUtil.getInstance().displayInitialProgress();
        int configuredProcessors = QueryConversionUtility.doGetAppThreadCnt();
        ExecutorService splitProcessExecutor = Executors.newFixedThreadPool(configuredProcessors);
        for (Map.Entry<Path, Path> fileDetails : files.entrySet()) {
            SqlSplitProcessor splitTask = new SqlSplitProcessor(fileDetails.getKey(), fileDetails.getValue(), migrationType, false);
            splitProcessExecutor.execute(splitTask);
        }
        splitProcessExecutor.shutdown();
        try {
            splitProcessExecutor.awaitTermination(QueryConversionUtility.getApplicationTimeout(), TimeUnit.HOURS);
        }
        catch (InterruptedException e) {
            MigrationProcessor.interrupt();
            logger.error("Exception while waiting for the termination of executor, exception is:{}", (Object)e.getMessage());
        }
        QueryConversionUtility.printConsoleMessage("");
        logger.debug("Completed generating the Statement Line Range Mapping");
    }
}

