/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.sqlformatter;

import com.huawei.db.migration.exception.MigrationServiceException;
import com.huawei.db.migration.sqlformatter.GaussSQLParser;
import com.huawei.db.migration.sqlformatter.GaussSQLRule;
import com.huawei.db.migration.sqlformatter.GaussSQLToken;
import com.huawei.db.migration.sqlformatter.IGaussAbstractToken;
import com.huawei.db.migration.util.ErrorLoggerUtility;
import com.huawei.db.migration.util.IGaussDBConstants;
import com.huawei.db.migration.util.MessageLoader;
import com.huawei.db.migration.util.QueryConversionUtility;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GaussSQLFormatter {
    private static final Logger logger = LogManager.getLogger(GaussSQLFormatter.class);
    private final GaussSQLParser sqlParser = new GaussSQLParser();
    private GaussSQLRule sqlRuleSet = null;
    private Stack<Boolean> fnBracket = new Stack();
    private boolean isGroupBy = false;
    private boolean isDelete = false;
    private boolean mHasBetween = false;
    private boolean mHasCaseStmt = false;
    private int mIndex = 0;
    private int mIndent = 0;
    private int beginCount = 0;
    private boolean keySpaceFlag = false;
    private int keySpaceCount = 0;
    private boolean bracketFlag = false;
    private int hashCount = 0;

    public GaussSQLFormatter(GaussSQLRule sqlRule) {
        this.sqlRuleSet = sqlRule;
    }

    public String formatSQL(String sqlQry) {
        return this.formatSQL(sqlQry, false);
    }

    public String formatSQL(String sqlQry, boolean isOutPutQuery) throws MigrationServiceException {
        this.fnBracket.clear();
        try {
            boolean isSqlWithNewLine = sqlQry.endsWith(IGaussDBConstants.NEW_LINE);
            List<IGaussAbstractToken> list = this.sqlParser.parseSQL(sqlQry);
            String formatType = "query";
            String patternSQL = "(?is).*((?<!\\w)function(?!\\w)|(?<!\\w)procedure(?!\\w)|(?<!\\w)package(?!\\w)|(?<!\\w)Declare(?!\\w)).*";
            String transactionPat = "(?is)Begin(" + System.lineSeparator() + "|\\s+).*?(" + System.lineSeparator() + "|\\s+)End\\s*;(" + System.lineSeparator() + "|\\s*)\\/.*";
            if (sqlQry.matches(patternSQL) || sqlQry.trim().matches(transactionPat)) {
                formatType = "blogic";
            }
            list = formatType.equals("query") ? this.sqlFormat(list, sqlQry, isOutPutQuery) : this.formatPLSQL(list);
            StringBuffer query = new StringBuffer(128);
            for (int index = 0; index < list.size(); ++index) {
                query.append(list.get(index).getTokenString());
            }
            if (isSqlWithNewLine) {
                query.append(IGaussDBConstants.NEW_LINE);
            }
            return query.toString();
        }
        catch (Exception ex) {
            logger.error(ErrorLoggerUtility.getExceptionDetails(ex) + " Error while formatting :" + ex.getMessage());
            throw new MigrationServiceException("[DSC_ERR_004_016] " + MessageLoader.getMessage("DSC_ERR_004_016"));
        }
    }

    private void restoreBackslashToken(List<IGaussAbstractToken> tokenList) {
        for (IGaussAbstractToken token : tokenList) {
            if (token.getTokenString().equals("##IFTHEN##") || token.getTokenString().equals("##ELSETHEN##") || token.getTokenString().equals("##FORTHEN##") || token.getTokenString().equals("##LOOPTHEN##")) {
                token.setTokenString(IGaussDBConstants.NEW_LINE);
            }
            if (token.getTokenString().startsWith("#")) {
                token.setTokenString(token.getTokenString().toLowerCase());
                token.setTokenString(token.getTokenString().replace("#endfor", "#end-for"));
                token.setTokenString(token.getTokenString().replace("#exitfor", "#exit-for"));
                token.setTokenString(token.getTokenString().replace("#", "\\"));
            }
            if (!token.getTokenString().equals("'=='")) continue;
            token.setTokenString("==");
        }
    }

    private List<IGaussAbstractToken> sqlFormat(List<IGaussAbstractToken> argumentList, String sqlQry, boolean isOutPutQuery) {
        this.updArgList(argumentList);
        int listSize = argumentList.size();
        for (int index = 0; index < listSize; ++index) {
            this.getToken(argumentList, index);
        }
        this.doChangeArgLstForSpace(argumentList);
        this.doChangeArgLstForKeyword(argumentList);
        this.mIndent = 0;
        this.isGroupBy = false;
        this.isDelete = false;
        this.mHasBetween = false;
        Stack<Integer> bracketIndent = new Stack<Integer>();
        IGaussAbstractToken prev = new GaussSQLToken(0, " ");
        this.mIndex = 0;
        while (this.mIndex < argumentList.size()) {
            IGaussAbstractToken token = argumentList.get(this.mIndex);
            if (token.getTokenType() == 1) {
                this.sqlFormatSymbol(argumentList, bracketIndent, prev);
            } else if (token.getTokenType() == 2) {
                this.sqlFormatToken(argumentList);
            } else if (token.getTokenType() == 5 && token.getTokenString().startsWith("/*")) {
                this.mIndex += this.insertAndIndent(argumentList, this.mIndex + 1, this.mIndent);
            }
            this.checkHashString(argumentList, token);
            prev = token;
            ++this.mIndex;
        }
        this.doChangeArgLstForBracket(argumentList);
        this.doChangeArgLstForComma(argumentList);
        this.doPerlMultitagFormat(argumentList);
        Pattern bteqCmdPattern = Pattern.compile("(?i)((#if)\\s+'?(\\$\\{(\\w+)\\})'?\\s*'?(==|!=)'?\\s*'?(\\w*|\\d+)'?\\s+(#q|goto|i)\\s*('?\\w*'?|\\d+)\\s+#else|endif.*)|(#for\\s+##FORTHEN##\\s+(.*)\\s+##FORTHEN##)|(#loop\\s+##LOOPTHEN##\\s+)|(#(?<!\\w)(endfor)|(exitfor)(?!\\w))|((\\s*#q|i|goto|label|set)\\s*\\w*)\\s*;?");
        Matcher bteqCmdMatcher = bteqCmdPattern.matcher(sqlQry);
        if (isOutPutQuery && bteqCmdMatcher.find()) {
            this.restoreBackslashToken(argumentList);
            this.doChangeArgListForBteqBlock(argumentList);
        }
        this.doChangeArgListForBteqBlock(argumentList);
        return argumentList;
    }

    private void getToken(List<IGaussAbstractToken> argumentList, int index) {
        IGaussAbstractToken token = argumentList.get(index);
        if (token.getTokenType() == 2) {
            this.sqlRuleSet.setKeywordCase(1);
            switch (this.sqlRuleSet.getDefaultCase()) {
                case 2: {
                    token.setTokenString(QueryConversionUtility.toLower(token.getTokenString()));
                    break;
                }
                case 1: {
                    token.setTokenString(QueryConversionUtility.toUpper(token.getTokenString()));
                    break;
                }
                case 0: {
                    break;
                }
            }
        }
    }

    private void updArgList(List<IGaussAbstractToken> argumentList) {
        IGaussAbstractToken token = this.getElementFromList(argumentList, 0);
        if (token.getTokenType() == 0) {
            argumentList.remove(0);
        }
        if ((token = this.getElementFromList(argumentList, argumentList.size() - 1)).getTokenType() == 0) {
            argumentList.remove(argumentList.size() - 1);
        }
    }

    private int indexOfArgList(List<IGaussAbstractToken> tokenList, String tokenKey) {
        int keyIndex = -1;
        for (int i = 0; i < tokenList.size(); ++i) {
            if (!tokenList.get(i).getTokenString().equals(tokenKey)) continue;
            keyIndex = i;
            break;
        }
        return keyIndex;
    }

    private void doChangeArgListForBteqBlock(List<IGaussAbstractToken> argumentList) {
        int startIdx;
        if (this.getElementFromList(argumentList, 0).getTokenString().equals("\\endif")) {
            this.insertAndIndent(argumentList, 1, this.mIndent);
        }
        boolean hasBteqCmdEnd = false;
        for (int i = 0; i < argumentList.size(); ++i) {
            IGaussAbstractToken token = argumentList.get(i);
            if (this.hasBteqCmdEnd(token)) {
                hasBteqCmdEnd = true;
            }
            if (!token.getTokenString().equals(";") || !hasBteqCmdEnd) continue;
            StringBuffer newToken = new StringBuffer(IGaussDBConstants.NEW_LINE);
            this.addItemToList(argumentList, i, newToken);
            break;
        }
        if ((startIdx = this.indexOfArgList(argumentList, "\\if")) < 0) {
            return;
        }
        for (int index = startIdx; index > -1 && index < argumentList.size() - 1; ++index) {
            IGaussAbstractToken curToken = this.getElementFromList(argumentList, index);
            IGaussAbstractToken nextToken = this.getElementFromList(argumentList, index + 1);
            if (!nextToken.getTokenString().startsWith("\\endif")) continue;
            this.insertAndIndent(argumentList, index + 1, this.mIndent);
            if (!this.isBteqCmdNeedTab(nextToken)) continue;
            curToken.setTokenString(curToken.getTokenString() + "\t");
        }
    }

    private boolean hasBteqCmdEnd(IGaussAbstractToken token) {
        boolean hasBteqCmdEnd = false;
        switch (token.getTokenString()) {
            case "\\q": 
            case "\\i": 
            case "\\set": 
            case "\\label": 
            case "\\goto": 
            case "\\endif": 
            case "\\end": 
            case "\\end-for": 
            case "\\exit-for": {
                hasBteqCmdEnd = true;
                break;
            }
        }
        return hasBteqCmdEnd;
    }

    private boolean isBteqCmdNeedTab(IGaussAbstractToken token) {
        boolean needTab = false;
        switch (token.getTokenString()) {
            case "\\q": 
            case "\\goto": 
            case "\\i": {
                needTab = true;
                break;
            }
        }
        return needTab;
    }

    private void checkHashString(List<IGaussAbstractToken> argumentList, IGaussAbstractToken token) {
        if (token.getTokenString().equalsIgnoreCase("###")) {
            ++this.hashCount;
            if (this.hashCount % 2 != 0) {
                IGaussAbstractToken hasToken;
                IGaussAbstractToken iGaussAbstractToken = hasToken = this.mIndex - 1 > 0 ? argumentList.get(this.mIndex - 1) : null;
                if (hasToken != null) {
                    hasToken.setTokenString(System.lineSeparator());
                }
            }
        }
    }

    private void doPerlMultitagFormat(List<IGaussAbstractToken> argumentList) {
        String tagString = "";
        for (int index = 1; index < argumentList.size(); ++index) {
            IGaussAbstractToken token = argumentList.get(index);
            if (token.getTokenString().equalsIgnoreCase("<<")) {
                token = index + 1 < argumentList.size() ? argumentList.get(++index) : null;
                String string = tagString = token != null ? token.getTokenString() : "";
                if (tagString.trim().isEmpty()) {
                    token = ++index < argumentList.size() ? argumentList.get(index) : null;
                    tagString = token != null ? token.getTokenString() : "";
                    IGaussAbstractToken iGaussAbstractToken = token = ++index < argumentList.size() ? argumentList.get(index) : null;
                }
            }
            if (token == null || !token.getTokenString().equalsIgnoreCase(tagString) || tagString.trim().isEmpty()) continue;
            IGaussAbstractToken iGaussAbstractToken = token = index + 1 < argumentList.size() ? argumentList.get(index + 1) : null;
            if (token == null || index + 1 >= argumentList.size()) continue;
            token.setTokenString(System.lineSeparator());
        }
    }

    private void sqlFormatSymbol(List<IGaussAbstractToken> argumentList, Stack<Integer> bracketIndent, IGaussAbstractToken prev) {
        IGaussAbstractToken token = this.getElementFromList(argumentList, this.mIndex);
        if ("(".equals(token.getTokenString())) {
            IGaussAbstractToken nextToken = this.getElementFromList(argumentList, this.mIndex + 1);
            if ("case".equalsIgnoreCase(nextToken.getTokenString())) {
                this.fnBracket.push(false);
                bracketIndent.push(this.mIndent);
                ++this.mIndent;
                this.mIndex += this.insertAndIndent(argumentList, this.mIndex + 1, this.mIndent);
            } else {
                this.fnBracket.push(this.sqlRuleSet.isFunction(prev.getTokenString()) ? Boolean.TRUE : Boolean.FALSE);
                bracketIndent.push(this.mIndent);
                ++this.mIndent;
                this.mIndex += this.insertAndIndent(argumentList, this.mIndex + 1, this.mIndent);
            }
            this.isGroupBy = false;
        }
        this.checkCloseBracket(argumentList, bracketIndent, token);
        this.checkSpecificSymbol(argumentList, token);
    }

    private void checkSpecificSymbol(List<IGaussAbstractToken> argumentList, IGaussAbstractToken token) {
        if (",".equals(token.getTokenString()) && !this.isGroupBy) {
            this.mIndex += this.insertAndIndent(argumentList, this.mIndex, this.mIndent);
        } else if (";".equals(token.getTokenString())) {
            this.mIndent = 0;
            this.mIndex += this.insertAndIndent(argumentList, this.mIndex + 1, this.mIndent);
        } else if ("\\endif".equals(token.getTokenString())) {
            this.mIndent = 0;
            this.mIndex += this.insertAndIndent(argumentList, this.mIndex + 1, this.mIndent);
        } else if (token.getTokenString().equals("/") && this.mIndex + 1 < argumentList.size()) {
            boolean condition;
            IGaussAbstractToken prevToken = this.mIndex - 2 > 0 ? argumentList.get(this.mIndex - 2) : null;
            IGaussAbstractToken nextToken = this.mIndex + 1 < argumentList.size() ? argumentList.get(this.mIndex + 1) : null;
            boolean fCondition = prevToken != null && prevToken.getTokenString().equalsIgnoreCase(";");
            boolean sCondition = prevToken != null && prevToken.getTokenType() == 5;
            boolean tCondition = nextToken != null && (nextToken.getTokenType() == 2 || nextToken.getTokenType() == 5);
            boolean bl = condition = fCondition || sCondition || tCondition;
            if (condition || this.mIndex + 1 == argumentList.size() - 1) {
                this.mIndex += this.insertAndIndent(argumentList, this.mIndex, this.mIndent);
                this.mIndex += this.insertAndIndent(argumentList, this.mIndex + 1, this.mIndent);
            }
        }
    }

    private void checkCloseBracket(List<IGaussAbstractToken> argumentList, Stack<Integer> bracketIndent, IGaussAbstractToken token) {
        if (")".equals(token.getTokenString())) {
            if (!bracketIndent.isEmpty()) {
                this.mIndent = bracketIndent.pop();
            }
            this.mIndex += this.insertAndIndent(argumentList, this.mIndex, this.mIndent);
            if (!this.fnBracket.isEmpty()) {
                this.fnBracket.pop();
            }
            this.isGroupBy = false;
        }
    }

    private void sqlFormatToken(List<IGaussAbstractToken> argumentList) {
        IGaussAbstractToken hashToken;
        IGaussAbstractToken token = this.getElementFromList(argumentList, this.mIndex);
        if ("select".equalsIgnoreCase(token.getTokenString()) || "update".equalsIgnoreCase(token.getTokenString())) {
            this.mIndent += 2;
            this.mIndex += this.insertAndIndent(argumentList, this.mIndex + 1, this.mIndent);
        }
        if (token.getTokenString().equalsIgnoreCase("begin")) {
            this.mIndex += this.insertAndIndent(argumentList, this.mIndex + 1, this.mIndent);
        }
        if ("delete".equalsIgnoreCase(token.getTokenString())) {
            this.mIndent += 2;
            this.isDelete = true;
        }
        this.sqlFormatTokenClientFormat1(token, argumentList);
        if ("on".equalsIgnoreCase(token.getTokenString())) {
            this.mIndex += this.insertAndIndent(argumentList, this.mIndex, this.mIndent + 1);
        }
        if ("values".equalsIgnoreCase(token.getTokenString())) {
            this.mIndex += this.insertAndIndent(argumentList, this.mIndex, this.mIndent);
        } else {
            this.handleSpoolNewLine(argumentList, token);
        }
        IGaussAbstractToken iGaussAbstractToken = hashToken = this.mIndex - 2 >= 0 ? this.getElementFromList(argumentList, this.mIndex - 2) : null;
        if (hashToken != null) {
            if (!hashToken.getTokenString().equalsIgnoreCase("###") && "end".equalsIgnoreCase(token.getTokenString())) {
                --this.mIndent;
                this.mIndent = this.mIndent < this.beginCount ? this.beginCount : this.mIndent;
                this.mIndex += this.insertAndIndent(argumentList, this.mIndex, this.mIndent);
            }
        } else if ("end".equalsIgnoreCase(token.getTokenString())) {
            --this.mIndent;
            this.mIndent = this.mIndent < this.beginCount ? this.beginCount : this.mIndent;
            this.mIndex += this.insertAndIndent(argumentList, this.mIndex, this.mIndent);
        }
        if (token.getTokenString().equalsIgnoreCase("CLOSE")) {
            this.mIndex += this.insertAndIndent(argumentList, this.mIndex, this.mIndent);
        }
        if (token.getTokenString().equalsIgnoreCase("WHEN")) {
            this.mIndex += this.insertAndIndent(argumentList, this.mIndex, this.mIndent + 1);
        }
        this.sqlFormatTokenClientFormat2(token, argumentList);
    }

    private void sqlFormatTokenClientFormat1(IGaussAbstractToken token, List<IGaussAbstractToken> argumentList) {
        if (this.checkPrimaryKeywords(token)) {
            if (this.mIndex >= 2 && !"drop".equalsIgnoreCase(this.getElementFromList(argumentList, this.mIndex - 2).getTokenString())) {
                ++this.mIndent;
                this.mIndex += this.insertAndIndent(argumentList, this.mIndex + 1, this.mIndent);
            } else if (this.mIndex < 2) {
                ++this.mIndent;
                this.mIndex += this.insertAndIndent(argumentList, this.mIndex + 1, this.mIndent);
            }
        }
        if (this.checkSecondaryKeywords(token)) {
            this.mIndex += this.insertAndIndent(argumentList, this.mIndex, this.mIndent - 1);
            if (this.isSetDefine(argumentList)) {
                this.mIndex += this.insertAndIndent(argumentList, this.mIndex + 1, this.mIndent);
            }
            this.isGroupBy = "group by".equalsIgnoreCase(token.getTokenString());
        }
        if ("from".equalsIgnoreCase(token.getTokenString()) && this.mIndex >= 2 && !"delete".equalsIgnoreCase(this.getElementFromList(argumentList, this.mIndex - 2).getTokenString())) {
            this.mIndex += this.insertAndIndent(argumentList, this.mIndex, this.mIndent - 1);
            this.mIndex += this.insertAndIndent(argumentList, this.mIndex + 1, this.mIndent);
        }
    }

    private void sqlFormatTokenClientFormat2(IGaussAbstractToken token, List<IGaussAbstractToken> argumentList) {
        IGaussAbstractToken preToken;
        if ("or".equalsIgnoreCase(token.getTokenString()) || "else".equalsIgnoreCase(token.getTokenString())) {
            this.mIndex += this.insertAndIndent(argumentList, this.mIndex, this.mIndent);
        }
        if ("case".equalsIgnoreCase(token.getTokenString())) {
            IGaussAbstractToken iGaussAbstractToken = preToken = this.mIndex - 1 > 0 ? argumentList.get(this.mIndex - 1) : null;
            if (preToken != null && !preToken.getTokenString().equalsIgnoreCase(",")) {
                this.mIndex += this.insertAndIndent(argumentList, this.mIndex, this.mIndent);
                this.mIndex += this.insertAndIndent(argumentList, this.mIndex + 1, this.mIndent);
            }
        }
        if ("WHEN".equalsIgnoreCase(token.getTokenString())) {
            IGaussAbstractToken iGaussAbstractToken = preToken = this.mIndex - 2 > 0 ? argumentList.get(this.mIndex - 2) : null;
            if (preToken != null && preToken.getTokenString().equalsIgnoreCase("CASE")) {
                this.mIndex += this.insertAndIndent(argumentList, this.mIndex, this.mIndent + 1);
            }
        }
        if ("using".equalsIgnoreCase(token.getTokenString())) {
            this.mIndex = this.isDelete ? (this.mIndex += this.insertAndIndent(argumentList, this.mIndex, this.mIndent - 1)) : (this.mIndex += this.insertAndIndent(argumentList, this.mIndex, this.mIndent + 1));
        }
        if ("between".equalsIgnoreCase(token.getTokenString())) {
            this.mHasBetween = true;
        }
        if ("union".equalsIgnoreCase(token.getTokenString()) || "intersect".equalsIgnoreCase(token.getTokenString()) || "except".equalsIgnoreCase(token.getTokenString())) {
            this.mIndent -= 2;
            this.mIndex += this.insertAndIndent(argumentList, this.mIndex, this.mIndent);
            this.mIndex += this.insertAndIndent(argumentList, this.mIndex + 1, this.mIndent);
        }
        if ("and".equalsIgnoreCase(token.getTokenString())) {
            if (!this.mHasBetween) {
                this.mIndex += this.insertAndIndent(argumentList, this.mIndex, this.mIndent);
            }
            this.mHasBetween = false;
        }
    }

    private boolean checkPrimaryKeywords(IGaussAbstractToken token) {
        return "INSERT".equalsIgnoreCase(token.getTokenString()) || "INTO".equalsIgnoreCase(token.getTokenString()) || "CREATE".equalsIgnoreCase(token.getTokenString()) || "truncate".equalsIgnoreCase(token.getTokenString()) || "table".equalsIgnoreCase(token.getTokenString()) || "case".equalsIgnoreCase(token.getTokenString());
    }

    private boolean checkSecondaryKeywords(IGaussAbstractToken token) {
        return "where".equalsIgnoreCase(token.getTokenString()) || "INSERT".equalsIgnoreCase(token.getTokenString()) || "SET".equalsIgnoreCase(token.getTokenString()) || "order by".equalsIgnoreCase(token.getTokenString()) || "group by".equalsIgnoreCase(token.getTokenString()) || "having".equalsIgnoreCase(token.getTokenString());
    }

    private void doChangeArgLstForBracket(List<IGaussAbstractToken> argumentList) {
        for (int index = argumentList.size() - 1; index >= 4; --index) {
            if (index >= argumentList.size()) continue;
            IGaussAbstractToken t0 = argumentList.get(index);
            IGaussAbstractToken t1 = argumentList.get(index - 1);
            IGaussAbstractToken t2 = argumentList.get(index - 2);
            IGaussAbstractToken t3 = argumentList.get(index - 3);
            IGaussAbstractToken t4 = argumentList.get(index - 4);
            if (!"(".equals(t4.getTokenString()) || !t3.getTokenString().trim().isEmpty() || !t1.getTokenString().trim().isEmpty() || !")".equals(t0.getTokenString())) continue;
            t4.setTokenString(t4.getTokenString() + t2.getTokenString() + t0.getTokenString());
            argumentList.remove(index);
            argumentList.remove(index - 1);
            argumentList.remove(index - 2);
            argumentList.remove(index - 3);
        }
    }

    private void doChangeArgLstForComma(List<IGaussAbstractToken> argumentList) {
        IGaussAbstractToken prevOne = null;
        for (int index = 1; index < argumentList.size(); ++index) {
            IGaussAbstractToken prev = argumentList.get(index - 1);
            IGaussAbstractToken token = argumentList.get(index);
            this.handlePathWithSlashI(argumentList, token, index);
            this.handleSpaceWithinShift(argumentList, token, index);
            if (prev.getTokenString().endsWith(">>")) {
                argumentList.add(index, new GaussSQLToken(0, IGaussDBConstants.NEW_LINE));
            }
            prevOne = this.doGetAbstractToken(argumentList, token, prev, prevOne, index);
        }
    }

    private void handleSpaceWithinShift(List<IGaussAbstractToken> argumentList, IGaussAbstractToken token, int index) {
        if (token.getTokenString().equals("<<") && index + 1 < argumentList.size() && index + 2 < argumentList.size()) {
            IGaussAbstractToken nextTok = argumentList.get(index + 1);
            IGaussAbstractToken futTok = argumentList.get(index + 2);
            StringBuffer sb = new StringBuffer();
            if (nextTok.getTokenString().matches("\\w+") && futTok.getTokenString().equals(">>")) {
                sb.append(token.getTokenString()).append(nextTok.getTokenString()).append(futTok.getTokenString());
                argumentList.remove(index + 1);
                argumentList.remove(index + 1);
                argumentList.set(index, new GaussSQLToken(3, sb.toString()));
            }
        }
    }

    private void handlePathWithSlashI(List<IGaussAbstractToken> argumentList, IGaussAbstractToken token, int index) {
        if (token.getTokenString().equals("\\i")) {
            StringBuffer sb = new StringBuffer();
            IGaussAbstractToken itrToken = argumentList.get(index + 1);
            while (!itrToken.getTokenString().endsWith("sql")) {
                sb.append(itrToken.getTokenString());
                argumentList.remove(index + 1);
                itrToken = argumentList.get(index + 1);
            }
            sb.append(itrToken.getTokenString());
            argumentList.set(index + 1, new GaussSQLToken(3, sb.toString()));
        }
    }

    private IGaussAbstractToken doGetAbstractToken(List<IGaussAbstractToken> argumentList, IGaussAbstractToken token, IGaussAbstractToken prev, IGaussAbstractToken previousOneQry, int index) {
        IGaussAbstractToken prevOne = previousOneQry;
        if (prev.getTokenType() != 0 && token.getTokenType() != 0) {
            if (prev.getTokenString().equals(",")) {
                return prevOne;
            }
            if (this.sqlRuleSet.isFunction(prev.getTokenString()) && token.getTokenString().equals("(")) {
                return prevOne;
            }
            if (this.handleDot(token, prev, prevOne)) {
                return prevOne;
            }
            if ((token.getTokenString().equals(".") || token.getTokenString().startsWith(".")) && prev.getTokenString().endsWith("\"")) {
                return prevOne;
            }
            if (this.handleEqualityClause(token, prev)) {
                return prevOne;
            }
            if (token.getTokenString().equals("*") && prev.getTokenString().equals("\\")) {
                return prevOne;
            }
            if (token.getTokenString().equals("\\") && prev.getTokenString().equals("*")) {
                return prevOne;
            }
            if (token.getTokenString().startsWith(".") && prev.getTokenString().endsWith(")")) {
                return prevOne;
            }
            if (token.getTokenString().equalsIgnoreCase("echo") && prev.getTokenString().equals("\\")) {
                return prevOne;
            }
            prevOne = this.doChangeArgLstCommandSelect(argumentList, token, prev, prevOne, index);
        }
        return prevOne;
    }

    private boolean handleDot(IGaussAbstractToken token, IGaussAbstractToken prev, IGaussAbstractToken prevOne) {
        return (prev.getTokenString().equals(".") || prev.getTokenString().endsWith(".")) && token.getTokenString().startsWith("\"");
    }

    private boolean handleEqualityClause(IGaussAbstractToken token, IGaussAbstractToken prev) {
        return token.getTokenString().equals("=") && (prev.getTokenString().equals(":") || prev.getTokenString().equals(">") || prev.getTokenString().equals("<")) || prev.getTokenString().equals("=") && token.getTokenString().equals(">");
    }

    private IGaussAbstractToken doChangeArgLstCommandSelect(List<IGaussAbstractToken> argumentList, IGaussAbstractToken token, IGaussAbstractToken prev, IGaussAbstractToken previousOneQry, int index) {
        IGaussAbstractToken futr;
        IGaussAbstractToken prevOne = previousOneQry;
        if (token.getTokenString().equals("<") ? (futr = this.getElementFromList(argumentList, index + 2)).getTokenString().equals(">") : (prev.getTokenString().equals("<") ? (futr = this.getElementFromList(argumentList, index + 1)).getTokenString().equals(">") : token.getTokenString().equals(">") && (prevOne = this.getElementFromList(argumentList, index - 2)).getTokenString().equals("<"))) {
            return prevOne;
        }
        if (!(prev.getTokenString().contains("'") && token.getTokenString().contains("'") || prev.getTokenString().endsWith(".") && token.getTokenString().equals("*") || prev.getTokenString().equals(":"))) {
            boolean tCondition;
            boolean fCondition = !prev.getTokenString().equals("+") || !token.getTokenString().matches("\\d+");
            boolean sCondition = !token.getTokenString().equals("'\t'") || !prev.getTokenString().equalsIgnoreCase("E");
            boolean bl = tCondition = !token.getTokenString().startsWith("'") || !prev.getTokenString().equalsIgnoreCase("E");
            if (fCondition && sCondition && tCondition) {
                this.addElementToList(argumentList, index);
            }
        }
        return prevOne;
    }

    private void addElementToList(List<IGaussAbstractToken> argumentList, int index) {
        if (index >= 0 && index <= argumentList.size()) {
            argumentList.add(index, new GaussSQLToken(0, " "));
        }
    }

    private void doChangeArgLstForKeyword(List<IGaussAbstractToken> argumentList) {
        for (int index = 0; index < argumentList.size() - 2; ++index) {
            IGaussAbstractToken t0 = argumentList.get(index);
            IGaussAbstractToken t1 = argumentList.get(index + 1);
            IGaussAbstractToken t2 = argumentList.get(index + 2);
            if (t0.getTokenType() == 2 && t1.getTokenType() == 0 && t2.getTokenType() == 2 && ("order".equalsIgnoreCase(t0.getTokenString()) || "group".equalsIgnoreCase(t0.getTokenString())) && "by".equalsIgnoreCase(t2.getTokenString())) {
                t0.setTokenString(t0.getTokenString() + " " + t2.getTokenString());
                argumentList.remove(index + 1);
                argumentList.remove(index + 1);
            }
            if (!"(".equals(t0.getTokenString()) || !"+".equals(t1.getTokenString()) || !")".equals(t2.getTokenString())) continue;
            t0.setTokenString("(+)");
            argumentList.remove(index + 1);
            argumentList.remove(index + 1);
        }
    }

    private void doChangeArgLstForSpace(List<IGaussAbstractToken> argumentList) {
        GaussSQLToken sqlToken;
        int index;
        for (int index2 = argumentList.size() - 1; index2 >= 1; --index2) {
            IGaussAbstractToken token = argumentList.get(index2);
            IGaussAbstractToken prevToken = argumentList.get(index2 - 1);
            if (token.getTokenType() == 0 && (prevToken.getTokenType() == 1 || prevToken.getTokenType() == 5)) {
                if (prevToken.getTokenString().equals("+") && token.getTokenType() == 0) continue;
                argumentList.remove(index2);
                continue;
            }
            if ((token.getTokenType() == 1 || token.getTokenType() == 5) && prevToken.getTokenType() == 0) {
                argumentList.remove(index2 - 1);
                continue;
            }
            if (token.getTokenType() != 0) continue;
            token.setTokenString(" ");
        }
        if (argumentList.size() > 2 && (index = argumentList.indexOf(sqlToken = new GaussSQLToken(3, "SQL_LANG"))) != -1) {
            argumentList.add(index + 1, new GaussSQLToken(0, IGaussDBConstants.NEW_LINE));
        }
        if (argumentList.size() > 1) {
            IGaussAbstractToken firstToken = argumentList.get(0);
            IGaussAbstractToken secondToken = argumentList.get(1);
            if ("/".equals(firstToken.getTokenString()) && (secondToken.getTokenType() == 2 || "ANALYZE".equals(secondToken.getTokenString()) || secondToken.getTokenString().startsWith("$"))) {
                argumentList.add(1, new GaussSQLToken(0, IGaussDBConstants.NEW_LINE));
            }
        }
    }

    private int insertAndIndent(List<IGaussAbstractToken> argumentList, int argIndex, int argIndent) {
        boolean isFunction = false;
        if (!this.fnBracket.isEmpty() && argIndex < argumentList.size() - 1) {
            IGaussAbstractToken nextToken = argumentList.get(argIndex + 1);
            if ("case".equalsIgnoreCase(nextToken.getTokenString())) {
                isFunction = this.fnBracket.pop();
                this.fnBracket.push(isFunction);
            } else {
                isFunction = this.fnBracket.contains(Boolean.TRUE) ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        if (isFunction) {
            return 0;
        }
        try {
            IGaussAbstractToken token;
            StringBuffer strBuffer = new StringBuffer(IGaussDBConstants.NEW_LINE);
            for (int index = 0; index < argIndent; ++index) {
                strBuffer.append(this.sqlRuleSet.indentString);
            }
            IGaussAbstractToken iGaussAbstractToken = token = argIndex < argumentList.size() ? argumentList.get(argIndex) : null;
            if (token == null) {
                return 0;
            }
            if (token.getTokenType() == 0) {
                token.setTokenString(strBuffer.toString());
                return 0;
            }
            IGaussAbstractToken iGaussAbstractToken2 = token = argIndex > 0 ? this.getElementFromList(argumentList, argIndex - 1) : null;
            if (token == null) {
                return 0;
            }
            if (token.getTokenType() == 0) {
                token.setTokenString(strBuffer.toString());
                return 0;
            }
            this.addItemToList(argumentList, argIndex, strBuffer);
            return 1;
        }
        catch (IndexOutOfBoundsException e) {
            logger.error(ErrorLoggerUtility.getExceptionDetails(e) + " Error occurred while Formatting. " + e.getMessage());
            return 0;
        }
    }

    private void addItemToList(List<IGaussAbstractToken> argumentList, int argIndex, StringBuffer strBuf) {
        if (argIndex >= 0 && argIndex <= argumentList.size()) {
            argumentList.add(argIndex, new GaussSQLToken(0, strBuf.toString()));
        }
    }

    private List<IGaussAbstractToken> formatPLSQL(List<IGaussAbstractToken> argumentList) {
        this.updArgList(argumentList);
        this.doChangeArgLstForSpace(argumentList);
        this.doChangeArgLstForKeyword(argumentList);
        this.mIndent = 0;
        this.isGroupBy = false;
        this.mHasBetween = false;
        this.mIndex = 0;
        while (this.mIndex < argumentList.size()) {
            IGaussAbstractToken token = argumentList.get(this.mIndex);
            if (token.getTokenType() == 1) {
                this.formatPLSQLSymbol(argumentList);
            } else if (token.getTokenType() == 2) {
                this.formatPLSQLKeyword(argumentList);
            } else if (token.getTokenType() == 5) {
                if (token.getTokenString().startsWith("/*") || token.getTokenString().startsWith("--")) {
                    this.mIndex += this.insertAndIndent(argumentList, this.mIndex + 1, this.mIndent);
                }
            } else if (token.getTokenString().equalsIgnoreCase("###")) {
                ++this.hashCount;
                if (this.hashCount % 2 != 0) {
                    IGaussAbstractToken hasToken;
                    IGaussAbstractToken iGaussAbstractToken = hasToken = this.mIndex - 1 >= 0 ? argumentList.get(this.mIndex - 1) : null;
                    if (hasToken != null) {
                        hasToken.setTokenString(System.lineSeparator());
                    }
                }
            }
            if (this.mIndent < 0) {
                this.mIndent = 0;
            }
            ++this.mIndex;
        }
        this.doChangeArgLstForBracket(argumentList);
        this.doChangeArgLstForComma(argumentList);
        this.doPerlMultitagFormat(argumentList);
        return argumentList;
    }

    private void formatPLSQLSymbol(List<IGaussAbstractToken> argumentList) {
        IGaussAbstractToken token = this.getElementFromList(argumentList, this.mIndex);
        this.handleTerminatorChar(argumentList, token);
        if (token.getTokenString().equals("/") && this.mIndex + 1 < argumentList.size() || token.getTokenString().equals("*/") && this.mIndex + 2 < argumentList.size()) {
            this.handleCreateStatements(argumentList);
        } else if (",".equals(token.getTokenString()) && !this.isGroupBy) {
            this.mIndex += this.insertAndIndent(argumentList, this.mIndex, this.mIndent);
        } else if ("(".equals(token.getTokenString())) {
            this.keySpaceInc(argumentList);
            if (!this.keySpaceFlag || this.mIndex > 0 && this.getElementFromList(argumentList, this.mIndex - 1).getTokenType() == 2) {
                this.isGroupBy = true;
            }
        } else if (")".equals(token.getTokenString())) {
            this.isGroupBy = false;
            this.forBracketFlagTrue(argumentList);
        } else if (token.getTokenString().equals("\\") && this.getElementFromList(argumentList, this.mIndex + 1).getTokenString().equalsIgnoreCase("echo")) {
            --this.mIndent;
            this.mIndex += this.insertAndIndent(argumentList, this.mIndex, this.mIndent);
        }
    }

    private void handleCreateStatements(List<IGaussAbstractToken> argumentList) {
        if (argumentList.size() > this.mIndex + 2 && (argumentList.get(this.mIndex + 1).getTokenString().equalsIgnoreCase("CREATE") || argumentList.get(this.mIndex + 1).getTokenString().equalsIgnoreCase("ANALYZE") || argumentList.get(this.mIndex + 1).getTokenString().equalsIgnoreCase("/") && argumentList.get(this.mIndex + 2).getTokenString().equalsIgnoreCase("CREATE"))) {
            this.mIndent = 0;
        }
        if (this.mIndex > 0 && (this.getElementFromList(argumentList, this.mIndex - 1).getTokenString().equals(" ") || this.getElementFromList(argumentList, this.mIndex - 1).getTokenString().contains(IGaussDBConstants.NEW_LINE))) {
            this.mIndex += this.insertAndIndent(argumentList, this.mIndex, this.mIndent);
            this.mIndex += this.insertAndIndent(argumentList, this.mIndex + 1, this.mIndent);
        }
    }

    private void handleTerminatorChar(List<IGaussAbstractToken> argumentList, IGaussAbstractToken token) {
        if (token.getTokenString().equals(";")) {
            this.keySpaceFlag = false;
            this.keySpaceCount = 0;
            if (argumentList.size() > this.mIndex + 1) {
                boolean sCondition;
                String nextToken = argumentList.get(this.mIndex + 1).getTokenString();
                boolean fCondition = nextToken.equalsIgnoreCase("IF") || nextToken.equalsIgnoreCase("LOOP");
                boolean bl = sCondition = argumentList.get(this.mIndex + 1).getTokenType() == 5 || argumentList.get(this.mIndex - 1).getTokenString().equalsIgnoreCase("END") || argumentList.get(this.mIndex + 1).getTokenType() == 3;
                if (fCondition || sCondition) {
                    boolean hasBteqVar;
                    if (nextToken.startsWith(".")) {
                        --this.mIndent;
                    }
                    if (!(hasBteqVar = this.hasBteqCommand(argumentList, 3))) {
                        this.mIndex += this.insertAndIndent(argumentList, this.mIndex + 1, this.mIndent);
                    }
                } else {
                    --this.mIndent;
                    this.mIndent = this.mIndent < this.beginCount ? this.beginCount : this.mIndent;
                    this.mIndex += this.insertAndIndent(argumentList, this.mIndex + 1, this.mIndent);
                }
                if (this.getElementFromList(argumentList, this.mIndex + 1).getTokenType() == 2 || this.getElementFromList(argumentList, this.mIndex + 1).getTokenType() == 5 && argumentList.size() > this.mIndex + 2 && argumentList.get(this.mIndex + 2).getTokenType() == 2) {
                    StringBuffer strBuff = new StringBuffer(IGaussDBConstants.NEW_LINE);
                    this.mIndent = this.beginCount;
                    for (int index = 0; index < this.mIndent; ++index) {
                        strBuff.append(this.sqlRuleSet.indentString);
                    }
                    argumentList.add(this.mIndex + 1, new GaussSQLToken(0, strBuff.toString()));
                }
            }
            if (this.mIndex >= 2 && this.getElementFromList(argumentList, this.mIndex - 2).getTokenString().equals(IGaussDBConstants.NEW_LINE)) {
                argumentList.set(this.mIndex - 2, new GaussSQLToken(0, " "));
            }
        }
    }

    public void keySpaceInc(List<IGaussAbstractToken> argumentList) {
        if (this.bracketFlag) {
            if (this.keySpaceCount == 0) {
                ++this.mIndent;
                this.mIndex += this.insertAndIndent(argumentList, this.mIndex + 1, this.mIndent);
            }
            ++this.keySpaceCount;
        }
    }

    public void forBracketFlagTrue(List<IGaussAbstractToken> argumentList) {
        if (this.bracketFlag) {
            --this.keySpaceCount;
            if (this.keySpaceCount == 0) {
                this.bracketFlag = false;
                --this.mIndent;
                this.mIndex += this.insertAndIndent(argumentList, this.mIndex, this.mIndent);
            }
        }
    }

    private void formatPLSQLKeyword(List<IGaussAbstractToken> argumentList) {
        IGaussAbstractToken token = this.getElementFromList(argumentList, this.mIndex);
        token.setTokenString(QueryConversionUtility.toUpper(token.getTokenString()));
        this.formatPLSQLKeywordSchema(argumentList, token);
        this.isGroupBy = "group by".equalsIgnoreCase(token.getTokenString());
        String patternKeywords = "(?i)(FROM|WHERE|SET|GROUP BY|HAVING|RETURNS)";
        patternKeywords = QueryConversionUtility.canonicalizeString(patternKeywords);
        if (token.getTokenString().matches(patternKeywords)) {
            if (this.mIndex >= 2 && !"delete".equalsIgnoreCase(this.getElementFromList(argumentList, this.mIndex - 2).getTokenString())) {
                this.mIndex += this.insertAndIndent(argumentList, this.mIndex, this.mIndent - 1);
                if (this.isSetDefine(argumentList)) {
                    this.mIndex += this.insertAndIndent(argumentList, this.mIndex + 1, this.mIndent);
                }
            } else {
                ++this.mIndent;
                if (this.isSetDefine(argumentList)) {
                    this.mIndex += this.insertAndIndent(argumentList, this.mIndex + 1, this.mIndent);
                }
            }
        }
        if ("values".equalsIgnoreCase(token.getTokenString())) {
            this.keySpaceFlag = true;
            --this.mIndent;
            this.mIndent = this.mIndent < this.beginCount ? this.beginCount : this.mIndent;
            this.mIndex += this.insertAndIndent(argumentList, this.mIndex, this.mIndent);
        } else {
            this.handleSpoolNewLine(argumentList, token);
        }
        if ("INSERT".equalsIgnoreCase(token.getTokenString())) {
            this.keySpaceFlag = true;
            this.bracketFlag = true;
        }
        this.handleKeywordsSetOne(argumentList, token);
        this.handleKeywordsSetTwo(argumentList, token);
    }

    private boolean isSetDefine(List<IGaussAbstractToken> argumentList) {
        return !"SET".equalsIgnoreCase(argumentList.get(this.mIndex).getTokenString()) || this.mIndex + 2 >= argumentList.size() || !"DEFINE".equalsIgnoreCase(argumentList.get(this.mIndex + 2).getTokenString());
    }

    private void handleSpoolNewLine(List<IGaussAbstractToken> argumentList, IGaussAbstractToken token) {
        if ("SPOOL".equalsIgnoreCase(token.getTokenString())) {
            this.mIndex += this.insertAndIndent(argumentList, this.mIndex - 1, this.mIndent);
            if (this.mIndex + 3 < argumentList.size() && 0 == argumentList.get(this.mIndex + 1).getTokenType() && 0 != argumentList.get(this.mIndex + 2).getTokenType() && 0 == argumentList.get(this.mIndex + 3).getTokenType()) {
                this.mIndex += this.insertAndIndent(argumentList, this.mIndex + 3, this.mIndent);
            }
        }
    }

    private void handleKeywordsSetTwo(List<IGaussAbstractToken> argumentList, IGaussAbstractToken token) {
        if (token.getTokenString().equalsIgnoreCase("BETWEEN")) {
            this.mHasBetween = true;
        }
        if (token.getTokenString().equalsIgnoreCase("ELSE") || token.getTokenString().equalsIgnoreCase("ELSIF")) {
            this.mIndex += this.insertAndIndent(argumentList, this.mIndex, this.mIndent);
            if (this.mHasCaseStmt) {
                this.mIndex += this.insertAndIndent(argumentList, this.mIndex + 1, this.mIndent + 1);
            } else {
                ++this.mIndent;
                this.mIndex += this.insertAndIndent(argumentList, this.mIndex + 1, this.mIndent);
            }
        }
        if (token.getTokenString().equalsIgnoreCase("WHEN")) {
            this.mIndex += this.insertAndIndent(argumentList, this.mIndex - 1, this.mIndent + 1);
        }
        if (token.getTokenString().equalsIgnoreCase("AND")) {
            if (!this.mHasBetween && !this.mHasCaseStmt) {
                this.mIndex += this.insertAndIndent(argumentList, this.mIndex, this.mIndent);
            }
            this.mHasBetween = false;
        }
        if (token.getTokenString().equalsIgnoreCase("ORDER BY") && !this.getElementFromList(argumentList, this.mIndex - 1).getTokenString().equalsIgnoreCase("(")) {
            this.mIndex += this.insertAndIndent(argumentList, this.mIndex, this.mIndent - 1);
            this.mIndex += this.insertAndIndent(argumentList, this.mIndex + 1, this.mIndent);
        }
        this.handleExceptionWhen(argumentList, token);
    }

    private void handleExceptionWhen(List<IGaussAbstractToken> argumentList, IGaussAbstractToken token) {
        if (token.getTokenString().equalsIgnoreCase("WHEN") && (!this.getElementFromList(argumentList, this.mIndex - 2).getTokenString().equalsIgnoreCase("CASE") || !this.getElementFromList(argumentList, this.mIndex - 1).getTokenString().equalsIgnoreCase(" ") || this.getElementFromList(argumentList, this.mIndex - 1).getTokenString().equalsIgnoreCase("CASE"))) {
            this.mIndex += this.insertAndIndent(argumentList, this.mIndex, this.mIndent + 1);
        }
        if (token.getTokenString().equalsIgnoreCase("EXCEPTION")) {
            boolean hasRaiseKeyword = false;
            if (this.mIndex > 2) {
                IGaussAbstractToken prev = this.getElementFromList(argumentList, this.mIndex - 2);
                boolean bl = hasRaiseKeyword = prev != null && "RAISE".equalsIgnoreCase(prev.getTokenString());
            }
            if (!hasRaiseKeyword) {
                ++this.mIndent;
                this.mIndex += this.insertAndIndent(argumentList, this.mIndex, this.mIndent);
            }
        }
    }

    private void handleKeywordsSetOne(List<IGaussAbstractToken> argumentList, IGaussAbstractToken token) {
        boolean sCondition;
        IGaussAbstractToken createToken;
        if (token.getTokenString().equalsIgnoreCase("END")) {
            IGaussAbstractToken hashToken;
            this.handleEndKeyword(argumentList);
            IGaussAbstractToken iGaussAbstractToken = hashToken = this.mIndex - 2 > 0 ? this.getElementFromList(argumentList, this.mIndex - 2) : null;
            if (hashToken != null && hashToken.getTokenString().equals("###")) {
                IGaussAbstractToken hasToken1 = this.getElementFromList(argumentList, this.mIndex - 1);
                hasToken1.setTokenString(" ");
                this.mIndex += this.insertAndIndent(argumentList, this.mIndex - 2, this.mIndent);
            } else {
                this.mIndex += this.insertAndIndent(argumentList, this.mIndex, this.mIndent);
            }
            this.mHasCaseStmt = false;
        }
        if ((token.getTokenString().equalsIgnoreCase("OR") || token.getTokenString().equalsIgnoreCase("RETURN")) && !this.mHasCaseStmt && !"CREATE".equalsIgnoreCase((createToken = argumentList.get(this.mIndex - 2)).getTokenString().trim())) {
            this.mIndex += this.insertAndIndent(argumentList, this.mIndex, this.mIndent);
        }
        if (token.getTokenString().equalsIgnoreCase("ON") || token.getTokenString().equalsIgnoreCase("USING")) {
            this.mIndex += this.insertAndIndent(argumentList, this.mIndex, this.mIndent + 1);
        }
        if (token.getTokenString().equalsIgnoreCase("CLOSE")) {
            this.mIndex += this.insertAndIndent(argumentList, this.mIndex, this.mIndent);
        }
        boolean fCondition = token.getTokenString().equalsIgnoreCase("UNION") || token.getTokenString().equalsIgnoreCase("INTERSECT") || token.getTokenString().equalsIgnoreCase("EXCEPT");
        boolean bl = sCondition = token.getTokenString().equalsIgnoreCase("MINUS") || token.getTokenString().equalsIgnoreCase("ALL");
        if (!(!fCondition && !sCondition || token.getTokenString().equalsIgnoreCase("UNION") && this.getElementFromList(argumentList, this.mIndex + 2).getTokenString().equalsIgnoreCase("ALL"))) {
            --this.mIndent;
            this.mIndex += this.insertAndIndent(argumentList, this.mIndex, this.mIndent);
            this.mIndex += this.insertAndIndent(argumentList, this.mIndex + 1, this.mIndent);
        }
    }

    private void handleEndKeyword(List<IGaussAbstractToken> argumentList) {
        if (this.getElementFromList(argumentList, this.mIndex + 1).getTokenString().equalsIgnoreCase(";")) {
            --this.beginCount;
            this.mIndent = this.beginCount <= 0 ? 0 : --this.mIndent;
        } else if (this.mIndex + 2 < argumentList.size() && this.mIndex + 3 < argumentList.size() && !this.getElementFromList(argumentList, this.mIndex + 2).getTokenString().isEmpty() && this.getElementFromList(argumentList, this.mIndex + 3).getTokenString().equalsIgnoreCase(";")) {
            --this.beginCount;
            this.mIndent = this.beginCount <= 0 ? 0 : --this.mIndent;
        }
    }

    private void formatPLSQLKeywordSchema(List<IGaussAbstractToken> argumentList, IGaussAbstractToken token) {
        this.handleSelectUpdateBeginStatements(argumentList, token);
        this.handleConditionalAndLoopStatements(argumentList, token);
        this.handleDropAndTruncateStatements(argumentList, token);
        this.handleCreateStatements(argumentList, token);
        this.handleCaseStatements(argumentList, token);
    }

    private void handleDropAndTruncateStatements(List<IGaussAbstractToken> argumentList, IGaussAbstractToken token) {
        if (token.getTokenString().equalsIgnoreCase("DROP") || token.getTokenString().equalsIgnoreCase("TRUNCATE")) {
            ++this.mIndent;
            if (this.mIndent > 2) {
                --this.mIndent;
            }
            this.mIndex += this.insertAndIndent(argumentList, this.mIndex + 1, this.mIndent);
        }
    }

    private void handleCaseStatements(List<IGaussAbstractToken> argumentList, IGaussAbstractToken token) {
        if (token.getTokenString().equalsIgnoreCase("CASE")) {
            this.mHasCaseStmt = true;
            if (!(this.mIndex < 2 || this.getElementFromList(argumentList, this.mIndex - 1).getTokenString().equals(",") && this.getElementFromList(argumentList, this.mIndex - 2).getTokenString().trim().isEmpty())) {
                this.mIndex += this.insertAndIndent(argumentList, this.mIndex, this.mIndent);
            }
        }
    }

    private void handleCreateStatements(List<IGaussAbstractToken> argumentList, IGaussAbstractToken token) {
        if (token.getTokenString().equalsIgnoreCase("CREATE")) {
            if (!this.getElementFromList(argumentList, this.mIndex + 2).getTokenString().equalsIgnoreCase("TABLE")) {
                ++this.mIndent;
                if (this.mIndent > 2) {
                    --this.mIndent;
                }
                this.mIndex += this.insertAndIndent(argumentList, this.mIndex + 1, this.mIndent);
            }
            if (this.mIndex > 0 && (this.getElementFromList(argumentList, this.mIndex - 1).getTokenString().equals(" ") || this.getElementFromList(argumentList, this.mIndex - 1).getTokenString().contains(IGaussDBConstants.NEW_LINE))) {
                --this.mIndent;
                this.mIndex += this.insertAndIndent(argumentList, this.mIndex - 1, this.mIndent);
            } else {
                this.bracketFlag = true;
            }
            IGaussAbstractToken orToken = argumentList.get(this.mIndex + 2);
            if ("OR".equalsIgnoreCase(orToken.getTokenString())) {
                IGaussAbstractToken nextToken = argumentList.get(this.mIndex + 1);
                nextToken.setTokenString(" ");
            }
        }
    }

    private void handleConditionalAndLoopStatements(List<IGaussAbstractToken> argumentList, IGaussAbstractToken token) {
        boolean hasBteqVar;
        if (!(!token.getTokenString().equalsIgnoreCase("IF") && !token.getTokenString().equalsIgnoreCase("LOOP") || this.getElementFromList(argumentList, this.mIndex + 1).getTokenString().equals(";") || this.getElementFromList(argumentList, this.mIndex + 2).getTokenString().equals(";") || (hasBteqVar = this.hasBteqCommand(argumentList, 2)))) {
            ++this.mIndent;
            this.mIndex += this.insertAndIndent(argumentList, this.mIndex + 1, this.mIndent);
        }
    }

    private void handleSelectUpdateBeginStatements(List<IGaussAbstractToken> argumentList, IGaussAbstractToken token) {
        if (token.getTokenString().equalsIgnoreCase("SELECT") || token.getTokenString().equalsIgnoreCase("UPDATE") || token.getTokenString().equalsIgnoreCase("BEGIN")) {
            if (token.getTokenString().equalsIgnoreCase("SELECT")) {
                if (this.mIndex > 0 && !this.getElementFromList(argumentList, this.mIndex - 1).getTokenString().equals("(")) {
                    this.mIndex += this.insertAndIndent(argumentList, this.mIndex, this.mIndent);
                }
                ++this.mIndent;
                this.mIndex += this.insertAndIndent(argumentList, this.mIndex + 1, this.mIndent);
            }
            ++this.mIndent;
            if (this.mIndent > 4) {
                --this.mIndent;
            }
            if (token.getTokenString().equalsIgnoreCase("BEGIN")) {
                ++this.beginCount;
                this.mIndex += this.insertAndIndent(argumentList, this.mIndex, this.mIndent - 1);
            }
            this.mIndex += this.insertAndIndent(argumentList, this.mIndex + 1, this.mIndent);
        }
    }

    private boolean hasBteqCommand(List<IGaussAbstractToken> argumentList, int index) {
        boolean hasBteqVar = false;
        if (argumentList.size() > this.mIndex + index) {
            IGaussAbstractToken bteqToken = this.getElementFromList(argumentList, this.mIndex + index);
            String tokenString = bteqToken.getTokenString();
            hasBteqVar = tokenString.equalsIgnoreCase("lv_mig_activitycount") || tokenString.equalsIgnoreCase("lv_mig_errorcode");
        }
        return hasBteqVar;
    }

    private IGaussAbstractToken getElementFromList(List<IGaussAbstractToken> argumentList, int index) {
        if (index >= 0 && index < argumentList.size()) {
            return argumentList.get(index);
        }
        throw new MigrationServiceException(MessageLoader.getMessage("DSC_ERR_004_017"));
    }
}

