/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.sqlformatter;

import com.huawei.db.migration.exception.MigrationServiceException;
import com.huawei.db.migration.sqlformatter.GaussSQLFormatter;
import com.huawei.db.migration.sqlformatter.GaussSQLRule;
import com.huawei.db.migration.util.IGaussDBConstants;
import com.huawei.db.migration.util.MessageLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GaussSQLQueryFormatter {
    private static final String[] CONSTANT_FUNCTIONLIST = new String[]{"EMPTY_BLOB", "EMPTY_CLOB", "CONCAT", "INITCAP", "LPAD", "LTRIM", "NCHR", "NLS_INITCAP", "NLS_UPPER", "NLSSORT", "INSERTCHILDXMLAFTER", "REGEXP_REPLACE", "REGEXP_SUBSTR", "REPLACE", "RPAD", "RTRIM", "SOUNDEX", "SUBSTR", "TRANSLATE", "TRIM", "UPPER", "INSTR", "LENGTH", "REGEXP_COUNT", "REGEXP_INSTR", "LNNVL", "NANVL", "NULLIF", "NVL", "INSERTXMLAFTER", "CLUSTER_PROBABILITY", "CLUSTER_SET", "LOWER", "FEATURE_ID", "PATH", "FEATURE_SET", "FEATURE_VALUE", "PREDICTION", "PREDICTION_BOUNDS", "CHAR", "PREDICTION_COST", "ELSE", "PREDICTION_DETAILS", "WIDTH_BUCKET", "PREDICTION_SET", "NLS_CHARSET_ID", "NLS_CHARSET_NAME", "DUMP", "ORA_HASH", "VSIZE", "NLS_LOWER", "SYS_CONNECT_BY_PATH", "SYS_XMLAGG", "CURRENT_DATE", "ON", "CASE", "RAWTOHEX", "NVL2", "DBTIMEZONE", "EXTRACT", "FROM_TZ", "LAST_DAY", "LOCALTIMESTAMP", "MONTHS_BETWEEN", "NEW_TIME", "NEXT_DAY", "NUMTODSINTERVAL", "NUMTOYMINTERVAL", "ORA_DST_AFFECTED", "ORA_DST_CONVERT", "ORA_DST_ERROR", "ROUND", "SESSIONTIMEZONE", "SYS_EXTRACT_UTC", "SYSDATE", "SYSTIMESTAMP", "TO_CHAR", "ABS", "TO_DSINTERVAL", "TO_TIMESTAMP", "TO_YMINTERVAL", "TRUNC", "WHEN", "SYS_DBURIGEN", "TZ_OFFSET", "COLLECT", "DATE", "DECOMPOSE", "OR", "POWERMULTISET", "TO_BINARY_FLOAT", "POWERMULTISET_BY_CARDINALITY", "SET", "SYS_GUID", "SYS_TYPEID", "UID", "USER", "USERENV", "LEAST", "BIN_TO_NUM", "CAST", "CHARTOROWID", "COMPOSE", "CONVERT", "UNISTR", "HEXTORAW", "SIN", "RAWTONHEX", "ROWIDTOCHAR", "ROWIDTONCHAR", "SCN_TO_TIMESTAMP", "OVER", "NOT", "TIMESTAMP_TO_SCN", "TO_BINARY_DOUBLE", "REMAINDER", "XMLQUERY", "TO_BLOB", "TO_CLOB", "TO_DATE", "TO_LOB", "TO_MULTI_BYTE", "TO_NCHAR", "TO_NCLOB", "TO_NUMBER", "TO_SINGLE_BYTE", "AND", "TREAT", "MAX", "THEN", "COUNT", "DECIMAL", "ACOS", "ASIN", "ATAN", "ATAN2", "BITAND", "CEIL", "COS", "COSH", "EXP", "FLOOR", "LN", "MOD", "POWER", "SAMPLE", "SIGN", "SINH", "SQRT", "TAN", "TANH", "DELETEXML", "DEPTH", "EXISTSNODE", "XMLSERIALIZE", "EXTRACTVALUE", "EXPLAIN", "INSERTCHILDXML", "INSERTCHILDXMLBEFORE", "PREDICTION_PROBABILITY", "INSERTXMLBEFORE", "TO_TIMESTAMP_TZ", "SYS_XMLGEN", "UPDATEXML", "XMLAGG", "XMLCAST", "XMLCDATA", "XMLCOLATTVAL", "XMLCOMMENT", "XMLCONCAT", "XMLDIFF", "XMLELEMENT", "XMLEXISTS", "XMLFOREST", "XMLISVALID", "XMLPARSE", "XMLPATCH", "XMLPI", "XMLROOT", "XMLSEQUENCE", "XMLTABLE", "CURRENT_TIMESTAMP", "XMLTRANSFORM", "COALESCE", "NULLIFZERO", "ZEROIFNULL", "VARCHAR", "ISNUMBER", "ROW_NUMBER", "MAXDATE", "MDIFF", "LAG", "DBMS_LOB.COMPARE", "PUBLIC.MIG_CLOB_COMPARE", "PUBLIC.MONTHS_BETWEEN"};
    private static final Logger logger = LogManager.getLogger(GaussSQLQueryFormatter.class);

    public static String format(String sqlQuery, boolean isOutputQuery) {
        String formatedResult = null;
        GaussSQLRule sqlRule = new GaussSQLRule();
        sqlRule.setFunctionNames(CONSTANT_FUNCTIONLIST);
        GaussSQLFormatter formatter = new GaussSQLFormatter(sqlRule);
        try {
            formatedResult = !sqlQuery.isEmpty() ? formatter.formatSQL(sqlQuery, isOutputQuery) : sqlQuery;
        }
        catch (MigrationServiceException objExp) {
            logger.error("[DSC_ERR_004_016] " + MessageLoader.getMessage("DSC_ERR_004_016") + objExp.getMessage());
            formatedResult = new StringBuffer().append("/*Error occurred while formatting! Returning unformatted SQL: */").append(IGaussDBConstants.NEW_LINE).append(sqlQuery).toString();
        }
        return formatedResult;
    }

    public static String format(String sqlQuery) {
        return GaussSQLQueryFormatter.format(sqlQuery, false);
    }
}

