/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.teradata;

import com.huawei.db.migration.exception.MigrationServiceException;
import com.huawei.db.migration.teradata.TeradataMapHelperAlias;
import com.huawei.db.migration.teradata.TeradataUtility;
import com.huawei.db.migration.util.DBPropertyLoader;
import com.huawei.db.migration.util.MessageLoader;
import com.huawei.db.migration.util.QueryConversionUtility;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DBCSystemUtil {
    private static final Pattern PATTERN_WHERE = Pattern.compile("(?i)(\\w+)?\\.?(?<!\\w|\\'|\\)\\s)(databasename)(?!\\w)");
    private static final Pattern PATTERN_COMMENT = Pattern.compile("(?i)(#S#\\d+#E#\\s*)");
    private static final Pattern PATTERN_FROM = Pattern.compile("(?i)(#S#\\d+#E#\\s*)*(?<!\\w)dbc\\s*(#S#\\d+#E#\\s*)*\\.\\s*(#S#\\d+#E#\\s*)*((columns|tables|indices)(?:\\s+(\\w+))?)");
    private static final Pattern PATTERN_SQL = Pattern.compile("(?i)(?<!\\w)select(?!\\w)(.*?)(?<!\\w)from(?!\\w)(.*)");

    public String changeDbcProperty(Map<String, String> replaceValMap, String query) throws MigrationServiceException {
        String outputQry = query;
        String fromClauseWoCmnt = TeradataUtility.getFromTblName(outputQry);
        if (fromClauseWoCmnt != null) {
            Matcher fromMatch = PATTERN_FROM.matcher(fromClauseWoCmnt);
            while (fromMatch.find()) {
                String type = fromMatch.group(5);
                String alias = fromMatch.group(6);
                if ("tables".equalsIgnoreCase(type)) {
                    outputQry = this.changeDbcPropertyNames(outputQry, "(?i)(#S#\\d+#E#\\s*)*(?:(?:dbc\\s*(#S#\\d+#E#\\s*)*\\.\\s*)?(#S#\\d+#E#\\s*)*(?<!\\w)tables\\.?(?:databasename|tablename|tablekind|version|protectiontype|columnname)?)|(?<!\\w|\\.|as\\s|\\'|\\)\\s)(?:tablename|databasename|tablekind|version|protectiontype|columnname)(?!\\w)", "tables", "dbc.tables", alias);
                    continue;
                }
                if ("indices".equalsIgnoreCase(type)) {
                    if (outputQry.matches("(?i).*indextype.*")) {
                        outputQry = outputQry.replaceFirst("(?i)and\\s+indextype\\s+IN\\s+(?:(?:\\(\\s*\\'\\s*Q\\s*\\'\\s*\\,\\s*\\'\\s*P\\s*\\'\\s*\\))|(?:\\(\\s*\\'\\s*P\\s*\\'\\s*\\,\\s*\\'\\s*Q\\s*\\'\\s*\\)))", "");
                        outputQry = this.changeDbcPropertyNames(outputQry, "(?i)(#S#\\d+#E#\\s*)*(?:(?:dbc\\s*(#S#\\d+#E#\\s*)*\\.\\s*)?(#S#\\d+#E#\\s*)*(?<!\\w)indices\\.?(?:databasename|tablename|tablekind|version|protectiontype|columnname)?)|(?<!\\w|\\.|as\\s|\\'|\\)\\s)(?:tablename|databasename|tablekind|version|protectiontype|columnname)(?!\\w)", "indices", "dbc.indices", alias);
                        continue;
                    }
                    throw new MigrationServiceException("[DSC_ERR_003_001] " + MessageLoader.getMessage("DSC_ERR_003_001"));
                }
                if (!"columns".equalsIgnoreCase(type)) continue;
                int whereIdx = QueryConversionUtility.getStartIndex(outputQry, "(?i)(?<!\\w)(where)(?!\\w)", 1);
                if (whereIdx != -1) {
                    TeradataUtility util = new TeradataUtility();
                    String whereQry = outputQry.substring(whereIdx);
                    whereQry = util.changeTblSchemaValToGauss(whereQry, "databasename");
                    whereQry = util.changeTblSchemaValToGauss(whereQry, "tablename");
                    outputQry = outputQry.substring(0, whereIdx) + whereQry;
                }
                outputQry = this.doChangeDBCColNamesInQuery(replaceValMap, outputQry, alias);
            }
        }
        return outputQry;
    }

    private String changeDbcPropertyNames(String queryInp, String pattern, String propertyConstant, String propertyDBCConstant, String aliasInp) throws MigrationServiceException {
        String query = queryInp;
        StringBuffer qryBuf = new StringBuffer(128);
        int tempIdx = 0;
        Pattern dbcPattern = Pattern.compile(pattern);
        Matcher dbcMatch = dbcPattern.matcher(query);
        String alias = aliasInp;
        if ("on".equalsIgnoreCase(alias)) {
            alias = null;
        }
        while (dbcMatch.find()) {
            int startIdx = dbcMatch.start(0);
            int endIdx = dbcMatch.end(0);
            String tabnme = dbcMatch.group(0);
            if (!tabnme.contains(propertyConstant) && !propertyDBCConstant.equalsIgnoreCase(tabnme) && alias == null) {
                tabnme = propertyDBCConstant + "." + tabnme;
            }
            if (tabnme.contains(" ")) {
                tabnme = tabnme.replace(" ", "");
                tabnme = tabnme.replaceAll("(?i)#S#\\d+#E#", "").trim();
            }
            String rplValue1 = DBPropertyLoader.getStringProperty(QueryConversionUtility.toLower(tabnme) + "TableReplace");
            if (alias != null && !propertyDBCConstant.equalsIgnoreCase(tabnme)) {
                rplValue1 = alias + "." + rplValue1;
            }
            qryBuf.append(query.substring(tempIdx, startIdx)).append(rplValue1);
            tempIdx = endIdx;
        }
        qryBuf.append(query.substring(tempIdx));
        query = qryBuf.toString();
        qryBuf.setLength(0);
        query = this.doChangeDBCTableColNamesInQuery(query, alias);
        return query;
    }

    private String doChangeDBCTableColNamesInQuery(String ipQry, String alias) {
        String outputQry = ipQry;
        Matcher sqlMatch = PATTERN_SQL.matcher(outputQry);
        StringBuffer qryBuf = new StringBuffer(128);
        if (sqlMatch.find()) {
            String tablNme = sqlMatch.group(2);
            if (tablNme.contains("dbc.tables")) {
                tablNme = tablNme.replace("dbc.tables", "mig_td_ext.vw_td_dbc_tables");
            } else if (tablNme.contains("dbc.indices")) {
                tablNme = tablNme.replace("dbc.indices", "mig_td_ext.vw_td_dbc_indices");
            } else if (tablNme.contains("databasename")) {
                tablNme = tablNme.replace(alias + "." + "databasename", alias + "." + "schemaname");
            }
            Matcher whereMatch = PATTERN_WHERE.matcher(tablNme);
            while (whereMatch.find()) {
                String colAlias = whereMatch.group(1);
                if (!colAlias.equalsIgnoreCase(alias)) continue;
                tablNme = tablNme.replace(alias + "." + "DatabaseName", alias + "." + "schemaname");
            }
            String columns = sqlMatch.group(1).trim();
            this.doChangeDBCSplitCols(alias, PATTERN_WHERE, PATTERN_COMMENT, qryBuf, tablNme, columns);
            outputQry = qryBuf.toString();
            qryBuf.setLength(0);
        }
        return outputQry;
    }

    private void doChangeDBCSplitCols(String alias, Pattern wherePattern, Pattern comment, StringBuffer qryBuf, String tablNme, String columnsInp) {
        String columns = columnsInp;
        Object[] colsArr = null;
        if (columns.contains(",")) {
            colsArr = columns.split(",");
        } else if (columns.matches("(?i)length\\s*\\(.*\\)")) {
            columns = columns.replace("databasename", "schemaname");
        }
        if (colsArr != null) {
            this.getReplaceValue((String[])colsArr, wherePattern, alias);
            columns = Arrays.toString(colsArr).replace("[", "").replace("]", "").trim();
            Matcher commentMatch = comment.matcher(columns);
            while (commentMatch.find()) {
                columns = columns.replace(commentMatch.group(1), QueryConversionUtility.toUpper(commentMatch.group(1)));
            }
        } else if (columns.contains(alias + ".")) {
            columns = columns.replace("databasename", "schemaname");
        }
        qryBuf.append("select").append(" ").append(columns).append(" ").append("from").append(tablNme);
    }

    private void getReplaceValue(String[] colsArr, Pattern wherePattern, String aliasInp) {
        String alias = aliasInp;
        String rplValue = null;
        for (int iIndex = 0; iIndex < colsArr.length; ++iIndex) {
            String col = colsArr[iIndex].trim();
            col = QueryConversionUtility.toLower(col);
            alias = QueryConversionUtility.toLower(alias);
            Matcher whereMatch = wherePattern.matcher(col);
            while (whereMatch.find()) {
                rplValue = col.contains(alias + ".") && !col.contains("as ") ? col.replace("databasename", "schemaname") : (col.matches("(?i)(?:length|trim|upper|lower|character_length)\\s*\\(.*\\)") ? col.replace("databasename", "schemaname") : col);
                colsArr[iIndex] = rplValue;
            }
            if (colsArr[iIndex].contains("tables.") && !colsArr[iIndex].contains("_tables.")) {
                colsArr[iIndex] = colsArr[iIndex].replace("tables.", "vw_td_dbc_tables.");
            }
            if (colsArr[iIndex].contains("indices.") && !colsArr[iIndex].contains("_indices.")) {
                colsArr[iIndex] = colsArr[iIndex].replace("indices.", "vw_td_dbc_indices.");
            }
            if (colsArr[iIndex].contains("tables.") || colsArr[iIndex].contains("indices.")) {
                colsArr[iIndex] = colsArr[iIndex].replace("dbc.", "mig_td_ext.");
            }
            if (!colsArr[iIndex].contains(alias + "." + "databasename")) continue;
            colsArr[iIndex] = colsArr[iIndex].replace("databasename", "schemaname");
        }
    }

    private String doChangeDBCColNamesInQuery(Map<String, String> replaceValMap, String ipQry, String alias) {
        String outputQry = ipQry;
        Matcher sqlMatch = PATTERN_SQL.matcher(outputQry);
        String columns = null;
        String fromClause = null;
        int colStIdx = 0;
        int colEndIdx = 0;
        int fromStIdx = 0;
        if (sqlMatch.find()) {
            colStIdx = sqlMatch.start(1);
            colEndIdx = sqlMatch.end(1);
            fromStIdx = sqlMatch.start(2);
            columns = sqlMatch.group(1);
            fromClause = sqlMatch.group(2);
        }
        columns = this.processColValuesSeparately(replaceValMap, columns, alias);
        if (fromClause != null) {
            TeradataUtility util = new TeradataUtility();
            fromClause = util.changeTblColNameValues(fromClause, alias);
        }
        outputQry = outputQry.substring(0, colStIdx) + " " + columns + " " + outputQry.substring(colEndIdx, fromStIdx) + " " + fromClause;
        return outputQry;
    }

    private String processColValuesSeparately(Map<String, String> replaceValMap, String columns, String alias) {
        TeradataMapHelperAlias helperAlias = new TeradataMapHelperAlias();
        String modifiedColumns = helperAlias.changeColumns(replaceValMap, columns).trim();
        List<String> colsLst = QueryConversionUtility.getLstFrmStringWithComma(modifiedColumns, false);
        String col = null;
        String colTopDistinct = "";
        for (int iIndex = 0; iIndex < colsLst.size(); ++iIndex) {
            Pattern topPattern;
            Matcher matcher;
            col = colsLst.get(iIndex);
            String string = col = col.startsWith("_COLUMN__") ? QueryConversionUtility.doReplaceFunctionVariables(col, replaceValMap, "_COLUMN__") : col;
            if (iIndex == 0 && col.matches("(?i).*(top|distinct).*") && (matcher = (topPattern = Pattern.compile("(?i)(.*(?<!\\w)top(?!\\w).*?(?:\\d+|:\\w+).*?(?<!\\w)(?:percent\\s+with\\s+ties|with\\s+ties|percent)?|.*(?<!\\w)distinct(?!\\w))\\s*(.*)")).matcher(col)).find()) {
                colTopDistinct = matcher.group(1);
                col = matcher.group(2).trim();
            }
            TeradataUtility util = new TeradataUtility();
            col = util.changeDBCColName(col, alias);
            col = iIndex == 0 ? colTopDistinct + " " + col : col;
            colsLst.set(iIndex, col);
        }
        return QueryConversionUtility.doGetStrFrmListWithComma(colsLst);
    }
}

