/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.teradata;

import com.huawei.db.migration.exception.MigrationServiceException;
import com.huawei.db.migration.util.QueryConversionUtility;

public class FindFormatUtility {
    private static final String COLUMN_DELIMETER = "(,|=";
    private static final String ARTHIMETIC_OPERATOR = "+-/%^*";
    private boolean result = false;
    private int bracketSpaceCount = 1;
    private String returnString = null;
    private StringBuilder sb = null;
    private int even = 0;
    private int spaceCnt = 0;
    private int end = 0;

    public String doFindFormatFunction(String substringInp) throws MigrationServiceException {
        this.result = false;
        this.bracketSpaceCount = 1;
        this.returnString = null;
        this.sb = new StringBuilder();
        this.even = 0;
        this.spaceCnt = 0;
        this.end = 0;
        String substring = substringInp;
        String endCmnt = QueryConversionUtility.doGetEndCmnts(substring);
        substring = substring.replace(endCmnt, "");
        if (!endCmnt.isEmpty()) {
            substring = substring.trim();
            substring = " " + substring;
        }
        boolean isEndsWithBracket = substring.endsWith(")");
        for (int iIndex = substring.length(); iIndex > 0; --iIndex) {
            char character = substring.charAt(iIndex - 1);
            if (!this.result && isEndsWithBracket) {
                this.handleCloseBracket(character);
                continue;
            }
            this.handleCloseOperator(character);
            if (this.bracketSpaceCount == 1) continue;
            int retValue = this.handleChar(character, substring, iIndex);
            if (retValue == -1) break;
            if (retValue == 1 || this.spaceCnt != 2) continue;
            this.sb = this.sb.reverse();
            String fnName = this.sb.toString().trim();
            boolean flag = this.handleSpace(fnName, character, substring, iIndex);
            if (!flag) break;
        }
        this.sb.setLength(0);
        this.handleResult(substring, endCmnt);
        if (this.returnString != null && this.returnString.matches("(?i)\\s*(?<!\\w)DISTINCT(?!\\w).*")) {
            this.returnString = this.returnString.replaceFirst("(?i)(?<!\\w)DISTINCT(?!\\w)", "");
        }
        return this.returnString != null ? this.returnString.trim() : this.returnString;
    }

    private int handleChar(char character, String substring, int iIndex) {
        if (character != ' ' && this.spaceCnt == 0) {
            if (COLUMN_DELIMETER.indexOf(character) != -1) {
                boolean flag = this.handleColumnDelimeter(substring, character, iIndex);
                if (flag) {
                    return -1;
                }
            } else if (Character.isDefined(character)) {
                this.sb.append(character);
                return 1;
            }
        } else {
            boolean flag = this.handleFirstSpace(character);
            if (flag) {
                return 1;
            }
        }
        return 0;
    }

    private boolean handleFirstSpace(char character) {
        if (this.spaceCnt == 0) {
            ++this.spaceCnt;
        } else {
            if (ARTHIMETIC_OPERATOR.indexOf(character) != -1) {
                this.handleArithmeticOperator(character);
                return true;
            }
            this.spaceCnt = 2;
        }
        return false;
    }

    private boolean handleColumnDelimeter(String substring, char character, int iIndex) {
        this.returnString = substring.substring(iIndex);
        if (character == '(' && this.even > 0) {
            --this.even;
        } else if (this.end == 0) {
            return true;
        }
        return false;
    }

    private boolean handleSpace(String fnName, char character, String substring, int iIndex) {
        if (fnName.matches("(?i)#S#\\d+#E#")) {
            this.spaceCnt = 0;
            return true;
        }
        if (QueryConversionUtility.equalCheck(fnName, "end")) {
            this.sb.setLength(0);
            this.sb.append(character);
            this.spaceCnt = 0;
            ++this.end;
            return true;
        }
        if (QueryConversionUtility.equalCheck(fnName, "case")) {
            --this.end;
            if (this.end > 0) {
                this.sb.setLength(0);
                this.sb.append(character);
                this.spaceCnt = 0;
                return true;
            }
            this.returnString = substring.substring(iIndex);
        } else {
            if (this.end > 0) {
                this.sb.setLength(0);
                this.sb.append(character);
                this.spaceCnt = 0;
                return true;
            }
            this.returnString = !QueryConversionUtility.equalCheck(fnName, "select") ? substring.substring(iIndex) : substring.substring(iIndex).replaceFirst("(?i)select ", "");
        }
        return false;
    }

    private void handleResult(String substring, String endCmnt) {
        String subStringTrim;
        int spaceIndex;
        if (this.returnString == null && (spaceIndex = (subStringTrim = substring.trim()).indexOf(32)) != -1) {
            this.returnString = subStringTrim.substring(spaceIndex + 1);
        }
        if (!endCmnt.isEmpty()) {
            this.returnString = this.returnString + " " + endCmnt;
        }
    }

    private void handleArithmeticOperator(char character) {
        String fnName;
        if (character == ')' && QueryConversionUtility.equalCheck(fnName = this.sb.reverse().toString().trim(), "end")) {
            ++this.end;
        }
        this.spaceCnt = 0;
        this.bracketSpaceCount = 1;
        this.sb.append(character);
    }

    private void handleCloseOperator(char character) {
        if (this.bracketSpaceCount == 1 && character != ' ') {
            if (character == ')') {
                this.result = false;
                this.bracketSpaceCount = 1;
                ++this.even;
            } else if (ARTHIMETIC_OPERATOR.indexOf(character) == -1) {
                ++this.bracketSpaceCount;
            }
        }
    }

    private void handleCloseBracket(char character) {
        if (character == ')') {
            ++this.even;
        } else if (character == '(') {
            --this.even;
        }
        if (this.even == 0) {
            this.result = true;
        }
    }
}

