/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.teradata;

import com.huawei.db.migration.database.bo.IBulkSplitPatternsBO;
import com.huawei.db.migration.database.bo.IQueryPatternsBO;
import com.huawei.db.migration.database.bo.IQuerySplitterPatternsBO;
import com.huawei.db.migration.exception.MigrationServiceException;
import com.huawei.db.migration.parser.GenericJSONParser;
import com.huawei.db.migration.services.TeradataMigrationService;
import com.huawei.db.migration.teradata.TeradataBteqHandler;
import com.huawei.db.migration.teradata.TeradataDateFormatUtility;
import com.huawei.db.migration.teradata.TeradataPartitionByComment;
import com.huawei.db.migration.teradata.TeradataQueryKeywordReplacer;
import com.huawei.db.migration.teradata.TeradataQueryMigrationService;
import com.huawei.db.migration.teradata.TeradataSchemaMigrationService;
import com.huawei.db.migration.teradata.TeradataUtility;
import com.huawei.db.migration.util.ColumnSplitter;
import com.huawei.db.migration.util.ErrorLoggerUtility;
import com.huawei.db.migration.util.FeatureLoader;
import com.huawei.db.migration.util.IGaussDBConstants;
import com.huawei.db.migration.util.MessageLoader;
import com.huawei.db.migration.util.ProgressUtil;
import com.huawei.db.migration.util.QueryConversionUtility;
import com.huawei.db.migration.util.QueryUtilityExt;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TeradataBulkHandler {
    private static boolean bulkHandlerFlag = false;
    private static final Logger logger = LogManager.getLogger(TeradataBulkHandler.class);
    private static final Pattern INDEX_PAT = Pattern.compile("(?i)((?<!\\w)INDEX(?!\\w)\\s*(\\(\\s*\\w+\\s*\\)))");
    private static final Pattern COMMENT_ON_TABLE = Pattern.compile("(?i)((?<!\\w)comment\\s+on\\s+table\\s+\\$?\\{?\\s*\\w+\\s*\\}?\\.\\$?\\w+)\\s+(.*?);");
    private static final Pattern CREATE_TABLE_SELECT = Pattern.compile("(\\s*?CREATE\\s+.*?(?<!\\w)TABLE(?!\\w).*?\\(?\\s*?SELECT\\s+)");
    private static final Pattern AS_PAT = Pattern.compile("(?i)(\\'\\s*\\w+\\s*\\w*\\')(\\s*as\\s*)(\\w+)");
    private List<IQueryPatternsBO> queryPatterns = null;
    private List<IQuerySplitterPatternsBO> querySplitterPatterns = null;
    private List<IQueryPatternsBO> schemaPatterns = null;
    private List<IBulkSplitPatternsBO> bulkSplitPatterns = null;
    private String migrationType = null;

    private static void setBulkHandlerFlag(boolean bulkHandlerFlag) {
        TeradataBulkHandler.bulkHandlerFlag = bulkHandlerFlag;
    }

    public static boolean isBulkHandlerFlag() {
        return bulkHandlerFlag;
    }

    public List<String> doBulkProcess(List<String> inputList, String fileName, List<?> bulkPatterns) throws MigrationServiceException, InterruptedException {
        ArrayList<String> outputList = new ArrayList<String>(inputList.size());
        int position = 0;
        try {
            this.validateBTEQ(inputList);
        }
        catch (MigrationServiceException e) {
            logger.error(ErrorLoggerUtility.getExceptionDetails(e) + " " + e.getMessage());
            this.handleRuntimeException(fileName, outputList, position);
            return inputList;
        }
        GenericJSONParser objJSONParser = new GenericJSONParser();
        this.queryPatterns = objJSONParser.getJSONObject("teradata-query");
        this.querySplitterPatterns = objJSONParser.getJSONObject("teradata-query-splitter");
        this.schemaPatterns = objJSONParser.getJSONObject("teradata-schema");
        this.bulkSplitPatterns = bulkPatterns;
        try {
            this.validateBTEQ(inputList);
        }
        catch (MigrationServiceException e) {
            logger.error(ErrorLoggerUtility.getExceptionDetails(e) + " " + e.getMessage());
            this.handleRuntimeException(fileName, outputList, position);
            return inputList;
        }
        return this.getOutputList(inputList, fileName, outputList, position);
    }

    private List<String> getOutputList(List<String> inputList, String fileName, List<String> outputList, int pos) throws InterruptedException {
        String output = null;
        int position = pos;
        for (int i = 0; i < inputList.size(); ++i) {
            String input = QueryConversionUtility.doRemoveExtraSpace(inputList.get(i));
            TeradataBulkHandler.setBulkHandlerFlag(true);
            ++position;
            output = input;
            this.migrationType = "";
            try {
                if (QueryConversionUtility.preQueryValidator(input)) {
                    output = this.doBLogicPreProcess(inputList, fileName, position, i, input);
                    output = TeradataBulkHandler.doBLogicProcess(output);
                }
            }
            catch (RuntimeException e) {
                QueryUtilityExt.handleInterruptedException(fileName, e);
                logger.error(ErrorLoggerUtility.getExceptionDetails(e) + " " + e.getMessage());
                this.handleRuntimeException(fileName, outputList, position);
                output = input;
            }
            output = this.doProcessBindVars(output);
            if (output.matches("(?i).*\\.(?<!\\w)(\\.?IF|GOTO|QUIT|RETURN|LOGOFF|RUN|EXPORT\\s+FILE)(?!\\w).*")) {
                output = this.doTransformBteqCommand(output);
            }
            output = output.replaceAll("(?i)(?<!\\w)(FOR\\s+SESSION)(?!\\w)", "/* $1 */");
            String btPattern = "(?i)(?<!\\w)(BT)(?!\\w)\\s*;";
            output = output.replaceAll(btPattern, "START TRANSACTION;");
            String etPattern = "(?i)(?<!\\w)(ET)(?!\\w)\\s*;";
            output = output.replaceAll(etPattern, "COMMIT;");
            output = this.doTransformDateFunction(output);
            this.reBuildQueryWithNestedDymVars(output, outputList);
            this.addDistKeyQuery(output, outputList);
            ProgressUtil.printProgress();
        }
        return outputList;
    }

    private String doTransformDateFunction(String inputQuery) {
        StringBuffer outputBuffer = new StringBuffer(inputQuery);
        Pattern addmonthPattern = Pattern.compile("(?i)(?<!\\w)ADD_MONTHS(?!\\w)\\(('?\\$?\\{?\\w+\\}?'?)\\s*(?:\\+|-|\\*|/)\\s*\\d+\\s*,\\s*-?\\d+\\s*\\)");
        Matcher addmonthMatcher = addmonthPattern.matcher(outputBuffer.toString());
        int startIdx = 0;
        int endIdx = 0;
        while (addmonthMatcher.find()) {
            startIdx = addmonthMatcher.start(1);
            endIdx = addmonthMatcher.end(1);
            String varName = addmonthMatcher.group(1);
            outputBuffer.replace(startIdx, endIdx, "CAST(" + varName + "AS DATE)");
            addmonthMatcher = addmonthPattern.matcher(outputBuffer.toString());
        }
        Pattern strtokPattern = Pattern.compile("(?i)\\s*(?<!\\w)(strtok|regexp_similar|oreplace|otranslate(?!\\w))\\(");
        Matcher strtokMatcher = strtokPattern.matcher(outputBuffer.toString());
        String funcName = null;
        while (strtokMatcher.find()) {
            startIdx = strtokMatcher.start(1);
            endIdx = strtokMatcher.end(1);
            funcName = strtokMatcher.group(1);
            outputBuffer.replace(startIdx, endIdx, this.getReplaceFuncName(funcName));
            strtokMatcher = strtokPattern.matcher(outputBuffer.toString());
        }
        return outputBuffer.toString();
    }

    private String getReplaceFuncName(String funcName) {
        StringBuffer newFuncName = new StringBuffer(64);
        switch (funcName.toLowerCase(Locale.ROOT)) {
            case "strtok": {
                newFuncName.append("split_part");
                break;
            }
            case "regexp_similar": {
                newFuncName.append("regexp_like");
                break;
            }
            case "oreplace": {
                newFuncName.append("replace");
                break;
            }
            case "otranslate": {
                newFuncName.append("translate");
                break;
            }
            default: {
                newFuncName.append(funcName);
            }
        }
        return newFuncName.toString();
    }

    private void addDistKeyQuery(String inputQuery, List<String> outputList) {
        Pattern columnDefQueryPattern = Pattern.compile("(?i)(A.ColumnName)\\s+AS\\s+(\\\"V_COLS\\w*\\\")");
        Matcher columnDefQueryMatcher = columnDefQueryPattern.matcher(inputQuery);
        if (columnDefQueryMatcher.find()) {
            String newQueryGetDistKey = "SELECT getdistributekey('${V_TDDLDB}'||'.'||'${TARGET_TABLE}') AS \"V_PICol\";";
            outputList.add(newQueryGetDistKey);
        }
    }

    private void reBuildQueryWithNestedDymVars(String outputQuery, List<String> outputList) {
        StringBuffer outputBuffer = new StringBuffer(outputQuery);
        Pattern selectPattern = Pattern.compile("(?i)(?:^|^\\s*(?:#\\w+#\\d+#\\w+#\\s*)+)\\s*(?<!\\w)SELECT(?!\\w)(.*?)(?:(?<!\\w)FROM(?!\\w)|\\s*;)");
        Matcher selectMatcher = selectPattern.matcher(outputQuery);
        ColumnSplitter splitter = new ColumnSplitter();
        if (selectMatcher.find()) {
            int startIdx = selectMatcher.start(1);
            int endIdx = selectMatcher.end(1);
            String targetCols = selectMatcher.group(1);
            List<String> columnList = splitter.doGetAllColumns(targetCols);
            ArrayList<String> varNameList = new ArrayList<String>(64);
            ArrayList<String> varExprList = new ArrayList<String>(64);
            ArrayList<Boolean> varFlagList = new ArrayList<Boolean>(64);
            this.getVarExprMap(varNameList, varExprList, varFlagList, columnList);
            this.markVarExprUseNestedVar(varNameList, varExprList, varFlagList, columnList);
            if (!varNameList.isEmpty()) {
                ArrayList<String> addedQueryList = new ArrayList<String>(64);
                String newColStr = this.restoreOutputList(addedQueryList, varFlagList, columnList);
                outputBuffer.replace(startIdx, endIdx, newColStr);
                outputList.add(outputBuffer.toString());
                for (int i = 0; i < addedQueryList.size(); ++i) {
                    outputList.add((String)addedQueryList.get(i));
                }
            } else {
                outputList.add(outputBuffer.toString());
            }
        } else {
            outputList.add(outputQuery);
        }
    }

    private String restoreOutputList(List<String> addedQueryList, List<Boolean> varFlagList, List<String> colList) {
        String newColStr = null;
        String addedQuery = null;
        for (int i = 0; i < varFlagList.size(); ++i) {
            if (!varFlagList.get(i).booleanValue()) continue;
            addedQuery = "SELECT " + colList.get(i) + ";";
            addedQueryList.add(addedQuery);
            colList.set(i, "");
        }
        Iterator<String> it = colList.iterator();
        while (it.hasNext()) {
            String col = it.next();
            if (!col.equals("")) continue;
            it.remove();
        }
        newColStr = QueryConversionUtility.doGetStrFrmListWithSeparator(colList, ",");
        return " " + newColStr + " ";
    }

    private void getVarExprMap(List<String> varNameList, List<String> varExprList, List<Boolean> varFlagList, List<String> colList) {
        for (int i = 0; i < colList.size(); ++i) {
            String col = colList.get(i);
            Pattern asVarPattern = Pattern.compile("(?i)(.*)\\s+AS\\s+(\"\\w+\")\\s*");
            Matcher asVarMatcher = asVarPattern.matcher(col);
            if (!asVarMatcher.find()) continue;
            String s1 = asVarMatcher.group();
            String varExpr = asVarMatcher.group(1);
            String varName = asVarMatcher.group(2);
            varNameList.add(varName);
            varExprList.add(varExpr);
            varFlagList.add(false);
        }
    }

    private void markVarExprUseNestedVar(List<String> varNameList, List<String> varExprList, List<Boolean> varFlagList, List<String> colList) {
        for (int i = 0; i < varNameList.size(); ++i) {
            String varName = varNameList.get(i);
            varName = varName.substring(1, varName.length() - 1);
            for (int j = i + 1; j < varExprList.size(); ++j) {
                String varExpr = varExprList.get(j);
                if (!varExpr.contains(varName) || varExpr.contains("${" + varName + "}")) continue;
                varFlagList.set(j, true);
                String newVarExpr = varExpr.replaceAll(varName, "'\\$\\{" + varName + "}'");
                varExprList.set(j, newVarExpr);
                String newColStr = newVarExpr + " AS " + varNameList.get(j);
                colList.set(j, newColStr);
            }
        }
        String colStr = null;
        for (int i = 0; i < colList.size(); ++i) {
            colStr = colList.get(i);
            colStr = colStr.replaceAll("'\\s+'(.*?)'\\s+'", "''$1''");
            colStr = colStr.replaceAll("''''\\s+''", "''''''");
            colList.set(i, this.transformAsDateColumn(colStr));
        }
    }

    private String transformAsDateColumn(String colStr) {
        Pattern numOperPattern = Pattern.compile("(?i)(?:(?:'?\\$?\\{?\\w+\\}?'?)|(?:CAST.*\\)))(\\s*(?:-|\\+|\\*|/)\\s*\\d+)(\\s+(?<!\\w)AS(?!\\w)\\s+(?<!\\w)DATE(?!\\w)\\s*\\))");
        Matcher numOperMatcher = numOperPattern.matcher(colStr);
        String numOperStr = null;
        String asDateStr = null;
        int startIdx = 0;
        int endIdx = 0;
        StringBuffer newColBuf = new StringBuffer(colStr);
        if (numOperMatcher.find()) {
            numOperStr = numOperMatcher.group(1);
            asDateStr = numOperMatcher.group(2);
            String strAfterAdjust = asDateStr + numOperStr;
            startIdx = numOperMatcher.start(1);
            endIdx = numOperMatcher.end(2);
            newColBuf.replace(startIdx, endIdx, strAfterAdjust);
        }
        return newColBuf.toString();
    }

    private String doTransformBteqCommand(String dotQuery) {
        StringBuffer slashQueryBuffer = new StringBuffer(256);
        Pattern miDotCmdPrefPattern = Pattern.compile("(?i)\\.\\.(?<!\\w)IF(?!\\w+)\\s+(\\w+)\\s*(<>|!=|=|>|<|>=|<=)\\s*'?(\\w+|\\d+)'?\\s+(THEN)\\s*;?");
        Matcher miDotCmdPrefMatcher = miDotCmdPrefPattern.matcher(dotQuery);
        Pattern miDotForCmdPattern = Pattern.compile("(?i)\\.\\.(?<!\\w)(FOR)(?!\\w)\\s+(.*);");
        Matcher miDotForCmdMatcher = miDotForCmdPattern.matcher(dotQuery);
        Pattern miDotCmdSuffPattern = Pattern.compile("(?i)\\.\\.(?<!\\w)(ELSE|END-IF|ENDIF|END-FOR|DO)\\s*;?");
        Matcher miDotCmdSuffMatcher = miDotCmdSuffPattern.matcher(dotQuery);
        Pattern siDotCmdPattern = Pattern.compile("(?i)(^|(#.*#\\s+)|((@@)?\\$\\{(\\w+)\\}(@@)?\\s+))((?<!\\.)\\.(?<!\\w)(IF)(?!\\w+)\\s+(\\w+)\\s*(<>|!=|=|>|<|>=|<=)\\s*('?(\\w*|\\d*)'?)\\s+(THEN)\\s+(\\.(QUIT|GOTO|EXIT-FOR)\\s*(\\w+|\\d+)?)|(.*?\\.END-IF|ENDIF);?)|(^|(#.*#\\s+))(\\.(?<!\\w)(GOTO|QUIT|RETURN|LABEL)(?!\\w+)\\s*(\\w*|\\d*)\\s*)|(^|(#.*#\\s+))(\\.(?<!\\w)(RUN\\s+FILE|EXTRACT\\s+FILE)(?!\\w+)\\s*=\\s*'?(.*(?!\\s))'?)|(^|(#.*#\\s+))(\\.(?<!\\w)SET(?!\\w+)\\s+(\\w+)\\s+'?(.*(?!\\s))'?\\s*);?");
        Matcher siDotCmdMatcher = siDotCmdPattern.matcher(dotQuery);
        Pattern doubleSetCmdPrefPattern = Pattern.compile("(?i)\\.\\.(?<!\\w)(SET)(?!\\w)\\s*(\\w+)\\s+(.*?;)");
        Matcher doubleSetCmdPrefMatcher = doubleSetCmdPrefPattern.matcher(dotQuery);
        Pattern doubleSetCmdSuffPattern = Pattern.compile("(?i)\\.\\.(?<!\\w)(END)(?!\\w)\\s*;?");
        Matcher doubleSetCmdSuffMatcher = doubleSetCmdSuffPattern.matcher(dotQuery);
        String slashQuery = null;
        if (miDotCmdPrefMatcher.find()) {
            slashQuery = this.doTransformMIPrefCommand(dotQuery);
            slashQueryBuffer.append(slashQuery);
        } else if (miDotForCmdMatcher.find()) {
            slashQuery = this.doTransformForCommand(dotQuery);
            slashQueryBuffer.append(slashQuery);
        } else if (miDotCmdSuffMatcher.find()) {
            slashQuery = this.doTransformMISuffCommand(dotQuery);
            slashQueryBuffer.append(slashQuery);
        } else if (siDotCmdMatcher.find()) {
            slashQuery = this.doTransformSIBteqCommand(dotQuery);
            slashQueryBuffer.append(slashQuery);
        } else if (doubleSetCmdPrefMatcher.find()) {
            slashQuery = this.doTransformDoubleSetCommand(dotQuery);
            slashQueryBuffer.append(slashQuery);
        } else if (doubleSetCmdSuffMatcher.find()) {
            slashQueryBuffer.append(IGaussDBConstants.NEW_LINE);
        } else {
            slashQueryBuffer.append(dotQuery);
        }
        return slashQueryBuffer.toString();
    }

    private String doTransformForCommand(String dotQuery) {
        StringBuffer miSlashPrefBlock = new StringBuffer(256);
        Pattern miForCmdPattern = Pattern.compile("(?i)\\.\\.(?<!\\w)(FOR)(?!\\w)\\s+(.*);");
        Matcher miForCmdMatcher = miForCmdPattern.matcher(dotQuery);
        int startIdx = 0;
        int endIdx = 0;
        if (miForCmdMatcher.find()) {
            startIdx = miForCmdMatcher.start();
            if (startIdx > 0) {
                miSlashPrefBlock.append(dotQuery.substring(0, startIdx));
            }
            miSlashPrefBlock.append("#for ##FORTHEN## " + IGaussDBConstants.NEW_LINE);
            miSlashPrefBlock.append(miForCmdMatcher.group(2));
            miSlashPrefBlock.append(" ##FORTHEN## " + IGaussDBConstants.NEW_LINE);
            endIdx = miForCmdMatcher.end();
        }
        if (endIdx < dotQuery.length()) {
            miSlashPrefBlock.append(dotQuery.substring(endIdx, dotQuery.length()));
        }
        return miSlashPrefBlock.toString();
    }

    private String doTransformDoubleSetCommand(String dotQuery) {
        StringBuffer doubleSetSlashBlock = new StringBuffer(256);
        Pattern doubleSetCmdPrefPattern = Pattern.compile("(?i)\\.\\.(?<!\\w)(SET)(?!\\w)\\s*('?\\w+'?)\\s+(.*?)(\\.\\.(?<!\\w)END(?!\\w)\\s*)?;");
        Matcher doubleSetCmdPrefMatcher = doubleSetCmdPrefPattern.matcher(dotQuery);
        int startIdx = 0;
        int endIdx = 0;
        if (doubleSetCmdPrefMatcher.find()) {
            startIdx = doubleSetCmdPrefMatcher.start();
            endIdx = doubleSetCmdPrefMatcher.end();
            if (startIdx > 0) {
                doubleSetSlashBlock.append(dotQuery.substring(0, startIdx));
            }
            doubleSetSlashBlock.append("SELECT ");
            String setValQuery = doubleSetCmdPrefMatcher.group(3);
            if (!setValQuery.trim().endsWith(";")) {
                setValQuery = setValQuery + ";";
            }
            doubleSetSlashBlock.append("'" + setValQuery + "' ");
            String setVarName = doubleSetCmdPrefMatcher.group(2);
            doubleSetSlashBlock.append("AS \"" + setVarName + "\"");
            doubleSetSlashBlock.append(";");
            String setSuffQuery = doubleSetCmdPrefMatcher.group(4);
            if (setSuffQuery != null && setSuffQuery.equalsIgnoreCase("..END")) {
                doubleSetSlashBlock.append(IGaussDBConstants.NEW_LINE);
            }
        }
        if (endIdx < dotQuery.length()) {
            doubleSetSlashBlock.append(dotQuery.substring(endIdx, dotQuery.length()));
        }
        return doubleSetSlashBlock.toString();
    }

    private String doTransformMIPrefCommand(String dotQuery) {
        StringBuffer miSlashPrefBlock = new StringBuffer(256);
        Pattern miDotCmdPattern = Pattern.compile("(?i)\\.\\.(?<!\\w)IF(?!\\w)\\s+(\\w+)\\s*(=|!=|<>|<=|>=|>|<)\\s*('?(?:\\w+|\\d+)'?)\\s+THEN\\s*;?");
        Matcher miDotCmdMatcher = miDotCmdPattern.matcher(dotQuery);
        int startIdx = 0;
        int endIdx = 0;
        if (miDotCmdMatcher.find()) {
            startIdx = miDotCmdMatcher.start();
            if (startIdx > 0) {
                miSlashPrefBlock.append(dotQuery.substring(0, startIdx));
            }
            miSlashPrefBlock.append("#if ");
            if (miDotCmdMatcher.group(1).equals("ERRORCODE")) {
                miSlashPrefBlock.append("${ERROR} ");
            } else {
                miSlashPrefBlock.append("${").append(miDotCmdMatcher.group(1)).append("} ");
            }
            miSlashPrefBlock.append(this.transformExprCondition(miDotCmdMatcher.group(2)));
            miSlashPrefBlock.append(this.transformExprValue(miDotCmdMatcher.group(2), miDotCmdMatcher.group(3)));
            miSlashPrefBlock.append("##IFTHEN##" + IGaussDBConstants.NEW_LINE);
            endIdx = miDotCmdMatcher.end();
        }
        if (endIdx < dotQuery.length()) {
            miSlashPrefBlock.append(dotQuery.substring(endIdx, dotQuery.length()));
        }
        return miSlashPrefBlock.toString();
    }

    private String doTransformMISuffCommand(String dotQuery) {
        StringBuffer miSlashSuffBlock = new StringBuffer(128);
        Pattern miDotCmdSuffPattern = Pattern.compile("(?i)\\.\\.(?<!\\w)(ELSE|END-IF|ENDIF|END-FOR|DO)\\s*;?");
        Matcher miDotCmdSuffMatcher = miDotCmdSuffPattern.matcher(dotQuery);
        int startIdx = 0;
        if (miDotCmdSuffMatcher.find()) {
            String cmdStr;
            startIdx = miDotCmdSuffMatcher.start();
            if (startIdx > 0) {
                miSlashSuffBlock.append(dotQuery.substring(0, startIdx));
            }
            switch (cmdStr = miDotCmdSuffMatcher.group(1)) {
                case "ELSE": {
                    miSlashSuffBlock.append("#else ##ELSETHEN##" + IGaussDBConstants.NEW_LINE);
                    break;
                }
                case "END-IF": 
                case "ENDIF": {
                    miSlashSuffBlock.append("#endif;" + IGaussDBConstants.NEW_LINE);
                    break;
                }
                case "END-FOR": {
                    miSlashSuffBlock.append("#endfor;" + IGaussDBConstants.NEW_LINE);
                    break;
                }
                case "DO": {
                    miSlashSuffBlock.append("#loop ##LOOPTHEN##" + IGaussDBConstants.NEW_LINE);
                    break;
                }
            }
        }
        int endIdx = miDotCmdSuffMatcher.end();
        miSlashSuffBlock.append(dotQuery.substring(endIdx, dotQuery.length()));
        return miSlashSuffBlock.toString();
    }

    private String doTransformSIBteqCommand(String dotQuery) {
        StringBuffer slashQueryBlock = new StringBuffer(128);
        Pattern dotCmdPattern = Pattern.compile("(?i)(?:^|(?:#.*#\\s+)|(?:(?:@@)?\\$\\{(?:\\w+)\\}(?:@@)?\\s+))(\\.(?<!\\w)(?:IF|GOTO|QUIT|EXIT-FOR|RETURN|LOGOFF|LABEL|SET|RUN\\s+FILE|EXPORT\\s+FILE))\\s*(.*)\\s*;?");
        Matcher dotCmdMatcher = dotCmdPattern.matcher(dotQuery);
        if (dotCmdMatcher.find()) {
            int startIdx = dotCmdMatcher.start(1);
            if (startIdx > 0) {
                String prefStr = dotQuery.substring(0, startIdx);
                boolean isNote = (prefStr = prefStr.replaceAll("@@", "")).matches("#.*#\\s+");
                slashQueryBlock.append(isNote ? prefStr : prefStr + ";" + IGaussDBConstants.NEW_LINE);
            }
            switch (dotCmdMatcher.group(1).toLowerCase()) {
                case ".if": {
                    slashQueryBlock.append(this.doTransformIfCommand(dotQuery));
                    break;
                }
                case ".quit": 
                case ".return": {
                    slashQueryBlock.append("#q ");
                    slashQueryBlock.append(dotCmdMatcher.group(2).replaceAll(";", "") + ";");
                    break;
                }
                case ".goto": {
                    slashQueryBlock.append("#goto ");
                    slashQueryBlock.append(dotCmdMatcher.group(2).replaceAll(";", "") + ";");
                    break;
                }
                case ".run file": {
                    slashQueryBlock.append("#i ");
                    StringBuffer fileNameBuffer = new StringBuffer("");
                    this.doTransformFileVal(dotQuery, fileNameBuffer);
                    slashQueryBlock.append(fileNameBuffer.toString() + ";");
                    break;
                }
                case ".label": {
                    slashQueryBlock.append("#label ");
                    slashQueryBlock.append(dotCmdMatcher.group(2).replaceAll(";", "") + ";");
                    break;
                }
                case ".set": {
                    slashQueryBlock.append("#set ");
                    StringBuffer setBuf = new StringBuffer();
                    this.doTransformSetVal(dotQuery, setBuf);
                    slashQueryBlock.append(setBuf.toString());
                    break;
                }
            }
            slashQueryBlock.append(IGaussDBConstants.NEW_LINE);
        }
        return slashQueryBlock.toString();
    }

    private void doTransformSetVal(String dotQuery, StringBuffer setBuf) {
        Pattern dotCmdPattern = Pattern.compile("(?i)\\.(?<!\\w)(?:SET)(?!\\w)\\s+'?(\\w+)'?\\s+'?(\\$\\{\\w+\\})'?[;]?");
        Matcher dotCmdMatcher = dotCmdPattern.matcher(dotQuery);
        if (dotCmdMatcher.find()) {
            String actVal = dotCmdMatcher.group(1);
            String setVal = dotCmdMatcher.group(2);
            setBuf.append(actVal + " ");
            setBuf.append(setVal + ";");
        }
    }

    private String doTransformIfCommand(String dotQuery) {
        StringBuffer slashQueryBlock = new StringBuffer(128);
        Pattern dotCmdPattern = Pattern.compile("(?i)(?<!\\w)(?:\\.IF)\\s+'?(\\w+)'?\\s*(=|<|>|<>|>=|<=)\\s*('?:?\\w*'?|\\d+)\\s+THEN\\s+(.*)[;]?");
        Matcher dotCmdMatcher = dotCmdPattern.matcher(dotQuery);
        String actionQuery = null;
        boolean isDotCmd = false;
        int endIdx = -1;
        while (dotCmdMatcher.find()) {
            isDotCmd = true;
            endIdx = dotCmdMatcher.end();
            slashQueryBlock.append("#if ");
            if (dotCmdMatcher.group(1).equalsIgnoreCase("ERRORCODE")) {
                slashQueryBlock.append("${ERROR} ");
            } else {
                slashQueryBlock.append("${").append(dotCmdMatcher.group(1)).append("} ");
            }
            slashQueryBlock.append(this.transformExprCondition(dotCmdMatcher.group(2)));
            slashQueryBlock.append(this.transformExprValue(dotCmdMatcher.group(1), dotCmdMatcher.group(3)));
            slashQueryBlock.append("##IFTHEN## ");
            actionQuery = dotCmdMatcher.group(4);
            Pattern actCmdPattern = Pattern.compile("(?i)\\.(?<!\\w)(GOTO|QUIT|EXIT-FOR|LOGOFF|RETURN|RUN\\s+FILE)(?!\\w)\\s*(\\w*)");
            Matcher actCmdMatcher = actCmdPattern.matcher(actionQuery);
            String actionCmd = null;
            String actionVal = null;
            if (actCmdMatcher.find()) {
                actionCmd = actCmdMatcher.group(1).toLowerCase();
                actionVal = actCmdMatcher.group(2);
                switch (actionCmd) {
                    case "goto": {
                        slashQueryBlock.append("#" + actionCmd + " ");
                        slashQueryBlock.append(actionVal + " ");
                        break;
                    }
                    case "quit": 
                    case "return": 
                    case "logoff": {
                        slashQueryBlock.append("#q ");
                        slashQueryBlock.append(actionVal + " ");
                        break;
                    }
                    case "exit-for": {
                        slashQueryBlock.append("#exitfor ");
                        break;
                    }
                    case "run file": {
                        slashQueryBlock.append("#i ");
                        StringBuffer fileNameBuf = new StringBuffer("");
                        endIdx = this.doTransformFileVal(dotQuery, fileNameBuf);
                        slashQueryBlock.append(fileNameBuf.toString() + " ");
                        break;
                    }
                    default: {
                        logger.info("\\if does not support this action \"{}\".", (Object)dotCmdMatcher.group(4));
                        break;
                    }
                }
            } else {
                String actCmdQuery = this.transformActionQuery(actionQuery);
                slashQueryBlock.append(actCmdQuery);
            }
            slashQueryBlock.append("#endif;");
            if (endIdx >= dotQuery.length()) continue;
            slashQueryBlock.append(dotQuery, endIdx, dotQuery.length());
        }
        return isDotCmd ? slashQueryBlock.toString() : dotQuery;
    }

    private String transformActionQuery(String actionCmdQuery) {
        StringBuffer actionCmdBuffer = new StringBuffer(128);
        Pattern actQueryPattern = Pattern.compile("(?i)(.*)\\s+(\\.END-IF|ENDIF;?)");
        Matcher actQueryMatcher = actQueryPattern.matcher(actionCmdQuery);
        if (actQueryMatcher.find()) {
            String actQuery = actQueryMatcher.group(1);
            actionCmdBuffer.append(IGaussDBConstants.NEW_LINE);
            if (!actQuery.trim().endsWith(";")) {
                actionCmdBuffer.append(actQuery + ";");
            }
            actionCmdBuffer.append(IGaussDBConstants.NEW_LINE);
        }
        return actionCmdBuffer.toString();
    }

    private int doTransformFileVal(String dotQuery, StringBuffer fileBuf) {
        Pattern dotCmdPattern = Pattern.compile("(?i)\\.(?<!\\w)(?:RUN\\s+FILE|EXTRACT\\s+FILE)(?!\\w)\\s*=\\s*(.*)[;]?");
        Matcher dotCmdMatcher = dotCmdPattern.matcher(dotQuery);
        int endIdx = 0;
        if (dotCmdMatcher.find()) {
            String fileVal = dotCmdMatcher.group(1);
            if (fileVal.endsWith(";")) {
                fileVal = fileVal.replace(";", "");
            }
            if (fileVal.startsWith("'") && fileVal.endsWith("'")) {
                fileBuf.append(fileVal);
            } else {
                fileBuf.append("'" + fileVal + "'");
            }
            endIdx = dotQuery.length();
        }
        return endIdx;
    }

    private String transformExprCondition(String expr) {
        StringBuffer exprBuf = new StringBuffer(32);
        switch (expr) {
            case "<>": 
            case "!=": {
                exprBuf.append("!= ");
                break;
            }
            case "=": 
            case "==": {
                exprBuf.append("'==' ");
                break;
            }
            default: {
                exprBuf.append("!=");
                logger.info("\\if only supports \"==\" and \"!=\", the current operator is {}}.", (Object)expr);
            }
        }
        return exprBuf.toString();
    }

    private String transformExprValue(String param, String val) {
        StringBuffer valBuf = new StringBuffer(32);
        if (param.equalsIgnoreCase("errorcode")) {
            if (val.equalsIgnoreCase("0")) {
                valBuf.append("'false' ");
            } else {
                valBuf.append("'true' ");
            }
        } else {
            valBuf.append(val).append(" ");
        }
        return valBuf.toString();
    }

    private void reBuildQuoteMap(Map<String, String> quoteMap) {
        Pattern dymVarPattern = Pattern.compile("(?i)(\\$\\{\\w+\\})");
        for (Map.Entry<String, String> m : quoteMap.entrySet()) {
            String quoteVal = m.getValue();
            Matcher dymVarMatcher = dymVarPattern.matcher(quoteVal);
            if (!dymVarMatcher.find()) continue;
            quoteMap.put(m.getKey(), quoteVal.toLowerCase(Locale.ROOT));
        }
    }

    private String doProcessBindVars(String query) {
        try {
            String output = null;
            LinkedHashMap<String, String> quoteMap = new LinkedHashMap<String, String>(10);
            output = this.doTransformAsTargetVar(query);
            output = this.doTransformToDate(output);
            output = QueryConversionUtility.getSingleDoubleQuoteMap(output, quoteMap);
            this.reBuildQuoteMap(quoteMap);
            output = QueryConversionUtility.getRplFromMap(output, quoteMap, "(##QUOTE##\\d+#)");
            output = output.replaceAll("(?i)(?<!\\w)comment\\s+table(?!\\w)", "COMMENT ON TABLE");
            Matcher onPat = COMMENT_ON_TABLE.matcher(output);
            while (onPat.find()) {
                if (onPat.group(2).startsWith("IS")) continue;
                output = output.replaceAll("(?i)((?<!\\w)comment\\s+on\\s+table\\s+\\$?\\{?\\s*\\w+\\s*\\}?\\.\\$?\\w+)\\s+(.*?);", "$1 IS $2;");
            }
            output = output.replaceAll("(?i)(?<!\\w)database\\s+hpbus(?!\\w)\\s*;", "SET SESSION CURRENT_SCHEMA TO HPBUS;");
            output = output.replace("~FRM~SB~PTRN~", "FROM");
            output = output.replace("~DT~SB~PTRN~", "from");
            output = output.replace("~EXT~SB~PTRN~", "EXTRACT");
            output = output.replace("mig_fn_castasint", "mig_td_ext.mig_fn_castasint");
            return output;
        }
        catch (Exception var8) {
            logger.error(ErrorLoggerUtility.getExceptionDetails(var8) + " Error in BTEQ processing. " + var8.getMessage());
            throw new MigrationServiceException("[DSC_ERR_003_002] " + MessageLoader.getMessage("DSC_ERR_003_002"));
        }
    }

    private String doTransformAsTargetVar(String inputQuery) {
        StringBuffer outputBuffer = new StringBuffer(inputQuery);
        Pattern selectPattern = Pattern.compile("(?i)(?:^|^\\s*(?:#\\w+#\\d+#\\w+#\\s*)+)\\s*(?<!\\w)SELECT(?!\\w)(.*?)(?:(?<!\\w)FROM(?!\\w)|\\s*;)");
        Matcher selectMatcher = selectPattern.matcher(inputQuery);
        if (selectMatcher.find()) {
            int startIdx = selectMatcher.start(1);
            int endIdx = selectMatcher.end(1);
            String targetBlock = selectMatcher.group(1);
            Vector<String> castFuncs = new Vector<String>();
            targetBlock = this.maskCastAsFunctions(castFuncs, targetBlock);
            Pattern asVarPattern = Pattern.compile("(?i)\\s+AS\\s+(\\w+)\\s*");
            Matcher asVarMatcher = asVarPattern.matcher(targetBlock);
            targetBlock = asVarMatcher.replaceAll(" AS \"$1\" ");
            targetBlock = this.restoreCastAsFunctions(targetBlock, castFuncs);
            outputBuffer.replace(startIdx, endIdx, targetBlock);
        }
        return outputBuffer.toString();
    }

    private String maskCastAsFunctions(Vector<String> castFuncs, String targetBlock) {
        Pattern castFuncPattern = Pattern.compile("(?i)(CAST\\((?!CAST\\(.*?\\)).+?AS.+?\\))");
        Matcher castFuncMatcher = castFuncPattern.matcher(targetBlock);
        int castNo = 1;
        while (castFuncMatcher.find()) {
            castFuncs.add(castFuncMatcher.group());
            targetBlock = castFuncMatcher.replaceFirst("##CASTAS##" + castNo + "##");
            castFuncMatcher = castFuncPattern.matcher(targetBlock);
            ++castNo;
        }
        return targetBlock;
    }

    private String restoreCastAsFunctions(String targetBlock, Vector<String> castFuncs) {
        if (castFuncs.isEmpty()) {
            return targetBlock;
        }
        String castQuote = null;
        String castFuncStr = null;
        for (int castNo = castFuncs.size(); castNo > 0; --castNo) {
            castQuote = "##CASTAS##" + Integer.toString(castNo) + "##";
            castFuncStr = castFuncs.get(castNo - 1);
            targetBlock = targetBlock.replace(castQuote, castFuncStr);
        }
        return targetBlock;
    }

    private String doTransformToDate(String inputQuery) {
        Pattern minusAbsTimePattern = Pattern.compile("(('?(?:(?:\\$\\{?\\w+\\}?)|(?:\\w+|\\d+))'?))\\s*-\\s*19000000");
        Matcher minusAbsTimeMatcher = minusAbsTimePattern.matcher(inputQuery);
        return minusAbsTimeMatcher.replaceAll("to_date\\($1, 'yyyymmdd'\\)");
    }

    private String doBLogicPreProcess(List<String> inputList, String fileName, int position, int i, String input) {
        TeradataDateFormatUtility dateUtility = new TeradataDateFormatUtility();
        String ipQry = dateUtility.getFrom(input);
        if (QueryConversionUtility.containsCheck(ipQry, "select")) {
            ipQry = TeradataBulkHandler.doAddFromDual(ipQry);
        }
        String inputValidator = TeradataQueryKeywordReplacer.doPreChangesOnInput(ipQry);
        String migType = QueryUtilityExt.findMigrationType(this.bulkSplitPatterns, this.migrationType, inputValidator);
        LinkedHashMap<String, String> multiCommentMap = new LinkedHashMap<String, String>(10);
        String output = TeradataPartitionByComment.doHandleCommentPartition(inputValidator, multiCommentMap, migType);
        output = TeradataQueryKeywordReplacer.doPreBulkChanges(output);
        output = this.doCallMigrationTypeService(migType, output, fileName, this.schemaPatterns, position);
        if ("range".equalsIgnoreCase(FeatureLoader.getStringProperty("tdMigrateRANGE_N"))) {
            output = TeradataBulkHandler.createIndexOnRangePartition(output);
        }
        if ((output = this.getOutputValue(inputList, output, i, inputValidator, multiCommentMap)).matches("(?i).*?CURRENT_DATE\\s*\\-\\s*\\(?\\w+.*") && FeatureLoader.getBooleanProperty("dsqlSupport")) {
            output = TeradataDateFormatUtility.doDateSubtractionForDlsql(output);
        }
        return output;
    }

    private static String createIndexOnRangePartition(String sb) {
        String input = sb;
        if (!input.matches("(?i).*((?<!\\w)CREATE\\s+(UNIQUE)?\\s+INDEX).*")) {
            Matcher indexMatcher = INDEX_PAT.matcher(input);
            String tableName = QueryConversionUtility.getTableName(input);
            if (indexMatcher.find()) {
                String indexString = indexMatcher.group();
                indexString = (input = input.replace(indexString, "")).matches("(?i).*(?<!\\w)partition(?!\\w).*") ? "\nCREATE INDEX ON " + tableName + " " + indexMatcher.group(2) + "LOCAL;" : "\nCREATE INDEX ON " + tableName + " " + indexMatcher.group(2) + ";";
                input = input + indexString;
            }
        }
        return input;
    }

    private static String doAddFromDual(String output) {
        String input = output;
        if (FeatureLoader.getBooleanProperty("dsqlSupport") && FeatureLoader.getBooleanProperty("tdMigrateALIAS") && !input.matches("(?i).*(select.*)from.*(;).*")) {
            input = input.replace(";", " from DUAL;");
        }
        return input;
    }

    private void doProcessBteqCommand(List<String> outputList) {
        try {
            String fullQuery = String.join((CharSequence)" ", outputList);
            outputList.clear();
            TeradataBteqHandler bteqHandler = new TeradataBteqHandler();
            String bteqOutput = bteqHandler.doBteqProcess(fullQuery);
            boolean hasDeclare = bteqOutput.contains("DECLARE ");
            bteqOutput = this.doBTChanges(bteqOutput, hasDeclare);
            outputList.add(bteqOutput);
            String output = String.join((CharSequence)" ", outputList);
            outputList.clear();
            output = output.replaceAll("(?i)(?<!\\w)comment\\s+table(?!\\w)", "COMMENT ON TABLE");
            Matcher onPat = COMMENT_ON_TABLE.matcher(output);
            while (onPat.find()) {
                if (onPat.group(2).startsWith("IS")) continue;
                output = output.replaceAll("(?i)((?<!\\w)comment\\s+on\\s+table\\s+\\$?\\{?\\s*\\w+\\s*\\}?\\.\\$?\\w+)\\s+(.*?);", "$1 IS $2;");
            }
            output = output.replaceAll("(?i)(?<!\\w)database\\s+hpbus(?!\\w)\\s*;", "SET SESSION CURRENT_SCHEMA TO HPBUS;");
            output = output.replace("~FRM~SB~PTRN~", "FROM");
            output = output.replace("~DT~SB~PTRN~", "from");
            output = output.replace("~EXT~SB~PTRN~", "EXTRACT");
            output = output.replace("mig_fn_castasint", "mig_td_ext.mig_fn_castasint");
            outputList.add(output);
        }
        catch (Exception e) {
            logger.error(ErrorLoggerUtility.getExceptionDetails(e) + " Error in BTEQ processing. " + e.getMessage());
            throw new MigrationServiceException("[DSC_ERR_003_002] " + MessageLoader.getMessage("DSC_ERR_003_002"));
        }
    }

    private void validateBTEQ(List<String> outputList) {
        if (!FeatureLoader.getBooleanProperty("terdataUtilities")) {
            for (int i = 0; i < outputList.size(); ++i) {
                String query = outputList.get(i);
                if (!query.matches("(?i).*\\.(?<!\\w)(\\.?IF|GOTO|QUIT|RETURN|LOGOFF|RUN|EXPORT\\s+FILE)(?!\\w).*")) continue;
                throw new MigrationServiceException("Error: Scripts contains BTEQ commands which is not supported by Gauss. Please enable the terdataUtilities parameter to TRUE in features-teradata.properties.");
            }
        }
    }

    private String getOutputValue(List<String> inputList, String outputInp, int iIndex, String inputValidator, Map<String, String> multiCommentMap) {
        String output = outputInp;
        output = TeradataBulkHandler.doCommentCompressWithBrackets(output);
        LinkedHashMap<String, String> commentMap = new LinkedHashMap<String, String>(10);
        output = QueryConversionUtility.getSingleOrDoubleQuoteMap(output, commentMap, "/*", "\\/\\*.*?\\*\\/", "##COMMENT##");
        output = TeradataBulkHandler.doCommentCompressWithoutBrackets(output);
        output = QueryConversionUtility.getRplFromMap(output, commentMap, "(##COMMENT##\\d+#)");
        for (int index = 0; index < inputList.size(); ++index) {
            String indexInput = inputList.get(index);
            indexInput = TeradataQueryKeywordReplacer.doPostBulkChanges(indexInput);
            inputList.set(index, indexInput);
        }
        output = TeradataQueryKeywordReplacer.doPostBulkChanges(output);
        output = this.doRetrieveCustomChanges(output, multiCommentMap);
        output = this.transformOutput(inputList, output, iIndex, inputValidator);
        return output;
    }

    private void handleRuntimeException(String fileName, List<String> outputList, int position) {
        ErrorLoggerUtility.failedQryCnt();
        ErrorLoggerUtility.failedFileCnt(fileName);
        logger.error("[DSC_ERR_004_039] " + MessageLoader.getMessage("DSC_ERR_004_039") + " " + fileName + " " + MessageLoader.getMessage("queryPosInfo") + position);
    }

    private String transformOutput(List<String> inputList, String outputInp, int iIndex, String inputValidator) {
        String output = outputInp;
        if (FeatureLoader.getBooleanProperty("deleteToTruncate") && output.matches("(?i).*?(?<!\\w)delete(?!\\w).*")) {
            TeradataUtility util = new TeradataUtility();
            output = util.doChangeDeleteToTruncate(output);
        }
        if (iIndex < inputList.size()) {
            output = TeradataUtility.doAddTransactionForWithData(output, inputValidator);
        }
        return output;
    }

    private String doRetrieveCustomChanges(String outputInp, Map<String, String> multiCommentMap) {
        String output = outputInp;
        if (multiCommentMap != null && !multiCommentMap.isEmpty()) {
            for (Map.Entry<String, String> entry : multiCommentMap.entrySet()) {
                output = output.replace(entry.getKey(), entry.getValue());
            }
        }
        return output;
    }

    private String doBTChanges(String input, boolean hasDeclare) {
        String output = input;
        if ((output = QueryConversionUtility.canonicalizeString(output)).matches("(?i).*(?<!\\w)(BT)(?!\\w).*")) {
            String pattern = hasDeclare ? "(?i)(?<!\\w)(BT)(?!\\w)\\s*;" : "(?i)(?<!\\w)(BT)(?!\\w)";
            output = output.replaceAll(pattern, hasDeclare ? "BEGIN" : "START TRANSACTION");
        }
        if (output.matches("(?i).*(?<!\\w)(ET)(?!\\w).*")) {
            output = output.replaceAll("(?i)(?<!\\w)(ET)(?!\\w)", hasDeclare ? "end" : "COMMIT");
        }
        return output;
    }

    private String doCallMigrationTypeService(String migrationtype, String inputSql, String fileName, List<IQueryPatternsBO> schemaPatterns, int position) throws MigrationServiceException {
        TeradataSchemaMigrationService objTaskService = null;
        Map<String, String> queryMap = null;
        StringBuffer inputQuery = new StringBuffer(inputSql);
        String input = null;
        String output = inputSql;
        inputQuery.append("~#~").append(position);
        TeradataUtility util = new TeradataUtility();
        switch (migrationtype) {
            case "Query": {
                output = this.handleMigForQry(fileName, this.queryPatterns, this.querySplitterPatterns, inputQuery);
                break;
            }
            case "Schema": {
                output = this.handleMigForSchema(fileName, this.querySplitterPatterns, schemaPatterns, inputQuery);
                break;
            }
            case "Schema with Query": {
                queryMap = new LinkedHashMap<String, String>(10);
                input = QueryConversionUtility.doGetSchemaQueries(inputQuery.toString(), queryMap, 0);
                objTaskService = new TeradataSchemaMigrationService();
                output = objTaskService.handleMigrationTask(input, fileName, schemaPatterns, this.querySplitterPatterns);
                queryMap = QueryConversionUtility.doMigrateSchemaQueries(fileName, this.queryPatterns, this.querySplitterPatterns, queryMap, new TeradataQueryMigrationService());
                output = this.getOutForSchemaQry(queryMap, output, util);
                break;
            }
            case "View with Query": {
                input = inputSql;
                this.addViewToMap(input);
                queryMap = new LinkedHashMap(10);
                input = QueryConversionUtility.doGetSchemaQueries(input, queryMap, 0);
                queryMap = QueryConversionUtility.doMigrateSchemaQueries(fileName, this.queryPatterns, this.querySplitterPatterns, queryMap, new TeradataQueryMigrationService());
                output = this.migShortAndRecursive(queryMap, input, util);
                break;
            }
            default: {
                throw new MigrationServiceException("[DSC_ERR_003_003] " + MessageLoader.getMessage("DSC_ERR_003_003") + IGaussDBConstants.NEW_LINE + fileName + " " + MessageLoader.getMessage("queryPosInfo") + position);
            }
        }
        if (output.contains("~#~")) {
            output = output.split("~#~")[0];
        }
        return output;
    }

    private String getOutForSchemaQry(Map<String, String> queryMap, String output, TeradataUtility util) {
        output = QueryConversionUtility.doReplaceFunctionVariables(output, queryMap, "##QUERY##");
        if (QueryConversionUtility.toLower(output = TeradataBulkHandler.doReplaceStaticValueOfColumn(output)).contains("recursive") && !QueryConversionUtility.toLower(output).contains("temporary")) {
            output = output.replaceFirst("(?i)(?<!\\w)\\s*RECURSIVE\\s*(?!\\w)", "");
            output = this.doReplaceRecursiveView(output);
        }
        output = util.doReplaceShortKeyword(output, "(?i)^CREATE\\s+VIEW(?!\\w).*", "(?i)(?<!\\w)CREATE(?!\\w)", "CREATE OR REPLACE ");
        output = util.doReplaceShortKeyword(output, "(?i)^CREATE\\s+RECURSIVE\\s+VIEW(?!\\w).*", "(?i)(?<!\\w)REPLACE(?!\\w)", "CREATE OR REPLACE ");
        return output;
    }

    private String migShortAndRecursive(Map<String, String> queryMap, String input, TeradataUtility util) {
        String output = this.doRecursive(queryMap, input);
        output = this.rplShortKey(output, util);
        return output;
    }

    private String doRecursive(Map<String, String> queryMap, String input) {
        String output = QueryConversionUtility.doReplaceFunctionVariables(input, queryMap, "##QUERY##");
        if (QueryConversionUtility.toLower(output).contains("recursive")) {
            output = output.replaceFirst("(?i)(?<!\\w)\\s*RECURSIVE\\s*(?!\\w)", "");
            output = this.doReplaceRecursiveView(output);
        }
        return output;
    }

    private String handleMigForSchema(String fileName, List<IQuerySplitterPatternsBO> querySplitterPatterns, List<IQueryPatternsBO> schemaPatterns, StringBuffer inputQuery) {
        TeradataSchemaMigrationService objTaskService = new TeradataSchemaMigrationService();
        String output = objTaskService.handleMigrationTask(inputQuery.toString(), fileName, schemaPatterns, querySplitterPatterns);
        if (QueryConversionUtility.containsCheck(output, " table ")) {
            output = TeradataQueryKeywordReplacer.doPutOrientationColumn(output);
        }
        return output;
    }

    private String handleMigForQry(String fileName, List<IQueryPatternsBO> queryPatterns, List<IQuerySplitterPatternsBO> querySplitterPatterns, StringBuffer inputQuery) {
        TeradataQueryMigrationService objTaskService = new TeradataQueryMigrationService();
        String output = objTaskService.handleMigrationTask(inputQuery.toString(), fileName, queryPatterns, querySplitterPatterns);
        return output;
    }

    public String rplShortKey(String input, TeradataUtility util) {
        String output = input;
        output = util.doReplaceShortKeyword(output, "(?i)^REPLACE\\s+VIEW(?!\\w).*", "(?i)(?<!\\w)REPLACE(?!\\w)", "CREATE OR REPLACE ");
        output = util.doReplaceShortKeyword(output, "(?i)^REPLACE\\s+RECURSIVE\\s+VIEW(?!\\w).*", "(?i)(?<!\\w)REPLACE(?!\\w)", "CREATE OR REPLACE ");
        return output;
    }

    public void addViewToMap(String input) {
        Pattern rplView = Pattern.compile("(?i)(?<!\\w)replace\\s+view\\s+(\\w*\\s*\\.?\\s*\\w+|\\\"?\\$\\{\\w+\\}\\\"?\\.\\w+\\$\\{\\w+\\}).*?from\\s+(\\w*\\s*\\.?\\s*\\w+|\\\"?\\$\\{\\w+\\}\\\"?\\.\\w+\\$\\{\\w+\\})(?:\\s+where(.*?))?;");
        Matcher rplViewMatch = rplView.matcher(input);
        if (rplViewMatch.find()) {
            String viewName = rplViewMatch.group(1);
            TeradataMigrationService.addCreateTypeMap(viewName, "VIEW");
            if (rplViewMatch.group(2) != null && !rplViewMatch.group(2).isEmpty()) {
                TeradataMigrationService.addCreateTypeMap(viewName + "__TABLE__DSQL__", rplViewMatch.group(2));
            }
            if (rplViewMatch.group(3) != null && !rplViewMatch.group(3).isEmpty()) {
                TeradataMigrationService.addCreateTypeMap(viewName + "_WHERE", rplViewMatch.group(3).trim());
            }
        }
    }

    private String doReplaceRecursiveView(String input) {
        String finalString = null;
        String resultString = input;
        String output = input;
        StringBuffer result = new StringBuffer(128);
        Pattern pattern = Pattern.compile("(?i)(?<!\\w)\\s*view((.*?)?\\s+(\\$?\\s*\\{?\\w+\\s*\\}?\\s*\\.\\s*\\$?\\s*\\{?\\w+\\}?(?:\\s*\\$\\s*\\{.*?\\})?|\\$?\\s*\\{?\".*?\"\\s*\\}?\\s*\\.\\s*\\$?\\s*\\{?\".*?\"\\}?(?:\\s*\\$\\s*\\{.*?\\})?|\\$?\\s*\\{?\".*?\"\\s*\\}?\\s*\\.\\s*\\$?\\s*\\{?\\w+\\}?(?:\\s*\\$\\s*\\{.*?\\})?|\\$?\\s*\\{?\\w+\\s*\\}?\\s*\\.\\s*\\$?\\s*\\{?\".*?\"\\}?(?:\\s*\\$\\s*\\{.*?\\})?|\\$?\\s*\\{?\".*?\"\\}?(?:\\s*\\$\\s*\\{.*?\\})?|\\$?\\s*\\{?\\w+\\}?(?:\\s*\\$\\s*\\{.*?\\})?).*?)\\s*as\\s*((?:\\(|\\/)\\s*)");
        Matcher matcher = pattern.matcher(output);
        if (matcher.find()) {
            finalString = output.replace(matcher.group(1), " " + matcher.group(3));
            int index = finalString.indexOf(40);
            if (index == -1) {
                return input;
            }
            StringBuffer withRecursive = new StringBuffer(128);
            withRecursive.append(" ").append("with").append(" ").append("recursive").append(" ").append(matcher.group(1)).append(" ").append("AS").append(" ").append("(");
            result.append(finalString);
            result.insert(index + 1, " " + withRecursive);
            resultString = result.toString();
            result = new StringBuffer(128);
            result.append(" ").append("select").append(" ").append("*").append(" ").append("from").append(" ").append(matcher.group(3)).append(" ").append(")").append(";");
            if (resultString.contains(";")) {
                resultString = resultString.replace(";", result.toString());
            }
        }
        return resultString;
    }

    private static String doCommentCompressWithoutBrackets(String inputSql) {
        String input = inputSql;
        Pattern compressPattern = Pattern.compile("(?i)(?<compress>(?<!\\\\w)COMPRESS(?!\\\\w)\\\\s*((\\\\((\\\\w+)?\\\\s*('.*?',?\\\\s*)*\\\\))|(\\\\((\\\\d+.\\\\d*\\\\s*,?\\\\s*)*\\\\))|('(.*?)')|(\\\\d+.\\\\d*)))\\\\s*");
        Matcher compressMatcher = compressPattern.matcher(input);
        StringBuffer sb = new StringBuffer(128);
        return compressMatcher.replaceAll("");
    }

    private static String doCommentCompressWithBrackets(String inputSql) {
        String input = inputSql;
        LinkedHashMap<String, String> quoteMap = new LinkedHashMap<String, String>(10);
        input = QueryConversionUtility.getSingleQuoteMap(input, quoteMap);
        input = input.replaceAll("(?<!\\w)COMPRESS(?!\\w)", "&&COMPRESS_FUNC&&");
        int indexTranslate = 0;
        int tempIdx = 0;
        StringBuffer sb = new StringBuffer();
        Pattern compressPattern = Pattern.compile("(?i)(?<compress>(?<!\\w)&&COMPRESS_FUNC&&(?!\\w)\\s*((\\(.*?\\))))\\s*");
        while (QueryConversionUtility.getIndex(input, "&&COMPRESS_FUNC&&", indexTranslate) != -1) {
            Matcher compressMatcher;
            indexTranslate = QueryConversionUtility.getIndex(input, "&&COMPRESS_FUNC&&", indexTranslate);
            sb.append(input.substring(tempIdx, indexTranslate));
            tempIdx = indexTranslate;
            String cols = "";
            if (indexTranslate != -1 && (cols = QueryUtilityExt.doGetStringFromGivenIndex(indexTranslate, input)).matches("(?i)&&COMPRESS_FUNC&&\\s*\\(.*") && (compressMatcher = compressPattern.matcher(cols)).find()) {
                cols = cols.replace(cols, "/* " + cols + " */");
                sb.append(" " + cols + " ");
                tempIdx = tempIdx + cols.length() - 6;
            }
            indexTranslate += 16;
        }
        sb.append(input.substring(tempIdx));
        input = sb.toString();
        input = QueryConversionUtility.getRplFromMap(input, quoteMap, "(##QUOTE##\\d+#)");
        input = input.replaceAll("&&COMPRESS_FUNC&&", "COMPRESS");
        return input;
    }

    private static String doBLogicProcess(String input) {
        String output = input;
        if (QueryConversionUtility.containsCheck(input, "FUNCTION") && QueryConversionUtility.containsCheck(input, "REPLACE")) {
            Pattern pattern = Pattern.compile("(?i)(?:#S#\\d+#E#\\s*)*(?<!\\w)REPLACE\\s+FUNCTION(?!\\w)(.*?)(?<!\\w)RETURNS(?!\\w)(.*?)(?<!\\w)RETURN(?!\\w)(.*?);(?:#S#\\d+#E#\\s*)*");
            Matcher matcher = pattern.matcher(input);
            StringBuffer sb = new StringBuffer(128);
            int endIndex = 0;
            while (matcher.find()) {
                int startIndex = matcher.start(1);
                String replaceFunc = input.substring(endIndex, startIndex).replace("REPLACE", "CREATE OR REPLACE");
                sb.append(replaceFunc);
                sb.append(matcher.group(1)).append(" RETURNS ");
                String returnsVal = matcher.group(2);
                returnsVal = QueryConversionUtility.replaceAll(returnsVal, "(?i)(?<!\\w)CONTAINS\\s*SQL(?!\\w)", "/* CONTAINS SQL */");
                returnsVal = QueryConversionUtility.replaceAll(returnsVal, "(?i)(?<!\\w)DETERMINISTIC(?!\\w)", "IMMUTABLE");
                returnsVal = QueryConversionUtility.replaceAll(returnsVal, "(?i)(?<!\\w)SQL\\s+SECURITY\\s+DEFINER(?!\\w)", "SECURITY DEFINER");
                returnsVal = QueryConversionUtility.replaceAll(returnsVal, "(?i)(?<!\\w)COLLATION\\s+INVOKER(?!\\w)", "/* COLLATION INVOKER */");
                returnsVal = QueryConversionUtility.replaceAll(returnsVal, "(?i)(?<!\\w)INLINE\\s+TYPE\\s+\\d+(?!\\w)", "/* INLINE TYPE 1 */");
                sb.append(returnsVal).append("AS").append(" $$ ").append("select").append(matcher.group(3)).append(" $$").append(";");
                endIndex = matcher.end();
            }
            sb.append(input.substring(endIndex));
            output = sb.toString();
        }
        return output;
    }

    private static String doReplaceStaticValueOfColumn(String input) {
        String output = input;
        Matcher ctMatcher = CREATE_TABLE_SELECT.matcher(input);
        StringBuffer sb = new StringBuffer(128);
        int tempEnd = 0;
        if (ctMatcher.find()) {
            Matcher matcher = AS_PAT.matcher(input);
            while (matcher.find()) {
                if ("date".equalsIgnoreCase(matcher.group(3))) continue;
                int startindex = matcher.start();
                int endIndex = matcher.end();
                sb.append(output.substring(tempEnd, startindex));
                sb.append("CAST(" + matcher.group(1) + " AS TEXT)" + " " + matcher.group(2) + " " + matcher.group(3));
                tempEnd = endIndex;
            }
        }
        sb.append(output.substring(tempEnd));
        output = sb.toString();
        return output;
    }
}

