/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.teradata;

import com.huawei.db.migration.exception.MigrationServiceException;
import com.huawei.db.migration.teradata.FindFormatUtility;
import com.huawei.db.migration.teradata.TeradataMapHelperAlias;
import com.huawei.db.migration.util.ErrorLoggerUtility;
import com.huawei.db.migration.util.FeatureLoader;
import com.huawei.db.migration.util.MessageLoader;
import com.huawei.db.migration.util.QueryConversionUtility;
import com.huawei.db.migration.util.QueryUtilityExt;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TeradataDateFormatUtility {
    private static final Pattern PATTERN_CAST_AS_INT = Pattern.compile("(?i)(?:\\s*#s#\\d+#e#\\s*)*\\((.*)(\\s*as\\s*(integer|int|decimal))");
    private static final Pattern PATTERN_Z_ALL = Pattern.compile("(?i)^\\'?Z+(Z|(?:\\s*\\(\\s*)\\d+(?:\\s*\\)\\s*))\\'?\\s*\\)?$");
    private static final Pattern PATTERN_9_ALL = Pattern.compile("(?i)^\\'?9+(9|(?:\\s*\\(\\s*)\\d+(?:\\s*\\)\\s*))\\'?\\s*\\)?$");
    private static final Pattern PATTERN_Z_WITH_9 = Pattern.compile("(?i)(Z+)(\\(\\d+\\))?(9+)(\\(\\d+\\))?.?((9+)(\\(\\d+\\))?)?");
    private static final Pattern PATTERN_DATE_FORMAT = Pattern.compile("(?i)(\\|\\||concat\\s*\\(|substr\\s*\\(|rpad\\s*\\(|lpad\\s*\\()\\s*cast\\s*\\(");
    private static final Pattern PATTERN_DATE_INNER = Pattern.compile("(?i).*as\\s+date\\s+(format\\s*)('\\w+(?:-|/)?\\w+(?:-|/)?\\w+'\\s*\\))\\s*$");
    private static final Pattern DATE_FORMAT = Pattern.compile("(?i)AS\\s+(#S#\\d+#E#\\s*)*DATE\\s*((#S#\\d+#E#\\s*)*)FORMAT", 2);
    private static final Pattern CURRENT_DATE_PAT = Pattern.compile("(?i).*?CURRENT_DATE\\s*\\-\\s*(DATE\\s*('\\s*\\d.*')).*");
    private static final Pattern CAST_CASE_PAT = Pattern.compile("(?i)(?<!cast\\()case");
    private static final Pattern COMMON_PAT = Pattern.compile("(?i)\\(\\s*(\\w+\\s*\\w*)\\s*(?:\\(\\s*\\w+\\s*\\,?\\s*\\w*\\s*\\))?\\s*\\)");
    private static final Pattern MIG_FN_CASTASINT = Pattern.compile("(?i)mig_fn_castasint\\s*\\(\\s*(CURRENT_DATE\\s*\\-).*?;");
    private static final Pattern DATE_SUB_PATTERN = Pattern.compile("(?i)(CAST)?\\s*(#S#\\d+#E#\\s*)*\\(?\\s*(#S#\\d+#E#\\s*)*((\\w+\\s*\\([\\w\\,\\s]+\\)|\\'\\d+?\\'|\\'?#*\\w+\\.?\\w*#*\\d*#*\\'?|\\$?\\'\\$?\\{?\\w+\\}?\\')\\s*(#S#\\d+#E#\\s*)*(AS\\s*DATE\\))?(#S#\\d+#E#\\s*)*\\s*-\\s*(#S#\\d+#E#\\s*)*(CAST)?\\s*(#S#\\d+#E#\\s*)*\\(?\\s*(#S#\\d+#E#\\s*)*(case(?:.*?)end|\\w+\\s*\\([\\w\\,\\s]+\\)|MAX\\s*\\(.*?\\)|\\'\\d.*?\\'|\\'?#*\\w+(?:\\(.*?\\)\\s*\\))?\\.?\\w*#*\\d*#*\\'?|\\$?\\'\\$?\\{?\\w+\\}?\\')\\s*(#S#\\d+#E#\\s*)*(AS\\s*DATE\\))?)(#S#\\d+#E#\\s*)*\\s*");
    private static final Logger logger = LogManager.getLogger(TeradataDateFormatUtility.class);
    private static final String STR_9 = "9";
    private final String schemeType;
    private String asInt;

    public TeradataDateFormatUtility() {
        this("query");
    }

    public TeradataDateFormatUtility(String schemeType) {
        this.schemeType = schemeType;
    }

    public String getFrom(String query) {
        Pattern fromPttrn = Pattern.compile("(?i)(?<!\\w)extract(?!\\w)\\s*(?:#S#\\d+#E#\\s*)*\\(.*?(?<!\\w)(from)(?!\\w)\\s*(?<!\\w|as\\s)(date)(?!\\w|\\s+format)(.*?)\\)");
        Matcher fromMtchr = fromPttrn.matcher(query);
        StringBuffer sb = new StringBuffer(128);
        int startIndex = 0;
        while (fromMtchr.find()) {
            int beginIndex = fromMtchr.start(1);
            int endIndex = fromMtchr.end(1);
            sb.append(query.substring(startIndex, beginIndex));
            sb.append("~DT~SB~PTRN~");
            startIndex = endIndex;
        }
        sb.append(query.substring(startIndex));
        return sb.toString();
    }

    private String getZFormatString(String neededString, String quoteStringInp, String function, String strToReplaceInFunctionInp) throws MigrationServiceException {
        String quoteString = quoteStringInp;
        String strToReplaceInFunction = strToReplaceInFunctionInp;
        Matcher colMatcher = PATTERN_CAST_AS_INT.matcher(neededString);
        boolean hasCast = colMatcher.find();
        String columnName = hasCast ? colMatcher.group(1) : neededString;
        StringBuffer formatQuotedStr = new StringBuffer(128);
        Matcher zStringMatcher = PATTERN_Z_ALL.matcher(quoteString = quoteString.replace("')", "").replace("'", "").trim());
        if (!zStringMatcher.find()) {
            return this.migStrWithZAndNo(quoteString, columnName, formatQuotedStr);
        }
        this.migStrWithZ(quoteString, formatQuotedStr, zStringMatcher);
        StringBuffer buffer = new StringBuffer(128);
        if ("LPAD".equalsIgnoreCase(strToReplaceInFunction)) {
            buffer.append(strToReplaceInFunction).append("(").append(neededString).append(",");
        } else {
            buffer.append(strToReplaceInFunction);
        }
        buffer.append(formatQuotedStr.toString()).append(",").append("'").append(" ").append("'").append(")");
        if ("LPAD".equalsIgnoreCase(strToReplaceInFunction)) {
            return buffer.toString();
        }
        strToReplaceInFunction = buffer.toString();
        return "LPAD(" + neededString.replace(function, strToReplaceInFunction);
    }

    private String migStrWithZAndNo(String quoteString, String columnName, StringBuffer formatQuotedStr) {
        Matcher zStringMatcher = PATTERN_Z_WITH_9.matcher(quoteString);
        if (zStringMatcher.find()) {
            String zStringAll = zStringMatcher.group(1);
            String zStringBracket = zStringMatcher.group(2);
            String zNineAll = zStringMatcher.group(3);
            String zNineBracket = zStringMatcher.group(4);
            String zNineDecAll = zStringMatcher.group(6);
            String zNineDecBracket = zStringMatcher.group(7);
            int zCount = this.getCharCount(zStringAll, zStringBracket);
            int nineCount = this.getCharCount(zNineAll, zNineBracket);
            int nineDecCount = this.getCharCount(zNineDecAll, zNineDecBracket);
            formatQuotedStr.append("TO_CHAR(").append(columnName).append(",").append("'");
            formatQuotedStr.append(this.getRepeatString(zCount, STR_9)).append(this.getRepeatString(nineCount, "0"));
            if (nineDecCount > 0) {
                formatQuotedStr.append(".").append(this.getRepeatString(nineDecCount, "0"));
            }
            formatQuotedStr.append("'").append(")");
            return formatQuotedStr.toString();
        }
        throw new MigrationServiceException("[DSC_ERR_003_004] " + MessageLoader.getMessage("DSC_ERR_003_004"));
    }

    private void migStrWithZ(String quoteString, StringBuffer formatQuotedStr, Matcher zStringMatcher) {
        String zString = null;
        zString = zStringMatcher.group(1);
        if ("Z".equalsIgnoreCase(zString)) {
            formatQuotedStr.append(quoteString.length());
        } else {
            zString = zString.substring(zString.indexOf(40) + 1, zString.indexOf(41));
            formatQuotedStr.append(zString);
        }
    }

    private int getCharCount(String allString, String bracketStringInp) {
        int count = 0;
        String bracketString = bracketStringInp;
        if (bracketString != null && !bracketString.isEmpty()) {
            bracketString = bracketString.trim().replace("(", "").replace(")", "");
            try {
                count = Integer.parseInt(bracketString);
            }
            catch (NumberFormatException e) {
                logger.error(ErrorLoggerUtility.getExceptionDetails(e) + " Error while converting from string to int for value= " + bracketString);
                throw new MigrationServiceException("[DSC_ERR_004_018] " + MessageLoader.getMessage("DSC_ERR_004_018"));
            }
        } else if (allString != null) {
            count = allString.trim().length();
        }
        return count;
    }

    private String doReplaceCastAsInt(String inputQuery) throws MigrationServiceException {
        String outputQuery = inputQuery;
        LinkedHashMap<String, String> quoteMap = new LinkedHashMap<String, String>(10);
        outputQuery = QueryConversionUtility.getSingleQuoteMap(outputQuery, quoteMap, "~~QUOTETEMP~~");
        Pattern pattern = Pattern.compile("(?i)((?<!\\w)(?:cast(?:\\s{0,}\\(\\s{0,}cast)?)(?!\\w)\\s*((?:#S#\\d+#E#\\s*)*)\\()\\s*(((?!cast).)*)((?<!\\w)as(?!\\w)\\s*((?:#S#\\d+#E#\\s*)*)(?<!\\w)(?:int|integer)(?!\\w)\\s*(?:#S#\\d+#E#\\s*)*)((?<!\\w)format(?!\\w)\\s*(?:#S#\\d+#E#\\s*)*\\'?(.*?)\\'?)?\\s*(?:#S#\\d+#E#\\s*)*\\)", 2);
        Matcher matcher = pattern.matcher(outputQuery);
        StringBuffer sb = new StringBuffer(128);
        int startIndex = 0;
        int endIndex = 0;
        while (matcher.find()) {
            int beginIndex = matcher.start();
            int index = matcher.start(4);
            List<Integer> list = QueryUtilityExt.findIndex(index, outputQuery, "cast");
            if (list.size() > 1) {
                beginIndex = list.get(1);
                outputQuery = this.doInfoLog(outputQuery, quoteMap, beginIndex);
            }
            endIndex = matcher.end();
            String preString = outputQuery.substring(startIndex, beginIndex);
            sb.append(preString);
            String substring = this.getSubstring(outputQuery, endIndex, beginIndex);
            String castStr = matcher.group(1);
            String columnName = matcher.group(3);
            this.asInt = matcher.group(5);
            columnName = this.getColName(outputQuery, matcher, list, columnName);
            int bracketCount = QueryConversionUtility.doChkBracketCnt(substring);
            if (bracketCount != 0 && castStr.trim().matches("(?i)cast\\s*\\(\\s*cast\\s*\\(")) {
                String castPat = "(?i)cast\\s*\\(";
                castStr = castStr.replaceFirst(castPat, "");
                substring = substring.replaceFirst(castPat, "");
                sb.append("CAST (");
            }
            String comment1 = matcher.group(2);
            int openBracketCnt = QueryConversionUtility.doChkBracketCnt(castStr);
            if (openBracketCnt > 1) {
                castStr = castStr.substring(castStr.indexOf("(") + 1).trim();
            }
            String asIntConverted = this.getCastIntString(sb, substring, QueryConversionUtility.santizePattern(castStr), comment1, columnName);
            startIndex = this.getUpdBuff(matcher, sb, endIndex, asIntConverted);
        }
        sb.append(outputQuery.substring(endIndex));
        outputQuery = this.getOutQry(quoteMap, sb);
        return outputQuery;
    }

    private String getColName(String outputQuery, Matcher matcher, List<Integer> list, String col) {
        String columnName = col;
        if (list.size() > 0) {
            columnName = outputQuery.substring(list.get(0), matcher.end(3));
        }
        return columnName;
    }

    private int getUpdBuff(Matcher matcher, StringBuffer sb, int endIndex, String asIntConverted) {
        sb.append(asIntConverted.trim());
        String comment2 = matcher.group(6);
        if (comment2 != null && !comment2.isEmpty()) {
            sb.append(comment2);
        }
        int startIndex = endIndex;
        return startIndex;
    }

    private String getOutQry(Map<String, String> quoteMap, StringBuffer sb) {
        String outputQuery = sb.toString();
        outputQuery = QueryConversionUtility.getRplFromMap(outputQuery, quoteMap, "(~~QUOTETEMP~~\\d+#)");
        return outputQuery;
    }

    private String getSubstring(String outputQuery, int endIndex, int beginIndex) {
        String substring = " " + outputQuery.substring(beginIndex, endIndex);
        if (outputQuery.matches("(?i).*(?<!\\w)create(?!\\w)\\s+(?<!\\w)table(?!\\w).*")) {
            substring = substring.replaceFirst("(?i)FORMAT\\s*~~QUOTETEMP~~\\d+#", "");
        }
        return substring;
    }

    private String doInfoLog(String outputQuery, Map<String, String> quoteMap, int beginIndex) {
        if (beginIndex == -1) {
            if (logger.isInfoEnabled()) {
                logger.info("Unable to CAST AS INT while processing the inputQuery the inputQuery formatting or query might be mismatched ");
            }
            outputQuery = QueryConversionUtility.getRplFromMap(outputQuery, quoteMap, "(~~QUOTETEMP~~\\d+#)");
            return outputQuery;
        }
        return outputQuery;
    }

    private String getCastIntString(StringBuffer sb, String substring, String castStr, String comment1, String columnName) {
        int lastIndex;
        String asIntConverted = substring.replaceFirst(castStr, "mig_fn_castasint(").replace(this.asInt, "").replace(columnName, columnName + ")");
        if (asIntConverted.trim().endsWith(")") && (lastIndex = asIntConverted.lastIndexOf(41)) != -1) {
            asIntConverted = asIntConverted.substring(0, lastIndex);
        }
        if (comment1 != null && !comment1.isEmpty()) {
            sb.append(comment1);
        }
        return asIntConverted;
    }

    public String changeDateFormatFns(String inputQry) throws MigrationServiceException {
        String inputSql = inputQry;
        if (inputSql.matches("(?i).*?(?<!\\w)(CAST|FORMAT|INT|DECIMAL|DATE|TIME|VARCHAR|CHAR)(?!\\w).*") && !Pattern.matches("(?i).*CREATE\\s*(\\w+\\s+)?TABLE.*?(?<!\\w)DECIMAL(?!\\w).*", inputSql)) {
            LinkedHashMap<String, String> dollarMap = new LinkedHashMap<String, String>(10);
            inputSql = QueryConversionUtility.getDollarMap(inputSql, dollarMap);
            inputSql = this.doReplaceDateFormats(inputSql);
            String dollarPattern = "(##DOLLAR##\\d+#)";
            inputSql = QueryConversionUtility.getRplFromMap(inputSql, dollarMap, dollarPattern);
        }
        return inputSql;
    }

    private String doReplaceDateFormats(String inputSql) throws MigrationServiceException {
        Matcher matcher;
        String inputQuery = inputSql;
        Matcher matcherFormat = DATE_FORMAT.matcher(inputQuery);
        inputQuery = this.getInputQry(inputQuery, matcherFormat);
        String qryPtrn = "(?i)(\\s*(?:\\(?|\\,)\\s*(?:#S#\\d+#E#\\s*)*(?<!as\\s|time\\s|timestamp\\s|timestamp\\(\\d\\)\\s)format\\s*(?:#S#\\d+#E#\\s*)*\\'(.*?)\\'\\s*(?:#S#\\d+#E#\\s*)*\\)?)";
        String schPtrn = "(\\s*(?:\\(|\\,)\\s*(?:#S#\\d+#E#\\s*)*(?<!date\\s)format\\s*(?:#S#\\d+#E#\\s*)*\\'(.*?)\\'\\s*(?:#S#\\d+#E#\\s*)*\\)?)";
        if (FeatureLoader.getBooleanProperty("tdMigrateAddMonth")) {
            inputQuery = TeradataDateFormatUtility.doSupportAddMonth(inputQuery);
        }
        inputQuery = this.doReplaceFormatOfDateOrInt(inputQuery, "schema".equalsIgnoreCase(this.schemeType) ? "(\\s*(?:\\(|\\,)\\s*(?:#S#\\d+#E#\\s*)*(?<!date\\s)format\\s*(?:#S#\\d+#E#\\s*)*\\'(.*?)\\'\\s*(?:#S#\\d+#E#\\s*)*\\)?)" : "(?i)(\\s*(?:\\(?|\\,)\\s*(?:#S#\\d+#E#\\s*)*(?<!as\\s|time\\s|timestamp\\s|timestamp\\(\\d\\)\\s)format\\s*(?:#S#\\d+#E#\\s*)*\\'(.*?)\\'\\s*(?:#S#\\d+#E#\\s*)*\\)?)");
        if ("schema".equalsIgnoreCase(this.schemeType) && inputQuery.matches("(?i).*(?<!\\w)default(?!\\w)(.*)(?<!INTEGER\\s)FORMAT\\s*\\'(.*?)\\'.*")) {
            inputQuery = this.doReplaceFormatOfDateOrInt(inputQuery, "(?i)(\\s*(?:#S#\\d+#E#\\s*)*(?<!date\\s|INTEGER\\s)format\\s*(?:#S#\\d+#E#\\s*)*\\'(.*?)\\'\\s*(?:#S#\\d+#E#\\s*)*\\)?)");
        }
        if ((inputQuery = this.doReplaceFormatOfDateOrInt(inputQuery, "(\\s*\\(\\s*?(?:(\\s*#S#\\d+#E#\\s*)*)(?:(?:char|varchar|decimal|number|clob|float|double\\s+precision|numeric|real|character|long\\s+varchar|char\\s+varying|character\\s+varying)\\s*(?:(#S#\\d+#E#\\s*)*)(?:\\(.*?\\))?(?:(\\s*#S#\\d+#E#\\s*)*)|(?:int|integer|bigint|smallint|timestamp|time))\\s*\\))")).matches("(?i).*?CURRENT_DATE\\s*\\-\\s*(DATE\\s*('\\s*\\d.*')).*") && (matcher = CURRENT_DATE_PAT.matcher(inputQuery)).find()) {
            String s2 = matcher.group(2);
            inputQuery = inputQuery.replaceAll(matcher.group(1), "CAST ( " + matcher.group(2) + " AS DATE)");
        }
        return inputQuery;
    }

    public String getInputQry(String input, Matcher matcherFormat) {
        String inputQuery = input;
        inputQuery = this.doRplDateFormatAsDate(inputQuery, matcherFormat);
        inputQuery = this.doTimestampFuncCasting(inputQuery);
        inputQuery = this.doReplaceAsFormatWithDateOrInt(inputQuery, "(\\s+as\\s+(?:#S#\\d+#E#\\s*)*format\\s*(?:#S#\\d+#E#\\s*)*\\'(.*?)\\'\\s*\\))");
        inputQuery = this.doReplaceCastAsInt(inputQuery);
        inputQuery = this.doReplaceAsDataTypeFormatWithDateOrInt(inputQuery, "(?i)((?<!\\w)as(?!\\w)\\s*(?:#S#\\d+#E#\\s*)*(?<!\\w)(?:int|integer|(?:char|varchar)\\s*\\(\\s*?\\d+\\s*\\)|(?:decimal\\s*\\(\\s*\\d+\\s*\\,\\s*\\d+\\s*\\)))(?!\\w)\\s*(?:#S#\\d+#E#\\s*)*(?<!\\w)format(?!\\w)\\s*(?:#S#\\d+#E#\\s*)*\\'(.*?)\\'\\s*(?:#S#\\d+#E#\\s*)*\\))");
        return inputQuery;
    }

    private String doRplDateFormatAsDate(String inputQuery, Matcher matcherFormat) {
        if (matcherFormat.find()) {
            Matcher matcher = PATTERN_DATE_FORMAT.matcher(inputQuery);
            int startIndex = 0;
            StringBuffer inputQry = new StringBuffer(128);
            while (matcher.find()) {
                int tempIndex = matcher.end(1);
                inputQry.append(inputQuery.substring(startIndex, tempIndex));
                String function = QueryConversionUtility.doGetReplaceString(inputQuery.substring(tempIndex));
                startIndex = tempIndex + function.length();
                Matcher matcherInner = PATTERN_DATE_INNER.matcher(function);
                if (matcherInner.find()) {
                    function = function.substring(0, matcherInner.start(1));
                    function = "TO_CHAR(" + function + ")" + "," + matcherInner.group(2);
                }
                inputQry.append(function);
            }
            inputQry.append(inputQuery.substring(startIndex));
            inputQuery = inputQry.toString();
            inputQuery = QueryConversionUtility.doReplaceKeyword(inputQuery, "(?i)\\s*(?<!\\w)AS\\s+((#S#\\d+#E#\\s*)*)DATE\\s*((#S#\\d+#E#\\s*)*)FORMAT\\s*((#S#\\d+#E#\\s*)*).*?\\s*((#S#\\d+#E#\\s*)*)\\)", "castAsDateFormatPattern");
        }
        return inputQuery;
    }

    private String doReplaceAsDataTypeFormatWithDateOrInt(String inputQuery, String fnFindPattern) throws MigrationServiceException {
        String outputQry = inputQuery;
        Pattern pattern = Pattern.compile(fnFindPattern, 2);
        Matcher matcher = pattern.matcher(inputQuery);
        String function = null;
        int tempIndex = 0;
        String replacementString = "";
        FindFormatUtility util = new FindFormatUtility();
        while (matcher.find()) {
            function = matcher.group(1);
            int endIndex = matcher.end();
            String substring = " " + outputQry.substring(0, endIndex + tempIndex);
            String neededString = util.doFindFormatFunction(substring);
            String quoteString = matcher.group(2);
            if (!QueryConversionUtility.containsCheck(neededString, "format")) continue;
            replacementString = this.doFindReplacementStr(neededString, function, quoteString);
            int opBfReplace = outputQry.length();
            outputQry = outputQry.replaceFirst(Pattern.quote(neededString), replacementString);
            tempIndex += outputQry.length() - opBfReplace;
        }
        return outputQry;
    }

    private String doReplaceFormatOfDateOrInt(String inputQuery, String fnFindPattern) throws MigrationServiceException {
        String output = inputQuery;
        Pattern pattern = Pattern.compile(fnFindPattern, 2);
        Matcher matcher = pattern.matcher(inputQuery);
        int tempIndex = 0;
        while (matcher.find()) {
            if (output.matches("(?i).*CREATE\\s*(SET)?\\s+TABLE\\s*.*")) {
                String group = matcher.group();
                output = this.getOut(output, group);
                continue;
            }
            String function = matcher.group(1);
            String functionTrim = function.trim();
            String functionTemp = function;
            String substring = " " + output.substring(0, matcher.start() + tempIndex);
            if (functionTrim.substring(0, 1).contentEquals(",")) {
                function = function.replace(functionTrim.substring(0, 1), "(").trim();
                substring = substring.concat(")");
            }
            String functionNew = function.replaceAll("(?i)#S#\\d+#E#", "");
            String neededString = this.getNeededString(functionTrim, substring);
            String functionLower = QueryConversionUtility.toLower(functionNew);
            functionTemp = this.getFuncTemp(functionTemp, neededString, functionLower);
            LinkedHashMap<String, String> quoteMap = new LinkedHashMap<String, String>(10);
            if ((neededString = QueryConversionUtility.getSingleDoubleQuoteMap(neededString, quoteMap)).trim().isEmpty() || neededString.trim().startsWith("'") && !neededString.trim().matches("'##DOLLAR##1#'")) continue;
            neededString = QueryConversionUtility.getRplFromMap(neededString, quoteMap, "(##QUOTE##\\d+#)");
            String replacementString = this.getReplacementStrForFormats(matcher, functionNew, neededString, functionLower);
            neededString = this.updNeededStr(functionTrim, neededString);
            String strToReplace = neededString + functionTemp;
            int opBfReplace = output.length();
            output = this.getRplString(output, replacementString, neededString, strToReplace);
            tempIndex += output.length() - opBfReplace;
        }
        return output;
    }

    private String updNeededStr(String functionTrim, String input) {
        String neededString = input;
        if (functionTrim.trim().substring(0, 1).contentEquals(",")) {
            neededString = neededString.substring(0, neededString.length() - 1);
        }
        return neededString;
    }

    private String getOut(String input, String group) {
        String output = input;
        output = group.endsWith(" ") ? output.replace(group, " ") : output.replace(group, "");
        return output;
    }

    private String getNeededString(String functionTrim, String substring) {
        FindFormatUtility util = new FindFormatUtility();
        String neededString = util.doFindFormatFunction(substring);
        if (functionTrim.matches("(?i).*?\\(\\s*decimal\\s*\\(\\s*\\w+\\s*\\,\\s*\\w+\\s*\\)\\s*\\).*") && (substring.endsWith("end") || substring.endsWith("END"))) {
            if (!neededString.trim().startsWith("CASE")) {
                int index = substring.indexOf(neededString);
                String tempstr = substring.substring(0, index).toUpperCase(Locale.ROOT);
                if ((index = tempstr.lastIndexOf("CASE")) != -1) {
                    neededString = substring.substring(index, substring.length());
                }
            } else {
                neededString = this.findCaseString(substring, neededString);
            }
        }
        return neededString;
    }

    private String findCaseString(String input, String neededString) {
        String output = input;
        Matcher matcher = CAST_CASE_PAT.matcher(output);
        String temp = "";
        while (matcher.find()) {
            temp = output.substring(matcher.start(), output.length());
        }
        if ("".equals(temp)) {
            return neededString;
        }
        return temp;
    }

    public String getRplString(String input, String replacementString, String neededString, String strToReplace) {
        String output = input;
        if (!QueryConversionUtility.containsCheck(strToReplace, "CURRENT_TIMESTAMP")) {
            output = output.replaceFirst(Pattern.quote(strToReplace), replacementString);
        } else {
            String rplString = "TO_CHAR (" + neededString + "," + " " + "'" + replacementString + "'" + ")";
            output = output.replaceFirst(Pattern.quote(strToReplace), rplString);
        }
        return output;
    }

    public String getFuncTemp(String funcTemp, String neededString, String functionLower) {
        int lastIndex;
        String funcLower;
        String functionTemp = funcTemp;
        if (neededString.startsWith("mig_fn_castasint") && !(funcLower = functionLower.trim()).startsWith("(") && !funcLower.startsWith(",") && funcLower.endsWith(")") && (lastIndex = functionTemp.lastIndexOf(41)) != -1) {
            functionTemp = functionTemp.substring(0, lastIndex);
        }
        return functionTemp;
    }

    private String getReplacementStrForFormats(Matcher matcher, String function, String neededString, String functionLower) throws MigrationServiceException {
        String replacementString = null;
        String replacedString = "";
        Matcher matcher1 = COMMON_PAT.matcher(function);
        if (matcher1.find()) {
            replacedString = matcher1.group(1);
        }
        if (functionLower.contains("format")) {
            String quoteString = matcher.group(2);
            replacementString = this.doGetRplStrForFormat(function, neededString, quoteString);
        } else {
            replacementString = function.contains(replacedString.trim()) ? this.doGetReplacementStr(neededString, function, replacedString.trim(), " as ", "cast") : neededString + function;
        }
        return replacementString;
    }

    private String doGetRplStrForFormat(String function, String neededString, String quoteString) throws MigrationServiceException {
        String replacementString = null;
        char quoteFirstChar = Character.toLowerCase(quoteString.trim().charAt(0));
        if (quoteFirstChar == 'y' || quoteFirstChar == 'm' || quoteFirstChar == 'd') {
            replacementString = this.doGetReplacementStr(neededString, function, "'", ",", "TO_CHAR");
        } else if (quoteFirstChar == 'z' || quoteFirstChar == '-' || Character.isDigit(quoteFirstChar)) {
            replacementString = this.doGetReplacementStr(neededString, function, "'", ",", "LPAD");
        } else {
            replacementString = quoteString.replace("B", " ");
            replacementString = replacementString.replace("MMM", "MON");
        }
        return replacementString;
    }

    private String doReplaceAsFormatWithDateOrInt(String inputQuery, String fnFindPattern) throws MigrationServiceException {
        String output = inputQuery;
        Pattern pattern = Pattern.compile(fnFindPattern, 2);
        Matcher matcher = pattern.matcher(inputQuery);
        String replacementString = "";
        String function = null;
        int tempIndex = 0;
        FindFormatUtility util = new FindFormatUtility();
        while (matcher.find()) {
            function = matcher.group(1);
            int endIndex = matcher.end();
            String substring = " " + output.substring(0, endIndex + tempIndex);
            String neededString = util.doFindFormatFunction(substring);
            String quoteString = matcher.group(2);
            char quoteFirstChar = Character.toLowerCase(quoteString.trim().charAt(0));
            if (!QueryConversionUtility.containsCheck(neededString, "format")) continue;
            replacementString = this.getRplStr(function, neededString, quoteString, quoteFirstChar);
            int opBfReplace = output.length();
            output = output.replaceFirst(Pattern.quote(neededString), Matcher.quoteReplacement(replacementString));
            tempIndex += output.length() - opBfReplace;
        }
        return output;
    }

    private String getRplStr(String function, String neededString, String input, char quoteFirstChar) {
        String replacementString;
        String quoteString = input;
        if (quoteFirstChar == 'y' || quoteFirstChar == 'm' || quoteFirstChar == 'd') {
            String strToReplaceComma = function.substring(0, function.indexOf(39));
            String strToReplacein = function.replace(strToReplaceComma, ",");
            String strToReplace = neededString.replace(function, strToReplacein);
            replacementString = strToReplace.replaceFirst("(?i)cast", "TO_CHAR");
        } else {
            String strToReplace = neededString.replace(function, ",");
            if (quoteFirstChar == 'z') {
                strToReplace = this.getRplValForHyphen(strToReplace, quoteString);
            } else if (quoteFirstChar == '9') {
                int closeBracket = quoteString.indexOf(41);
                quoteString = closeBracket > 0 ? quoteString : quoteString.replace(quoteString, "2");
                strToReplace = strToReplace + quoteString.substring(quoteString.indexOf(40) + 1, closeBracket >= 0 ? quoteString.indexOf(41) : quoteString.length()) + "," + "'" + 0 + "'" + ")";
            }
            replacementString = strToReplace.replaceFirst("(?i)cast", "LPAD");
        }
        return replacementString;
    }

    private String doGetReplacementStr(String neededString, String function, String indexToFind, String replaceFnString, String replaceVariable) throws MigrationServiceException {
        String replacementFormatFn = "";
        String replacementString = "";
        String quoteStr = "";
        if (!function.isEmpty()) {
            quoteStr = this.getQuoteFunctionString(function, indexToFind, quoteStr);
            if (QueryConversionUtility.equalCheck(replaceVariable, "LPAD")) {
                char quoteFirstChar = Character.toLowerCase(quoteStr.trim().charAt(1));
                if (quoteFirstChar == 'z') {
                    return this.getRplValForZFormat(neededString, function, replaceVariable, quoteStr);
                }
                if (quoteFirstChar == '-') {
                    replacementFormatFn = this.getRplValForHyphen(replaceFnString, quoteStr);
                } else if (quoteFirstChar == '9') {
                    replacementFormatFn = this.getRplForIntFormat(replaceFnString, quoteStr);
                }
            } else {
                replacementFormatFn = replaceFnString + quoteStr;
            }
        }
        replacementString = " " + replaceVariable + "(" + neededString + replacementFormatFn;
        if (!function.trim().endsWith(")") && !QueryConversionUtility.equalCheck(replaceVariable, "LPAD")) {
            replacementString = replacementString + ")";
        }
        return replacementString;
    }

    private String getRplForIntFormat(String replaceFnString, String input) {
        String quoteStr = input;
        Matcher stringMatcher = PATTERN_9_ALL.matcher(quoteStr);
        quoteStr = quoteStr.replace("'", "").trim();
        String tempstr = "";
        if (stringMatcher.find()) {
            String zString = stringMatcher.group(1);
            tempstr = STR_9.equalsIgnoreCase(zString) ? quoteStr.replace(")", "").trim().length() + "" : zString.substring(zString.indexOf(40) + 1, zString.indexOf(41));
        }
        String replacementFormatFn = replaceFnString + tempstr + "," + "'" + 0 + "'" + ")";
        return replacementFormatFn;
    }

    private String getRplValForHyphen(String replaceFnString, String quoteStr) {
        String replacementFormatFn = replaceFnString + quoteStr.substring(quoteStr.indexOf(40) + 1, quoteStr.indexOf(41)) + "," + "'" + " " + "'" + ")";
        return replacementFormatFn;
    }

    private String getRplValForZFormat(String neededString, String function, String replaceVariable, String quoteStr) {
        TeradataDateFormatUtility formatUtil = new TeradataDateFormatUtility();
        String returnvalue = formatUtil.getZFormatString(neededString, quoteStr, function, replaceVariable);
        return returnvalue;
    }

    private String getQuoteFunctionString(String function, String indexToFind, String quoteStr) {
        int positionSmallInt = function.indexOf("smallint");
        TeradataMapHelperAlias teradataMapHelperAlias = new TeradataMapHelperAlias();
        String migratedDataType = teradataMapHelperAlias.doReplaceDataType(indexToFind);
        String functionStr = function.replace(indexToFind, migratedDataType);
        if (positionSmallInt != -1) {
            quoteStr = functionStr.substring(positionSmallInt);
        } else {
            int positionBigInt = function.indexOf("bigint");
            if (positionBigInt != -1) {
                quoteStr = functionStr.substring(positionBigInt);
            } else {
                int position = function.indexOf(indexToFind);
                if (position != -1) {
                    quoteStr = functionStr.substring(position);
                }
            }
        }
        return quoteStr;
    }

    private String doFindReplacementStr(String neededString, String function, String quoteString) throws MigrationServiceException {
        String replacementStr = "";
        String strToReplaceInFunction = function;
        strToReplaceInFunction = function.substring(0, function.indexOf(39)).trim();
        strToReplaceInFunction = " " + strToReplaceInFunction.substring(0, QueryConversionUtility.toLower(strToReplaceInFunction).indexOf("format"));
        char quoteFirstChar = Character.toLowerCase(quoteString.trim().charAt(0));
        if (quoteFirstChar == 'y' || quoteFirstChar == 'm' || quoteFirstChar == 'd') {
            replacementStr = this.doGetRplString(neededString, function, quoteString, strToReplaceInFunction);
        } else {
            int quotePosition = function.indexOf(39);
            String newQuoteStr = function.substring(quotePosition);
            if (quoteFirstChar == 'z') {
                return this.getReturnVal(neededString, function, quoteString, strToReplaceInFunction);
            }
            if (quoteFirstChar == '9') {
                strToReplaceInFunction = this.getStrToRpl(quoteString, strToReplaceInFunction, newQuoteStr);
            }
            replacementStr = "LPAD(" + neededString.replace(function, strToReplaceInFunction);
        }
        return replacementStr;
    }

    private String getStrToRpl(String quoteString, String input, String newQuoteStr) {
        String strToReplaceInFunction = input;
        strToReplaceInFunction = quoteString.matches("\\b[9]+\\b") ? strToReplaceInFunction + ")" + "," + quoteString.length() + "," + "'" + 0 + "'" + ")" : strToReplaceInFunction + ")" + "," + newQuoteStr.substring(newQuoteStr.indexOf(40) + 1, newQuoteStr.indexOf(41)) + "," + "'" + 0 + "'" + ")";
        return strToReplaceInFunction;
    }

    private String getReturnVal(String neededString, String function, String quoteString, String strToReplaceInFunction) {
        TeradataDateFormatUtility formatUtil = new TeradataDateFormatUtility();
        String returnValue = formatUtil.getZFormatString(neededString, quoteString, function, strToReplaceInFunction + ")" + ",");
        return returnValue;
    }

    private String doGetRplString(String neededString, String function, String quoteString, String input) {
        String strToReplaceInFunction = input;
        strToReplaceInFunction = strToReplaceInFunction + ")" + "," + "'" + quoteString + "'" + ")";
        String replacementStr = "TO_CHAR(" + neededString.replace(function, strToReplaceInFunction);
        return replacementStr;
    }

    private static String doDateSubtraction(String input) throws MigrationServiceException {
        Matcher matcher = DATE_SUB_PATTERN.matcher(input);
        int endIndex = 0;
        int startIndex = 0;
        String matcherStr = null;
        StringBuffer buffer = new StringBuffer(128);
        String replacementString = null;
        String inputData = null;
        while (matcher.find()) {
            int beginIndex = matcher.start();
            buffer.append(input.substring(startIndex, beginIndex));
            endIndex = matcher.end();
            matcherStr = input.substring(beginIndex, endIndex);
            if (!(matcher.group(7) == null && matcher.group(15) == null || matcher.group(13).matches("\\d+") || matcher.group(5).matches("\\d+"))) {
                inputData = matcher.group(7) != null ? matcherStr : matcher.group(4);
                StringBuffer replaceBuffer = new StringBuffer(128);
                replaceBuffer.append(" ").append("~EXT~SB~PTRN~").append("(").append("'DAY' ").append("~DT~SB~PTRN~").append(" ").append("(").append(inputData).append(")").append(")");
                replacementString = matcherStr.replace(inputData, replaceBuffer.toString());
            } else {
                replacementString = matcherStr;
            }
            buffer.append(replacementString);
            startIndex = endIndex;
        }
        buffer.append(input.substring(endIndex));
        return buffer.toString();
    }

    public static String doDateSubtractionForDlsql(String input) {
        Matcher matcher = MIG_FN_CASTASINT.matcher(input);
        int endIndex = 0;
        int startIndex = 0;
        int indexTranslate = 0;
        StringBuffer buffer = new StringBuffer(128);
        String cols = "";
        while (matcher.find()) {
            if ((indexTranslate = QueryConversionUtility.getIndex(input, "mig_fn_castasint", indexTranslate)) != -1) {
                buffer.append(input.substring(startIndex, indexTranslate));
                cols = QueryUtilityExt.doGetStringFromGivenIndex(indexTranslate, input);
                String rpl = cols.substring(cols.indexOf("(") + 1, cols.lastIndexOf(")"));
                endIndex = indexTranslate + cols.length();
                cols = cols.replace(rpl, "EXTRACT( 'DAY' ~FRM~SB~PTRN~ (" + rpl + "))");
                buffer.append(cols);
            }
            startIndex = endIndex;
            indexTranslate = endIndex;
        }
        buffer.append(input.substring(endIndex));
        return buffer.toString();
    }

    private String doTimestampFuncCasting(String inputQuery) throws MigrationServiceException {
        String input = inputQuery.replaceAll("(?i)(TIMESTAMP)\\s+(\\'[\\w-\\s:]*\\')", "CAST ($2 AS $1)");
        Pattern toTimestampFuncPattern = Pattern.compile("(?i)as\\s+(?:\\s*\\#S\\#\\d+\\#E\\#\\s*)*timestamp\\s*(?:\\s*\\#S\\#\\d+\\#E\\#\\s*)*(?:\\(\\s*(?:\\s*\\#S\\#\\d+\\#E\\#\\s*)*(?<num>\\d+)\\s*(?:\\s*\\#S\\#\\d+\\#E\\#\\s*)*\\))?\\s+(?:\\s*\\#S\\#\\d+\\#E\\#\\s*)*format\\s+(?:\\s*\\#S\\#\\d+\\#E\\#\\s*)*\\'\\s*(?<format>y*?m*?\\/?\\-?m*?d*?\\/?\\-?d*?y*?)\\s*b?h+\\:mi\\:s+(?<dec>(?:\\.s|ds)\\(\\d+\\))?\\s*\\'\\s*(?:\\s*\\#S\\#\\d+\\#E\\#\\s*)*\\)");
        Matcher toTimestampFuncMatcher = toTimestampFuncPattern.matcher(input);
        while (toTimestampFuncMatcher.find()) {
            try {
                int startIndex = toTimestampFuncMatcher.start(0);
                int endIndex = toTimestampFuncMatcher.end(0);
                List<Integer> castLst = QueryUtilityExt.findIndex(startIndex, input, "cast");
                int colIndex = castLst.get(0);
                int castIndex = castLst.get(1);
                String castFunc = input.substring(castIndex, endIndex);
                String colmn = input.substring(colIndex, startIndex);
                if (toTimestampFuncMatcher.group("num") == null || Integer.parseInt(toTimestampFuncMatcher.group("num").trim()) >= 0) {
                    String formatStr = toTimestampFuncMatcher.group("format");
                    String dateFormat = formatStr + " HH24:MI:SS";
                    String decimalPrecision = toTimestampFuncMatcher.group("dec");
                    String decimalValue = TeradataDateFormatUtility.doChangeInDecimalPrecision(decimalPrecision);
                    String supportedTimestamp = "TO_TIMESTAMP( " + colmn + "," + " " + "'" + dateFormat + decimalValue + "'" + " " + ")";
                    input = input.replace(castFunc, supportedTimestamp);
                    toTimestampFuncMatcher = toTimestampFuncPattern.matcher(input);
                    continue;
                }
                throw new MigrationServiceException(MessageLoader.getMessage("timestampError"));
            }
            catch (NumberFormatException e) {
                logger.error(ErrorLoggerUtility.getExceptionDetails(e) + " Error while converting from string to int for value= " + toTimestampFuncMatcher.group("num").trim());
                throw new MigrationServiceException("[DSC_ERR_004_018] " + MessageLoader.getMessage("DSC_ERR_004_018"));
            }
        }
        return input;
    }

    private static String doChangeInDecimalPrecision(String decimalPrecision) {
        StringBuffer decimalConv = new StringBuffer("");
        if (decimalPrecision != null) {
            if ((decimalPrecision = decimalPrecision.trim()).matches("(?i)\\.s\\s*\\(\\d+\\)")) {
                decimalConv = TeradataDateFormatUtility.doChangeDecimalToSupportedFormat(decimalPrecision, decimalConv);
            } else if (decimalPrecision.matches("(?i)ds\\s*\\(\\d+\\)")) {
                decimalConv = TeradataDateFormatUtility.doChangeDecimalToSupportedFormat(decimalPrecision, decimalConv);
            }
        }
        return decimalConv.toString();
    }

    private static StringBuffer doChangeDecimalToSupportedFormat(String decimalPrecision, StringBuffer decimalConv) {
        String numeric = decimalPrecision.substring(decimalPrecision.indexOf(40) + 1, decimalPrecision.indexOf(41));
        int val = Integer.parseInt(numeric);
        if (val > 0) {
            if (val <= 3) {
                decimalConv.append(".").append("MS");
            } else {
                decimalConv.append(".").append("US");
            }
        }
        return decimalConv;
    }

    public String doUserEnvironmentDate(String input) {
        String[] patterns;
        String output = input;
        LinkedHashMap<String, String> quoteMap = new LinkedHashMap<String, String>(10);
        output = QueryConversionUtility.getSingleDoubleQuoteMap(output, quoteMap);
        for (String pattern : patterns = new String[]{"(?<!\\w)default\\s*(?:#S#\\d+#E#\\s*)*(?<!\\w)(date)(?!\\w)\\s*(?:#S#\\d+#E#\\s*)*\\s*(?=,|\\)|;)", "(?:=|<=|>=|<>|<|>|\\+|\\-|\\*|\\/|(?<!\\w)(?:LT|GT|EQ|LE|GE|NE)(?!\\w))\\s*(?:\\s*#S#\\d+#E#)*\\s+(?<!\\w)(date)(?!(\\w|\\s*##QUOTE##\\d+#))", "(?<!\\w)(date)(?!\\w)\\s*(?:#S#\\d+#E#\\s*)*(?:=|<=|>=|<>|<|>|\\+|\\-|\\*|\\/|(?<!\\w)(?:LT|GT|EQ|LE|GE|NE)(?!\\w))", "(?<!\\w)cast\\s*(?:#S#\\d+#E#\\s*)*\\(\\s*(?:#S#\\d+#E#\\s*)*(?<!\\w)(date)(?!\\w)", "(?i)(?<!\\')\\(\\s*(?:#S#\\d+#E#\\s*)*(?<!\\w)(date)(?!\\w)\\s*(.*?)\\)(?!\\')", "(?i)(?<!\\w)(date)(?!\\w)\\s*(?:#S#\\d+#E#\\s*)*\\s*\\(", "(?i)(?<!\\w)extract(?!\\w)\\s*(?:#S#\\d+#E#\\s*)*\\(.*?(?<!\\w|as\\s)(date)(?!\\w|\\s+format)(.*?)\\)", "(?i)(?<!\\w)where(?!\\w).*(?<!\\w|as\\s)(date)(?!\\w|\\s*##QUOTE##\\d+#)"}) {
            output = QueryConversionUtility.doReplaceSpecificGrp(output, pattern, null, "CURRENT_DATE", 1, false);
        }
        output = QueryConversionUtility.getRplFromMap(output, quoteMap, "(##QUOTE##\\d+#)");
        return output;
    }

    public String dateTypeCasting(String inputSql) {
        String input = inputSql;
        Pattern dateTypeCastPattern = Pattern.compile("(?i)(\\'\\s*(?:\\d{4}(?:\\-|\\/|\\.)?(?:0?[1-9]|1[012])(?:\\-|\\/|\\.)?(?:0?[1-9]|[12][0-9]|3[01]))\\s*\\')(?!\\w)\\s*(?:#S#\\d+#E#\\s*)*\\s*(?<!\\w)\\(\\s*(?:#S#\\d+#E#\\s*)*(date|(?:varchar|char|number).*)\\s*(?:#S#\\d+#E#\\s*)*\\)");
        Matcher dateTypeCastMatcher = dateTypeCastPattern.matcher(input);
        StringBuffer sb = new StringBuffer(128);
        String dateCast = null;
        String dateKey = null;
        int endIndex = 0;
        int tempIdx = 0;
        while (dateTypeCastMatcher.find()) {
            dateCast = dateTypeCastMatcher.group(1);
            dateKey = dateTypeCastMatcher.group(2);
            int startIndex = dateTypeCastMatcher.start();
            endIndex = dateTypeCastMatcher.end();
            sb.append(input.substring(tempIdx, startIndex)).append(" ");
            sb.append("cast").append("(");
            sb.append(dateCast).append(" ");
            sb.append("AS");
            sb.append(" ").append(dateKey);
            sb.append(")");
            tempIdx = endIndex;
        }
        sb.append(input.substring(endIndex));
        return sb.toString();
    }

    public String dateTypeCastDollar(String inputSql) {
        Pattern dateCast = Pattern.compile("(?i)((?<!\\w)date(?!\\w))\\s*(\\'\\s*\\$\\s*\\{(.*?)\\s*\\}\\')");
        Matcher dateCastMatcher = dateCast.matcher(inputSql);
        int startIdx = 0;
        StringBuffer sb = new StringBuffer(128);
        while (dateCastMatcher.find()) {
            String date = dateCastMatcher.group(1);
            String dateCol = dateCastMatcher.group(2);
            int tempIdx = dateCastMatcher.start(1);
            int endIdx = dateCastMatcher.end(2);
            sb.append(inputSql.substring(startIdx, tempIdx));
            sb.append("CAST").append("(").append(dateCol).append(" ").append("AS").append(" ").append(date).append(")");
            startIdx = endIdx;
        }
        sb.append(inputSql.substring(startIdx));
        return sb.toString();
    }

    private String getRepeatString(int count, String replaceStr) {
        return String.join((CharSequence)"", Collections.nCopies(count, replaceStr));
    }

    private static String doSupportAddMonth(String input) {
        String inputQuery = input;
        Pattern pattern = Pattern.compile("(?i)(?<!\\w)ADD_MONTHS(?!\\w)\\s*\\(");
        Matcher matcher = pattern.matcher(inputQuery);
        int temp = 0;
        int start = 0;
        int end = 0;
        StringBuffer outbuff = new StringBuffer(128);
        while (matcher.find()) {
            start = matcher.start();
            end = matcher.end();
            outbuff.append(inputQuery.substring(temp, start));
            String addMonthStr = matcher.group();
            outbuff.append("mig_td_ext.").append(addMonthStr);
            temp = end;
        }
        outbuff.append(inputQuery.substring(temp));
        return outbuff.toString();
    }
}

