/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.teradata;

import com.huawei.db.migration.exception.MigrationServiceException;
import com.huawei.db.migration.teradata.FindFormatUtility;
import com.huawei.db.migration.teradata.TeradataPatternHandler;
import com.huawei.db.migration.util.ColumnSplitter;
import com.huawei.db.migration.util.FeatureLoader;
import com.huawei.db.migration.util.MessageLoader;
import com.huawei.db.migration.util.QueryConversionUtility;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TeradataFnIntoExists {
    private static final Pattern WHERE_AND_OR_PAT = Pattern.compile("(?i).*(?<!\\w)(where|and|or)(?!\\w)");
    private StringBuffer sbuffOut = null;
    private Pattern patternExists = null;
    private Matcher matcherExists = null;
    private Pattern patternUpdExists = null;
    private Matcher matcherUpdExists = null;
    private String selUpdStr = null;
    private String fromUpdtbls = null;
    private String columns = null;
    private String setwhereAndOr = null;
    private String notIn = null;
    private String subQry = null;
    private String grpByStr = null;
    private String tabAlias = null;
    private boolean isReq = false;
    private boolean extraBrcktFlag = false;
    private int brkCnt = 0;
    private int tabAliasCount = 0;

    public String doIntoExistsConversion(String queryInp, Map<String, String> subQueryTrackMap, Map<String, String> functionMap) throws MigrationServiceException {
        String outputQuery = queryInp;
        String query = queryInp;
        boolean inToExists = false;
        inToExists = FeatureLoader.getBooleanProperty("inToExists");
        if (inToExists && query.matches("(?i).*(?<!\\w)in\\s*(?:#S#\\d+#E#\\s*)*?##SUBQUERY##.*")) {
            LinkedHashMap<String, String> dollarMap = new LinkedHashMap<String, String>(10);
            query = QueryConversionUtility.getDollarMap(query, dollarMap);
            for (int cnter = 0; query.matches("(?i).*(?<!\\w)in\\s*(?:#S#\\d+#E#\\s*)*?##SUBQUERY##.*") && cnter <= 5; ++cnter) {
                outputQuery = this.doChangeInToExists(query, subQueryTrackMap, functionMap);
                query = outputQuery;
            }
            String dollarPattern = "(##DOLLAR##\\d+#)";
            for (Map.Entry<String, String> entry : subQueryTrackMap.entrySet()) {
                String newVal = QueryConversionUtility.getRplFromMap(entry.getValue(), dollarMap, dollarPattern);
                subQueryTrackMap.put(entry.getKey(), newVal);
            }
            outputQuery = QueryConversionUtility.getRplFromMap(outputQuery, dollarMap, dollarPattern);
        }
        return outputQuery;
    }

    public String doChangeInToExists(String query, Map<String, String> subQueryTrackMap, Map<String, String> functionMap) throws MigrationServiceException {
        this.sbuffOut = new StringBuffer(query);
        this.patternUpdExists = Pattern.compile("(?i)(.*(?<!\\w)update(?!\\w))(.*?)((?<!\\w)set(?!\\w).*(?<!\\w)(?:where|and|or)(?!\\w))(.*?)(?<!\\w)(NOT\\s*(?:#S#\\d+#E#\\s*)*?in\\s*(?:#S#\\d+#E#\\s*)*?|in\\s*(?:#S#\\d+#E#\\s*)*?)(?!\\w)\\s*(##SUBQUERY##\\d+__)(.*)");
        this.matcherUpdExists = this.patternUpdExists.matcher(query);
        if (this.matcherUpdExists.find()) {
            this.updateWithIntoExists(subQueryTrackMap, functionMap);
        } else {
            this.patternExists = Pattern.compile("(?i)(.*)(?<!\\w)from\\s+(.*)(?<!\\w)(where|and|or)(?!\\w)(.*?)(?<!\\w)(NOT\\s*(?:#S#\\d+#E#\\s*)*?in\\s*(?:#S#\\d+#E#\\s*)*?|in\\s*(?:#S#\\d+#E#\\s*)*?)(?!\\w)\\s*(##SUBQUERY##\\d+__)(.*)");
            this.matcherExists = this.patternExists.matcher(query);
            if (this.matcherExists.find()) {
                this.sbuffOut = new StringBuffer();
                this.selUpdStr = this.matcherExists.group(1);
                this.fromUpdtbls = this.matcherExists.group(2);
                this.setwhereAndOr = this.matcherExists.group(3);
                this.columns = this.matcherExists.group(4).trim();
                int brckCnt = QueryConversionUtility.doChkBracketCnt(this.columns);
                if (brckCnt != 0) {
                    this.handleBrackets(brckCnt);
                }
                this.checkJoin();
                String inInput = QueryConversionUtility.toUpper(this.matcherExists.group(5));
                this.notIn = inInput.replace("IN", "EXISTS");
                this.subQry = this.matcherExists.group(6);
                this.grpByStr = this.matcherExists.group(7);
                String tableName = this.fromUpdtbls.replaceAll("(?i)#S#\\d+#E#", "").trim();
                tableName = QueryConversionUtility.getTblNmeRmvinWhrJoin(this.setwhereAndOr, tableName);
                boolean isJoin = QueryConversionUtility.checkJoin(tableName);
                this.columns = this.columns.trim();
                this.chkUnevenBrckts();
                this.intoExistsReplaceFunctionVariable(tableName, isJoin, subQueryTrackMap, functionMap);
            }
        }
        return this.sbuffOut.toString();
    }

    private void updateWithIntoExists(Map<String, String> subQueryTrackMap, Map<String, String> functionMap) throws MigrationServiceException {
        this.sbuffOut = new StringBuffer();
        this.selUpdStr = this.matcherUpdExists.group(1);
        this.fromUpdtbls = this.matcherUpdExists.group(2);
        this.setwhereAndOr = this.matcherUpdExists.group(3);
        this.columns = this.matcherUpdExists.group(4);
        String inInput = QueryConversionUtility.toUpper(this.matcherUpdExists.group(5));
        this.notIn = inInput.replace("IN", "EXISTS");
        this.subQry = this.matcherUpdExists.group(6);
        this.grpByStr = this.matcherUpdExists.group(7);
        String tableName = this.fromUpdtbls.replaceAll("(?i)#S#\\d+#E#", "").trim();
        this.columns = this.columns.trim();
        this.chkUnevenBrckts();
        boolean bracketFlagSub = this.updAliasAndGetBuff(subQueryTrackMap, functionMap, tableName);
        if (bracketFlagSub) {
            this.sbuffOut.append("(");
        }
        if (this.extraBrcktFlag) {
            StringBuffer strbufBracket = new StringBuffer();
            while (this.brkCnt > 0) {
                strbufBracket = strbufBracket.append("(");
                --this.brkCnt;
            }
            this.sbuffOut.append(strbufBracket).append(this.notIn).append(" ").append(this.subQry).append(" ").append(this.grpByStr);
        } else {
            this.sbuffOut.append(this.notIn).append(" ").append(this.subQry).append(" ").append(this.grpByStr);
        }
    }

    private boolean updAliasAndGetBuff(Map<String, String> subQueryTrackMap, Map<String, String> functionMap, String tableName) {
        if (tableName.contains(" ")) {
            this.tabAlias = tableName.substring(tableName.lastIndexOf(32) + 1);
        } else {
            this.tabAliasCount = TeradataPatternHandler.getTabaliasCnt();
            this.tabAlias = "MigTblAlias" + this.tabAliasCount++;
            TeradataPatternHandler.setTabaliasCnt(this.tabAliasCount);
            String strTblname = Pattern.quote(tableName);
            this.fromUpdtbls = this.fromUpdtbls.replaceFirst(strTblname, tableName + " " + this.tabAlias);
        }
        this.setwhereAndOr = this.changeTblNmeToTblAlias(this.setwhereAndOr, tableName);
        this.grpByStr = this.changeTblNmeToTblAlias(this.grpByStr, tableName);
        this.columns = QueryConversionUtility.doReplaceFunctionVariables(this.columns, functionMap, "__FUNCTION__");
        boolean bracketFlagSub = QueryConversionUtility.doGetupdatedSubQryStr(this.columns, subQueryTrackMap, this.tabAlias, this.subQry);
        this.sbuffOut.append(this.selUpdStr).append(" ").append(this.fromUpdtbls).append(" ").append(this.setwhereAndOr).append(" ");
        return bracketFlagSub;
    }

    private void chkUnevenBrckts() {
        String tempColumn;
        if (this.columns.startsWith("(") && this.columns.endsWith(")") && (tempColumn = QueryConversionUtility.doGetReplaceString(this.columns)).isEmpty()) {
            boolean balancedBracket = false;
            while (!balancedBracket) {
                String tempBracket = this.columns.substring(1);
                this.extraBrcktFlag = true;
                tempBracket = tempBracket.trim();
                this.columns = QueryConversionUtility.doGetReplaceString(tempBracket);
                ++this.brkCnt;
                if (this.columns.isEmpty()) {
                    balancedBracket = false;
                    this.columns = tempBracket;
                    continue;
                }
                balancedBracket = true;
            }
        }
    }

    private void handleBrackets(int brckCnt) throws MigrationServiceException {
        if (this.columns.endsWith(")") && brckCnt != 0 || QueryConversionUtility.toLower(this.columns).endsWith("end")) {
            String allColumns = this.fromUpdtbls + this.setwhereAndOr + " " + this.columns;
            FindFormatUtility formatUtil = new FindFormatUtility();
            String tempColumns = formatUtil.doFindFormatFunction(allColumns);
            String tempFromUpdtbls = allColumns.replace(tempColumns, "");
            int openBracketIdx = tempColumns.indexOf(40);
            this.setwhereAndOr = tempColumns.substring(0, openBracketIdx);
            if (this.setwhereAndOr.trim().matches("(?i)AND|OR|WHERE")) {
                this.fromUpdtbls = tempFromUpdtbls;
                this.columns = tempColumns.substring(openBracketIdx);
            } else {
                Matcher match = WHERE_AND_OR_PAT.matcher(tempFromUpdtbls);
                if (match.find()) {
                    int endIdx = match.end(1);
                    this.setwhereAndOr = match.group(1);
                    this.columns = tempFromUpdtbls.substring(endIdx) + tempColumns;
                    this.fromUpdtbls = tempFromUpdtbls.substring(0, match.start(1));
                }
            }
        }
    }

    private void intoExistsReplaceFunctionVariable(String tableName, boolean isJoin, Map<String, String> subQueryTrackMap, Map<String, String> functionMap) throws MigrationServiceException {
        this.columns = QueryConversionUtility.doReplaceFunctionVariables(this.columns, functionMap, "__FUNCTION__");
        if (tableName.contains(",") || isJoin) {
            this.tabAlias = "";
            this.isReq = false;
            if (this.columns.contains(".")) {
                this.isReq = true;
            }
        } else if (tableName.contains(" ")) {
            this.tabAlias = tableName.substring(tableName.lastIndexOf(32) + 1);
            this.isReq = true;
        } else {
            this.tabAliasCount = TeradataPatternHandler.getTabaliasCnt();
            this.tabAlias = "MigTblAlias" + this.tabAliasCount++;
            TeradataPatternHandler.setTabaliasCnt(this.tabAliasCount);
            String strTblname = Pattern.quote(tableName);
            this.fromUpdtbls = this.fromUpdtbls.replaceFirst(strTblname, tableName + " " + this.tabAlias);
            this.isReq = true;
        }
        this.selUpdStr = this.changeTblNmeToTblAlias(this.selUpdStr, tableName);
        this.grpByStr = this.changeTblNmeToTblAlias(this.grpByStr, tableName);
        if (this.isReq) {
            boolean bracketFlag = QueryConversionUtility.doGetupdatedSubQryStr(this.columns, subQueryTrackMap, this.tabAlias, this.subQry);
            this.sbuffOut.append(this.selUpdStr).append(" ").append("from").append(" ").append(this.fromUpdtbls).append(" ").append(this.setwhereAndOr).append(" ");
            if (bracketFlag) {
                this.sbuffOut.append("(");
            }
            if (this.extraBrcktFlag) {
                StringBuffer strbuf = new StringBuffer();
                while (this.brkCnt > 0) {
                    strbuf = strbuf.append("(");
                    --this.brkCnt;
                }
                this.sbuffOut.append(strbuf).append(this.notIn).append(" ").append(this.subQry).append(" ").append(this.grpByStr);
            } else {
                this.sbuffOut.append(this.notIn).append(" ").append(this.subQry).append(" ").append(this.grpByStr);
            }
        } else {
            throw new MigrationServiceException("[DSC_ERR_003_005] " + MessageLoader.getMessage("DSC_ERR_003_005"));
        }
    }

    private void checkJoin() throws MigrationServiceException {
        String column = null;
        Pattern patternJoin = Pattern.compile("(?i)(?<!\\w)join(?!\\w)");
        Matcher matcherJoin = patternJoin.matcher(this.fromUpdtbls);
        Pattern patternSelfJoin = Pattern.compile("(?i)(?<!\\w)self(?!\\w)\\s*(?:#S#\\d+#E#\\s*)*(?<!\\w)join(?!\\w)");
        Matcher matcherSelfJoin = patternSelfJoin.matcher(this.fromUpdtbls);
        if (matcherJoin.find() && !matcherSelfJoin.find()) {
            ColumnSplitter splitter = new ColumnSplitter();
            List<String> list = splitter.doGetAllColumns(this.fromUpdtbls);
            column = this.columns.trim();
            if (column.startsWith("(") && column.endsWith(")")) {
                column = column.substring(1, column.length() - 1);
            }
            this.checkColumnContainsDot(list);
            List<String> columnList = splitter.doGetAllColumns(column);
            this.checkColumnContainsDot(columnList);
        }
    }

    private String changeTblNmeToTblAlias(String inputStr, String tableName) {
        String outputStr = inputStr;
        if (inputStr.contains(tableName + ".")) {
            outputStr = inputStr.replace(tableName, this.tabAlias);
        }
        return outputStr;
    }

    private void checkColumnContainsDot(List<String> columnList) throws MigrationServiceException {
        for (String listColumn : columnList) {
            if (listColumn.contains(".")) continue;
            throw new MigrationServiceException("[DSC_ERR_003_006] " + MessageLoader.getMessage("DSC_ERR_003_006"));
        }
    }
}

