/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.teradata;

import com.huawei.db.migration.common.handlers.CommentsHandler;
import com.huawei.db.migration.exception.MigrationServiceException;
import com.huawei.db.migration.util.ColumnSplitter;
import com.huawei.db.migration.util.FeatureLoader;
import com.huawei.db.migration.util.MessageLoader;
import com.huawei.db.migration.util.PlaceHolderUtility;
import com.huawei.db.migration.util.QueryConversionUtility;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TeradataMapHelperAlias {
    public String doPutColumnAlias(String columnNames) {
        String inputCols = columnNames;
        String inputQry = columnNames;
        inputCols = QueryConversionUtility.doRemDotOrAppendAlias(inputCols, true);
        String patternInputToMatch = inputCols.replaceAll("(?i)#S#\\d+#E#", "");
        List<String> list = Arrays.asList(patternInputToMatch.split(","));
        HashSet<String> uniqueWords = new HashSet<String>(list);
        for (String wordCount : uniqueWords) {
            if (Collections.frequency(list, wordCount) <= 1) continue;
            String neededStr = "." + wordCount.trim() + " ";
            inputQry = inputQry.replaceAll("(?i)#S#\\d+#E#", "");
            String[] splittedString = inputQry.split(",");
            splittedString = QueryConversionUtility.trimElementsInArray(splittedString);
            List<String> uniqueCols = Arrays.asList(splittedString);
            HashSet<String> uniqueSet = new HashSet<String>(uniqueCols);
            for (String word : uniqueSet) {
                if (!(word = word + " ").contains(neededStr)) continue;
                columnNames = this.putAliasForDotColumns(columnNames, word);
            }
        }
        return QueryConversionUtility.doRemDotOrAppendAlias(columnNames, false);
    }

    private String putAliasForDotColumns(String column, String word) {
        String columnNames = column;
        String rqdString = word.trim();
        if (rqdString.contains(".")) {
            String aliasStr = rqdString.replace(".", "_").trim();
            if (column.contains(rqdString)) {
                columnNames = column.replace(rqdString, rqdString + " " + "AS" + " " + aliasStr);
            }
        }
        return columnNames;
    }

    public void doReplaceTopFunction(String sqlQuery, Map<String, String> parserMap) {
        String topFn = parserMap.get("topfunction").trim();
        String outerQuery = null;
        String columnName = "";
        String limit = parserMap.get("limit").trim();
        outerQuery = parserMap.get("wherecondition");
        if (outerQuery.contains(";")) {
            parserMap.put("semicolon", ";");
            outerQuery = outerQuery.replace(";", "");
            parserMap.put("wherecondition", outerQuery);
        } else {
            parserMap.put("semicolon", "");
        }
        String[] topArray = topFn.split("(?i)TIES|PERCENT");
        columnName = topArray.length > 1 ? topArray[topArray.length - 1] : topFn.substring(topFn.indexOf(limit) + limit.length() + 1);
        parserMap.put("wherecondition", outerQuery);
        String aliasColumnName = parserMap.get("aliascolumnname");
        aliasColumnName = aliasColumnName.replace(topFn, columnName);
        parserMap.put("aliascolumnname", aliasColumnName);
    }

    public boolean updDelFunction(String sqlQuery, Map<String, String> parserMap) {
        boolean isUpdFn = false;
        String tables = parserMap.get("tables");
        String[] table = null;
        table = this.getTable(tables);
        isUpdFn = this.retFlagForUpd(sqlQuery, isUpdFn);
        if (QueryConversionUtility.containsCheck(tables, "from") && table.length > 0) {
            return this.getTableQry(parserMap, isUpdFn, table);
        }
        return false;
    }

    private boolean getTableQry(Map<String, String> parserMap, boolean isUpdFn, String[] table) {
        String updateTable = "";
        String tableSelector = "";
        String tables = "";
        StringBuffer tempTables = new StringBuffer(128);
        updateTable = tableSelector = table[0].substring(0, QueryConversionUtility.toLower(table[0]).indexOf("from")).trim();
        if (tableSelector.contains("#S#")) {
            tableSelector = tableSelector.replaceAll("(?i)#S#\\d+#E#", "").trim();
        }
        table[0] = table[0].substring(QueryConversionUtility.toLower(table[0]).indexOf("from") + 5);
        for (String tableName : table) {
            tableName = " " + tableName + " ";
            if (!tableSelector.isEmpty() && QueryConversionUtility.toLower(tableName).contains(" " + QueryConversionUtility.toLower(tableSelector) + " ")) {
                updateTable = updateTable.replace(tableSelector, tableName);
                tableName = "";
            }
            if (tableName.isEmpty()) continue;
            tempTables.append(tableName).append(",");
        }
        tables = this.getTempTables(isUpdFn, tables, tempTables);
        if (updateTable.trim().isEmpty()) {
            return false;
        }
        parserMap.put("table1", updateTable);
        parserMap.put("table2", tables);
        return true;
    }

    private String getTempTables(boolean isUpdFn, String tbl, StringBuffer tempTables) {
        String tables = tbl;
        if (tempTables.toString().contains(",")) {
            tempTables.deleteCharAt(tempTables.length() - 1);
            tempTables.insert(0, " ");
            if (isUpdFn) {
                tempTables.insert(0, "from");
            }
            tables = tempTables.toString();
        }
        return tables;
    }

    private boolean retFlagForUpd(String sqlQuery, boolean flag) {
        Pattern pattern;
        Matcher matcher;
        boolean isUpdFn = flag;
        if (QueryConversionUtility.containsCheck(sqlQuery, "update") && (matcher = (pattern = Pattern.compile("(?<!\\w)Update\\s", 2)).matcher(sqlQuery)).find()) {
            isUpdFn = true;
        }
        return isUpdFn;
    }

    private String[] getTable(String tables) {
        String[] table = tables.contains(",") ? tables.split(",") : new String[]{tables};
        return table;
    }

    public boolean updFunction(String sqlQuery, Map<String, String> parserMap) {
        String tables;
        String tab;
        String tableAlias = parserMap.get("tablealias");
        if (tableAlias.contains("#S#")) {
            tableAlias = " " + tableAlias.replaceAll("(?i)#S#\\d+#E#", "") + " ";
        }
        if ((tab = (tables = parserMap.get("tables")).replaceAll("(?i)from", "") + " ").contains(",")) {
            String[] tableArray = tab.split(",");
            for (int iIndex = 0; iIndex < tableArray.length; ++iIndex) {
                tableArray[iIndex] = " " + tableArray[iIndex] + " ";
                if (!tableArray[iIndex].contains(tableAlias)) continue;
                tableAlias = tableArray[iIndex];
                tableArray[iIndex] = null;
            }
            StringBuffer tempTables = new StringBuffer(128);
            tempTables.append("from").append(" ");
            for (int iIndex = 0; iIndex < tableArray.length; ++iIndex) {
                if (tableArray[iIndex] == null) continue;
                tempTables.append(tableArray[iIndex]).append(",");
            }
            tempTables.deleteCharAt(tempTables.length() - 1);
            tab = tempTables.toString();
        } else if (tab.contains(tableAlias.trim())) {
            tableAlias = tab;
            tab = "";
        } else if (!tab.trim().isEmpty()) {
            tab = "from " + tab;
        }
        parserMap.put("table1", tableAlias);
        parserMap.put("table2", tab);
        return true;
    }

    public String doReplaceDataType(String inputTableColumns) {
        String tableColumns = inputTableColumns;
        if (tableColumns.matches("(?i).*(?<!\\w)(byte|varbyte|vargraphic)(?!\\w).*")) {
            tableColumns = tableColumns.replaceAll("(?i)((?<!\\w)byte(?:\\s*?\\(.*?\\))?(?!\\w)|(?<!\\w)varbyte(?:\\s*?\\(.*?\\))?(?!\\w)|(?<!\\w)vargraphic\\s*\\(.*?\\))", "BYTEA ");
        }
        if (tableColumns.matches("(?i).*(?<!\\w)(graphic|vargraphic)(?!\\w).*")) {
            tableColumns = QueryConversionUtility.doReplaceKeywords(tableColumns, "(?i)(?<!\\w)graphic\\s*\\(\\s*\\d+\\s*\\)|character\\s*\\(\\s*\\d+\\s*\\)\\s*character\\s+set\\s+graphic|long\\s+varchar\\s+character\\s+set\\s+long\\s+vargraphic|long\\s+vargraphic|long\\s+varchar\\s+character\\s+set\\s+graphic|vargraphic\\s*\\(\\s*\\d+\\s*\\)|varchar\\s*\\(\\s*\\d+\\s*\\)\\s*character\\s+set\\s+graphic(?!\\w)");
        }
        if (tableColumns.matches("(?i).*(?<!\\w)(byteint|float|int|number|string|varchar|varying|character|period)(?!\\w).*")) {
            tableColumns = QueryConversionUtility.doReplaceKeywords(tableColumns, "(?<!\\w)byteint(?!\\w)|(?<!\\w)float(?!\\w)|(?<!\\w)int(?!\\w)|(?<!\\w)STRING(?!\\w)|(?<!\\w)number(?!\\w)|(?<!\\w)long\\s+varchar(?!\\w)|(?<!\\w)(?:char|character)\\s+varying(?!\\w)|((?<!\\w|\\/\\*\\s)character(?!\\w|\\s+varying))|(?<!\\w)period\\s*?\\(\\s*?date\\s*?\\)|(?<!\\w)period\\s*?\\(\\s*?(?:time|timestamp)\\s+with\\s+time\\s+zone\\s*?\\)");
        }
        if (tableColumns.matches("(?i).*(?<!\\w)((?:b|c)lob|period)(?!\\w).*")) {
            tableColumns = QueryConversionUtility.doReplaceKeywords(tableColumns, "(?<!\\w)(?:b|c)lob\\s*(?:\\(.*?\\))?(?!\\w)|(?<!\\w)period\\s*\\(\\s*(?:time|timestamp)\\s*(\\(\\s*\\d+\\s*\\))?\\s*\\)");
        }
        return tableColumns;
    }

    public boolean schemaFunctions(String sqlQuery, Map<String, String> parserMap) {
        LinkedHashMap<String, String> quoteMap;
        boolean keywordMatcher;
        String tableConditions = parserMap.get("tablecondition");
        String tableColumns = parserMap.get("endschema");
        if (tableConditions.contains("#S#")) {
            String tableComment = QueryConversionUtility.doGetPatternMatch("(?i)#S#\\d+#E#", tableConditions);
            tableColumns = tableComment + tableColumns;
        }
        if (QueryConversionUtility.containsCheck(tableColumns, "partition")) {
            tableColumns = QueryConversionUtility.doReplaceSpecificGrp(tableColumns, "(?i)(((?:,\\s*)?(?<!\\w)partition\\s+by)\\s+.*?)(?:\\s?ON\\s+COMMIT|;|\\s+with\\s+data|\\s+with\\s+no\\s+data|primary\\s+|unique\\s+|index\\s*\\()", "", "", 1, true);
        }
        if (keywordMatcher = (tableColumns = QueryConversionUtility.getDoubleQuoteMap(tableColumns, quoteMap = new LinkedHashMap<String, String>(10))).matches("(?i).*(?<!\\w)(CS|COMMIT|format|GENERATED|PRIMARY\\s+INDEX)(?!\\w).*")) {
            tableColumns = QueryConversionUtility.doReplaceKeyword(tableColumns, "(?i)(\\s+not)?((\\s+CS)(?!\\w)|\\s?ON\\s+COMMIT\\s+(?:DELETE|DROP)\\s+ROWS|format(?!\\w|')(\\s+)?(#S#\\d+#E#(\\s+)?)*?\\'.*?\\'|\\s*primary\\s*index(?!\\s*(\\w+\\s*)?\\()|\\s+GENERATED\\s+ALWAYS\\s+AS\\s+IDENTITY\\s*\\(.*?\\)|no\\s+primary\\s+index)", "columnFunction");
        }
        tableColumns = QueryConversionUtility.getRplFromMap(tableColumns, quoteMap, "(##QUOTE##\\d+#)");
        String setFn = parserMap.get("setFn");
        if (QueryConversionUtility.containsCheck(setFn, "volatile")) {
            String sessionRpl = FeatureLoader.getStringProperty("volatile");
            String defaultRpl = "LOCAL TEMPORARY";
            if (!sessionRpl.isEmpty() && sessionRpl.trim().equalsIgnoreCase("UNLOGGED")) {
                defaultRpl = "UNLOGGED";
                tableColumns = tableColumns.replaceAll("(?i)on\\s+commit\\s+preserve\\s+rows", "");
            }
            parserMap.put("session", defaultRpl);
        } else {
            tableColumns = tableColumns.replaceAll("(?i)on\\s+commit\\s+preserve\\s+rows", "");
        }
        quoteMap = new LinkedHashMap(10);
        tableColumns = QueryConversionUtility.getSingleDoubleQuoteMap(tableColumns, quoteMap);
        tableColumns = this.doReplaceDataType(tableColumns);
        tableColumns = QueryConversionUtility.getRplFromMap(tableColumns, quoteMap, "(##QUOTE##\\d+#)");
        parserMap.put("endschema", tableColumns);
        return true;
    }

    public void primaryIndexCheck(String sqlQuery, Map<String, String> parserMap) {
        String tableColumns = parserMap.get("endschema");
        parserMap.put("endschema", tableColumns);
        parserMap.put("primaryIndex", "");
    }

    public void schemaConditions(Map<String, String> parserMap) {
        Pattern pattern;
        Matcher matcher;
        String tableColumns = parserMap.get("endschema").trim();
        StringBuffer cmntBuf = new StringBuffer(128);
        boolean withData = false;
        if (tableColumns.matches("(?i).*(?<!\\w)with(?!\\w).*?(?<!\\w)data(?!\\w).*") && (matcher = (pattern = Pattern.compile("(?i)((?:#S#\\d+#E#\\s*)*)(?<!\\w)with(?!\\w)\\s*((?:#S#\\d+#E#\\s*)*)((?<!\\w)no(?!\\w)\\s*((?:#S#\\d+#E#\\s*)*))?(?<!\\w)data(?!\\w)\\s*((?:#S#\\d+#E#\\s*)*)((?<!\\w)and(?!\\w)\\s*((?:#S#\\d+#E#\\s*)*)(?<!\\w)(?:stats|statistics|stat)(?!\\w)\\s*((?:#S#\\d+#E#\\s*)*))?")).matcher(tableColumns)).find()) {
            cmntBuf.append(matcher.group(1)).append(matcher.group(2));
            withData = this.getCommentBuff(cmntBuf, withData, matcher);
            String tableName = this.getTableName(tableColumns, matcher);
            StringBuffer replacementTable = new StringBuffer(128);
            tableColumns = this.getReplacementTableString(tableColumns, tableName, withData, replacementTable);
            tableColumns = tableColumns.replaceAll("(?i)((?:#S#\\d+#E#\\s*)*)(?<!\\w)with(?!\\w)\\s*((?:#S#\\d+#E#\\s*)*)((?<!\\w)no(?!\\w)\\s*((?:#S#\\d+#E#\\s*)*))?(?<!\\w)data(?!\\w)\\s*((?:#S#\\d+#E#\\s*)*)((?<!\\w)and(?!\\w)\\s*((?:#S#\\d+#E#\\s*)*)(?<!\\w)(?:stats|statistics|stat)(?!\\w)\\s*((?:#S#\\d+#E#\\s*)*))?", "");
            replacementTable.append(cmntBuf);
            tableColumns = withData ? tableColumns.replace(tableName, replacementTable.toString()) : this.getTableCols(parserMap, tableColumns, tableName, replacementTable);
        }
        parserMap.put("endschema", tableColumns);
    }

    private String getTableCols(Map<String, String> parserMap, String tblCols, String tableName, StringBuffer replacementTable) {
        String tableColumns = tblCols;
        if (tableName.contains("##QUERY##")) {
            tableColumns = tableColumns.replace(";", replacementTable.toString() + ";");
        } else {
            tableColumns = QueryConversionUtility.replaceAll(tableColumns, "(?<!\\w)" + Pattern.quote(tableName) + "(?!\\w)", replacementTable.toString());
            replacementTable = new StringBuffer(128);
            String tableNmeCreate = parserMap.get("tablename");
            replacementTable.append("INSERT INTO ").append(tableNmeCreate).append(" ").append(" select * from ").append(tableName).append(";");
            tableColumns = tableColumns + replacementTable.toString();
        }
        return tableColumns;
    }

    private String getTableName(String tableColumns, Matcher matcher) {
        int startIndex = QueryConversionUtility.toUpper(tableColumns).indexOf("AS");
        int endIndex = matcher.start();
        String tableName = "";
        if (startIndex != -1) {
            tableName = tableColumns.substring(startIndex + 2, endIndex).trim();
        }
        return tableName;
    }

    private boolean getCommentBuff(StringBuffer cmntBuf, boolean withNoData, Matcher matcher) {
        if (matcher.group(3) != null) {
            withNoData = true;
            cmntBuf.append(matcher.group(4));
        }
        cmntBuf.append(matcher.group(5));
        if (matcher.group(6) != null) {
            cmntBuf.append(matcher.group(7)).append(matcher.group(8));
        }
        return withNoData;
    }

    private String getReplacementTableString(String tableColumnsInp, String tableName, boolean withNoData, StringBuffer replacementTable) {
        String tableColumns = tableColumnsInp;
        if (tableName.contains("##QUERY##")) {
            if (withNoData) {
                replacementTable.append("(").append(" select * from ").append(tableName).append(" where ").append(1).append("=").append(2).append(")");
            }
        } else {
            if (tableColumns.matches("(?i)AS(?!\\w).*")) {
                tableColumns = tableColumns.substring(2);
            }
            if (tableColumns.matches("(?i).*?(?<!\\w)PRIMARY(?!\\w).*?(?<!\\w)INDEX(?!\\w).*") && !tableColumns.matches("(?i).*?(?<!\\w)UNIQUE(?!\\w).*")) {
                this.doGetRplmentTblValForIndex(tableName, replacementTable);
            } else {
                this.doGetRplmentTblVal(tableName, replacementTable);
            }
        }
        return tableColumns;
    }

    private void doGetRplmentTblVal(String tableName, StringBuffer replacementTable) {
        replacementTable.append("(").append("LIKE").append(" ");
        replacementTable.append(tableName).append(" ").append("INCLUDING");
        replacementTable.append(" ").append(QueryConversionUtility.toUpper("all"));
        replacementTable.append(" ").append("EXCLUDING").append(" ");
        replacementTable.append(QueryConversionUtility.toUpper("partition")).append(" ");
        replacementTable.append("EXCLUDING").append(" ").append("RELOPTIONS").append(")");
    }

    private void doGetRplmentTblValForIndex(String tableName, StringBuffer replacementTable) {
        replacementTable.append("(").append("LIKE");
        replacementTable.append(" ").append(tableName).append(" ").append("INCLUDING").append(" ");
        replacementTable.append(QueryConversionUtility.toUpper("all")).append(" ").append("EXCLUDING").append(" ").append(QueryConversionUtility.toUpper("partition")).append(" ").append("EXCLUDING").append(" ");
        replacementTable.append("RELOPTIONS").append(" ").append("EXCLUDING").append(" ");
        replacementTable.append("DISTRIBUTION").append(")");
    }

    public void primaryIndexReplace(String sqlQuery, Map<String, String> parserMap) throws MigrationServiceException {
        String tableColumns = parserMap.get("endschema");
        boolean isSchemaWithQuery = QueryConversionUtility.containsCheck(tableColumns, "##QUERY##") || QueryConversionUtility.isExactMatch(tableColumns, "select") && tableColumns.matches("(?i)\\(LIKE\\s+\\w+\\s+INCLUDING\\s+ALL\\s+.*?\\).*?;\\s+INSERT\\s+INTO\\s+\\w+\\s+SELECT\\s+.*?;");
        String primaryIndex = "";
        if (tableColumns.contains("DISTRIBUTE BY HASH")) {
            int primaryStartIndex = tableColumns.indexOf("DISTRIBUTE BY HASH");
            int primaryEndIndex = tableColumns.indexOf(41, primaryStartIndex) + 1;
            if (primaryEndIndex != 0) {
                primaryIndex = tableColumns.substring(primaryStartIndex, primaryEndIndex);
                String distributeByHash = FeatureLoader.getStringProperty("distributeByHash");
                if (primaryIndex.contains(",") && !distributeByHash.isEmpty() && distributeByHash.trim().equalsIgnoreCase("one")) {
                    String primaryIndexSingleCol = primaryIndex.substring(0, primaryIndex.indexOf(44)) + ")";
                    tableColumns = tableColumns.replace(primaryIndex, primaryIndexSingleCol);
                    primaryIndex = primaryIndexSingleCol;
                }
                if (isSchemaWithQuery) {
                    tableColumns = tableColumns.replace(primaryIndex, "");
                    if (primaryIndex.contains(".")) {
                        primaryIndex = primaryIndex.substring(0, primaryIndex.indexOf(40) + 1) + primaryIndex.substring(primaryIndex.indexOf(46) + 1);
                    }
                    if (tableColumns.contains("ON COMMIT PRESERVE ROWS")) {
                        tableColumns = tableColumns.replace("ON COMMIT PRESERVE ROWS", "");
                        primaryIndex = "ON COMMIT PRESERVE ROWS " + primaryIndex;
                    }
                    parserMap.put("primaryIndex", primaryIndex);
                }
                parserMap.put("endschema", tableColumns);
            } else {
                throw new MigrationServiceException("[DSC_ERR_003_007] " + MessageLoader.getMessage("DSC_ERR_003_007"));
            }
        }
    }

    public void changePlaceholderCol(String[] placeHolderCommaArray, String[] commaArray) {
        for (int iIndex = 0; iIndex < commaArray.length; ++iIndex) {
            String normalColumn = commaArray[iIndex];
            String placeHolderColumn = null;
            placeHolderColumn = placeHolderCommaArray[iIndex].contains("#S#") ? placeHolderCommaArray[iIndex].replaceAll("(?i)#S#\\d+#E#", "") : placeHolderCommaArray[iIndex];
            if (QueryConversionUtility.equalCheck(placeHolderColumn, normalColumn)) continue;
            placeHolderCommaArray[iIndex] = placeHolderCommaArray[iIndex].replace(placeHolderColumn, normalColumn);
        }
    }

    public void dpRplNestedAliasWithColVal(String[] columnArrays, String columnToChk, String aliasNCM, String aliasToChk, String columnACM) {
        for (int iIndex = 0; iIndex < columnArrays.length; ++iIndex) {
            String column = columnArrays[iIndex].trim();
            if (aliasNCM == null && QueryConversionUtility.equalCheck(column, aliasToChk)) {
                columnArrays[iIndex] = columnACM;
                break;
            }
            if (aliasNCM == null || !QueryConversionUtility.containsCheck(column, columnToChk) || !QueryConversionUtility.containsCheck(column, aliasNCM)) continue;
            String patternString = QueryConversionUtility.doGetAliasPattern(aliasToChk);
            columnArrays[iIndex] = column = QueryConversionUtility.doReplaceSpecificGrp(" " + column + " ", patternString, "", columnACM, 1, false);
            break;
        }
    }

    public Map<String, String> doGetColWithAlias(String[] commaArray) {
        Map<String, String> normalColumnsMap = new LinkedHashMap<String, String>(10);
        String column = null;
        for (int iIndex = 0; iIndex < commaArray.length; ++iIndex) {
            column = commaArray[iIndex].trim();
            if (column.startsWith("_COLUMN__")) continue;
            normalColumnsMap = this.putColAndAliasInMap(normalColumnsMap, column);
        }
        return normalColumnsMap;
    }

    private Map<String, String> putColAndAliasInMap(Map<String, String> normalColumnsMap, String column) {
        Map<String, String> columnsMap = normalColumnsMap;
        if (column.contains(" ")) {
            String[] colArr = column.split(" ");
            String colName = null;
            String alias = null;
            if (colArr.length == 2) {
                colName = colArr[0];
                alias = colArr[1];
            } else if (colArr.length == 3) {
                colName = colArr[0];
                alias = colArr[2];
            }
            columnsMap.put(colName, alias);
        } else {
            columnsMap.put(column, null);
        }
        return columnsMap;
    }

    public String changeColumns(Map<String, String> replaceValMap, String columnNamesInp) {
        String columnNames;
        if (replaceValMap != null) {
            replaceValMap.clear();
        }
        List<String> columnArrays = null;
        LinkedHashMap<String, String> quoteMap = new LinkedHashMap<String, String>(10);
        String modifiedPlaceholderColumns = columnNames = columnNamesInp;
        if (columnNames != null && !columnNames.trim().equals("*") && !columnNames.trim().replace(" ", "").endsWith(".*")) {
            columnNames = QueryConversionUtility.getSingleDoubleQuoteMap(columnNames, quoteMap);
            ColumnSplitter splitter = new ColumnSplitter();
            columnArrays = splitter.doGetAllColumns(columnNames);
            if (!(columnArrays = CommentsHandler.replacementForQuote(columnArrays, quoteMap, "(##QUOTE##\\d+#)")).isEmpty()) {
                PlaceHolderUtility placeHolder = new PlaceHolderUtility();
                modifiedPlaceholderColumns = placeHolder.doGetPlaceholderColumns(columnArrays, replaceValMap, true, true);
            }
        }
        return modifiedPlaceholderColumns;
    }
}

