/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.teradata;

import com.huawei.db.migration.database.bo.IQueryPatternsBO;
import com.huawei.db.migration.exception.MigrationServiceException;
import com.huawei.db.migration.interfaces.IMigrationMapper;
import com.huawei.db.migration.interfaces.IReplacerMap;
import com.huawei.db.migration.teradata.TeradataMapHelper;
import com.huawei.db.migration.teradata.TeradataMapHelperAlias;
import com.huawei.db.migration.teradata.TeradataMapHelperIndex;
import com.huawei.db.migration.teradata.TeradataUtility;
import com.huawei.db.migration.teradata.TeradataUtilityExt;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TeradataMapper
implements IMigrationMapper {
    private static final Logger logger = LogManager.getLogger(TeradataMapper.class);

    @Override
    public boolean doMapping(String sqlQuery, IQueryPatternsBO mapper, IReplacerMap parserMap) {
        TeradataMapHelper objMapHelper = new TeradataMapHelper();
        TeradataMapHelperAlias aliasMapHelper = new TeradataMapHelperAlias();
        TeradataMapHelperIndex indexMapHelper = new TeradataMapHelperIndex();
        TeradataUtility objUtil = new TeradataUtility();
        boolean validationSuccess = false;
        boolean validation = false;
        List<String> constChk = mapper.getConstraintList();
        try {
            for (String chkFnName : constChk) {
                if (chkFnName.equals("doColumnSplit")) {
                    objMapHelper.doColumnSplit(mapper, parserMap);
                } else if (chkFnName.equals("changeInQualifyClause")) {
                    objMapHelper.changeInQualifyClause(parserMap);
                } else if (chkFnName.equals("changeOrderBy")) {
                    indexMapHelper.changeOrderBy(parserMap);
                } else if (chkFnName.startsWith("alias")) {
                    validationSuccess = this.handleForStartingWithAlias(chkFnName, sqlQuery, mapper, parserMap, objMapHelper);
                } else if (chkFnName.equals("topFunctionReplace")) {
                    aliasMapHelper.doReplaceTopFunction(sqlQuery, parserMap);
                } else if (chkFnName.startsWith("upd")) {
                    validationSuccess = this.handleForStartingWithUpd(chkFnName, sqlQuery, parserMap, objMapHelper, aliasMapHelper, objUtil);
                    this.mapDelete(mapper, parserMap);
                } else if (chkFnName.startsWith("schema")) {
                    validationSuccess = this.handleForStartingWithSchema(chkFnName, sqlQuery, parserMap, objMapHelper, aliasMapHelper);
                } else if (chkFnName.startsWith("primary")) {
                    validationSuccess = this.handleForStartingWithPrimary(chkFnName, sqlQuery, parserMap, objMapHelper, aliasMapHelper);
                } else if (chkFnName.equals("doGrpingFn")) {
                    validationSuccess = objMapHelper.doGrpingFn(parserMap);
                } else if (chkFnName.equals("mergeFn")) {
                    validationSuccess = indexMapHelper.mergeFn(parserMap);
                } else {
                    logger.debug("No mapper has been selected");
                }
                if (!validationSuccess) continue;
                validation = true;
            }
        }
        catch (MigrationServiceException e) {
            logger.error("Conversion for the query has been cancelled and the message is : " + e.getMessage());
            validation = false;
        }
        return validation;
    }

    private void mapDelete(IQueryPatternsBO mapper, IReplacerMap parserMap) {
        String table2;
        if ("Delete".equalsIgnoreCase(mapper.getName()) && (table2 = (String)parserMap.get("table2")) != null && table2.isEmpty()) {
            mapper.setReplacementPattern("${deletecomment}DELETE FROM ${table1} ${endquery}");
        }
    }

    private boolean handleForStartingWithUpd(String chkFnName, String sqlQuery, IReplacerMap parserMap, TeradataMapHelper objMapHelper, TeradataMapHelperAlias aliasMapHelper, TeradataUtility objUtil) {
        boolean validationSuccess = false;
        if (chkFnName.equals("updDelFunction")) {
            validationSuccess = aliasMapHelper.updDelFunction(sqlQuery, parserMap);
        } else if (chkFnName.equals("updFunction")) {
            validationSuccess = aliasMapHelper.updFunction(sqlQuery, parserMap);
        } else if (chkFnName.equals("updTableList")) {
            TeradataUtilityExt utility = new TeradataUtilityExt();
            validationSuccess = utility.tableChkInWhereClause(parserMap);
        }
        return validationSuccess;
    }

    private boolean handleForStartingWithSchema(String chkFnName, String sqlQuery, IReplacerMap parserMap, TeradataMapHelper objMapHelper, TeradataMapHelperAlias aliasMapHelper) {
        boolean validationSuccess = false;
        if (chkFnName.equals("schemaFunctions")) {
            validationSuccess = aliasMapHelper.schemaFunctions(sqlQuery, parserMap);
        } else if (chkFnName.equals("schemaConditions")) {
            aliasMapHelper.schemaConditions(parserMap);
        } else if (chkFnName.equals("schemaIndexes")) {
            objMapHelper.doReplaceConstraintsIndex(parserMap);
        }
        return validationSuccess;
    }

    private boolean handleForStartingWithAlias(String chkFnName, String sqlQuery, IQueryPatternsBO mapper, IReplacerMap parserMap, TeradataMapHelper objMapHelper) {
        boolean validationSuccess = false;
        if (chkFnName.equals("aliasColumnNamesReplacememnt")) {
            validationSuccess = objMapHelper.aliasColumnNamesReplacememnt(parserMap);
        } else if (chkFnName.equals("aliasNameUsageinWhrclause")) {
            validationSuccess = objMapHelper.aliasNameUsageinWhrclause(mapper, sqlQuery, parserMap);
        } else if (chkFnName.equals("aliasNameReplaceForQualify")) {
            validationSuccess = objMapHelper.aliasNameReplaceForQualify(mapper, sqlQuery, parserMap);
        } else if (chkFnName.equals("aliasNameUsageinQualifyRowNumRank")) {
            validationSuccess = objMapHelper.aliasNameUsageinQualifyRowNumRank(mapper, sqlQuery, parserMap);
        } else if (chkFnName.equals("aliasNameReplaceInFrom")) {
            validationSuccess = objMapHelper.aliasNameReplaceInFrom(mapper, sqlQuery, parserMap);
        }
        return validationSuccess;
    }

    private boolean handleForStartingWithPrimary(String chkFnName, String sqlQuery, IReplacerMap parserMap, TeradataMapHelper objMapHelper, TeradataMapHelperAlias aliasMapHelper) throws MigrationServiceException {
        boolean validationSuccess = false;
        if (chkFnName.equals("primaryIndexCheck")) {
            aliasMapHelper.primaryIndexCheck(sqlQuery, parserMap);
        } else if (chkFnName.equals("primaryIndexReplace")) {
            aliasMapHelper.primaryIndexReplace(sqlQuery, parserMap);
        }
        return validationSuccess;
    }
}

