/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.teradata;

import com.huawei.db.migration.database.bo.IQueryPatternsBO;
import com.huawei.db.migration.exception.MigrationServiceException;
import com.huawei.db.migration.interfaces.IMigrationParser;
import com.huawei.db.migration.interfaces.IReplacerMap;
import com.huawei.db.migration.util.ErrorLoggerUtility;
import com.huawei.db.migration.util.FeatureLoader;
import com.huawei.db.migration.util.MessageLoader;
import com.huawei.db.migration.util.QueryConversionUtility;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TeradataParser
implements IMigrationParser {
    private static final Logger logger = LogManager.getLogger(TeradataParser.class);

    @Override
    public IReplacerMap doParsing(String sqlQueryInp, IQueryPatternsBO mapper, IReplacerMap parserMap) throws MigrationServiceException {
        LinkedHashMap<String, String> overMap = new LinkedHashMap<String, String>(10);
        String sqlQuery = sqlQueryInp;
        sqlQuery = sqlQuery.replace(";", " ;");
        if (!(sqlQuery = QueryConversionUtility.canonicalizeString(sqlQuery)).endsWith(";")) {
            sqlQuery = sqlQuery + " ";
        }
        String sqlQry = QueryConversionUtility.doReplaceOverStr(sqlQuery, overMap);
        Map<String, String> tokens = mapper.getReplacementMapAtt();
        String patternName = mapper.getName();
        if ("Grouping set - ROLLUP".equalsIgnoreCase(patternName) ? !QueryConversionUtility.containsCheck(sqlQry, "ROLLUP") || !QueryConversionUtility.containsCheck(sqlQry, "GROUPING") || !QueryConversionUtility.containsCheck(sqlQry, "CUBE") : "Create VOLATILE table - basic".equalsIgnoreCase(patternName) && !QueryConversionUtility.containsCheck(sqlQry, "VOLATILE")) {
            return parserMap;
        }
        boolean isExcludePatternValidation = QueryConversionUtility.excludePatternValidation(mapper.getExcludePattern(), sqlQry);
        Pattern pattern = Pattern.compile(mapper.getFinderPattern(), 2);
        Matcher matcher = pattern.matcher(sqlQry);
        boolean groupingSets = false;
        groupingSets = FeatureLoader.getBooleanProperty("extendedGroupByClause");
        if (matcher.find() && isExcludePatternValidation && (!patternName.equals("Grouping set - ROLLUP") && !patternName.equals("Grouping set - ROLLUP with QUALIFY/TOP") || groupingSets)) {
            logger.debug("Query Pattern Match Found - Pattern Name:{}", (Object)mapper.getName());
            this.formParserMap(parserMap, matcher, tokens);
            this.changeOverMapValueInGrps(parserMap, overMap, "qualifyclause");
            this.changeOverMapValueInGrps(parserMap, overMap, "aliascolumnname");
            this.changeOverMapValueInGrps(parserMap, overMap, "rankquery");
            this.changeOverMapValueInGrps(parserMap, overMap, "from");
            this.changeOverMapValueInGrps(parserMap, overMap, "wherecondition");
            this.changeOverMapValueInGrps(parserMap, overMap, "orderBy");
            parserMap.put("sqlquery", sqlQuery);
        }
        return parserMap;
    }

    private void changeOverMapValueInGrps(IReplacerMap parserMap, Map<String, String> overMap, String key) {
        String qualifyClause = (String)parserMap.get(key);
        if (qualifyClause != null) {
            qualifyClause = QueryConversionUtility.getRplFromMap(qualifyClause, overMap, "(##OVER##\\d+#)");
            parserMap.put(key, qualifyClause);
        }
    }

    private void formParserMap(Map<String, String> parserMap, Matcher matcher, Map<String, String> tokens) {
        String key = null;
        String queryGrp = null;
        for (Map.Entry<String, String> token : tokens.entrySet()) {
            key = token.getKey();
            int group = 0;
            try {
                group = Integer.parseInt(token.getValue());
            }
            catch (NumberFormatException e) {
                logger.error(ErrorLoggerUtility.getExceptionDetails(e) + " Error while converting from string to int for value= " + token.getValue());
                throw new MigrationServiceException("[DSC_ERR_004_018] " + MessageLoader.getMessage("DSC_ERR_004_018"));
            }
            queryGrp = matcher.group(group);
            if (queryGrp != null) {
                parserMap.put(key, queryGrp.trim());
                continue;
            }
            parserMap.put(key, "");
        }
    }
}

