/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.teradata;

import com.huawei.db.migration.util.FeatureLoader;
import com.huawei.db.migration.util.QueryConversionUtility;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TeradataPartitionByComment {
    private static int commentCountValue = 2000;
    private static boolean flagRange = false;
    private static Pattern individualCols = Pattern.compile("(?i)(.*?)(?:(?<!\\w)and(?!\\w)(.*?))?(?:$|(?<!\\w)each(?!w)(.*?$))");
    private static Pattern rangeNPattern = Pattern.compile("(?i)((?<!w)range_n(?!w)\\s*\\(\\s*(\\w+).*?(?<!w)between(?!w)(.*?(?<!w)and(?!w).*?(?<!w)each(?!w).*?)\\))");
    private static final Pattern SEP_BY_COMMAS = Pattern.compile("(?i)((?<!w)range_n(?!w)\\s*\\(\\s*(\\w+)\\s+between\\s+(.*?)\\))");

    public static String doHandleCommentPartition(String input, Map<String, String> multiCommentMap, String migrationType) {
        String output = input;
        if (QueryConversionUtility.containsCheck(input, "partition")) {
            LinkedHashMap<String, String> queryMap = new LinkedHashMap<String, String>(10);
            if ("Schema with Query".equalsIgnoreCase(migrationType)) {
                input = QueryConversionUtility.doGetSchemaQueries(input, queryMap, 0);
            }
            if ((output = TeradataPartitionByComment.doCommentPartition(input, multiCommentMap, migrationType)).contains("##QUERY##")) {
                output = QueryConversionUtility.doReplaceFunctionVariables(output, queryMap, "##QUERY##");
            }
        }
        return output;
    }

    private static String doCommentPartition(String input, Map<String, String> multiCommentMap, String migrationType) {
        String output = input;
        if ("schema".equalsIgnoreCase(migrationType) || "Schema with Query".equalsIgnoreCase(migrationType)) {
            Pattern pattern = Pattern.compile("(?i)((?<!\\w)partition\\s+by\\s*(.*?\\s*(\\(?\\s*range_n\\s*\\(.*?\\)\\s*\\,?\\s*\\)?)?(\\(?\\s*case_n\\s*\\(.*?\\)\\s*\\,?\\s*\\)?)?(range_n\\s*\\(.*?\\)\\s*\\)?)?\\s*))(?:ON\\s+COMMIT|;|\\s+with\\s+data|\\s+with\\s+no\\s+data|primary\\s+|unique\\s+|index\\s*\\()");
            Matcher matcher = pattern.matcher(input);
            if (matcher.find() && (matcher.group(3) != null || matcher.group(4) != null || matcher.group(5) != null)) {
                String[] colArr = matcher.group(2).split(",(?![^(]*\\))");
                output = TeradataPartitionByComment.getMigratedOutput(multiCommentMap, output, matcher, colArr);
            } else {
                output = TeradataPartitionByComment.doAddcomments(input, multiCommentMap, output, "(?i)(((?:,\\s*)?(?<!\\w)partition\\s+by)\\s+.*?)(?:\\s?ON\\s+COMMIT|;|\\s+with\\s+data|\\s+with\\s+no\\s+data|primary\\s+|unique\\s+|index\\s*\\()", 1000);
            }
        }
        return output;
    }

    private static String getMigratedOutput(Map<String, String> multiCommentMap, String input, Matcher matcher, String[] column) {
        String output = input;
        String caseNGroup = null;
        String rangeNGroup = null;
        boolean caseNFlag = true;
        boolean rangeNFlag = true;
        int length = column.length;
        int stringCount = 0;
        for (String col : column) {
            if (length > 1 && stringCount < length - 1) {
                col = col + ",";
            }
            if (caseNFlag && QueryConversionUtility.toLower(col).contains("case_n")) {
                caseNGroup = col;
                if ("comment".equalsIgnoreCase(FeatureLoader.getStringProperty("tdMigrateCASE_N"))) {
                    output = TeradataPartitionByComment.doCommentCaseNOutput(multiCommentMap, col, output);
                    caseNFlag = false;
                }
            } else if (rangeNFlag && QueryConversionUtility.toLower(col).contains("range_n")) {
                rangeNGroup = col;
                if ("comment".equalsIgnoreCase(FeatureLoader.getStringProperty("tdMigrateRANGE_N"))) {
                    output = TeradataPartitionByComment.doCommentRangeNOutput(multiCommentMap, col, output);
                    rangeNFlag = false;
                } else if ("range".equalsIgnoreCase(FeatureLoader.getStringProperty("tdMigrateRANGE_N"))) {
                    output = TeradataPartitionByComment.doMigrateRangeNOutput(col, output);
                    if (flagRange) {
                        output = TeradataPartitionByComment.doCommentRangeNOutput(multiCommentMap, col, output);
                    }
                    rangeNFlag = false;
                }
            } else {
                output = TeradataPartitionByComment.doCommentColumn(col, multiCommentMap, output);
            }
            ++stringCount;
        }
        output = TeradataPartitionByComment.doAddPartitionComment(multiCommentMap, output, caseNGroup, rangeNGroup);
        flagRange = false;
        return output;
    }

    private static String doCommentColumn(String col, Map<String, String> multiCommentMap, String output) {
        String columnCommented = "/* " + col + " " + "*/";
        String comment = "#S# " + commentCountValue + " " + "#E#";
        output = output.replace(col, comment);
        multiCommentMap.put(comment, columnCommented);
        ++commentCountValue;
        return output;
    }

    private static String doCommentCaseNOutput(Map<String, String> multiCommentMap, String caseNGroup, String output) {
        if (caseNGroup != null) {
            String groupFourCaseCommented = "/* " + caseNGroup + " " + "*/";
            String comment = "#S# " + commentCountValue + " " + "#E#";
            output = output.replace(caseNGroup, comment);
            multiCommentMap.put(comment, groupFourCaseCommented);
            ++commentCountValue;
        }
        return output;
    }

    private static String doCommentRangeNOutput(Map<String, String> multiCommentMap, String rangeNGroup, String output) {
        if (rangeNGroup != null) {
            String groupRangeCommented = "/* " + rangeNGroup + " " + "*/";
            String comment = "#S#" + commentCountValue + "#E#";
            output = output.replace(rangeNGroup, comment);
            multiCommentMap.put(comment, groupRangeCommented);
            ++commentCountValue;
        }
        return output;
    }

    private static String doMigrateRangeNOutput(String rangeNGroup, String output) {
        if (rangeNGroup != null) {
            output = TeradataPartitionByComment.doMigrateRangen(output, rangeNGroup);
        }
        return output;
    }

    private static String doMigrateRangen(String input, String rangePartition) {
        Matcher matcher = rangeNPattern.matcher(input);
        String sb = input;
        String tableName = QueryConversionUtility.getTableName(input);
        sb = matcher.find() && !sb.matches("(?i)(?<!\\w)create\\s*multiset\\s*volatile\\s*table.*?;") ? TeradataPartitionByComment.migrateRangeNWithStartAndEndDate(rangePartition, matcher, sb, tableName) : TeradataPartitionByComment.rangeNForDateWithInteger(rangePartition, sb, tableName);
        return sb;
    }

    private static String rangeNForDateWithInteger(String rangePartition, String buffer, String tableName) {
        String sb = buffer;
        Matcher sepByCommasMatch = SEP_BY_COMMAS.matcher(rangePartition);
        if (sepByCommasMatch.find() && sepByCommasMatch.group(3).trim().startsWith("*") && sepByCommasMatch.group(3).trim().endsWith("*")) {
            String entryRangeData = "range (" + sepByCommasMatch.group(2) + ")" + " (";
            String startToEndDate = sepByCommasMatch.group(3).trim();
            startToEndDate = startToEndDate.replace(" AND", ",");
            String[] commaSplitArrays = QueryConversionUtility.doGetArrSplit(startToEndDate, ",");
            int length = commaSplitArrays.length;
            String tempTableName = "";
            String endDate = "";
            String appenStr = "";
            ArrayList<String> appendedList = new ArrayList<String>();
            for (int i = 1; i < length; ++i) {
                tempTableName = "partition " + tableName + "_" + i + " ";
                endDate = commaSplitArrays[i].trim().equals("*") ? "end(MAXVALUE)" : "end(" + commaSplitArrays[i].trim() + ")";
                appenStr = tempTableName + endDate;
                tempTableName = "";
                appendedList.add(appenStr);
            }
            appenStr = String.join((CharSequence)",", appendedList) + ")";
            String rangeMigratedStr = entryRangeData + tempTableName + appenStr;
            sb = sb.replace(rangePartition, rangeMigratedStr);
        } else {
            flagRange = true;
        }
        return sb;
    }

    private static String migrateRangeNWithStartAndEndDate(String rangePartition, Matcher matcher, String buffer, String tblNme) {
        String tableName = tblNme;
        tableName = tableName.substring(tableName.indexOf(".") + 1, tableName.length());
        String startToEndDate = matcher.group(3);
        String[] commaSplitArrays = QueryConversionUtility.doGetArrSplit(startToEndDate, ",");
        ArrayList<String> startDateList = new ArrayList<String>();
        ArrayList<String> endDateList = new ArrayList<String>();
        ArrayList<String> intervalList = new ArrayList<String>();
        int length = commaSplitArrays.length;
        String appenStr = "";
        for (int i = 0; i < commaSplitArrays.length; ++i) {
            String eachCol = commaSplitArrays[i].trim();
            if (QueryConversionUtility.containsCheck(eachCol, "NO RANGE") || QueryConversionUtility.containsCheck(eachCol, "UNKNOWN")) {
                --length;
                continue;
            }
            Matcher individualColsMatch = individualCols.matcher(eachCol);
            if (!individualColsMatch.find()) continue;
            TeradataPartitionByComment.getStartDateList(startDateList, i, individualColsMatch);
            TeradataPartitionByComment.getEndDateList(endDateList, individualColsMatch);
            TeradataPartitionByComment.getIntervalList(intervalList, individualColsMatch);
        }
        String updStartDate = "";
        String updEndDate = "";
        String tempTableName = "";
        ArrayList<String> appendedList = new ArrayList<String>();
        for (int i = 0; i < length; ++i) {
            tempTableName = "partition " + tableName + "_" + i;
            if (i == 0) {
                updStartDate = " start (" + (String)startDateList.get(i) + ")";
                updEndDate = "end(" + (String)endDateList.get(i) + ")";
            } else {
                updStartDate = TeradataPartitionByComment.updStartDateWithPrevEndDate(startDateList, endDateList, i);
                updEndDate = TeradataPartitionByComment.updEndDateWithNextStartDate(startDateList, endDateList, i);
            }
            String eachInterval = TeradataPartitionByComment.getIntervalForEachCol(intervalList, i);
            appenStr = tempTableName + updStartDate + updEndDate + eachInterval;
            tempTableName = "";
            appendedList.add(appenStr);
        }
        appenStr = String.join((CharSequence)",", appendedList) + ")";
        return TeradataPartitionByComment.getTheRplString(rangePartition, buffer, "range (" + matcher.group(2) + ")" + " (" + tempTableName + appenStr);
    }

    private static String getTheRplString(String rangePartition, String buffer, String rangeMigratedStr) {
        String sb = buffer;
        sb = sb.replace(rangePartition, rangeMigratedStr);
        return sb;
    }

    private static String getIntervalForEachCol(List<String> intervalList, int i) {
        int index = intervalList.get(i).indexOf(",");
        String eachInterval = "";
        if (!intervalList.get(i).isEmpty()) {
            eachInterval = index != -1 ? " every (" + intervalList.get(i).substring(0, index) + ")" + ")" : " every (" + intervalList.get(i) + ")";
        }
        return eachInterval;
    }

    private static String updEndDateWithNextStartDate(List<String> startDateList, List<String> endDateList, int i) {
        String updEndDate = endDateList.get(i).isEmpty() ? "end(" + startDateList.get(i + 1) + ")" : "end(" + endDateList.get(i) + ")";
        return updEndDate;
    }

    private static String updStartDateWithPrevEndDate(List<String> startDateList, List<String> endDateList, int i) {
        String updStartDate = !endDateList.get(i - 1).isEmpty() ? " start (" + endDateList.get(i - 1) + ")" : " start (" + startDateList.get(i) + ")";
        return updStartDate;
    }

    private static void getIntervalList(List<String> intervalList, Matcher individualColsMatch) {
        if (null != individualColsMatch.group(3)) {
            intervalList.add(individualColsMatch.group(3));
        } else {
            intervalList.add("");
        }
    }

    private static void getStartDateList(List<String> startDateList, int i, Matcher individualColsMatch) {
        if (i == 0 && individualColsMatch.group(1).trim().endsWith("*")) {
            startDateList.add("DATE '0001-01-01'");
        } else {
            startDateList.add(individualColsMatch.group(1));
        }
    }

    private static void getEndDateList(List<String> endDateList, Matcher individualColsMatch) {
        if (null != individualColsMatch.group(2)) {
            if (individualColsMatch.group(2).trim().equals("*")) {
                endDateList.add("MAXVALUE");
            } else {
                endDateList.add(individualColsMatch.group(2));
            }
        } else {
            endDateList.add("");
        }
    }

    private static String doAddPartitionComment(Map<String, String> multiCommentMap, String output, String caseNGroup, String rangeNGroup) {
        Matcher matcherStr;
        boolean sCondition;
        boolean fCondition = caseNGroup == null || "comment".equalsIgnoreCase(FeatureLoader.getStringProperty("tdMigrateCASE_N"));
        boolean bl = sCondition = rangeNGroup == null || "comment".equalsIgnoreCase(FeatureLoader.getStringProperty("tdMigrateRANGE_N")) || flagRange;
        if (fCondition && sCondition && (matcherStr = Pattern.compile("(?i)(((?:,\\s*)?(?<!\\w)partition\\s+by)\\s+.*?)(?:\\s?ON\\s+COMMIT|;|\\s+with\\s+data|\\s+with\\s+no\\s+data|primary\\s+|unique\\s+|index\\s*\\()").matcher(output)).find()) {
            String groupTwoCase = matcherStr.group(2);
            String groupTwoCommented = "/* " + groupTwoCase + " " + "*/";
            String comment = "#S# " + commentCountValue + " " + "#E#";
            output = output.replace(groupTwoCase, comment);
            multiCommentMap.put(comment, groupTwoCommented);
            ++commentCountValue;
        }
        return output;
    }

    private static String doAddcomments(String input, Map<String, String> multiCommentMap, String outputInp, String pattrn, int commentCountInp) {
        String output = outputInp;
        int commentCount = commentCountInp;
        output = QueryConversionUtility.canonicalizeString(output);
        Pattern pattern = Pattern.compile(pattrn, 2);
        Matcher matcher = pattern.matcher(output);
        int tempEnd = 0;
        StringBuffer sb = new StringBuffer();
        String replaceStr = null;
        while (matcher.find()) {
            String grpValue = matcher.group(1);
            replaceStr = commentCount == 1000 || commentCount == 10000 ? "/* " + grpValue + " " + "*/" : grpValue;
            if (grpValue == null) continue;
            int startindex = matcher.start(1);
            int endIndex = matcher.end(1);
            sb.append(input.substring(tempEnd, startindex));
            String comment = "#S#" + commentCount + "#E#";
            multiCommentMap.put(comment, replaceStr);
            sb.append(comment);
            tempEnd = endIndex;
            ++commentCount;
        }
        sb.append(input.substring(tempEnd));
        output = sb.toString();
        return output;
    }
}

