/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.teradata;

import com.huawei.db.migration.exception.MigrationServiceException;
import com.huawei.db.migration.services.TeradataMigrationService;
import com.huawei.db.migration.teradata.TeradataBulkHandler;
import com.huawei.db.migration.teradata.TeradataPatternHandler;
import com.huawei.db.migration.teradata.TeradataQueryKeywordReplacer;
import com.huawei.db.migration.util.ErrorLoggerUtility;
import com.huawei.db.migration.util.FeatureLoaderExtended;
import com.huawei.db.migration.util.MessageLoader;
import com.huawei.db.migration.util.ProgressUtil;
import com.huawei.db.migration.util.QueryConversionUtility;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TeradataQueryHandler {
    private static final Logger TERADATA_LOGGER = LogManager.getLogger(TeradataQueryHandler.class);
    private static final Pattern UPD_OR_DEL = Pattern.compile("(?i)(?<!\\w)(update|delete\\s+from)\\s+(\\w+(?:\\.\\w+)?)(.*?)where(.*?);");

    public List<String> doMigProcess(List<String> inputList, String fileName, List<?> patterns, List<?> splitterPatterns) throws MigrationServiceException {
        TeradataPatternHandler objPatternHandler = new TeradataPatternHandler();
        ArrayList<String> outputList = new ArrayList<String>(10);
        objPatternHandler.setFileName(fileName);
        int position = 0;
        for (String inputSQL : inputList) {
            String[] inputQry;
            ++position;
            if ((inputSQL = QueryConversionUtility.canonicalizeString(inputSQL)).contains("~#~") && (inputQry = inputSQL.split("~#~")).length > 1) {
                inputSQL = inputQry[0];
                position = this.execTryCatch(inputQry);
            }
            String output = inputSQL;
            String forInput = QueryConversionUtility.doRemoveExtraSpace(inputSQL);
            boolean isProperInput = true;
            String unSupportedQryCheck = this.supportedValidator(forInput);
            if (!TeradataBulkHandler.isBulkHandlerFlag()) {
                isProperInput = QueryConversionUtility.preQueryValidator(inputSQL);
            }
            if (unSupportedQryCheck.equals(forInput) && isProperInput) {
                HashMap<String, String> commentMap = new HashMap<String, String>(10);
                forInput = this.getOutQry(commentMap, forInput);
                output = objPatternHandler.doSplit(forInput, patterns, splitterPatterns, position);
                output = QueryConversionUtility.getRplFromMap(output, commentMap, "(##COMMENT##\\d+#)");
                if (!this.postQueryValidator(output = TeradataQueryKeywordReplacer.doPostQueryReplacement(output))) {
                    output = inputSQL;
                    TERADATA_LOGGER.error("DSC_ERR_004_041" + MessageLoader.getMessage("postValidationInfo"), (Object)fileName, (Object)" ", (Object)MessageLoader.getMessage("queryPosInfo"), (Object)position);
                }
            }
            outputList.add(output);
            ProgressUtil.printProgress();
        }
        return outputList;
    }

    private String getOutQry(Map<String, String> commentMap, String forInput) {
        forInput = this.preQueryProcess(forInput);
        if (FeatureLoaderExtended.getBooleanProperty("dsqlSupport")) {
            Map<String, String> partTable = TeradataMigrationService.getDSQLScriptFilePath();
            Map<String, String> viewTable = TeradataMigrationService.getCreateTypeMap();
            forInput = TeradataQueryHandler.viewForDML(forInput, partTable, viewTable);
        }
        forInput = QueryConversionUtility.getSingleOrDoubleQuoteMap(forInput, commentMap, "/*", "\\/\\*.*?\\*\\/", "##COMMENT##");
        forInput = TeradataQueryKeywordReplacer.doPreQueryReplacement(forInput);
        return forInput;
    }

    private int execTryCatch(String[] inputQry) {
        int postion = 0;
        try {
            postion = Integer.parseInt(inputQry[1].trim());
        }
        catch (NumberFormatException e) {
            TERADATA_LOGGER.error(ErrorLoggerUtility.getExceptionDetails(e) + " Error while converting from string to int for value= " + inputQry[1].trim());
            throw new MigrationServiceException("[DSC_ERR_004_018] " + MessageLoader.getMessage("DSC_ERR_004_018"));
        }
        return postion;
    }

    public static String viewForDML(String input, Map<String, String> partTable, Map<String, String> viewTable) {
        String forInput = input;
        forInput = TeradataQueryHandler.getEnvVar(forInput, partTable);
        forInput = TeradataQueryHandler.getDMLInsert(forInput, viewTable);
        forInput = TeradataQueryHandler.getDMLUpdAndDel(forInput, viewTable);
        return forInput;
    }

    public static String getDMLUpdAndDel(String input, Map<String, String> viewTable) {
        String forInput = input;
        Matcher updOrDelMatch = UPD_OR_DEL.matcher(forInput);
        String schemaName = "";
        String beforeWhere = "";
        int startIdx = 0;
        int endIdx = 0;
        if (updOrDelMatch.find()) {
            startIdx = updOrDelMatch.start();
            endIdx = updOrDelMatch.end();
            schemaName = updOrDelMatch.group(2);
            beforeWhere = updOrDelMatch.group(3);
            String whereClause = "";
            String tableName = "";
            for (Map.Entry<String, String> entry : viewTable.entrySet()) {
                if (entry.getKey().equalsIgnoreCase(schemaName + "__TABLE__DSQL__")) {
                    tableName = entry.getValue();
                }
                if (!entry.getKey().equalsIgnoreCase(schemaName + "_WHERE")) continue;
                whereClause = entry.getValue();
            }
            StringBuffer sb = new StringBuffer();
            sb.append(forInput.substring(0, startIdx));
            sb.append(updOrDelMatch.group(1)).append(" ");
            if (tableName.isEmpty()) {
                sb.append(schemaName);
            } else {
                sb.append(tableName);
            }
            String whereClass = updOrDelMatch.group(4);
            sb.append(" ").append(beforeWhere).append("WHERE").append(" ").append(whereClass);
            if (!whereClause.isEmpty()) {
                sb.append(" AND ").append(whereClause);
            }
            sb.append(";").append(forInput.substring(endIdx));
            forInput = sb.toString();
        }
        return forInput;
    }

    public static String getEnvVar(String input, Map<String, String> partTable) {
        String forInput = input;
        Pattern schName = Pattern.compile("(?i)(?<!\\w)(?:(?:insert\\s+into)|update|(?:delete\\s+from))\\s+(\\$\\{\\s*(\\w+)\\s*\\})");
        Matcher schNameMatch = schName.matcher(forInput);
        String schema = "";
        if (schNameMatch.find()) {
            schema = schNameMatch.group(2);
            for (Map.Entry<String, String> entry : partTable.entrySet()) {
                if (!entry.getKey().equalsIgnoreCase(schema)) continue;
                forInput = forInput.replace(schNameMatch.group(1), schema);
            }
        }
        return forInput;
    }

    public static String getDMLInsert(String input, Map<String, String> viewTable) {
        String forInput = input;
        Pattern insInto = Pattern.compile("(?i)(?<!\\w)insert\\s+into\\s+(\\w+(?:\\.\\w+)?)\\s*(\\(.*?\\)).*?((?<!\\w)values(?!\\w).*?);");
        Matcher insIntoMatch = insInto.matcher(forInput);
        String schemaName = "";
        String colName = "";
        int startIdx = 0;
        int endIdx = 0;
        if (insIntoMatch.find()) {
            startIdx = insIntoMatch.start();
            endIdx = insIntoMatch.end();
            schemaName = insIntoMatch.group(1);
            colName = insIntoMatch.group(2);
            String values = insIntoMatch.group(3);
            String tableName = "";
            String whereClause = "";
            for (Map.Entry<String, String> entry : viewTable.entrySet()) {
                if (entry.getKey().equalsIgnoreCase(schemaName + "__TABLE__DSQL__")) {
                    tableName = entry.getValue();
                }
                if (!entry.getKey().equalsIgnoreCase(schemaName + "_WHERE")) continue;
                whereClause = entry.getValue();
            }
            StringBuffer sb = new StringBuffer();
            if (!tableName.isEmpty()) {
                sb.append(forInput.substring(0, startIdx));
                sb.append("WITH ins_view ").append(colName).append(" AS (").append(values).append(")").append(" ").append("INSERT INTO ").append(tableName).append(" ").append(colName).append(" ").append("SELECT * FROM ins_view");
                if (!whereClause.isEmpty()) {
                    sb.append(" WHERE ").append(whereClause);
                }
                sb.append(";").append(forInput.substring(endIdx));
                forInput = sb.toString();
            }
        }
        return forInput;
    }

    private String preQueryProcess(String input) {
        String inputSQL = input;
        if (!TeradataBulkHandler.isBulkHandlerFlag()) {
            inputSQL = TeradataQueryKeywordReplacer.doPreChangesOnInput(input);
        }
        return inputSQL;
    }

    private boolean postQueryValidator(String outputQuery) {
        Pattern pattern;
        Matcher matcher;
        boolean isValid = true;
        String input = outputQuery;
        if (QueryConversionUtility.toLower(input).contains("qualify ") && (matcher = (pattern = Pattern.compile("(?i)(?<!\\w)Qualify\\s+")).matcher(input)).find()) {
            isValid = false;
        }
        return isValid;
    }

    private String supportedValidator(String inputQuery) {
        String output = QueryConversionUtility.isExcludePatternFound(inputQuery, "(?<!\\w)(NORMALIZE\\s|KURTOSIS\\s*\\(|SKEW\\s*\\(|MAVG\\s*\\(|QUANTILE\\s*\\(|MLINREG\\s*\\(|PERCENT_RANK\\s*\\(|CUME_DIST\\s*\\(|LDIFF\\s|RDIFF\\s|RANDOM\\s*\\(\\s*\\w)");
        return output;
    }
}

