/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.teradata;

import com.huawei.db.migration.database.bo.IIndexConstraintsBO;
import com.huawei.db.migration.exception.MigrationServiceException;
import com.huawei.db.migration.replacer.ReplacerMap;
import com.huawei.db.migration.services.TeradataMigrationService;
import com.huawei.db.migration.teradata.FindFormatUtility;
import com.huawei.db.migration.teradata.TeradataDateFormatUtility;
import com.huawei.db.migration.teradata.TeradataMapHelperAlias;
import com.huawei.db.migration.teradata.TeradataTimeUtility;
import com.huawei.db.migration.teradata.TeradataUtility;
import com.huawei.db.migration.teradata.TitleNamedUtility;
import com.huawei.db.migration.util.ColumnSplitter;
import com.huawei.db.migration.util.DBPropertyLoader;
import com.huawei.db.migration.util.ErrorLoggerUtility;
import com.huawei.db.migration.util.FeatureLoader;
import com.huawei.db.migration.util.IGaussDBConstants;
import com.huawei.db.migration.util.MessageLoader;
import com.huawei.db.migration.util.QueryConversionUtility;
import com.huawei.db.migration.util.QueryUtilityExt;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TeradataQueryKeywordReplacer {
    private static final Logger logger = LogManager.getLogger(TeradataQueryKeywordReplacer.class);
    private static final Pattern REMOVE_TITLE = Pattern.compile("(?i)(\\(\\s*title\\s+(?:\\'.*?\\'|##QUOTE##\\d+#)\\s*\\)\\s*)as");
    private static final Pattern DATA_TYPE_PAT = Pattern.compile("(.*?)\\(\\s*CHAR\\s*\\(\\d+\\s*\\)\\s*\\)");
    private static final Pattern COL_PAT = Pattern.compile("(?i)(?<!\\w)select(?!\\w)(.*?)(?<!\\w)from(?!\\w).*?$");
    private static final Pattern MOD_PAT = Pattern.compile("(?i)mod\\s*\\(");
    private static final Pattern ADD_TBL_OR_VIEW = Pattern.compile("(?i)(?<!\\w)COMMENT\\s+on\\s+(\\w+(?:\\.\\w+(?:\\.(\\w+))?)?)\\s+is.*?;");
    private static final Pattern DATE_FORMAT_PAT = Pattern.compile("(?i)(\"?\\s*#?\\w+\\s*\"?)\\s+date\\s+(format\\s+)('.*?')");
    private static final Pattern TILL_KEY = Pattern.compile("(?i)(.*?)\\(\\s*(date|integer)\\s*\\).*?;");
    private static final Pattern SELECT_FROM_PAT = Pattern.compile("(?i)(?<!\\w)select(?!\\w)(.*?)(?<!\\w)from(?!\\w).*?");
    private static final Pattern DATE_AS_CAST = Pattern.compile("(?i)(.*?)\\(\\s*(?:date|integer)\\s*\\).*");
    private static final Pattern PATTERN_DATE = Pattern.compile("(?i)(?<!\\w)format(?!\\w)(\\s*)?((#S#\\d+#E#\\s*)*)?'.*?'");
    private static final Pattern CONSTRAINT_PAT = Pattern.compile("(?i).*?(?<!\\w)(CONSTRAINT(?!\\w).*)");
    private static final Pattern JOIN_PAT = Pattern.compile("(?i).*?((?<!\\w)(?:inner|left|right|self|cross|full|outer|join)(?!\\w).*)");
    private static final Pattern PATTERN_SAMPLE = Pattern.compile("(?i)(sample\\s+\\d+)");
    private static final Pattern PATTERN_COLL_STAT = Pattern.compile("(?i)(?<!\\w)(?:column|index)(?!\\w)\\s*(?:\\(|\\s*)(.*?)(?:\\)|(?<!\\w)on)");
    private static final Pattern PATTERN_ON = Pattern.compile("(?i)(?:on\\s)(.*)");
    private static final Pattern SET_END_PAT = Pattern.compile("(?i).*(..SET\\s+(\\w+))(.*?)(?:;|\\.\\.end(?!\\w))");
    private static final Pattern DATE_FUNCTION_PAT = Pattern.compile("(?i)((\\'?\\$\\s*\\{\\s*\\w+\\s*\\}\\s*\\'?)\\s*-\\s*\\d+)");
    private static final Pattern GET_COL_PAT = Pattern.compile("(?i)create.*?table.*?\\((.*)\\).*?;");
    private String columnForConstraint;
    private String columnWOCmntForConstraint;
    private int uniqueCntForConstraint;
    private boolean isPrimaryKeyForCons;
    private String primaryColumnForCons;

    public static String doPreQueryReplacement(String input) throws MigrationServiceException {
        String inputSql = input;
        if (inputSql.contains("||")) {
            inputSql = TeradataQueryKeywordReplacer.concatPriority(inputSql);
        }
        inputSql = TeradataQueryKeywordReplacer.isNotInImpl(input, inputSql);
        inputSql = TeradataQueryKeywordReplacer.doChangeCollectStat(input, inputSql);
        LinkedHashMap<String, String> quoteMap = new LinkedHashMap<String, String>(10);
        Matcher removeTitleMatcher = REMOVE_TITLE.matcher(inputSql = QueryConversionUtility.getSingleDoubleQuoteMap(inputSql, quoteMap));
        if (removeTitleMatcher.find()) {
            String title = removeTitleMatcher.group(1);
            inputSql = inputSql.replace(title, "");
        }
        TitleNamedUtility titleUtility = new TitleNamedUtility();
        inputSql = titleUtility.doChangeNamedAlias(inputSql, quoteMap);
        String inputSqlLower = QueryConversionUtility.toLower(input);
        inputSql = TeradataQueryKeywordReplacer.changeAllKeyword(inputSql, inputSqlLower);
        inputSql = TeradataQueryKeywordReplacer.changeModFunction(inputSql, inputSqlLower);
        inputSql = TeradataQueryKeywordReplacer.doModifyModFun(inputSql, inputSqlLower);
        inputSql = TeradataQueryKeywordReplacer.changeCharToLength(inputSql, inputSqlLower);
        inputSql = TeradataQueryKeywordReplacer.changeIndexFunction(inputSql, inputSqlLower);
        inputSql = TeradataQueryKeywordReplacer.changeReplaceFunction(inputSql, inputSqlLower);
        inputSql = TeradataQueryKeywordReplacer.changeDecimal(inputSql, inputSqlLower);
        inputSql = TeradataQueryKeywordReplacer.addZeroInDecimal(inputSql);
        inputSql = QueryConversionUtility.getRplFromMap(inputSql, quoteMap, "(##QUOTE##\\d+#)");
        quoteMap = new LinkedHashMap(10);
        inputSql = QueryConversionUtility.getDoubleQuoteMap(inputSql, quoteMap);
        inputSql = inputSql.replaceAll("(?i)(TIMESTAMP)\\s*+(\\'[\\w-\\s:]*\\')", "CAST ($2 AS $1)");
        TeradataDateFormatUtility formatUtil = new TeradataDateFormatUtility("query");
        inputSql = formatUtil.changeDateFormatFns(inputSql);
        inputSql = TeradataQueryKeywordReplacer.changeCastAsInterval(inputSql);
        inputSql = TeradataQueryKeywordReplacer.doHandleTimeFormat(inputSql);
        inputSql = QueryConversionUtility.getRplFromMap(inputSql, quoteMap, "(##QUOTE##\\d+#)");
        return inputSql;
    }

    private static String concatPriority(String input) {
        String inputSql = input;
        ColumnSplitter split = new ColumnSplitter();
        Matcher colPatMatch = COL_PAT.matcher(inputSql);
        StringBuffer sb = new StringBuffer();
        String column = "";
        int tempIdx = 0;
        int endIdx = 0;
        if (colPatMatch.find()) {
            column = colPatMatch.group(1).trim();
            List<String> colFrom = split.doGetAllColumns(column);
            String updCol = "";
            for (String col : colFrom) {
                if (!col.contains("||")) continue;
                String col1 = "";
                Matcher dataTypeMatch = DATA_TYPE_PAT.matcher(col);
                while (dataTypeMatch.find()) {
                    tempIdx = dataTypeMatch.end(1);
                    endIdx = dataTypeMatch.end();
                    int count = QueryConversionUtility.doChkBracketCnt(dataTypeMatch.group(1));
                    if (count == 0 && !dataTypeMatch.group(1).startsWith(")")) {
                        col1 = "(" + dataTypeMatch.group(1) + ")";
                        col1 = col1 + col.substring(tempIdx, endIdx);
                        sb.append(col1);
                        tempIdx = endIdx;
                        continue;
                    }
                    sb.append(dataTypeMatch.group(1)).append(col.substring(tempIdx, endIdx));
                }
                sb.append(col.substring(endIdx));
                updCol = sb.toString();
                sb.setLength(0);
                inputSql = inputSql.replace(col, updCol);
            }
        }
        return inputSql;
    }

    private static String doHandleTimeFormat(String inputSql) {
        Pattern timeFormat = Pattern.compile("(?i)cast\\s*\\(\\s*((?:\\'\\d+:\\d{2}:\\d{2}\\')|(?:\\'\\$\\{)?\\w+(?:\\.\\w+)?(?:\\}\\')?)\\s+(as\\s+time)\\s+format\\s+(\\'.*?\\'\\s*\\))");
        Matcher timeFormatMatcher = timeFormat.matcher(inputSql);
        StringBuffer sb = new StringBuffer(128);
        int startIdx = 0;
        while (timeFormatMatcher.find()) {
            String variable = timeFormatMatcher.group(1);
            String asTime = timeFormatMatcher.group(2);
            String timeFor = timeFormatMatcher.group(3);
            timeFor = QueryConversionUtility.toUpper(timeFor);
            timeFor = QueryConversionUtility.replace(timeFor, "HH", "HH24", true);
            int tempIdx = timeFormatMatcher.start(1);
            int endIdx = timeFormatMatcher.end(3);
            sb.append(inputSql.substring(startIdx, tempIdx));
            sb.append("TO_TIMESTAMP(").append(variable).append(",");
            sb.append(" ").append(timeFor).append(" ");
            sb.append(asTime).append(")");
            startIdx = endIdx;
        }
        sb.append(inputSql.substring(startIdx));
        inputSql = sb.toString();
        return inputSql;
    }

    private static String changeCastAsInterval(String inputSql) {
        String input = inputSql;
        Pattern castPattern = Pattern.compile("(?i)\\-\\s*(?:#S#\\d+#E#\\s*)*(?<!\\w)cast(?!\\w)\\s*(?:#S#\\d+#E#\\s*)*\\(.*?(?<!\\w)as(?!\\w)\\s*(?:#S#\\d+#E#\\s*)*(?<!\\w)timestamp(?!\\w)\\s*(?:#S#\\d+#E#\\s*)*\\)\\s*(?:#S#\\d+#E#\\s*)*(\\s*(?:#S#\\d+#E#\\s*)*(?<!\\w)day\\s*(?:#S#\\d+#E#\\s*)*(?:\\(\\s*\\d+\\s*\\))?(?!\\w)\\s*(?:#S#\\d+#E#\\s*)*(?<!\\w)to(?!\\w)\\s*(?:#S#\\d+#E#\\s*)*(?<!\\w)second(?!\\w)\\s*(?:#S#\\d+#E#\\s*)*(?:\\(\\s*\\d+\\s*\\))?)?");
        Matcher castMatcher = castPattern.matcher(input);
        StringBuffer nsb = new StringBuffer(128);
        StringBuffer newsb = new StringBuffer(128);
        int tempIndex = 0;
        int castStartIndex = 0;
        int castEndIndex = 0;
        int castStartIndexone = 0;
        while (castMatcher.find()) {
            castStartIndex = castMatcher.start();
            castEndIndex = castMatcher.end();
            castStartIndexone = QueryConversionUtility.toLower(input).lastIndexOf("cast", castStartIndex);
            nsb.append(input.substring(castStartIndexone, castEndIndex));
            String typeCasted = TeradataQueryKeywordReplacer.doCastTypeCasting(nsb.toString());
            newsb.append(input.substring(tempIndex, castStartIndexone)).append(typeCasted);
            tempIndex = castEndIndex;
            nsb.setLength(0);
        }
        newsb.append(input.substring(castEndIndex));
        return newsb.toString();
    }

    private static String doCastTypeCasting(String inputSql) {
        String input = inputSql;
        Pattern asIntervalPattern = Pattern.compile("(?i)(\\s*(?:#S#\\d+#E#\\s*)*(?<!\\w)cast(?!\\w)\\s*(?:#S#\\d+#E#\\s*)*\\(.*?(?<!\\w)as(?!\\w)\\s*(?:#S#\\d+#E#\\s*)*(?<!\\w)timestamp(?!\\w)\\s*(?:#S#\\d+#E#\\s*)*\\)\\s*(?:#S#\\d+#E#\\s*)*\\-\\s*(?:#S#\\d+#E#\\s*)*(?<!\\w)cast(?!\\w)\\s*(?:#S#\\d+#E#\\s*)*\\(.*?(?<!\\w)as(?!\\w)\\s*(?:#S#\\d+#E#\\s*)*(?<!\\w)timestamp(?!\\w)\\s*(?:#S#\\d+#E#\\s*)*\\)\\s*(?:#S#\\d+#E#\\s*)*)(\\s*(?:#S#\\d+#E#\\s*)*(?<!\\w)day\\s*(?:#S#\\d+#E#\\s*)*(?:\\(\\s*\\d+\\s*\\))?(?!\\w)\\s*(?:#S#\\d+#E#\\s*)*(?<!\\w)to(?!\\w)\\s*(?:#S#\\d+#E#\\s*)*(?<!\\w)second(?!\\w)\\s*(?:#S#\\d+#E#\\s*)*(?:\\(\\s*\\d+\\s*\\))?)?");
        Matcher asIntervalMatcher = asIntervalPattern.matcher(input);
        String cast = null;
        String dayToSec = null;
        StringBuffer sb = new StringBuffer(128);
        while (asIntervalMatcher.find()) {
            dayToSec = asIntervalMatcher.group(2);
            cast = asIntervalMatcher.group(1);
            if (dayToSec != null && !dayToSec.isEmpty()) {
                sb.append("cast").append("(").append("(");
                sb.append(cast).append(")");
                sb.append("AS").append(" ").append("INTERVAL").append(" ");
                sb.append(dayToSec).append(")");
                continue;
            }
            sb.append(cast).append(" ");
        }
        return sb.toString();
    }

    private static String doTimeIntervalTypeCasting(String inputVal) {
        String input;
        String output = input = inputVal;
        input = QueryConversionUtility.canonicalizeString(input);
        Pattern pattern = Pattern.compile("(?i)(?<!\\w)time\\s+(?:(?:#S#\\d+#E#\\s*)*)(\\'[0-9 :.]+\\')\\s*((?:#S#\\d+#E#\\s*)*)hour\\s+(?:(?:#S#\\d+#E#\\s*)*)to\\s+(?:(?:#S#\\d+#E#\\s*)*)second(?!\\w)");
        Matcher matcher = pattern.matcher(input);
        String comment = null;
        while (matcher.find()) {
            comment = matcher.group(2);
            output = output.replace(matcher.group(), "TIME " + matcher.group(1) + (comment != null ? comment + " " : ""));
        }
        return output;
    }

    private static String doDataTypeCastingForNull(String input) {
        String output = input;
        Pattern pattern = Pattern.compile("(?i)(?<!\\w)null\\s*((?:#S#\\d+#E#\\s*)*)\\(\\s*(?:#S#\\d+#E#\\s*)*(bigint|byteint|decimal|decimal\\s*\\(.*?\\)\\s*(?:#S#\\d+#E#\\s*)*|double\\s+precision\\s*(?:#S#\\d+#E#\\s*)*|\\s*float|int|integer|number|numeric|number\\s*\\(\\s*(?:#S#\\d+#E#\\s*)*.*?\\s*(?:#S#\\d+#E#\\s*)*\\)\\s*(?:#S#\\d+#E#\\s*)*|real|smallint|char|character|char\\s*\\(\\s*\\d+\\s*\\)|character\\s*\\(\\s*\\d+\\s*\\)|clob|long\\s+varchar|varchar\\s*\\(\\s*\\d+\\s*\\)|char\\s+varying\\s*\\(\\s*\\d+\\s*\\)|character\\s+varying\\s*\\(\\s*\\d+\\s*\\)|date|time|timestamp|time\\s*\\(\\s*\\d+\\s*\\)|timestamp\\s*\\(\\s*\\d+\\s*\\)|time\\s+with\\s+time\\s+zone|timestamp\\s+with\\s+time\\s+zone|time\\s*\\(\\s*\\d+\\s*+\\)\\s+with\\s+time\\s+zone|timestamp\\s*\\(\\s*\\d+\\s*\\)\\s+with\\s+time\\s+zone|period\\s*\\(\\s*date\\s*\\)|period\\s*\\(\\s*time\\s*\\)|period\\s*\\(\\s*time\\s*\\(\\s*\\d+\\s*\\)\\s*\\)|period\\s*\\(\\s*time\\s+with\\s+time\\s+zone\\s*\\)|period\\s*\\(\\s*timestamp\\s+with\\s+time\\s+zone\\s*\\)|period\\s*\\(\\s*timestamp\\s*\\)|period\\s*\\(\\s*timestamp\\s*\\(\\s*\\d+\\s*\\)\\s*\\)|blob|blob\\s*\\(\\s*\\d+\\s*\\)|byte|byte\\s*\\(\\s*\\d+\\s*\\)|varbyte|varbyte\\s*\\(\\s*\\d+\\s*\\)|graphic\\s*\\(\\s*\\d+\\s*\\)|character\\s*\\(\\s*\\d+\\s*\\)\\s*character\\s+set\\s+graphic|long\\s+vargraphic|long\\s+varchar\\s+character\\s+set\\s+graphic|vargraphic\\s*\\(\\s*\\d+\\s*\\)|varchar\\s*\\(\\s*\\d+\\s*\\)\\s*character\\s+set\\s+graphic)\\s*\\)(?!\\w)");
        Matcher matcher = pattern.matcher(output);
        String typeName = null;
        String replacementType = null;
        String comment = null;
        StringBuffer replacementBuf = new StringBuffer();
        TeradataMapHelperAlias tdmaphelperalias = new TeradataMapHelperAlias();
        while (matcher.find()) {
            comment = matcher.group(1);
            typeName = matcher.group(2);
            replacementType = tdmaphelperalias.doReplaceDataType(typeName);
            replacementBuf.append("cast").append("(").append("null").append(comment != null ? " " + comment + " " : "").append(" ").append("AS").append(" ").append(replacementType).append(")");
            output = output.replace(matcher.group(), replacementBuf);
            replacementBuf.setLength(0);
        }
        return output;
    }

    private static String doCastingForPeriod(String input) {
        String output = input;
        output = QueryConversionUtility.canonicalizeString(output);
        Pattern pattern = Pattern.compile("(?i)(period\\s*\\(\\s*date\\s*\\)|period\\s*\\(\\s*time\\s*\\)|period\\s*\\(\\s*time\\s*\\(\\s*\\d+\\s*\\)\\s*\\)|period\\s*\\(\\s*time\\s+with\\s+time\\s+zone\\s*\\)|period\\s*\\(\\s*timestamp\\s+with\\s+time\\s+zone\\s*\\)|period\\s*\\(\\s*timestamp\\s*\\)|period\\s*\\(\\s*timestamp\\s*\\(\\s*\\d+\\s*\\)\\s*\\))");
        Matcher matcher = pattern.matcher(output);
        String typeName = null;
        String replacementType = null;
        TeradataMapHelperAlias tdmaphelperalias = new TeradataMapHelperAlias();
        while (matcher.find()) {
            typeName = matcher.group(1);
            replacementType = tdmaphelperalias.doReplaceDataType(typeName);
            output = output.replace(matcher.group(), replacementType);
        }
        return output;
    }

    private static String addZeroInDecimal(String inputQry) {
        String inputSql = inputQry;
        if (QueryConversionUtility.containsCheck(inputSql, "decimal")) {
            inputSql = QueryConversionUtility.doReplaceSpecificGrp(inputSql, "(?i)(?<!\\w)decimal\\s*\\(\\s*(\\d+)\\s*\\)", "", ",0", 1, true);
            inputSql = QueryConversionUtility.doReplaceSpecificGrp(inputSql, "((?<!\\w)decimal)\\s+format", "", "(18,0)", 1, true);
        }
        return inputSql;
    }

    private static String changeDecimal(String inputQry, String inputSqlLower) {
        String inputSql = inputQry;
        if (inputSqlLower.contains("dec")) {
            inputSql = QueryConversionUtility.doReplaceKeyword(inputSql, "(?i)(?<!\\w)dec\\s*\\(", "decPattern");
        }
        return inputSql;
    }

    private static String changeReplaceFunction(String inputQry, String inputSqlLower) {
        String inputSql = inputQry;
        if (inputSqlLower.contains("strreplace") || inputSqlLower.contains("oreplace")) {
            Pattern pattern = Pattern.compile("(?i)(?<!\\w)(strreplace|oreplace)\\s*(#S#\\d+#E#\\s*)*\\(");
            Matcher matcher = pattern.matcher(inputSql);
            while (matcher.find()) {
                inputSql = inputSql.replace(matcher.group(1), " " + QueryConversionUtility.toUpper("Replace"));
            }
        }
        return inputSql;
    }

    private static String changeIndexFunction(String inputQry, String inputSqlLower) {
        String inputSql = inputQry;
        if (inputSqlLower.contains("index")) {
            inputSql = QueryConversionUtility.doReplaceKeyword(inputSql, "(?i)((?<!\\w)index\\s*\\()", "indexFnPattern");
        }
        return inputSql;
    }

    private static String changeCharToLength(String inputQry, String inputSqlLower) {
        String inputSql = inputQry;
        if (inputSqlLower.contains("char")) {
            inputSql = QueryConversionUtility.doReplaceKeyword(inputSql, "(?i)((?<!as\\s)(?<![\\w\\d])(?:char|chars|characters|character)\\s*\\((?!\\s*[\\d]))", "charKeywordReplacementPattern");
        }
        return inputSql;
    }

    private static String doModifyModFun(String inputQry, String inputSqlLower) {
        String inputSql = inputQry;
        if (inputSqlLower.contains("mod")) {
            StringBuffer sbMod = new StringBuffer();
            Matcher matcher = MOD_PAT.matcher(inputSql);
            int tempStart = 0;
            int modIdx = 0;
            String modStr = null;
            while (matcher.find()) {
                modIdx = matcher.start();
                modStr = QueryConversionUtility.doGetReplaceString(inputSql.substring(modIdx));
                if (modStr.contains(",")) continue;
                sbMod.append(inputSql.substring(tempStart, modIdx)).append(" ").append("%");
                tempStart = modIdx + 3;
            }
            sbMod.append(inputSql.substring(tempStart));
            inputSql = sbMod.toString();
        }
        return inputSql;
    }

    private static String changeModFunction(String inputQry, String inputSqlLower) {
        String inputSql = inputQry;
        if (inputSqlLower.matches(".*?(?<!\\w)mod(?!\\w).*") || inputSql.contains("*")) {
            inputSql = QueryConversionUtility.doReplaceKeywords(inputSql, "((?<!\\w)\\s*MOD\\s+(?!\\()|(?<!\\'|\\*)\\*\\s*\\*(?!\\'|\\*))");
        }
        return inputSql;
    }

    private static String changeAllKeyword(String inputQry, String inputSqlLower) {
        String inputSql = inputQry;
        if (inputSqlLower.contains(" all")) {
            inputSql = TeradataQueryKeywordReplacer.doReplaceAllKeyword(inputSql);
        }
        return inputSql;
    }

    private static String doChangeCollectStat(String input, String inputQry) throws MigrationServiceException {
        String inputSql = inputQry;
        if (QueryConversionUtility.containsCheck(input, "collect ")) {
            inputSql = TeradataQueryKeywordReplacer.doReplaceCollectStatWithUsingKeyWordAndWithMulColms(inputSql);
            inputSql = TeradataQueryKeywordReplacer.doReplaceCollectStat(inputSql);
        }
        return inputSql;
    }

    private static String doReplaceCollectStatWithUsingKeyWordAndWithMulColms(String inputSqlVal) {
        String output = null;
        LinkedHashMap<String, String> quoteMap = new LinkedHashMap<String, String>(10);
        String inputSql = inputSqlVal;
        inputSql = QueryConversionUtility.getSingleDoubleQuoteMap(inputSql, quoteMap);
        Pattern pattern = Pattern.compile("(?i)(.*)collect\\s+(?:#S#\\d+#E#\\s*)*(?:stat(?:s)?|statistics)\\s+USING\\s+\\w+\\s+(\\d+\\.\\d+)\\s+\\w+(\\scolumn(?!\\w).*?)(?<!\\w)ON(?!\\w)(.*?);(.*)");
        Matcher matcher = pattern.matcher(inputSql);
        StringBuffer inputBuf = new StringBuffer(inputSql);
        if (matcher.find()) {
            inputBuf.delete(0, inputBuf.length());
            String decimalVal = matcher.group(2);
            String columnsVal = matcher.group(3).trim();
            String tblName = matcher.group(4).trim();
            inputBuf.append("SET").append(" ");
            inputBuf.append("default_statistics_target").append(" ");
            inputBuf.append("=").append(" ");
            inputBuf.append(decimalVal).append(";").append(" ");
            String colList = TeradataQueryKeywordReplacer.getColfromColmsVal(columnsVal, tblName);
            inputBuf.append(colList);
            inputBuf.append("RESET").append(" ");
            inputBuf.append("default_statistics_target").append(";");
        }
        output = inputBuf.toString();
        output = QueryConversionUtility.getRplFromMap(output, quoteMap, "(##QUOTE##\\d+#)");
        return output;
    }

    private static String getColfromColmsVal(String columnsVal, String tblName) {
        String[] colArrWithBrackets = columnsVal.split(",(?![^(]*\\))");
        StringBuffer replStatment = new StringBuffer();
        for (int iIndex = 0; iIndex < colArrWithBrackets.length; ++iIndex) {
            String colms = colArrWithBrackets[iIndex];
            if (!colms.contains("(") || !colms.contains(")")) continue;
            replStatment.append("ANALYZE").append(" ").append(tblName).append(colms.substring(colms.indexOf("("), colms.indexOf(")") + 1).trim()).append(";");
        }
        return replStatment.toString();
    }

    private static String isNotInImpl(String input, String inputQry) {
        String inputSql = inputQry;
        if (QueryConversionUtility.containsCheck(input, "is") && QueryConversionUtility.containsCheck(input, "not")) {
            inputSql = QueryConversionUtility.doReplaceKeyword(inputSql, "(?i)(?<!\\w)is\\s+not\\s+in(?!\\w)", "isNotInPattern");
        }
        return inputSql;
    }

    public static String doPostQueryReplacement(String input) {
        String modifiedInput = TeradataQueryKeywordReplacer.doReplaceFnKeyword(input);
        modifiedInput = TeradataQueryKeywordReplacer.addTableOrView(modifiedInput);
        modifiedInput = TeradataQueryKeywordReplacer.doRplSingleQuote(modifiedInput);
        modifiedInput = modifiedInput.replaceAll("(?i)(E)\\s+(\\'\\\\x.*?\\')", "$1$2");
        if (QueryConversionUtility.containsCheck(input, "LIKE") && (QueryConversionUtility.containsCheck(input, "any") || QueryConversionUtility.containsCheck(input, "all"))) {
            LinkedHashMap<String, String> quoteMap = new LinkedHashMap<String, String>(10);
            modifiedInput = QueryConversionUtility.getSingleDoubleQuoteMap(modifiedInput, quoteMap);
            modifiedInput = QueryConversionUtility.doReplaceSpecificGrp(modifiedInput, "(?<!\\w)like(?!\\w)(\\s*#S#\\d+#E#)*?\\s*(?<!\\w)(any|all)(?!\\w)(\\s*#S#\\d+#E#)*?\\s*\\((?!(\\s*#S#\\d+#E#)*?\\s*(?<!\\w)select(?!\\w)(.*?)(?<!\\w)from(?!\\w)(.*?))(.*?)\\)", "ARRAY[", "]", 7, true);
            modifiedInput = QueryConversionUtility.getRplFromMap(modifiedInput, quoteMap, "(##QUOTE##\\d+#)");
        }
        if (QueryConversionUtility.containsCheck(modifiedInput, "next")) {
            modifiedInput = TeradataQueryKeywordReplacer.doReplaceNextKeyword(modifiedInput);
        }
        if (QueryConversionUtility.containsCheck(modifiedInput, "Table")) {
            modifiedInput = new TeradataUtility().doTableOperatorReplacement(modifiedInput);
        }
        return modifiedInput;
    }

    public static String addTableOrView(String input) {
        String modifiedInput = input;
        Matcher addTblOrViewMatch = ADD_TBL_OR_VIEW.matcher(modifiedInput);
        if (addTblOrViewMatch.find()) {
            Map<String, String> partTable = TeradataMigrationService.getCreateTypeMap();
            String tableName = addTblOrViewMatch.group(1);
            for (Map.Entry<String, String> entry : partTable.entrySet()) {
                String type = entry.getKey();
                if (!type.equalsIgnoreCase(tableName)) continue;
                String val = entry.getValue();
                if (val.equalsIgnoreCase("TABLE")) {
                    modifiedInput = modifiedInput.replace(tableName, "TABLE " + tableName);
                }
                if (!val.equalsIgnoreCase("VIEW")) continue;
                modifiedInput = modifiedInput.replace(tableName, "VIEW " + tableName);
            }
            if (addTblOrViewMatch.group(2) != null && !addTblOrViewMatch.group(2).isEmpty()) {
                modifiedInput = modifiedInput.replace(tableName, "COLUMN " + tableName);
            }
        }
        return modifiedInput;
    }

    public static String doPostSchemaReplacement(String input) {
        String output = input;
        Pattern creTabPat = Pattern.compile("(?i)(?<!\\w)create\\s*(?:(?<!\\w)(set\\s+volatile|multiset\\s+volatile|volatile\\s+set|volatile\\s+multiset|volatile|multiset|set))?(\\s+table\\s+)(\\w*\\s*\\.?\\s*\\w+|\\\"?\\$\\{\\w+\\}\\\"?\\.\\w+\\$\\{\\w+\\})");
        Matcher tabMatcher = creTabPat.matcher(output);
        String tableName = "";
        Boolean isCreTab = false;
        while (tabMatcher.find()) {
            tableName = tabMatcher.group(tabMatcher.groupCount());
            TeradataMigrationService.addCreateTypeMap(tableName, "TABLE");
            isCreTab = true;
        }
        StringBuilder sb = new StringBuilder();
        output = QueryConversionUtility.doCommentSpecificGrp(output, "(?i)((?<!\\w)title\\s*'(.*?)'|\\(\\s*(?<!\\w)title\\s*'(.*?)'\\s*\\))", 1);
        return output;
    }

    private static String getCommentOnTitle(String input, String tableName, StringBuilder sb) {
        String output = input;
        LinkedHashMap<String, String> commentMap = new LinkedHashMap<String, String>(10);
        output = QueryConversionUtility.getSingleOrDoubleQuoteMap(output, commentMap, "/*", "\\/\\*.*?\\*\\/", "##COMMENT##");
        Pattern pattern = Pattern.compile("(?<=\\,|\\()(\\s*\\w+)((\\s+\\w+\\s*)+(\\(\\s*\\d+(\\s*\\,\\s*\\d+\\s*)?\\s*\\)\\s*)?(?:##COMMENT##\\d+#\\s*)*\\s*(?i)title\\s*)('.*?')");
        Matcher matcher = pattern.matcher(output);
        String titleColName = "";
        String titleStr = "";
        while (matcher.find()) {
            titleColName = matcher.group(1).trim();
            titleStr = matcher.group(matcher.groupCount()).trim();
            sb.append(IGaussDBConstants.NEW_LINE).append("comment on column ").append(tableName).append(".").append(titleColName).append(" is ").append(titleStr).append(";");
        }
        output = output + sb.toString();
        output = QueryConversionUtility.getRplFromMap(output, commentMap, "(##COMMENT##\\d+#)");
        return output;
    }

    public static void doAddTableNameAndColNameInMap(String inputWOcmtVal, String tableName) {
        String inputWOcmt = inputWOcmtVal;
        inputWOcmt = QueryConversionUtility.canonicalizeString(inputWOcmt);
        Matcher matcherNew = DATE_FORMAT_PAT.matcher(inputWOcmt);
        String colName = null;
        String dateReplace = null;
        while (matcherNew.find()) {
            colName = matcherNew.group(1).trim();
            dateReplace = matcherNew.group(3) + ")" + " " + "AS" + " " + colName;
            if (tableName == null) continue;
            TeradataMigrationService.addDateColumn(tableName, colName + "--" + dateReplace);
        }
    }

    public static String doPreChangesOnInput(String input) {
        TeradataUtility util = new TeradataUtility();
        String inputSql = input;
        inputSql = TeradataQueryKeywordReplacer.changeCTAndCV(util, inputSql);
        String inputSqlLower = QueryConversionUtility.toLower(inputSql);
        inputSql = TeradataQueryKeywordReplacer.changeIns(inputSql, inputSqlLower);
        inputSql = TeradataQueryKeywordReplacer.doPreMigOnQry(inputSql);
        Pattern pattern = Pattern.compile("(?i)(period\\s*\\(\\s*date\\s*\\)|period\\s*\\(\\s*time\\s*\\)|period\\s*\\(\\s*time\\s*\\(\\s*\\d+\\s*\\)\\s*\\)|period\\s*\\(\\s*time\\s+with\\s+time\\s+zone\\s*\\)|period\\s*\\(\\s*timestamp\\s+with\\s+time\\s+zone\\s*\\)|period\\s*\\(\\s*timestamp\\s*\\)|period\\s*\\(\\s*timestamp\\s*\\(\\s*\\d+\\s*\\)\\s*\\))");
        Matcher matcher = pattern.matcher(input);
        if (matcher.find()) {
            inputSql = TeradataQueryKeywordReplacer.doDataTypeCastingForNull(inputSql);
            inputSql = TeradataQueryKeywordReplacer.doCastingForPeriod(inputSql);
        }
        LinkedHashMap<String, String> quoteMap = new LinkedHashMap<String, String>(10);
        inputSql = QueryConversionUtility.getSingleDoubleQuoteMap(inputSql, quoteMap);
        inputSql = TeradataQueryKeywordReplacer.doDataTypeCastingForNull(inputSql);
        inputSql = QueryConversionUtility.getRplFromMap(inputSql, quoteMap, "(##QUOTE##\\d+#)");
        quoteMap = new LinkedHashMap(10);
        inputSql = QueryConversionUtility.getDoubleQuoteMap(inputSql, quoteMap);
        inputSql = TeradataQueryKeywordReplacer.doTimeIntervalTypeCasting(inputSql);
        inputSql = QueryConversionUtility.getRplFromMap(inputSql, quoteMap, "(##QUOTE##\\d+#)");
        inputSql = TeradataQueryKeywordReplacer.getMigQry(inputSql);
        return inputSql;
    }

    private static String getMigQry(String input) {
        String inputSql = input;
        inputSql = TeradataQueryKeywordReplacer.doInsertCommentsBeforeFormat(inputSql);
        inputSql = TeradataQueryKeywordReplacer.doDateCast(inputSql);
        inputSql = TeradataQueryKeywordReplacer.inputChangesForWithData(inputSql);
        if (QueryConversionUtility.containsCheck(inputSql = TeradataQueryKeywordReplacer.inputChangesForBigIntAsDate(inputSql), "type")) {
            inputSql = TeradataQueryKeywordReplacer.removeCreateTypeInput(inputSql);
        }
        return inputSql;
    }

    private static String doDateCast(String input) {
        String inputSql = input;
        TeradataDateFormatUtility dateUtility = new TeradataDateFormatUtility();
        inputSql = TeradataQueryKeywordReplacer.dateToCast(inputSql);
        inputSql = dateUtility.dateTypeCasting(inputSql);
        inputSql = dateUtility.dateTypeCastDollar(inputSql);
        inputSql = TeradataQueryKeywordReplacer.dateToDate(inputSql);
        inputSql = TeradataQueryKeywordReplacer.dateOrIntegerAsCast(inputSql);
        inputSql = inputSql.replace("~FR~OM~", "FROM");
        inputSql = dateUtility.doUserEnvironmentDate(inputSql);
        inputSql = TeradataTimeUtility.doUserEnvironmentTime(inputSql);
        return inputSql;
    }

    private static String doPreMigOnQry(String input) {
        String inputSql = input;
        if (inputSql.matches("(?i).*SHOW\\s+STATS\\s+VALUES\\s+SEQUENCED.*")) {
            inputSql = inputSql.replaceAll("SHOW\\s+STATS\\s+VALUES\\s+SEQUENCED.*$", "/*$0*/");
        }
        inputSql = QueryConversionUtility.doReplaceKeywords(inputSql, "(?<!\\w|:\\s|:)(SEL|UPD|DEL|EXEC)(?!\\w)");
        inputSql = QueryConversionUtility.doReplaceKeywords(inputSql, "(?<!\\w)byteint(?!\\w)");
        if (QueryConversionUtility.toLower(inputSql = QueryConversionUtility.canonicalizeString(inputSql)).contains("cast")) {
            inputSql = TeradataQueryKeywordReplacer.doPutSingleQuotesOnDate(inputSql);
        }
        return inputSql;
    }

    private static String changeIns(String input, String inputSqlLower) {
        String inputSql = input;
        if (inputSqlLower.contains("grant ") || inputSqlLower.contains("revoke ")) {
            if (inputSqlLower.contains("ins ") || inputSqlLower.contains("ins,")) {
                inputSql = QueryConversionUtility.doReplaceSpecificGrp(inputSql, "(?<!\\w)(INS)(?!\\w)", "", "INSERT ", 1, false);
            }
        } else if (!inputSql.matches("(?i).*(?<!\\w)merge(?!\\w).*") || !"NONE".equalsIgnoreCase(FeatureLoader.getStringProperty("mergeImplementation"))) {
            inputSql = QueryConversionUtility.doReplaceSpecificGrp(inputSql, "(?i)(^INS\\s+INTO|(?<!\\w)\\s*INS\\s+INTO|^INS\\s+(?:table)?|(?<!\\w)INS\\s+|^INSERT\\s+(?:table)?(?!(?:#S#\\d+#E#\\s*)*INTO)|(?<!\\w)\\s*INSERT\\s+(?!(?:#S#\\d+#E#\\s*)*INTO))", "", "INSERT INTO ", 0, false);
        }
        return inputSql;
    }

    private static String changeCTAndCV(TeradataUtility util, String input) {
        String inputSql = input;
        inputSql = util.doReplaceShortKeyword(inputSql, "(?i)^((\\$.*?\\s+)|(\\$\\{.*?\\}\\s+))*CT(?!\\w).*", "(?i)(?<!\\w|\\$)CT(?!\\w)", "CREATE table ");
        inputSql = util.doReplaceShortKeyword(inputSql, "(?i)^((\\$.*?\\s+)|(\\$\\{.*?\\}\\s+))*CV(?!\\w).*", "(?i)(?<!\\w|\\$)CV(?!\\w)", "CREATE OR REPLACE VIEW ");
        return inputSql;
    }

    private static String dateToCast(String input) {
        String inputSql = input;
        LinkedHashMap<String, String> singleDoubleQuoteMap = new LinkedHashMap<String, String>(10);
        if (inputSql.matches("(?i).*date\\s*\\'.*?\\'\\s*\\(\\s*date\\s*\\).*")) {
            inputSql = inputSql.replaceAll("(?i)(?<!\\w)(date)(?!\\w)\\s*(\\'\\s*(?:\\d{4}(?:\\-|\\/|\\.)?(?:0?[1-9]|1[012])(?:\\-|\\/|\\.)?(?:0?[1-9]|[12][0-9]|3[01]))\\s*\\')(?!\\w)\\s*(?:#S#\\d+#E#\\s*)*\\s*(?<!\\w)\\s*(?:#S#\\d+#E#\\s*)*", "CAST($2 AS $1)");
        }
        if ((inputSql = QueryConversionUtility.getSingleDoubleQuoteMap(inputSql, singleDoubleQuoteMap)).matches("(?i).*(?<!\\w)(date)\\s+(?!format|default|as|where|order|from|is|not|check|title|LANGUAGE)(\\w+).*")) {
            inputSql = inputSql.replaceAll("(?i)(?<!\\w)(date)\\s+(?!format)(\\w+)(?!\\')", "CAST($2 AS $1)");
        }
        inputSql = QueryConversionUtility.getRplFromMap(inputSql, singleDoubleQuoteMap, "(##QUOTE##\\d+#)");
        return inputSql;
    }

    public static String dateToDate(String input) {
        String inputSql = input;
        int indexTranslate = 0;
        while (QueryConversionUtility.getIndex(inputSql, "CAST", indexTranslate) != -1) {
            indexTranslate = QueryConversionUtility.getIndex(inputSql, "CAST", indexTranslate);
            String cols = "";
            String params = "";
            if (indexTranslate == -1) continue;
            cols = QueryUtilityExt.doGetStringFromGivenIndex(indexTranslate, inputSql);
            Pattern toChar = Pattern.compile("(?i)CAST\\s*\\((.*)AS\\s+(#S#\\d+#E#\\s*)*DATE\\s*((#S#\\d+#E#\\s*)*)FORMAT\\s*(\\'.*?\\')\\s*\\)");
            Matcher toCharMatch = toChar.matcher(cols);
            String column = "";
            int endIdx = 0;
            if (toCharMatch.find()) {
                params = toCharMatch.group();
                int check = QueryConversionUtility.doChkBracketCnt(params);
                if (check != 0) {
                    indexTranslate += 3;
                    continue;
                }
                String dateQuote = "";
                endIdx = toCharMatch.end();
                column = toCharMatch.group(1);
                dateQuote = toCharMatch.group(5);
                if (!dateQuote.matches("(?i)\\'\\s*(?:YYYY|MM)(?:\\/|\\-|\\.)?(?:MM|DD)(?:\\/|\\-|\\.)?(?:YYYY|MM|DD)\\s*\\'")) {
                    inputSql = inputSql.replace(cols, "TO_DATE(" + column + ", " + dateQuote + ")" + cols.substring(endIdx));
                }
            }
            indexTranslate += 3;
        }
        return inputSql;
    }

    public static String dateOrIntegerAsCast(String input) {
        String inputSql = input;
        Matcher tillKeyMatch = TILL_KEY.matcher(inputSql);
        StringBuffer sb = new StringBuffer();
        int indexTranslate = 0;
        String cols = "";
        while (QueryConversionUtility.getIndex(inputSql, "TRIM", indexTranslate) != -1) {
            if ((indexTranslate = QueryConversionUtility.getIndex(inputSql, "TRIM", indexTranslate)) == -1) continue;
            cols = QueryUtilityExt.doGetStringFromGivenIndex(indexTranslate, inputSql);
            inputSql = TeradataQueryKeywordReplacer.getInpQry(inputSql, cols);
            indexTranslate += 3;
        }
        if (tillKeyMatch.find()) {
            String subStr = tillKeyMatch.group(1);
            if (subStr.endsWith(")")) {
                return TeradataQueryKeywordReplacer.getCastForFunc(inputSql, tillKeyMatch, subStr, sb);
            }
            ColumnSplitter splitter = new ColumnSplitter();
            Matcher colMatch = SELECT_FROM_PAT.matcher(inputSql);
            int startIdx = 0;
            while (colMatch.find() && inputSql.matches("(?i).*\\(\\s*(?<!\\w)(?:date|integer)(?!\\w)\\s*\\).*")) {
                String columns = colMatch.group(1).trim();
                int tempIdx = colMatch.start();
                int endIdx = colMatch.end();
                sb.append(inputSql.substring(startIdx, tempIdx));
                if (!columns.matches("(?i)(?:\\(\\s*)?(?:date|integer)\\s*\\)?.*") && (QueryConversionUtility.containsCheck(columns, "date") || QueryConversionUtility.containsCheck(columns, "integer"))) {
                    List<String> colList = splitter.doGetAllColumns(columns);
                    sb.append(inputSql.substring(tempIdx, colMatch.start(1)));
                    TeradataQueryKeywordReplacer.appendCast(sb, colList);
                    TeradataQueryKeywordReplacer.getUpdBuffer(inputSql, sb, endIdx, colMatch);
                } else {
                    sb.append(inputSql.substring(tempIdx, endIdx));
                }
                startIdx = endIdx;
            }
            sb.append(inputSql.substring(startIdx));
            if (!sb.toString().isEmpty()) {
                return sb.toString();
            }
        }
        return inputSql;
    }

    private static void getUpdBuffer(String inputSql, StringBuffer sb, int endIdx, Matcher colMatch) {
        if (sb.toString().endsWith(",")) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append(" ").append(inputSql.substring(colMatch.end(1), endIdx));
    }

    private static String getInpQry(String input, String cols) {
        String inputSql = input;
        String colRep = "";
        if (QueryConversionUtility.containsCheck(cols, "FROM")) {
            colRep = cols.replace("FROM", "~FR~OM~");
            inputSql = inputSql.replace(cols, colRep);
        }
        return inputSql;
    }

    private static void appendCast(StringBuffer sb, List<String> colList) {
        for (String col : colList) {
            Matcher dateAsCastMatch = DATE_AS_CAST.matcher(col);
            String col1 = " ";
            if (dateAsCastMatch.find()) {
                col1 = col.replaceAll("(?i)(.*?)\\(\\s*date\\s*\\)(.*)", " CAST($1 AS DATE)$2");
                col1 = col1.replaceAll("(?i)(.*?)\\(\\s*integer\\s*\\)(.*)", " CAST($1 AS INTEGER)$2");
                sb.append(" ").append(col1).append(",");
                continue;
            }
            sb.append(" ").append(col).append(",");
        }
    }

    public static String getCastForFunc(String inputSql, Matcher tillKeyMatch, String subStr, StringBuffer sb) {
        int endIdx = tillKeyMatch.end(2);
        FindFormatUtility util = new FindFormatUtility();
        String neededString = util.doFindFormatFunction(subStr);
        int tillIdx = QueryConversionUtility.getIndex(subStr, neededString, 0);
        sb.append(subStr.subSequence(0, tillIdx));
        sb.append("CAST(").append(neededString).append(" AS ").append(tillKeyMatch.group(2));
        sb.append(inputSql.substring(endIdx));
        return sb.toString();
    }

    private static String removeCreateTypeInput(String inputSql) {
        String period = "(?<!\\w)time(?:stamp)?\\s*(?:\\(\\s*\\d+\\s*\\))?\\s+with\\s+time\\s+zone|timestamp\\s*\\(\\s*\\d+\\s*\\)|time\\s*\\(\\s*\\d+\\s*\\)|time|timestamp\\s+with\\s+time\\s+zone|timestamp|period\\s*\\(\\s*date\\s*\\)|period\\s*\\(\\s*time\\s*\\)|period\\s*\\(\\s*time\\s*\\(\\s*\\d+\\s*\\)\\s*\\)|period\\s*\\(\\s*time\\s+with\\s+time\\s+zone\\s*\\)|period\\s*\\(\\s*timestamp\\s+with\\s+time\\s+zone\\s*\\)|period\\s*\\(\\s*timestamp\\s*\\)|period\\s*\\(\\s*timestamp\\s*\\(\\s*\\d+\\s*\\)\\s*\\)(?!\\w)";
        String dataTypePattern = "(?i)(?<!\\w)graphic\\s*\\(\\s*\\d+\\s*\\)|character\\s*\\(\\s*\\d+\\s*\\)\\s*character\\s+set\\s+graphic|long\\s+varchar\\s+character\\s+set\\s+long\\s+vargraphic|long\\s+vargraphic|long\\s+varchar\\s+character\\s+set\\s+graphic|vargraphic\\s*\\(\\s*\\d+\\s*\\)|varchar\\s*\\(\\s*\\d+\\s*\\)\\s*character\\s+set\\s+graphic(?!\\w)|" + period + "|(?<!\\w)date(?!\\w)|CHAR\\s+VARYING|char|decimal|bigint|double\\s+PRECISION|blob(?:\\s*\\(\\s*\\d+\\s*\\)\\s*)?|varchar(?!\\w)|" + "(?<!\\w)byteint(?!\\w)|(?<!\\w)float(?!\\w)|(?<!\\w)int(?!\\w)|(?<!\\w)STRING(?!\\w)|(?<!\\w)number(?!\\w)|(?<!\\w)long\\s+varchar(?!\\w)|(?<!\\w)(?:char|character)\\s+varying(?!\\w)|((?<!\\w|\\/\\*\\s)character(?!\\w|\\s+varying))|(?<!\\w)period\\s*?\\(\\s*?date\\s*?\\)|(?<!\\w)period\\s*?\\(\\s*?(?:time|timestamp)\\s+with\\s+time\\s+zone\\s*?\\)" + "|" + "(?i)((?<!\\w)byte(?:\\s*?\\(.*?\\))?(?!\\w)|(?<!\\w)varbyte(?:\\s*?\\(.*?\\))?(?!\\w)|(?<!\\w)vargraphic\\s*\\(.*?\\))" + "|\\w+";
        Matcher matcher = Pattern.compile("(?i)(?<!\\w)create\\s+type(?!\\w)(.*?)(?<!\\w)(as)(?!\\w)\\s+(" + dataTypePattern + ")(?!\\w)(.*)").matcher(inputSql);
        if (matcher.find()) {
            String userdataType = matcher.group(1).trim();
            String dataTypeStr = matcher.group(3);
            String dataTypeValue = matcher.group(6).trim();
            String value = null;
            if (dataTypeValue.startsWith("(") && dataTypeValue.contains(")")) {
                value = dataTypeValue.substring(0, dataTypeValue.indexOf(")") + 1);
            }
            if (value != null) {
                dataTypeStr = dataTypeStr + value;
            }
            TeradataMigrationService.addCreateTypeMap(userdataType, dataTypeStr);
            return "";
        }
        return inputSql;
    }

    private static String inputChangesForBigIntAsDate(String inputValidator) {
        Pattern patternWith = Pattern.compile("(?i)(?<!\\w)cast(?!\\w)\\s*\\(\\s*(?<!\\w)(cast(?!\\w)\\s*\\().*?(?<!\\w)(AS\\s*(?<!\\w)BIGINT(?!\\w)\\s*\\))\\s*AS\\s*(?<!\\w)DATE(?!\\w)");
        Matcher matcherWith = patternWith.matcher(inputValidator);
        StringBuilder sb = new StringBuilder();
        int startIndex = 0;
        int endIndex = 0;
        while (matcherWith.find()) {
            int startIndexGroupOne = matcherWith.start(1);
            endIndex = matcherWith.end(2);
            sb.append(inputValidator.substring(startIndex, startIndexGroupOne));
            int endIndexGroupOne = matcherWith.end(1);
            int startIndexGroupTwo = matcherWith.start(2);
            sb.append(inputValidator.substring(endIndexGroupOne, startIndexGroupTwo));
            startIndex = endIndex;
        }
        sb.append(inputValidator.substring(endIndex));
        return sb.toString();
    }

    private static String inputChangesForWithData(String inputValidator) {
        Pattern patternWith = Pattern.compile("(?i)(?<!\\w)(?:create)\\s*(?:volatile)?\\s*(set|multiset)?\\s*(?:volatile)?\\s*(?:table)(?!\\w)\\s*(?:[\\w${}\\.]*)\\s*((?<!\\w)AS(?!\\w)).*?((?<!\\w)with(?!\\w)\\s*(?:no)?\\s*(?<!\\w)data(?!\\w))?\\s*;");
        Matcher matcherWith = patternWith.matcher(inputValidator);
        if (matcherWith.find() && matcherWith.group(3) == null) {
            Pattern pattern = Pattern.compile("(?i)((?<!\\w)with(?!\\w)\\s*(?:no\\s+)?(?<!\\w)data(?!\\w)\\s+|as\\s*)?(?<!\\w)((?:(?:no|unique)?\\s*(?:primary)?\\s*index)(?!\\w)(.*?)(?:on\\s+commit\\s+(?:preserve|delete)\\s+rows\\s*)?|(?:(?:no|unique)?\\s*(?:primary)?\\s*index)?(?:on\\s+commit\\s+(?:preserve|delete)\\s+rows\\s*))(?!\\w);");
            Matcher matcher = pattern.matcher(inputValidator);
            boolean flag = false;
            while (matcher.find()) {
                String commitGroup = matcher.group(2);
                if (commitGroup.isEmpty()) continue;
                flag = true;
                if (matcher.group(1) != null) continue;
                inputValidator = inputValidator.replace(commitGroup, " with data " + commitGroup);
                break;
            }
            if (!flag) {
                inputValidator = inputValidator.replace(";", " with data ;");
            }
        }
        return inputValidator;
    }

    private static String doPutQuoteSymbolKeyword(String input) {
        String output = input;
        String keywordsGauss = "(?:#|\\$)(#|\\$){0,}\\{?\\w+\\}?";
        Pattern keywordPattern = Pattern.compile("(?i)((?<!\\w)(select|update|drop|delete|replace|create|alter|insert|with|truncate|analyze|collect|merge\\s*(?:#S#\\d+#E#\\s*)*into)(?!\\w).*)");
        Matcher keywordMatcher = keywordPattern.matcher(output);
        if (keywordMatcher.find()) {
            String sqlQuery = keywordMatcher.group(1);
            String patternString = "(?i)(?<!\\w|\")(" + keywordsGauss + ")(?!\\w|#|\")";
            sqlQuery = TeradataQueryKeywordReplacer.doRplSymbolKeywordInSql(sqlQuery, patternString, "\"", "\"", 1);
            output = output.substring(0, keywordMatcher.start()) + sqlQuery;
        }
        return output;
    }

    private static String doRplSymbolKeywordInSql(String input, String patternString, String befReplacement, String replacement, int grpNumber) {
        String outputStr = input;
        Pattern patternSymbolWord = Pattern.compile(patternString, 2);
        Matcher matcherSymbolWord = patternSymbolWord.matcher(outputStr);
        int tempEnd = 0;
        int startidx = 0;
        StringBuffer strbuff = new StringBuffer();
        boolean dollarMigrate = true;
        String str = FeatureLoader.getStringProperty("tdMigrateDollar").trim();
        if (str.equalsIgnoreCase("false")) {
            dollarMigrate = false;
        }
        LinkedHashMap<String, String> singleDoubleQuoteMap = new LinkedHashMap<String, String>(10);
        if ((outputStr.contains("'") || outputStr.contains("\"")) && matcherSymbolWord.find()) {
            outputStr = QueryConversionUtility.getSingleDoubleQuoteMap(outputStr, singleDoubleQuoteMap);
        }
        matcherSymbolWord = patternSymbolWord.matcher(outputStr);
        int endIdx = 0;
        while (matcherSymbolWord.find()) {
            String groupWord = matcherSymbolWord.group(grpNumber);
            if ((!groupWord.startsWith("$") || !dollarMigrate) && groupWord.startsWith("$")) continue;
            startidx = matcherSymbolWord.start(grpNumber);
            endIdx = matcherSymbolWord.end(grpNumber);
            strbuff.append(outputStr.substring(tempEnd, startidx));
            if (!groupWord.startsWith("$")) {
                groupWord = QueryConversionUtility.toUpper(groupWord);
            }
            strbuff.append(befReplacement).append(groupWord).append(replacement);
            tempEnd = endIdx;
        }
        strbuff.append(outputStr.substring(tempEnd));
        outputStr = strbuff.toString();
        outputStr = QueryConversionUtility.getRplFromMap(outputStr, singleDoubleQuoteMap, "(##QUOTE##\\d+#)");
        return outputStr;
    }

    private static String doInsertCommentsBeforeFormat(String inputSql) {
        String inputWOcmt = inputSql.replaceAll("(?i)#S#\\d+#E#", "").trim();
        String outputSql = inputSql;
        if ((inputWOcmt = QueryConversionUtility.canonicalizeString(inputWOcmt)).matches("(?i).*?(?<!\\w)(format)(?!\\w).*?")) {
            int tempEnd = 0;
            int startidx = 0;
            int endIdx = 0;
            StringBuffer strBuff = new StringBuffer();
            Matcher matcherDate = PATTERN_DATE.matcher(inputSql);
            while (matcherDate.find()) {
                startidx = matcherDate.start(0);
                endIdx = matcherDate.end(0);
                strBuff.append(inputSql.substring(tempEnd, startidx));
                strBuff.append(matcherDate.group(2));
                strBuff.append(inputSql.substring(startidx, endIdx + 1));
                tempEnd = endIdx + 1;
            }
            strBuff.append(inputSql.substring(tempEnd));
            outputSql = strBuff.toString();
        }
        return outputSql;
    }

    private static String doPutSingleQuotesOnDate(String input) {
        String output = input;
        Pattern pattern = Pattern.compile("(?i)(?<!\\w)(cast\\s*\\(\\s*(\\d{8}?(?!\\'))\\s+as)\\s*");
        Matcher matcher = pattern.matcher(output);
        StringBuffer strbuf = new StringBuffer();
        int tempIndex = 0;
        while (matcher.find()) {
            int startIndex = matcher.start(2);
            int endIndex = matcher.end(2);
            strbuf.append(output.substring(tempIndex, startIndex)).append("'").append(matcher.group(2).trim()).append("'");
            tempIndex = endIndex;
        }
        strbuf.append(output.substring(tempIndex));
        return strbuf.toString();
    }

    private static String doReplaceAllKeyword(String input) {
        String inputSql = input;
        String allPattern = "(.*)(\\s+ALL)(.*;)";
        Pattern pattern = Pattern.compile(allPattern, 2);
        Matcher matcher = pattern.matcher(inputSql);
        if (matcher.find()) {
            String cmntWithSemiColn = matcher.group(3);
            String qryStr = matcher.group(1);
            if (cmntWithSemiColn.replaceAll("(?i)#S#\\d+#E#", "").trim().equals(";")) {
                inputSql = qryStr + cmntWithSemiColn;
            }
        }
        return inputSql;
    }

    private static String doReplaceFnKeyword(String input) {
        String inputSql = input;
        String fnFindPattern = "(?<!\\w)(ZEROIFNULL\\s*(#S#\\d+#E#\\s*)*\\(|NULLIFZERO\\s*(#S#\\d+#E#\\s*)*\\()";
        Matcher matcher = null;
        Pattern pattern = Pattern.compile(fnFindPattern, 2);
        matcher = pattern.matcher(inputSql);
        boolean migrateZeroIfNull = TeradataQueryKeywordReplacer.getBoolZero(true);
        boolean migrateNullIfNull = TeradataQueryKeywordReplacer.getBoolNull(true);
        while (matcher.find()) {
            String function = matcher.group(1);
            int startIndex = matcher.start(1);
            String substring = inputSql.substring(startIndex);
            String replaceFnString = QueryConversionUtility.doGetReplaceString(substring);
            int openIndex = replaceFnString.indexOf(40);
            int closeIndex = replaceFnString.lastIndexOf(41);
            String parameterStr = replaceFnString.substring(openIndex + 1, closeIndex);
            function = QueryConversionUtility.toUpper(function.trim().replaceAll(" ", ""));
            function = function.replaceAll("(?i)#S#\\d+#E#", "");
            String comment = TeradataQueryKeywordReplacer.getCmntStr(matcher, function);
            if ((!function.equals("ZEROIFNULL(") || !migrateZeroIfNull) && (!function.equals("NULLIFZERO(") || !migrateNullIfNull)) continue;
            String replacementStr = DBPropertyLoader.getStringProperty(function) + parameterStr.trim() + "," + 0 + ")" + comment;
            inputSql = inputSql.replace(replaceFnString, replacementStr);
            matcher = pattern.matcher(inputSql);
        }
        return inputSql;
    }

    private static boolean getBoolNull(boolean flag) {
        boolean migrateNullIfNull = flag;
        String str = FeatureLoader.getStringProperty("tdMigrateNULLIFZERO").trim();
        if (str.equalsIgnoreCase("false")) {
            migrateNullIfNull = false;
        }
        return migrateNullIfNull;
    }

    private static boolean getBoolZero(boolean flag) {
        boolean migrateZeroIfNull = flag;
        String str = FeatureLoader.getStringProperty("tdMigrateZEROIFNULL").trim();
        if (str.equalsIgnoreCase("false")) {
            migrateZeroIfNull = false;
        }
        return migrateZeroIfNull;
    }

    private static String getCmntStr(Matcher matcher, String function) {
        String comment = "";
        if (matcher.group(2) != null || matcher.group(3) != null) {
            comment = function.equals("ZEROIFNULL(") ? matcher.group(2) : matcher.group(3);
        }
        return comment;
    }

    private static String doReplaceNextKeyword(String inputSql) {
        String inputQry = inputSql;
        Pattern pattern = Pattern.compile("(?i)next\\s*\\((.*?)\\)");
        Matcher matcher = pattern.matcher(inputQry);
        while (matcher.find()) {
            inputQry = inputQry.replace(matcher.group(0), matcher.group(1) + "+" + 1);
        }
        return inputQry;
    }

    private static String doRplSingleQuote(String quoteStrInp) {
        Pattern pattern = null;
        Matcher matcher = null;
        String quoteStr = quoteStrInp;
        quoteStr = quoteStr.replaceAll("(?i)(?<!\\w)not\\s*=|\\^\\s*=", "<>");
        pattern = Pattern.compile("(?i)(\\s(?:eq|gt|lt|le|ge|ne|in|not\\s+in)(?:\\s|\\'))");
        matcher = pattern.matcher(quoteStr);
        if (matcher.find()) {
            int cnt = 1;
            LinkedHashMap<String, String> quoteMap = new LinkedHashMap<String, String>(10);
            pattern = Pattern.compile("(\\'{4}|\\'.*?\\')");
            matcher = pattern.matcher(quoteStr);
            while (matcher.find()) {
                String subStr = matcher.group(1);
                quoteStr = QueryConversionUtility.replaceQueryWithCommonPattern(quoteStr, subStr, cnt, quoteMap, "#");
                ++cnt;
            }
            quoteStr = TeradataQueryKeywordReplacer.doRplInNotInOp(quoteStr, "(\\s+not\\s+in|\\sin)(\\s|#)(?!\\s*(#S#\\d+#E#\\s*)*?\\s*\\()");
            if ((quoteStr = QueryConversionUtility.doReplaceOperators(quoteStr, "(\\s(?:eq|gt|lt|le|ge|ne)(\\s|#|\\())")).contains("__")) {
                int count = 1;
                quoteStr = QueryConversionUtility.doReplaceFunctionVariables(quoteStr, quoteMap, "#" + count + "_" + "_");
            }
        }
        return quoteStr;
    }

    private static String doRplInNotInOp(String inputVal, String patternString) {
        LinkedHashMap<String, String> quoteMap = new LinkedHashMap<String, String>(10);
        String input = inputVal;
        input = QueryConversionUtility.getSingleDoubleQuoteMap(input, quoteMap);
        String outputQry = input.replaceAll("\\s*\\(\\s*", "(");
        Pattern pattern = Pattern.compile(patternString, 2);
        Matcher matcher = pattern.matcher(outputQry);
        String matcherString = null;
        int tempEnd = 0;
        StringBuffer formQry = new StringBuffer();
        while (matcher.find()) {
            int endIndex = matcher.end();
            int startindex = matcher.start();
            formQry.append(outputQry.substring(tempEnd, startindex));
            matcherString = QueryConversionUtility.toLower(matcher.group(1));
            if (matcherString.contains("not")) {
                formQry.append(" ").append("<>").append(matcher.group(2));
            } else if (matcherString.contains("in")) {
                formQry.append(" ").append("=").append(matcher.group(2));
            }
            tempEnd = endIndex;
        }
        formQry.append(outputQry.substring(tempEnd));
        outputQry = formQry.toString();
        outputQry = QueryConversionUtility.getRplFromMap(outputQry, quoteMap, "(##QUOTE##\\d+#)");
        return outputQry;
    }

    public static String doReplaceCSUM(String inputQuery) {
        String inputSql;
        String outputQuery = inputSql = inputQuery;
        StringBuffer outputBuff = null;
        String grpElements = null;
        String[] groupByElements = null;
        String tempOut = null;
        if (QueryConversionUtility.containsCheck(inputSql, "csum")) {
            if (!(QueryConversionUtility.containsCheck(inputSql, "cube") || QueryConversionUtility.containsCheck(inputSql, "rollup") || QueryConversionUtility.containsCheck(inputSql, "grouping"))) {
                groupByElements = QueryConversionUtility.getGroupByElements(inputSql);
            }
            if (groupByElements != null && groupByElements.length > 2) {
                inputSql = groupByElements[0];
                grpElements = groupByElements[2];
            }
            outputQuery = inputSql;
            Pattern pattern1 = Pattern.compile("(?i)csum\\s*\\(");
            Matcher matcher = pattern1.matcher(inputSql);
            ColumnSplitter splitter = new ColumnSplitter();
            String firstElement = null;
            while (matcher.find()) {
                int cSumEnd = matcher.end();
                outputBuff = new StringBuffer();
                String cSum = matcher.group(0).substring(0, matcher.group(0).length() - 1);
                String cSumToEnd = inputSql.substring(cSumEnd - 1);
                String cSumFn = QueryConversionUtility.doGetReplaceString(cSumToEnd);
                String cSumChk = cSumFn.replace(" ", "");
                if (cSumChk.charAt(3) == '1' && cSumChk.charAt(1) == '1') {
                    outputQuery = TeradataQueryKeywordReplacer.doReplaceCSUMPartition(outputQuery, outputBuff, grpElements, cSum, cSumFn);
                    continue;
                }
                firstElement = TeradataQueryKeywordReplacer.doReplaceCSUMSplit(outputBuff, firstElement, grpElements, splitter, cSumFn);
                String output = "sum(" + firstElement + ")" + outputBuff.toString();
                outputQuery = outputQuery.replace(cSum + cSumFn, output);
            }
            tempOut = inputQuery.replaceAll("(?i)#S#\\d+#E#", "");
            if (outputBuff != null && groupByElements != null && groupByElements.length > 1 && !tempOut.matches("(?i).*?(?<!\\w)(MDIFF|ROW_NUMBER|RANK)(?!\\w)\\s*\\(.*")) {
                outputQuery = outputQuery.replace(groupByElements[1], "");
            }
        }
        return outputQuery;
    }

    private static String doReplaceCSUMSplit(StringBuffer outputBuff, String firstElementInp, String grpElements, ColumnSplitter splitter, String cSumFn) {
        String cSumCols = cSumFn.substring(1, cSumFn.length() - 1);
        List<String> splittingFnString = splitter.doGetAllColumns(cSumCols);
        String elements = "";
        String firstElement = firstElementInp;
        if (!splittingFnString.isEmpty() && splittingFnString.size() > 0) {
            firstElement = splittingFnString.get(0);
            splittingFnString.remove(0);
            elements = QueryConversionUtility.doGetStrFrmListWithComma(splittingFnString);
        }
        outputBuff.append(" ").append("over").append("(");
        if (grpElements != null) {
            outputBuff.append("partition").append(" ").append("by").append(" ").append(grpElements);
        }
        outputBuff.append(" ").append("order").append(" ").append("by").append(" ").append(elements).append(" ").append("ROWS UNBOUNDED PRECEDING").append(")");
        return firstElement;
    }

    private static String doReplaceCSUMPartition(String outputQueryInp, StringBuffer outputBuff, String grpElements, String cSum, String cSumFn) {
        String outputQuery = outputQueryInp;
        outputBuff.append("ROW_NUMBER").append("(").append(")").append("over").append("(");
        if (grpElements != null) {
            outputBuff.append("partition").append(" ").append("by").append(" ").append(grpElements).append(" ");
        }
        outputBuff.append(")");
        outputQuery = outputQuery.replace(cSum + cSumFn, outputBuff.toString());
        return outputQuery;
    }

    public IIndexConstraintsBO doGetIndexConstraintsBO(String tableColumns, String tableColumnsWOCmnt, IIndexConstraintsBO objIndexConstraintsBO, Map<String, String> multiCommentMap) {
        int index;
        LinkedHashMap<String, String> quoteMap = new LinkedHashMap<String, String>(10);
        String columnsString = QueryConversionUtility.getSingleQuoteMap(tableColumns, quoteMap);
        columnsString = QueryConversionUtility.doGetReplaceString(columnsString).trim();
        columnsString = QueryConversionUtility.getRplFromMap(columnsString, quoteMap, "(##QUOTE##\\d+#)");
        int columnStrLength = columnsString.length();
        String indexesStr = tableColumns.trim().substring(columnStrLength);
        String tableColumnsUpper = QueryConversionUtility.toUpper(tableColumns);
        int asIndex = tableColumnsUpper.indexOf(" AS ", columnStrLength) + 1;
        if (asIndex > 0 && (index = TeradataQueryKeywordReplacer.getUniquePrimaryIndex(tableColumnsUpper)) >= asIndex) {
            columnsString = tableColumns.substring(asIndex, index);
            indexesStr = tableColumns.trim().substring(index);
            if (asIndex < tableColumnsWOCmnt.length()) {
                tableColumnsWOCmnt = tableColumnsWOCmnt.substring(asIndex);
            }
        }
        this.createIdxConstraintsBO(tableColumnsWOCmnt, objIndexConstraintsBO, columnsString);
        StringBuffer extraKeywords = new StringBuffer();
        String tempIndexesStr = TeradataQueryKeywordReplacer.doMigratePrimaryIndex(objIndexConstraintsBO, multiCommentMap, indexesStr, extraKeywords);
        TeradataQueryKeywordReplacer.setExtraStringInObjBO(objIndexConstraintsBO, extraKeywords, tempIndexesStr);
        return objIndexConstraintsBO;
    }

    private static String doMigratePrimaryIndex(IIndexConstraintsBO objIndexConstraintsBO, Map<String, String> multiCommentMap, String indexesStr, StringBuffer extraKeywords) {
        String tempIndexesStr = indexesStr;
        if (!indexesStr.matches(";") && indexesStr.matches("(?i).*(?<!\\w)(unique\\s+)?(primary\\s+)?index(?!\\w).*")) {
            LinkedHashMap<String, String> quotetMap = new LinkedHashMap<String, String>(10);
            tempIndexesStr = QueryConversionUtility.replacementQuoteComment(tempIndexesStr, quotetMap, multiCommentMap);
            tempIndexesStr = QueryConversionUtility.getRplFromMap(tempIndexesStr, quotetMap, "(##QUOTE##\\d+#)");
            tempIndexesStr = QueryConversionUtility.getRplFromMap(tempIndexesStr, multiCommentMap, "(##COMMENT##\\d+#)");
            String primaryIndex = null;
            ArrayList<String> uniqueIndexList = new ArrayList<String>(10);
            ArrayList<String> indexList = new ArrayList<String>(10);
            String strCmnt = "";
            String tempTrim = tempIndexesStr.trim();
            if (tempTrim.startsWith("#S#")) {
                strCmnt = QueryConversionUtility.doGetStartCmnts(tempTrim);
                tempIndexesStr = tempTrim.substring(strCmnt.length());
            }
            while (!tempIndexesStr.matches(";") && tempIndexesStr.matches("(?i).*(?<!\\w)(unique\\s+)?(primary\\s+)?index(?!\\w).*")) {
                String indexStr = QueryConversionUtility.doGetReplaceString(tempIndexesStr).trim();
                if (indexStr.matches("(?i).*(?<!\\w)unique\\s+primary\\s+index(?!\\w).*")) {
                    primaryIndex = TeradataQueryKeywordReplacer.migUniquePrimaryIdx(uniqueIndexList, indexStr);
                } else if (indexStr.matches("(?i).*(?<!\\w)unique\\s+index(?!\\w).*")) {
                    TeradataQueryKeywordReplacer.migUniqueIdx(uniqueIndexList, indexStr);
                } else if (indexStr.matches("(?i).*(?<!\\w)primary\\s+index(?!\\w).*")) {
                    primaryIndex = TeradataQueryKeywordReplacer.migPrimaryIdx(indexStr);
                } else if (indexStr.matches("(?i).*(?<!\\w)index(?!\\w).*")) {
                    TeradataQueryKeywordReplacer.migIndex(indexList, indexStr);
                } else {
                    extraKeywords.append(" ").append(tempIndexesStr);
                    break;
                }
                tempIndexesStr = TeradataQueryKeywordReplacer.getTempIdxStr(tempIndexesStr, indexStr);
            }
            tempIndexesStr = strCmnt + tempIndexesStr;
            TeradataQueryKeywordReplacer.setUpLists(objIndexConstraintsBO, primaryIndex, uniqueIndexList, indexList);
        } else {
            TeradataQueryKeywordReplacer.getExtraKeywrdsBuf(indexesStr, extraKeywords);
        }
        return tempIndexesStr;
    }

    private static String getTempIdxStr(String tempIndexesStr, String indexStr) {
        tempIndexesStr = tempIndexesStr.trim().substring(indexStr.length());
        tempIndexesStr = tempIndexesStr.replaceAll("(##COMMENT##\\d+#)", "");
        return tempIndexesStr;
    }

    private static void migIndex(List<String> indexList, String indexStr) {
        String indexCols = TeradataQueryKeywordReplacer.doGetIndexColumnsList(indexStr, "(?i).*(?<!\\w)index(\\s+\\w+)?\\s*\\((.*?)\\)");
        indexList.add(indexCols);
    }

    private static String migPrimaryIdx(String indexStr) {
        String indexCols;
        String primaryIndex = indexCols = TeradataQueryKeywordReplacer.doGetIndexColumnsList(indexStr, "(?i).*(?<!\\w)primary\\s+index(\\s+\\w+)?\\s*\\((.*?)\\)");
        return primaryIndex;
    }

    private static void migUniqueIdx(List<String> uniqueIndexList, String indexStr) {
        String indexCols = TeradataQueryKeywordReplacer.doGetIndexColumnsList(indexStr, "(?i).*(?<!\\w)unique\\s+index(\\s+\\w+)?\\s*\\((.*?)\\)");
        uniqueIndexList.add(indexCols);
    }

    private static void getExtraKeywrdsBuf(String indexesStr, StringBuffer extraKeywords) {
        extraKeywords.setLength(0);
        extraKeywords.append(indexesStr);
    }

    private static void setUpLists(IIndexConstraintsBO objIndexConstraintsBO, String primaryIndex, List<String> uniqueIndexList, List<String> indexList) {
        objIndexConstraintsBO.setIndexList(indexList);
        objIndexConstraintsBO.setUniqueIndexList(uniqueIndexList);
        objIndexConstraintsBO.setPrimaryIndex(primaryIndex);
    }

    private static String migUniquePrimaryIdx(List<String> uniqueIndexList, String indexStr) {
        String indexCols;
        String primaryIndex = indexCols = TeradataQueryKeywordReplacer.doGetIndexColumnsList(indexStr, "(?i).*(?<!\\w)unique\\s+primary\\s+index(\\s+\\w+)?\\s*\\((.*?)\\)");
        uniqueIndexList.add(indexCols);
        return primaryIndex;
    }

    private static int getUniquePrimaryIndex(String tableColumnsUpper) {
        int index = tableColumnsUpper.indexOf("UNIQUE PRIMARY INDEX ");
        if (index == -1 && (index = tableColumnsUpper.indexOf("PRIMARY INDEX ")) == -1) {
            index = tableColumnsUpper.indexOf(" INDEX ") + 1;
        }
        return index;
    }

    private static void setExtraStringInObjBO(IIndexConstraintsBO objIndexConstraintsBO, StringBuffer extraKeywordsInp, String tempIndexesStr) {
        StringBuffer extraKeywords = extraKeywordsInp;
        if (!tempIndexesStr.trim().isEmpty() && !(extraKeywords = new StringBuffer(tempIndexesStr.replaceAll("(?i)on\\s+commit\\s+preserve\\s+rows", ""))).toString().equals(tempIndexesStr)) {
            objIndexConstraintsBO.setOnCommitRows("ON COMMIT PRESERVE ROWS");
        }
        objIndexConstraintsBO.setExtraKeywords(extraKeywords.toString());
    }

    private void doGetConstraints(String columnsString, IIndexConstraintsBO objIndexConstraintsBO) {
        List<String> columnArrays = TeradataQueryKeywordReplacer.getColumnList(columnsString);
        LinkedHashMap<String, String> indexMap = new LinkedHashMap<String, String>(10);
        LinkedHashMap<String, String> colIndexMap = new LinkedHashMap<String, String>(10);
        ArrayList<String> uniqueList = new ArrayList<String>(10);
        this.initializeConstraints();
        for (int iIndex = 0; iIndex < columnArrays.size(); ++iIndex) {
            this.columnForConstraint = columnArrays.get(iIndex).trim();
            this.columnWOCmntForConstraint = this.columnForConstraint.replaceAll("(?i)#S#\\d+#E#", "").trim();
            if (this.columnWOCmntForConstraint.matches("(?i).*(?<!\\w)primary\\s+key(?!\\w)")) {
                this.isPrimaryKeyForCons = true;
                this.primaryColumnForCons = this.columnWOCmntForConstraint.trim().substring(0, this.columnWOCmntForConstraint.indexOf(32)).trim();
                continue;
            }
            if (this.columnWOCmntForConstraint.matches("(?i)(?<!\\w)FOREIGN\\s+KEY(?!\\w).*")) {
                columnArrays.set(iIndex, "/*" + this.columnForConstraint + "*/");
                continue;
            }
            if (this.columnWOCmntForConstraint.matches("(?i)(?<!\\w)CONSTRAINT(?!\\w).*")) {
                this.extractConstraintBegin(columnArrays, indexMap, colIndexMap, uniqueList, iIndex);
                continue;
            }
            if (this.columnWOCmntForConstraint.matches("(?i).*?(?<!\\w)CONSTRAINT(?!\\w).*")) {
                this.extractConstraint(columnArrays, indexMap, colIndexMap, uniqueList, iIndex);
                continue;
            }
            if (this.columnWOCmntForConstraint.matches("(?i).*\\s+(?<!\\w)REFERENCES(?!\\w)\\s+.*")) {
                columnArrays = TeradataQueryKeywordReplacer.doAddReferenceColInlst(columnArrays, this.columnForConstraint, iIndex);
                continue;
            }
            if (this.columnForConstraint.matches("(?i).*(?<!\\w)UNIQUE(?!\\w).*")) {
                this.uniqueCntForConstraint = TeradataQueryKeywordReplacer.doAddUniqueColInLst(columnArrays, this.uniqueCntForConstraint, indexMap, colIndexMap, uniqueList, this.columnForConstraint, this.columnWOCmntForConstraint, iIndex);
                continue;
            }
            if (!this.columnForConstraint.matches("(?i)(?<!\\w)PRIMARY\\s+KEY(?!\\w).*")) continue;
            this.isPrimaryKeyForCons = true;
            this.primaryColumnForCons = QueryConversionUtility.removeParenthesis(this.columnWOCmntForConstraint).trim();
        }
        TeradataQueryKeywordReplacer.setIndexConstaintsBO(objIndexConstraintsBO, indexMap, colIndexMap, uniqueList);
        TeradataQueryKeywordReplacer.setIndexConstraintsBoExt(objIndexConstraintsBO, columnArrays, this.isPrimaryKeyForCons, this.primaryColumnForCons);
    }

    private void initializeConstraints() {
        this.columnForConstraint = null;
        this.columnWOCmntForConstraint = null;
        this.uniqueCntForConstraint = 1;
        this.isPrimaryKeyForCons = false;
        this.primaryColumnForCons = null;
    }

    private void extractConstraintBegin(List<String> columnArrays, Map<String, String> indexMap, Map<String, String> colIndexMap, List<String> uniqueList, int iIndex) {
        String toChkConstraint = TeradataQueryKeywordReplacer.getCheckConstraints(this.columnWOCmntForConstraint);
        if (toChkConstraint.matches("(?i)(?<!\\w)PRIMARY(?!\\w).*")) {
            this.isPrimaryKeyForCons = true;
            this.primaryColumnForCons = QueryConversionUtility.removeParenthesis(this.columnWOCmntForConstraint).trim();
        }
        if (toChkConstraint.matches("(?i)(?<!\\w)UNIQUE(?!\\w).*")) {
            this.uniqueCntForConstraint = TeradataQueryKeywordReplacer.doAddUniqueColumnsInList(columnArrays, this.uniqueCntForConstraint, indexMap, colIndexMap, uniqueList, iIndex, this.columnForConstraint, this.columnWOCmntForConstraint);
        } else if (toChkConstraint.matches("(?i)(?<!\\w)FOREIGN(?!\\w).*")) {
            columnArrays.set(iIndex, "/*" + this.columnForConstraint + "*/");
        }
    }

    private void extractConstraint(List<String> columnArrays, Map<String, String> indexMap, Map<String, String> colIndexMap, List<String> uniqueList, int iIndex) {
        Matcher match = TeradataQueryKeywordReplacer.getConstraintMatcher(this.columnForConstraint);
        int constraintIdx = 0;
        String constraintStr = "";
        if (match.find()) {
            constraintIdx = match.start(1);
            constraintStr = match.group(1);
        }
        if (constraintStr.matches("(?i).*(?<!\\w)(FOREIGN\\s+KEY|REFERENCES)(?!\\w).*")) {
            TeradataQueryKeywordReplacer.setColArrays(columnArrays, this.columnForConstraint, iIndex, constraintStr);
        } else if (constraintStr.matches("(?i).*(?<!\\w)UNIQUE(?!\\w).*")) {
            TeradataQueryKeywordReplacer.fillUniqueList(uniqueList, this.columnWOCmntForConstraint);
            TeradataQueryKeywordReplacer.setColumnArray(columnArrays, this.uniqueCntForConstraint, this.columnForConstraint, iIndex, constraintIdx);
            TeradataQueryKeywordReplacer.setColIndexMap(this.uniqueCntForConstraint, indexMap, colIndexMap, this.columnForConstraint, constraintIdx);
            ++this.uniqueCntForConstraint;
        }
    }

    private static void setColArrays(List<String> columnArrays, String col, int iIndex, String constraintStr) {
        String column = col;
        column = column.replace(constraintStr, "/*" + constraintStr + "*/");
        columnArrays.set(iIndex, column);
    }

    private static List<String> getColumnList(String columnsString) {
        LinkedHashMap<String, String> quoteMap = new LinkedHashMap<String, String>(10);
        columnsString = QueryConversionUtility.getSingleQuoteMap(columnsString, quoteMap);
        List<String> columnArrays = TeradataQueryKeywordReplacer.getColumnArrays(columnsString).stream().map(item -> QueryConversionUtility.getRplFromMap(item, quoteMap, "(##QUOTE##\\d+#)")).collect(Collectors.toList());
        return columnArrays;
    }

    private static void setIndexConstraintsBoExt(IIndexConstraintsBO objIndexConstraintsBO, List<String> columnArrays, boolean isPrimaryKey, String primaryColumn) {
        objIndexConstraintsBO.setPrimaryKey(isPrimaryKey);
        objIndexConstraintsBO.setColumnArrays(columnArrays);
        objIndexConstraintsBO.setPrimaryKeyCols(primaryColumn);
    }

    private static void setIndexConstaintsBO(IIndexConstraintsBO objIndexConstraintsBO, Map<String, String> indexMap, Map<String, String> colIndexMap, List<String> uniqueList) {
        objIndexConstraintsBO.setUniqueList(uniqueList);
        objIndexConstraintsBO.setIndexMap(indexMap);
        objIndexConstraintsBO.setColIndexMap(colIndexMap);
    }

    private static void setColIndexMap(int uniqueCnt, Map<String, String> indexMap, Map<String, String> colIndexMap, String column, int constraintIdx) {
        indexMap.put("#UNIQUE#" + uniqueCnt + "#", column.substring(constraintIdx));
        colIndexMap.put(column, "#UNIQUE#" + uniqueCnt + "#");
    }

    private static void setColumnArray(List<String> columnArrays, int uniqueCnt, String column, int iIndex, int constraintIdx) {
        String placeHolderColumn = column.substring(0, constraintIdx) + "#" + "UNIQUE" + "#" + uniqueCnt + "#";
        columnArrays.set(iIndex, placeHolderColumn);
    }

    private static void fillUniqueList(List<String> uniqueList, String columnWOCmnt) {
        int spaceIndex = columnWOCmnt.indexOf(32);
        String columnNames = columnWOCmnt.substring(0, spaceIndex);
        uniqueList.add(columnNames);
    }

    private static Matcher getConstraintMatcher(String column) {
        return CONSTRAINT_PAT.matcher(column);
    }

    private static String getCheckConstraints(String columnWOCmnt) {
        String[] constraintArr = columnWOCmnt.split(" ");
        return constraintArr.length > 2 ? constraintArr[2].trim() : "";
    }

    private static List<String> getColumnArrays(String columnsString) {
        ColumnSplitter splitter = new ColumnSplitter();
        return splitter.doGetAllColumns(columnsString);
    }

    private static String doGetIndexColumnsList(String indexStr, String indexPattern) {
        String indexCol = null;
        String idxName = null;
        Pattern idxPattern = Pattern.compile(indexPattern);
        Matcher idxMatch = idxPattern.matcher(indexStr);
        if (idxMatch.find()) {
            indexCol = idxMatch.group(2).trim();
            idxName = idxMatch.group(1);
        }
        if (idxName != null) {
            return idxName + "-" + indexCol;
        }
        return indexCol;
    }

    private static int doAddUniqueColumnsInList(List<String> columnArrays, int uniqueCntInp, Map<String, String> indexMap, Map<String, String> colIndexMap, List<String> uniqueList, int index, String column, String columnWOCmnt) {
        int uniqueCnt = uniqueCntInp;
        String columnNames = QueryConversionUtility.removeParenthesis(columnWOCmnt);
        uniqueList.add(columnNames);
        columnArrays.set(index, "#" + QueryConversionUtility.toUpper("unique") + "#" + uniqueCnt + "#");
        indexMap.put("#" + QueryConversionUtility.toUpper("unique") + "#" + uniqueCnt + "#", column);
        colIndexMap.put(column, "#" + QueryConversionUtility.toUpper("unique") + "#" + uniqueCnt + "#");
        return ++uniqueCnt;
    }

    public static String doReplaceWhereGrpByOrdrByClauses(String inputQuery) throws MigrationServiceException {
        LinkedHashMap<String, String> quoteMap = new LinkedHashMap<String, String>(10);
        String inputQry = QueryConversionUtility.getSingleDoubleQuoteMap(inputQuery, quoteMap);
        inputQry = inputQry.replaceAll("\\s+,\\s+|\\s+,|,\\s+", ",");
        String qualifyStr = "";
        String whereStr = "";
        String orderByStr = "";
        String groupByStr = "";
        String havingStr = "";
        String strAfterFrmClause = null;
        String selectClause = null;
        String semiColon = null;
        StringBuffer outStrBuffClause = new StringBuffer();
        LinkedHashMap<String, String> overMap = new LinkedHashMap<String, String>(10);
        if (inputQry.matches("(?i).*(?<!\\w)Qualify(?!\\w).*")) {
            inputQry = QueryConversionUtility.doReplaceOverStr(inputQuery, overMap);
        }
        if (inputQry.matches("(?i).*(?<!\\w)from(?!\\w).*")) {
            inputQry = TeradataQueryKeywordReplacer.doModifytoStructuredQuery(inputQry);
            Pattern pattern = Pattern.compile("(?i)(.*(?<!\\w)from(?!\\w).*?)((?<!\\w)(?:where|having|order\\s+by|group\\s+by|Qualify)(?!\\w).*?)?(;.*|$)");
            Matcher matcher = pattern.matcher(inputQry);
            if (matcher.find()) {
                selectClause = matcher.group(1);
                strAfterFrmClause = matcher.group(2);
                if (strAfterFrmClause != null) {
                    strAfterFrmClause = strAfterFrmClause + " ";
                }
                semiColon = matcher.group(3).trim();
                outStrBuffClause.append(selectClause);
            }
        } else {
            outStrBuffClause.append(inputQry);
        }
        String joinsStr = " ";
        if (strAfterFrmClause != null) {
            whereStr = TeradataQueryKeywordReplacer.doGetWhereClause(strAfterFrmClause);
            qualifyStr = TeradataQueryKeywordReplacer.doGetQualifyClause(strAfterFrmClause);
            if (qualifyStr.matches("(?i).*(?<!\\w)join(?!\\w).*")) {
                joinsStr = TeradataQueryKeywordReplacer.doGetJoinsInQualify(qualifyStr);
                outStrBuffClause.append(" ").append(joinsStr);
                qualifyStr = qualifyStr.replace(joinsStr, "");
            }
            groupByStr = TeradataQueryKeywordReplacer.doGetGroupByClause(strAfterFrmClause);
            havingStr = TeradataQueryKeywordReplacer.doGetHavingClause(strAfterFrmClause);
            orderByStr = TeradataQueryKeywordReplacer.doGetOrderByClause(strAfterFrmClause);
        }
        String outputQuery = TeradataQueryKeywordReplacer.getOutputQuery(quoteMap, qualifyStr, whereStr, orderByStr, groupByStr, havingStr, semiColon, outStrBuffClause, overMap);
        return outputQuery;
    }

    private static String getOutputQuery(Map<String, String> quoteMap, String qualifyStr, String whereStr, String orderByStr, String groupByStr, String havingStr, String semiColon, StringBuffer outStrBuffClause, Map<String, String> overMap) {
        outStrBuffClause.append(" ").append(whereStr);
        outStrBuffClause.append(" ").append(qualifyStr);
        outStrBuffClause.append(" ").append(groupByStr);
        outStrBuffClause.append(" ").append(havingStr);
        outStrBuffClause.append(" ").append(orderByStr);
        String outputQuery = outStrBuffClause.toString().trim();
        if (semiColon != null) {
            outputQuery = outputQuery + semiColon;
        }
        if (QueryConversionUtility.containsCheck(outputQuery = QueryConversionUtility.getRplFromMap(outputQuery, overMap, "(##OVER##\\d+#)"), "TOP")) {
            outputQuery = outputQuery.replaceAll("(?i),TOP", ", TOP");
        }
        if (QueryConversionUtility.containsCheck(outputQuery, " sample ")) {
            boolean isOrder = !orderByStr.isEmpty();
            outputQuery = TeradataQueryKeywordReplacer.doRplSampleKeywrd(outputQuery, isOrder);
        }
        outputQuery = QueryConversionUtility.getRplFromMap(outputQuery, quoteMap, "(##QUOTE##\\d+#)");
        return outputQuery;
    }

    private static String doModifytoStructuredQuery(String inputQry) {
        String output = inputQry;
        if (!output.matches("(?i).*(?<!\\w)(as\\s+)(Qualify)(?!\\w).*")) {
            String selectQry;
            Pattern patternbfr;
            Matcher matcherbfr;
            boolean findMatcher;
            HashMap<String, String> overQryMap = new HashMap<String, String>(5);
            int overQryCnt = 1;
            String ovrPlaceHolder = "##OVRQRY##";
            boolean flag = false;
            if (output.matches("(?i).*(?<!\\w)over(?!\\w)\\s*(?:#S#\\d+#E#\\s*)*\\(.*?(?<!\\w)order\\s+by(?!\\w).*?\\).*?(?<!\\w)from(?!\\w).*")) {
                Pattern pattrnOverFunc = Pattern.compile("(?i)(?<!\\w)(over\\s*(?:#S#\\d+#E#\\s*)*\\(.*?)(?<!\\w)from(?!\\w)");
                Matcher matchOverFunc = pattrnOverFunc.matcher(output);
                String ovrStr = null;
                while (matchOverFunc.find()) {
                    ovrStr = QueryConversionUtility.doGetReplaceString(matchOverFunc.group(1));
                    overQryMap.put(ovrPlaceHolder + overQryCnt, ovrStr);
                    output = output.replace(ovrStr, ovrPlaceHolder + overQryCnt);
                    ++overQryCnt;
                    matchOverFunc = pattrnOverFunc.matcher(output);
                    flag = true;
                }
            }
            if ((findMatcher = output.matches("(?i).*((?<!\\w)(?:where|having|order\\s+by|group\\s+by|Qualify)(?!\\w).*?)((?<!\\w)from(?!\\w).*?)(;.*|$)")) && (matcherbfr = (patternbfr = Pattern.compile("(?i)(.*?)((?<!\\w)(?:where|having|order\\s+by|group\\s+by|Qualify)(?!\\w).*?)((?<!\\w)from(?!\\w).*?)(;.*|$)")).matcher(output)).find() && !QueryConversionUtility.containsCheck(selectQry = matcherbfr.group(1), " FROM ")) {
                StringBuffer selectClauseWithFrom = new StringBuffer();
                output = "";
                selectClauseWithFrom.append(selectQry).append(matcherbfr.group(3)).append(" ").append(matcherbfr.group(2)).append(" ").append(matcherbfr.group(4).trim());
                output = selectClauseWithFrom.toString();
            }
            if (flag) {
                output = QueryConversionUtility.doReplaceFunctionVariables(output, overQryMap, ovrPlaceHolder);
            }
        }
        return output;
    }

    private static String doGetOrderByClause(String strAfterFrmClause) {
        Pattern pattern;
        Matcher matcher;
        String orderByStr = "";
        if (strAfterFrmClause.matches("(?i).*(?<!\\w)order\\s+by(?!\\w).*") && (matcher = (pattern = Pattern.compile("(?i).*?((?<!\\w)order\\s+by(?!\\w).*?)(?<!\\w)(where|having|group\\s+by|Qualify|$)(?!\\w)")).matcher(strAfterFrmClause)).find()) {
            orderByStr = matcher.group(1);
        }
        return orderByStr;
    }

    private static String doGetHavingClause(String strAfterFrmClause) {
        Pattern pattern;
        Matcher matcher;
        String havingStr = "";
        if (strAfterFrmClause.matches("(?i).*(?<!\\w)Having(?!\\w).*") && (matcher = (pattern = Pattern.compile("(?i).*?((?<!\\w)Having(?!\\w).*?)(?<!\\w)(where|order\\s+by|group\\s+by|Qualify|$)(?!\\w)")).matcher(strAfterFrmClause)).find()) {
            havingStr = matcher.group(1);
        }
        return havingStr;
    }

    private static String doGetGroupByClause(String strAfterFrmClause) {
        Pattern pattern;
        Matcher matcher;
        String groupByStr = "";
        if (strAfterFrmClause.matches("(?i).*(?<!\\w)group\\s+by(?!\\w).*") && (matcher = (pattern = Pattern.compile("(?i).*?((?<!\\w)group\\s+by(?!\\w).*?)(?<!\\w)(where|having|order\\s+by|Qualify|$)(?!\\w)")).matcher(strAfterFrmClause)).find()) {
            groupByStr = matcher.group(1);
        }
        return groupByStr;
    }

    private static String doGetJoinsInQualify(String qualifyStr) {
        Matcher matcher;
        String joinStr = "";
        if (qualifyStr.matches("(?i).*(?<!\\w)Qualify(?!\\w).*") && (matcher = JOIN_PAT.matcher(qualifyStr)).find()) {
            joinStr = matcher.group(1);
        }
        return joinStr;
    }

    private static String doGetQualifyClause(String strAfterFrmClause) {
        Pattern pattern;
        Matcher matcher;
        String qualifyStr = "";
        if (strAfterFrmClause.matches("(?i).*(?<!\\w)Qualify(?!\\w).*") && (matcher = (pattern = Pattern.compile("(?i).*?((?<!\\w)Qualify(?!\\w).*?)(?<!\\w)(where|having|order\\s+by|group\\s+by|$)(?!\\w)")).matcher(strAfterFrmClause)).find()) {
            qualifyStr = matcher.group(1);
            qualifyStr = qualifyStr.replaceAll("(?i)(?<!\\w)not\\s*=|\\^\\s*=", "<>");
            qualifyStr = QueryConversionUtility.doReplaceOperators(qualifyStr, "(\\s(?:eq|gt|lt|le|ge|ne)(\\s|#|\\())");
        }
        return qualifyStr;
    }

    private static String doGetWhereClause(String strAfterFrmClause) {
        Pattern pattern;
        Matcher matcher;
        String whereStr = "";
        if (strAfterFrmClause.matches("(?i).*(?<!\\w)where(?!\\w).*") && (matcher = (pattern = Pattern.compile("(?i).*?((?<!\\w)where(?!\\w).*?)(?<!\\w)(having|order\\s+by|group\\s+by|Qualify|$)(?!\\w)")).matcher(strAfterFrmClause)).find()) {
            whereStr = matcher.group(1);
        }
        return whereStr;
    }

    private static String doRplSampleKeywrd(String inputQryVal, boolean isOrder) {
        String frmStr;
        String inputQry = inputQryVal;
        Matcher matchSample = PATTERN_SAMPLE.matcher(inputQry);
        String sampleStr = null;
        if (matchSample.find()) {
            sampleStr = matchSample.group(1);
            inputQry = TeradataQueryKeywordReplacer.addSampleStrAtEnd(inputQry, sampleStr);
        }
        String fromStg = frmStr = TeradataQueryKeywordReplacer.extractFromStr(inputQry);
        if (isOrder) {
            fromStg = fromStg.replaceFirst("(?i)\\ssample\\s", " limit ");
            inputQry = inputQry.replace(frmStr, fromStg);
        } else {
            inputQry = inputQry.replaceAll("(?i) sample ", " limit ");
        }
        return inputQry;
    }

    private static String addSampleStrAtEnd(String inputQry, String sampleStr) {
        String outputQry = inputQry;
        outputQry = (outputQry = outputQry.replace(sampleStr, "").trim()).endsWith(";") ? outputQry.replace(";", " " + sampleStr + ";") : outputQry + " " + sampleStr;
        return outputQry;
    }

    private static String extractFromStr(String inputQry) {
        String fromLength = inputQry;
        if (QueryConversionUtility.containsCheck(inputQry, "from")) {
            fromLength = inputQry.substring(QueryConversionUtility.toLower(inputQry).lastIndexOf("from"));
        }
        return fromLength;
    }

    private static String doReplaceCollectStat(String inputQuery) throws MigrationServiceException {
        String inputSql = inputQuery;
        String output = inputQuery;
        LinkedHashMap<String, String> quoteMap = new LinkedHashMap<String, String>(10);
        inputSql = QueryConversionUtility.getSingleDoubleQuoteMap(inputSql, quoteMap);
        Pattern pattern = Pattern.compile("(?i)(.*)(collect\\s+(?:#S#\\d+#E#\\s*)*(?:stat(?:s)?|statistics)\\s+(?:on\\s)?)(.*?)((\\scolumn(?!\\w)|\\sindex(?!\\w))(.*?))?;(.*)");
        Matcher matcher = pattern.matcher(inputSql);
        if (matcher.find()) {
            output = TeradataQueryKeywordReplacer.getOutQry(matcher);
        }
        output = QueryConversionUtility.getRplFromMap(output, quoteMap, "(##QUOTE##\\d+#)");
        return output;
    }

    private static String getOutQry(Matcher matcher) {
        ReplacerMap queryMap = null;
        String tableName = null;
        String commAftercol = null;
        queryMap = new ReplacerMap();
        tableName = matcher.group(3);
        commAftercol = matcher.group(7);
        queryMap.put("comment", matcher.group(1));
        String columns = matcher.group(6);
        if (columns != null && columns.contains("ON")) {
            tableName = tableName + matcher.group(4);
            columns = null;
        }
        columns = TeradataQueryKeywordReplacer.getColumnsVal(columns);
        if (tableName.matches("(?i)column\\s*.*") && columns.isEmpty()) {
            String tableNameWoCmnt = tableName.replaceAll("(?i)#S#\\d+#E#", "").trim();
            Matcher matcherCollStat = PATTERN_COLL_STAT.matcher(tableNameWoCmnt);
            Matcher matcherOn = PATTERN_ON.matcher(tableNameWoCmnt);
            String commaOpr = "";
            String columnBuffer = "";
            StringBuffer colBuffer = new StringBuffer();
            StringBuffer sb = new StringBuffer(128);
            while (matcherCollStat.find()) {
                commaOpr = TeradataQueryKeywordReplacer.getColBuff(matcherCollStat, commaOpr, colBuffer);
            }
            columnBuffer = colBuffer.toString();
            if (!columnBuffer.startsWith("(")) {
                sb.append("(").append(colBuffer).append(")");
            }
            if (matcherOn.find()) {
                tableName = matcherOn.group(1);
            }
            columns = columnBuffer = sb.toString();
        }
        String output = TeradataQueryKeywordReplacer.setQueryMapAndOutput(queryMap, tableName, commAftercol, columns);
        return output;
    }

    private static String getColBuff(Matcher matcherCollStat, String commaOpr, StringBuffer colBuffer) {
        String colName = "";
        colName = matcherCollStat.group(1).trim();
        String columnBuffer = colBuffer.toString();
        if (!QueryConversionUtility.containsCheck(columnBuffer, colName)) {
            colBuffer.append(commaOpr).append(colName);
            commaOpr = ",";
        }
        return commaOpr;
    }

    private static String setQueryMapAndOutput(ReplacerMap queryMap, String tableName, String commAftercol, String columns) {
        queryMap.put("tablename", tableName);
        queryMap.put("columns", columns);
        String output = queryMap.doSqlReplacement("${comment}ANALYZE ${tablename} ${columns};");
        if (commAftercol != null) {
            output = output + commAftercol;
        }
        return output;
    }

    private static String getColumnsVal(String columnsInp) {
        String columns = columnsInp;
        if (columns == null) {
            columns = "";
        } else if (!columns.replaceAll("(?i)#S#\\d+#E#", "").trim().startsWith("(")) {
            columns = "(" + columns + ")";
        }
        return columns;
    }

    public static String doPutOrientationColumn(String input) {
        int semiColonIndex = input.indexOf(59);
        String inputSql = input.substring(0, semiColonIndex + 1);
        String indexSql = "";
        if (input.length() > semiColonIndex) {
            indexSql = input.substring(semiColonIndex + 1);
        }
        if (FeatureLoader.getBooleanProperty("rowstoreToColumnstore")) {
            inputSql = TeradataQueryKeywordReplacer.doRowStoreColumnStore(inputSql);
        }
        inputSql = inputSql + indexSql;
        return inputSql;
    }

    public static String doRowStoreColumnStore(String inputSqlVal) {
        boolean sCondition;
        String inputSql = inputSqlVal;
        boolean fCondition = !QueryConversionUtility.containsCheck(inputSql, "unique") && !QueryConversionUtility.containsCheck(inputSql, "check") && !QueryConversionUtility.containsCheck(inputSql, "primary key");
        boolean bl = sCondition = !QueryConversionUtility.containsCheck(inputSql, "select") && !QueryConversionUtility.containsCheck(inputSql, "grant ") && !QueryConversionUtility.containsCheck(inputSql, "revoke ");
        if (fCondition || sCondition) {
            inputSql = QueryConversionUtility.doReplaceSpecificGrp(inputSql, "(.*?)(on\\s*commit\\s*preserve\\s*rows.*|distribute\\s*by\\s*hash.*|;)", "", "with (ORIENTATION = column) ", 1, true);
        }
        return inputSql;
    }

    static String doGetReplacementForOrderbyInRankFunc(String inputSqlVal) {
        String output = inputSqlVal;
        String inputSql = inputSqlVal;
        Pattern pattern = Pattern.compile("((?<!\\w)(?:rank)\\s*(#S#\\d+#E#\\s*)*\\()\\s*(?:#S#\\d+#E#\\s*)*(?:(?:\\$?\\w.*?)|(?:\\\"\\$.*?\\)))", 2);
        Matcher matcher = pattern.matcher(output);
        int startindex = 0;
        String grpValue = null;
        String rankFunc = null;
        String rankCol = null;
        while (matcher.find()) {
            String[] arr;
            startindex = matcher.start(1);
            StringBuffer strBuf = new StringBuffer();
            grpValue = matcher.group(1);
            rankFunc = QueryConversionUtility.doGetReplaceString(output.substring(startindex));
            rankCol = rankFunc.substring(rankFunc.indexOf(40) + 1, rankFunc.lastIndexOf(41));
            for (String col : arr = rankCol.split(",(?![^(]*\\))")) {
                if (!col.matches("(?i).*(asc|desc)\\s*\\)?\\s*$")) {
                    strBuf.append(col).append(" DESC ").append(",");
                    continue;
                }
                strBuf.append(col).append(",");
            }
            String replacement = strBuf.replace(strBuf.length() - 1, strBuf.length(), "").toString();
            replacement = grpValue + replacement + ')';
            inputSql = inputSql.replace(rankFunc, replacement);
        }
        return inputSql;
    }

    public static String doPreBulkChanges(String inputQry) throws MigrationServiceException {
        String output = inputQry;
        output = TeradataQueryKeywordReplacer.doPutQuoteSymbolKeyword(output);
        TeradataDateFormatUtility dateUtility = new TeradataDateFormatUtility();
        output = dateUtility.dateTypeCasting(output);
        output = TeradataQueryKeywordReplacer.doCsReplacement(output);
        output = TeradataQueryKeywordReplacer.viewWithLock(output);
        if (QueryConversionUtility.containsCheck(output = TeradataQueryKeywordReplacer.doMigrateWithCheckOption(output), "CREATE TABLE")) {
            output = TeradataQueryKeywordReplacer.doMigrateVarcharAndChar(output);
        }
        output = TeradataQueryKeywordReplacer.doMigrateCharsetCase(output);
        output = QueryConversionUtility.doReplaceTrunc(output);
        output = TeradataQueryKeywordReplacer.doDSQLMigration(output);
        output = TeradataQueryKeywordReplacer.doAdjustComment(output);
        return output;
    }

    private static String doAdjustComment(String input) {
        Pattern commentPattern = Pattern.compile("(?i)(?<!\\w)comment(?!\\w)\\s+on\\s+(table)\\s+(\\$?\\{?\\s*\\w+\\s*\\}?\\.\\$?\\w+)\\s+(.*?);");
        Matcher commentMatcher = commentPattern.matcher(input);
        StringBuffer output = new StringBuffer(input);
        Map<String, String> createObjMap = TeradataMigrationService.getCreateTypeMap();
        int startIdx = -1;
        int endIdx = -1;
        if (commentMatcher.find()) {
            String objCommentType = commentMatcher.group(1);
            startIdx = commentMatcher.start(1);
            endIdx = commentMatcher.end(1);
            String objName = commentMatcher.group(2);
            String objType = createObjMap.get(objName);
            if (!objCommentType.equalsIgnoreCase(objType)) {
                output.replace(startIdx, endIdx, "VIEW");
            }
        }
        return output.toString();
    }

    private static String doDSQLMigration(String input) {
        String output = input;
        if (FeatureLoader.getBooleanProperty("dsqlSupport")) {
            if (QueryConversionUtility.containsCheck(output, "..SET")) {
                Matcher matcher = SET_END_PAT.matcher(output);
                while (matcher.find()) {
                    String key = matcher.group(2);
                    String value = matcher.group(3);
                    TeradataMigrationService.addDSQLSetMap(key, value.trim());
                }
            }
            if (QueryConversionUtility.containsCheck(output, "STRTOK")) {
                output = TeradataQueryKeywordReplacer.doCheckSTROK(output);
            }
            if (FeatureLoader.getBooleanProperty("input_date_format_yyyymmdd")) {
                output = TeradataQueryKeywordReplacer.doReplaceDateFunction(output);
            }
            if (output.matches("(?i).*trim\\s*\\((?!cast).*")) {
                output = TeradataQueryKeywordReplacer.doChangeTrimFunction(output);
            }
        }
        return output;
    }

    private static String doCheckSTROK(String input) {
        int idxStrTok = 0;
        String output = input;
        do {
            if ((idxStrTok = QueryConversionUtility.getIndex(output, "strtok", idxStrTok)) == -1) continue;
            String strTokFunc = QueryUtilityExt.doGetStringFromGivenIndex(idxStrTok, output);
            String params = strTokFunc.substring(strTokFunc.indexOf("(") + 1, strTokFunc.lastIndexOf(")"));
            String[] paramsArr = params.trim().split(",(?![^(]*\\))");
            if (paramsArr[1].length() == 3) {
                int substringIndex = idxStrTok + strTokFunc.length();
                strTokFunc = strTokFunc.replaceFirst("(?i)(?<!\\w)STRTOK(?!\\w)", "split_part");
                output = output.substring(0, idxStrTok) + strTokFunc + output.substring(substringIndex);
            } else if (logger.isInfoEnabled()) {
                logger.info("Gauss will not support STRTOK multiple character splitting.");
            }
            idxStrTok += 5;
        } while (QueryConversionUtility.getIndex(output, "strtok", idxStrTok) != -1);
        return output;
    }

    private static String doChangeTrimFunction(String input) {
        String output = input;
        int indexTrim = 0;
        int endIdx = 0;
        StringBuffer sb = new StringBuffer();
        String trimString = "";
        int startIdx = 0;
        while (indexTrim >= 0) {
            if ((indexTrim = QueryConversionUtility.getIndex(output, "TRIM", indexTrim)) == -1) continue;
            trimString = QueryUtilityExt.doGetStringFromGivenIndex(indexTrim, output);
            endIdx = indexTrim + trimString.length();
            sb.append(output.substring(startIdx, indexTrim));
            if (trimString.matches("(?i).*\\(\\s*int\\s*\\).*")) {
                String colName = "";
                colName = trimString.substring(trimString.indexOf("(") + 1, trimString.lastIndexOf(")"));
                if (colName.contains("(")) {
                    colName = colName.substring(0, colName.indexOf("("));
                    sb.append("TRIM(mig_fn_castasint(" + colName + "))");
                } else {
                    sb.append("TRIM(" + colName + ")");
                }
            } else {
                sb.append(trimString);
            }
            startIdx = endIdx;
            indexTrim = endIdx;
        }
        sb.append(output.substring(endIdx));
        output = sb.toString();
        return output;
    }

    private static String doReplaceDateFunction(String input) {
        String output = input;
        Matcher dateMatcher = DATE_FUNCTION_PAT.matcher(output);
        int startIdx = 0;
        int tempIdx = 0;
        int endIdx = 0;
        StringBuffer sb = new StringBuffer();
        while (dateMatcher.find()) {
            String dateString = dateMatcher.group(2);
            String replaceString = "TO_DATE(" + dateString + ",'YYYYMMDD')";
            tempIdx = dateMatcher.start();
            endIdx = dateMatcher.end();
            sb.append(output.substring(startIdx, tempIdx));
            sb.append(replaceString);
            startIdx = endIdx;
        }
        sb.append(output.substring(endIdx));
        return sb.toString();
    }

    private static String doMigrateWithCheckOption(String input) throws MigrationServiceException {
        String output = input;
        Pattern patternCheck = Pattern.compile("(?i)(?<!\\w)with(?!\\w)(?:\\s*#s#\\d+#e#)*\\s*(?<!\\w)check(?!\\w)(?:\\s*#s#\\d+#e#)*\\s*(?<!\\w)option(?!\\w)\\s*");
        Matcher matcherCheck = patternCheck.matcher(output);
        String withCheckOption = null;
        while (matcherCheck.find()) {
            if (FeatureLoader.getBooleanProperty("tdMigrateVIEWCHECKOPTION")) {
                withCheckOption = matcherCheck.group();
                output = output.replace(withCheckOption, "/*" + withCheckOption + "*/");
                continue;
            }
            throw new MigrationServiceException("[DSC_ERR_003_009] " + MessageLoader.getMessage("DSC_ERR_003_009"));
        }
        return output;
    }

    private static String doMigrateCharsetCase(String input) throws MigrationServiceException {
        boolean isMigrateCharsetEnabled = FeatureLoader.getBooleanProperty("tdMigrateCharsetCase");
        Pattern patternCheck = Pattern.compile("(?i)((\\s+not)?\\s+CASESPECIFIC|\\s+CHARACTER\\s+SET\\s+(?:UNICODE|LATIN|GRAPHIC))");
        Matcher matcherCheck = patternCheck.matcher(input);
        Object charsetCase = null;
        int startIndex = 0;
        StringBuffer sb = new StringBuffer(128);
        while (matcherCheck.find()) {
            if (isMigrateCharsetEnabled) {
                int beginIndex = matcherCheck.start(1);
                int endIndex = matcherCheck.end(1);
                sb.append(input.substring(startIndex, beginIndex));
                startIndex = endIndex;
                continue;
            }
            throw new MigrationServiceException("[DSC_ERR_003_010] " + MessageLoader.getMessage("DSC_ERR_003_010"));
        }
        sb.append(input.substring(startIndex));
        return sb.toString();
    }

    private static String doMigrateVarcharAndChar(String input) throws MigrationServiceException {
        String output = input;
        StringBuffer sb = new StringBuffer(128);
        String isMigrateDefaultCharset = FeatureLoader.getStringProperty("default_charset");
        Matcher getColMatch = GET_COL_PAT.matcher(output);
        Pattern getVarcharOrChar = Pattern.compile("(?i)((?<!\\w)varchar|char(?!\\w)).*?CHARACTER\\s+SET\\s+(LATIN|UNICODE|GRAPHIC)");
        String cols = "";
        String charSet = "";
        String type = "";
        String temp = "";
        if (getColMatch.find()) {
            cols = getColMatch.group(1);
        }
        String[] colArr = null;
        colArr = QueryConversionUtility.doGetArrSplit(cols, ",");
        if (!cols.isEmpty() && (QueryConversionUtility.containsCheck(cols, "varchar") || QueryConversionUtility.containsCheck(cols, "char"))) {
            for (String col : colArr) {
                Matcher getVarcharOrCharMatcher = getVarcharOrChar.matcher(col);
                if (getVarcharOrCharMatcher.find()) {
                    type = getVarcharOrCharMatcher.group(1);
                    charSet = getVarcharOrCharMatcher.group(2);
                    if (QueryConversionUtility.containsCheck(charSet, "UNICODE") || QueryConversionUtility.containsCheck(charSet, "GRAPHIC")) {
                        col = QueryConversionUtility.replace(col, "(?i)" + type, "NVARCHAR2", true);
                    }
                } else if (QueryConversionUtility.containsCheck(isMigrateDefaultCharset, "UNICODE") || QueryConversionUtility.containsCheck(isMigrateDefaultCharset, "GRAPHIC")) {
                    col = QueryConversionUtility.replace(col, "(?i)(?<!\\w)VARCHAR(?!\\w)", "NVARCHAR2", true);
                    col = QueryConversionUtility.replace(col, "(?i)(?<!\\w)CHAR(?!\\w)", "NVARCHAR2", true);
                }
                sb.append(col).append(",");
            }
            temp = sb.toString();
            if (temp.endsWith(",")) {
                temp = temp.substring(0, temp.length() - 1);
            }
            output = output.replace(cols, temp);
        }
        return output;
    }

    private static String viewWithLock(String inputQry) throws MigrationServiceException {
        String output = inputQry;
        Pattern patternLock = Pattern.compile("(?i)((?<!\\w)(?:LOCK|LOCKING)(?!\\w).*(?<!\\w)(?:ACCESS|READ|WRITE|EXCLUSIVE)(?!\\w)\\s*)");
        Matcher matcherLock = patternLock.matcher(output);
        String lockToAccess = null;
        if (matcherLock.find()) {
            if (FeatureLoader.getBooleanProperty("tdMigrateLOCKOption")) {
                lockToAccess = matcherLock.group(1);
                output = output.replace(lockToAccess, "/*" + lockToAccess + "*/");
            } else {
                throw new MigrationServiceException("[DSC_ERR_003_011] " + MessageLoader.getMessage("DSC_ERR_003_011"));
            }
        }
        return output;
    }

    private static String doCsReplacement(String input) {
        LinkedHashMap<String, String> singleDoubleQuoteMap = new LinkedHashMap<String, String>(10);
        String output = input;
        output = QueryConversionUtility.getSingleDoubleQuoteMap(output, singleDoubleQuoteMap);
        output = output.replaceAll("(?i)(\\(\\s*(?:#S#\\d+#E#\\s*)*CS\\s*(?:#S#\\d+#E#\\s*)*\\))", "");
        output = QueryConversionUtility.getRplFromMap(output, singleDoubleQuoteMap, "(##QUOTE##\\d+#)");
        return output;
    }

    public static String doPostBulkChanges(String inputQry) {
        inputQry = inputQry.replaceAll("(?i)\\'([A-F0-9]+)\\'\\s*xc(?!\\w)", "E'\\\\x$1'");
        inputQry = inputQry.replaceAll("(?i)\\'(\\d+)\\'xb(?!\\w)", "BYTEA '\\\\x$1'");
        return inputQry;
    }

    private void createIdxConstraintsBO(String tableColumnsWOCmnt, IIndexConstraintsBO objIndexConstraintsBO, String columnsStringInp) {
        String columnsString = columnsStringInp;
        String columnsStringWOCmnt = columnsString.replaceAll("(?i)#S#\\d+#E#", "").trim();
        if (columnsStringWOCmnt.trim().startsWith("(")) {
            columnsString = QueryConversionUtility.removeParenthesis(columnsString);
            this.doGetConstraints(columnsString, objIndexConstraintsBO);
        } else if (tableColumnsWOCmnt.matches("(?i)(?<!\\w)as(?!\\w).*")) {
            ArrayList<String> columnArrays = new ArrayList<String>(10);
            columnArrays.add(columnsString);
            objIndexConstraintsBO.setColumnArrays(columnArrays);
        }
    }

    private static List<String> doAddReferenceColInlst(List<String> columnArrs, String columnInp, int iIndex) {
        ArrayList<String> columnArrays = new ArrayList<String>(columnArrs);
        String column = columnInp;
        String lwrColumn = QueryConversionUtility.toLower(column);
        String cmntPlaceholderAtEnd = "";
        if (column.contains("#S#") && column.trim().endsWith("#E#")) {
            cmntPlaceholderAtEnd = QueryConversionUtility.doGetEndCmnts(column);
        }
        int endIndex = lwrColumn.indexOf("references ");
        column = column.substring(0, endIndex);
        columnArrays.set(iIndex, column + cmntPlaceholderAtEnd);
        return columnArrays;
    }

    private static int doAddUniqueColInLst(List<String> columnArrays, int uniqueCntInp, Map<String, String> indexMap, Map<String, String> colIndexMap, List<String> uniqueList, String column, String columnWOCmnt, int iIndex) {
        int uniqueCnt = uniqueCntInp;
        if (columnWOCmnt.matches("(?i)(?<!\\w)UNIQUE(?!\\w).*")) {
            String columnNames = QueryConversionUtility.removeParenthesis(columnWOCmnt);
            uniqueList.add(columnNames);
            columnArrays.set(iIndex, "#UNIQUE#" + uniqueCnt + "#");
            indexMap.put("#UNIQUE#" + uniqueCnt + "#", column);
            colIndexMap.put(column, "#UNIQUE#" + uniqueCnt + "#");
            ++uniqueCnt;
        } else if (columnWOCmnt.matches("(?i).*\\s+UNIQUE(?!\\w)")) {
            int endIndex = columnWOCmnt.indexOf(32);
            String columnNames = columnWOCmnt.substring(0, endIndex);
            uniqueList.add(columnNames);
            int index = column.trim().length() - 6;
            String placeHolderColumn = column.trim().substring(0, index) + "#" + "UNIQUE" + "#" + uniqueCnt + "#";
            columnArrays.set(iIndex, placeHolderColumn);
            indexMap.put("#UNIQUE#" + uniqueCnt + "#", column.substring(index));
            colIndexMap.put(column, "#UNIQUE#" + uniqueCnt + "#");
            ++uniqueCnt;
        }
        return uniqueCnt;
    }

    public static String doReplaceMDIFF(String ipQuery) throws MigrationServiceException {
        String inputSql;
        String outputQuery = inputSql = ipQuery;
        StringBuffer outputStrBuff = null;
        String grpElements = null;
        String[] groupByArray = null;
        try {
            if (!(QueryConversionUtility.containsCheck(inputSql, "cube") || QueryConversionUtility.containsCheck(inputSql, "rollup") || QueryConversionUtility.containsCheck(inputSql, "grouping"))) {
                groupByArray = QueryConversionUtility.getGroupByElements(inputSql);
            }
            if (groupByArray != null && groupByArray.length > 2) {
                inputSql = groupByArray[0];
                grpElements = groupByArray[2];
            }
            outputQuery = inputSql;
            Pattern patternMdiff = Pattern.compile("(?i)MDIFF\\s*\\(");
            Matcher matcherMdiff = patternMdiff.matcher(inputSql);
            String mdiffFunction = null;
            String mdiffCols = null;
            int mdiffStart = 0;
            while (matcherMdiff.find()) {
                outputStrBuff = new StringBuffer();
                mdiffStart = matcherMdiff.start();
                mdiffFunction = QueryConversionUtility.doGetReplaceString(inputSql.substring(mdiffStart));
                mdiffCols = QueryConversionUtility.removeParenthesis(mdiffFunction);
                ColumnSplitter splitter = new ColumnSplitter();
                List<String> mdiffColList = splitter.doGetAllColumns(mdiffCols);
                outputQuery = TeradataQueryKeywordReplacer.doReplaceMDIFFCol(outputQuery, outputStrBuff, grpElements, mdiffFunction, mdiffColList);
            }
            if (outputStrBuff != null && groupByArray != null && groupByArray.length > 1) {
                outputQuery = outputQuery.replace(groupByArray[1], "");
            }
        }
        catch (NumberFormatException e) {
            logger.error(ErrorLoggerUtility.getExceptionDetails(e) + " Error occurred in number format. " + e.getMessage());
            throw new MigrationServiceException("[DSC_ERR_003_012] " + MessageLoader.getMessage("DSC_ERR_003_012"));
        }
        return outputQuery;
    }

    private static String doReplaceMDIFFCol(String outputQueryVal, StringBuffer outputStrBuff, String grpElements, String mdiffFunction, List<String> mdiffColList) throws MigrationServiceException {
        String outputQuery = outputQueryVal;
        if (mdiffColList.size() < 2) {
            throw new MigrationServiceException("[DSC_ERR_003_013] " + MessageLoader.getMessage("DSC_ERR_003_013"));
        }
        String col1 = mdiffColList.get(1).replaceAll("(?i)#S#\\d+#E#", "").trim();
        int intValue = mdiffColList.size() >= 2 ? Integer.parseInt(col1) : -1;
        String firstElement = mdiffColList.get(0);
        if (mdiffColList.size() < 2 || intValue <= 0 || intValue >= 4096) {
            if (mdiffColList.size() < 2) {
                throw new MigrationServiceException("[DSC_ERR_003_013] " + MessageLoader.getMessage("DSC_ERR_003_013"));
            }
            throw new MigrationServiceException("[DSC_ERR_003_012] " + MessageLoader.getMessage("DSC_ERR_003_012"));
        }
        outputStrBuff.append(firstElement).append(" ").append("-").append("(");
        outputStrBuff.append("LAG").append("(").append(firstElement);
        outputStrBuff.append(",").append(mdiffColList.get(1)).append(",");
        outputStrBuff.append(QueryConversionUtility.toUpper("null")).append(")");
        outputStrBuff.append("over");
        outputStrBuff.append("(");
        TeradataQueryKeywordReplacer.doReplaceMDIFFGroupBy(outputStrBuff, grpElements, mdiffColList);
        outputQuery = outputQuery.replace(mdiffFunction, outputStrBuff.toString());
        return outputQuery;
    }

    private static void doReplaceMDIFFGroupBy(StringBuffer outputStrBuff, String grpElements, List<String> mdiffColList) {
        if (grpElements != null) {
            outputStrBuff.append("PARTITION BY").append(" ");
            outputStrBuff.append(grpElements).append(" ");
        }
        if (mdiffColList.size() > 2) {
            outputStrBuff.append(QueryConversionUtility.toUpper("order by")).append(" ");
            outputStrBuff.append(QueryConversionUtility.getColumnsFromList(2, mdiffColList));
        }
        outputStrBuff.append(")");
        outputStrBuff.append(")");
    }
}

