/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.teradata;

import com.huawei.db.migration.database.bo.IQueryPatternsBO;
import com.huawei.db.migration.exception.MigrationServiceException;
import com.huawei.db.migration.handlers.TeradataMigrationTaskHandler;
import com.huawei.db.migration.interfaces.IMigrationMapper;
import com.huawei.db.migration.interfaces.IMigrationParser;
import com.huawei.db.migration.services.TeradataMigrationService;
import com.huawei.db.migration.teradata.TeradataDateFormatUtility;
import com.huawei.db.migration.teradata.TeradataPatternHandler;
import com.huawei.db.migration.teradata.TeradataQueryKeywordReplacer;
import com.huawei.db.migration.util.FeatureLoader;
import com.huawei.db.migration.util.QueryConversionUtility;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TeradataSchemaHandler {
    public List<String> doSchemaProcess(List<String> inputList, String fileName, List<?> patterns) throws MigrationServiceException {
        TeradataMigrationTaskHandler taskHandler = new TeradataMigrationTaskHandler();
        IMigrationParser objParser = taskHandler.getParser();
        IMigrationMapper objMapper = taskHandler.getMapper();
        ArrayList<String> outputList = new ArrayList<String>(10);
        List<IQueryPatternsBO> schemaPatterns = null;
        TeradataPatternHandler patternHandler = new TeradataPatternHandler();
        for (String inputSQL : inputList) {
            if ((inputSQL = QueryConversionUtility.canonicalizeString(inputSQL)).contains("~#~")) {
                String[] inputQry = inputSQL.split("~#~");
                inputSQL = inputQry.length > 0 ? inputQry[0] : inputSQL;
            }
            inputSQL = QueryConversionUtility.doRemoveExtraSpace(inputSQL);
            schemaPatterns = patterns;
            String output = inputSQL;
            patternHandler.setFileName(fileName);
            LinkedHashMap<String, String> quoteMap = new LinkedHashMap<String, String>(10);
            output = QueryConversionUtility.getDoubleQuoteMap(output, quoteMap);
            TeradataDateFormatUtility formatUtil = new TeradataDateFormatUtility("schema");
            output = formatUtil.changeDateFormatFns(output);
            output = QueryConversionUtility.getRplFromMap(output, quoteMap, "(##QUOTE##\\d+#)");
            output = QueryConversionUtility.doReplaceSpecificGrp(output, "(?i)title\\s+u&\\'.*?\\'\\s*uescape\\s*\\'.*?\\'", "/*", "*/", 0, true);
            this.doAddTblNmeForWithData(fileName, output);
            output = this.doAddTblNmeAndColsWithDateFormat(output);
            output = patternHandler.doPatternSplitter(output, schemaPatterns, objMapper, objParser);
            output = TeradataQueryKeywordReplacer.doPostSchemaReplacement(output);
            outputList.add(output);
        }
        return outputList;
    }

    private String doAddTblNmeAndColsWithDateFormat(String outputVal) {
        Matcher matcherDate;
        Pattern patternDate;
        String tableName = null;
        String output = outputVal;
        String inputWOcmt = output.replaceAll("(?i)#S#\\d+#E#", "").trim();
        if (inputWOcmt.matches("(?i).*?(?<!\\w)(alter)(?!\\w).*?")) {
            output = QueryConversionUtility.canonicalizeString(output);
            patternDate = Pattern.compile("(?i)(alter\\s+table\\s(\\$?\\s*\\{?\\w+\\s*\\}?\\s*\\.\\s*\\$?\\s*\\{?\\w+\\}?(?:\\s*\\$\\s*\\{.*?\\})?|\\$?\\s*\\{?\".*?\"\\s*\\}?\\s*\\.\\s*\\$?\\s*\\{?\".*?\"\\}?(?:\\s*\\$\\s*\\{.*?\\})?|\\$?\\s*\\{?\".*?\"\\s*\\}?\\s*\\.\\s*\\$?\\s*\\{?\\w+\\}?(?:\\s*\\$\\s*\\{.*?\\})?|\\$?\\s*\\{?\\w+\\s*\\}?\\s*\\.\\s*\\$?\\s*\\{?\".*?\"\\}?(?:\\s*\\$\\s*\\{.*?\\})?|\\$?\\s*\\{?\".*?\"\\}?(?:\\s*\\$\\s*\\{.*?\\})?|\\$?\\s*\\{?\\w+\\}?(?:\\s*\\$\\s*\\{.*?\\})?)(\\s+(\\$?\\s*\\{?\\w+\\s*\\}?\\s*\\.\\s*\\$?\\s*\\{?\\w+\\}?(?:\\s*\\$\\s*\\{.*?\\})?|\\$?\\s*\\{?\".*?\"\\s*\\}?\\s*\\.\\s*\\$?\\s*\\{?\".*?\"\\}?(?:\\s*\\$\\s*\\{.*?\\})?|\\$?\\s*\\{?\".*?\"\\s*\\}?\\s*\\.\\s*\\$?\\s*\\{?\\w+\\}?(?:\\s*\\$\\s*\\{.*?\\})?|\\$?\\s*\\{?\\w+\\s*\\}?\\s*\\.\\s*\\$?\\s*\\{?\".*?\"\\}?(?:\\s*\\$\\s*\\{.*?\\})?|\\$?\\s*\\{?\".*?\"\\}?(?:\\s*\\$\\s*\\{.*?\\})?|\\$?\\s*\\{?\\w+\\}?(?:\\s*\\$\\s*\\{.*?\\})?))?\\s+)(ADD\\s*(#S#\\d+#E#\\s*)*((\\(\\s*)?(#S#\\d+#E#\\s*)*\"?\\s*#?\\w+\\s*\"?\\s+(#S#\\d+#E#\\s*)*date\\s+(#S#\\d+#E#\\s*)*format\\s*(#S#\\d+#E#\\s*)*'.*?'(\\s*,\\s*)?)*)");
            matcherDate = patternDate.matcher(output);
            if (matcherDate.find()) {
                String[] strArr;
                tableName = matcherDate.group(2).trim();
                String columns = matcherDate.group(5).trim();
                for (String col : strArr = columns.split(",")) {
                    String colUpd = col.replaceFirst("(?i)(?<!\\w)format(?!\\w)\\s*(#S#\\d+#E#(\\s*))*'.*?'", "");
                    output = output.replace(col, colUpd);
                }
            }
        }
        if (inputWOcmt.matches("(?i).*?(?<!\\w)(create)(?!\\w).*?") && (matcherDate = (patternDate = Pattern.compile("(?i)(?<!\\w)create\\s*(?:(?<!\\w)(set\\s+volatile|multiset\\s+volatile|volatile\\s+set|volatile\\s+multiset|volatile|multiset|set))?\\s+table\\s+(\\$?\\s*\\{?\\w+\\s*\\}?\\s*\\.\\s*\\$?\\s*\\{?\\w+\\}?(?:\\s*\\$\\s*\\{.*?\\})?|\\$?\\s*\\{?\".*?\"\\s*\\}?\\s*\\.\\s*\\$?\\s*\\{?\".*?\"\\}?(?:\\s*\\$\\s*\\{.*?\\})?|\\$?\\s*\\{?\".*?\"\\s*\\}?\\s*\\.\\s*\\$?\\s*\\{?\\w+\\}?(?:\\s*\\$\\s*\\{.*?\\})?|\\$?\\s*\\{?\\w+\\s*\\}?\\s*\\.\\s*\\$?\\s*\\{?\".*?\"\\}?(?:\\s*\\$\\s*\\{.*?\\})?|\\$?\\s*\\{?\".*?\"\\}?(?:\\s*\\$\\s*\\{.*?\\})?|\\$?\\s*\\{?\\w+\\}?(?:\\s*\\$\\s*\\{.*?\\})?)((.*)date\\s+format\\s+(.*))(?!\\w)")).matcher(inputWOcmt)).find()) {
            tableName = matcherDate.group(2).trim();
        }
        TeradataQueryKeywordReplacer.doAddTableNameAndColNameInMap(inputWOcmt, tableName);
        return output;
    }

    private void doAddTblNmeForWithData(String fileName, String output) {
        String tempQry = output.replaceAll("(?i)#S#\\d+#E#", "");
        if (QueryConversionUtility.containsCheck(tempQry = tempQry.replaceAll("\\s*\\.\\s*", ".").trim(), "with ") && QueryConversionUtility.containsCheck(tempQry, " data")) {
            tempQry = QueryConversionUtility.canonicalizeString(tempQry);
            Pattern pattern = Pattern.compile("(?i)create\\s+(.*?)(?<!\\w)table\\s+(.*?)(?<!\\w)as\\s+(.*?)(?<!\\w)with\\s+data(?!\\w).*");
            Matcher matcher = pattern.matcher(tempQry);
            String tableName = null;
            String setFn = null;
            if (matcher.find()) {
                setFn = matcher.group(1).trim();
                if (setFn.contains(" ")) {
                    setFn = setFn.substring(0, setFn.indexOf(32));
                }
                String tempSet = setFn.replaceAll("(?i)#S#\\d+#E#", "");
                boolean isVolatileTbl = false;
                if (QueryConversionUtility.containsCheck(tempSet, "volatile")) {
                    isVolatileTbl = true;
                }
                tableName = !(tableName = matcher.group(2).trim()).contains("\"") ? QueryConversionUtility.toUpper(tableName) : QueryConversionUtility.doGetSetTableName(tableName);
                if (QueryConversionUtility.equalCheck(setFn, "SET") || !FeatureLoader.getStringProperty("session_mode").equalsIgnoreCase("ansi") && (QueryConversionUtility.equalCheck(setFn, "volatile") || setFn.isEmpty())) {
                    TeradataMigrationService.addPackageNameMap(fileName, tableName);
                    if (isVolatileTbl) {
                        TeradataMigrationService.addSetTempTblsMap(fileName, tableName);
                    }
                }
            }
        }
    }
}

