/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.teradata;

import com.huawei.db.migration.util.ColumnSplitter;
import com.huawei.db.migration.util.DBPropertyLoader;
import com.huawei.db.migration.util.IGaussDBConstants;
import com.huawei.db.migration.util.QueryConversionUtility;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TeradataUtility {
    private String colNme;
    private String columnAlias;
    private String alias;

    public String doTableOperatorReplacement(String input) {
        String output = input;
        Pattern tableFinder = Pattern.compile("(?i)(.*?)((?<!\\w)table\\s*(#S#\\d+#E#\\s*)*\\()");
        Matcher tableMatcher = tableFinder.matcher(output);
        int tabAliasCounter = 1;
        String tableOperator = null;
        String tabName = null;
        String returnStr = null;
        boolean tableMatch = output.matches("(?i).*(?<!\\w)table(?!\\w).*");
        if (tableMatch) {
            while (tableMatcher.find()) {
                tableOperator = QueryConversionUtility.doGetReplaceString(output.substring(tableMatcher.start(2)));
                tabName = QueryConversionUtility.removeParenthesis(tableOperator);
                if (tableMatcher.group(3) != null) {
                    tabName = tableMatcher.group(3) + tabName;
                }
                if (tableOperator.matches("(?i).*(?<!\\w)returns\\s*(#S#\\d+#E#\\s*)*(?!\\w).*")) {
                    String tempInput = tableOperator.replaceAll("(?i)#S#\\d+#E#", "").trim();
                    returnStr = this.getReturnStr(tempInput);
                    tabName = tabName.replaceAll("(?i)(?<!\\w)returns(?!\\w).*", "");
                    output = output.replace(tableOperator, tabName);
                    output = this.addAliasToReturnTable(output, tabName, returnStr, tabAliasCounter++);
                } else {
                    output = output.replace(tableOperator, tabName);
                }
                tableMatcher = tableFinder.matcher(output);
            }
        }
        return output;
    }

    private String addAliasToReturnTable(String outputVal, String tabName, String returnStr, int tabAliasCounter) {
        LinkedHashMap<String, String> quoteMap = new LinkedHashMap<String, String>(10);
        String output = outputVal;
        output = QueryConversionUtility.getDoubleQuoteMap(output, quoteMap);
        Pattern pattern = Pattern.compile("(?i)(" + QueryConversionUtility.santizePattern(tabName) + "\\s*((as)?\\s*('?\\w+'?|##QUOTE##\\d#)))");
        Matcher matcher = pattern.matcher(output);
        if (matcher.find()) {
            int index = matcher.start(2);
            String tabAlias = matcher.group(2);
            if (tabAlias.matches("(?i)where|inner|outer|left|right|group|order|qualify|sample|limit")) {
                tabAlias = " as MigTblAlias" + tabAliasCounter + returnStr + " ";
                output = output.substring(0, index) + tabAlias + output.substring(index);
            } else {
                tabAlias = tabAlias + returnStr;
                output = output.replace(matcher.group(1), tabName + tabAlias);
            }
        } else {
            int index = output.indexOf(tabName);
            output = output.substring(0, index + tabName.length()) + " as " + "MigTblAlias" + tabAliasCounter + returnStr + output.substring(index + tabName.length());
        }
        output = QueryConversionUtility.getRplFromMap(output, quoteMap, "(##QUOTE##\\d+#)");
        return output;
    }

    private String getReturnStr(String tableOperator) {
        String returnStr = null;
        String retCols = null;
        Pattern returnFinder = Pattern.compile("(?i)(?<!\\w)returns(?!\\w)(.*?)\\)");
        Matcher returnMatcher = returnFinder.matcher(tableOperator);
        if (returnMatcher.find()) {
            retCols = returnStr = returnMatcher.group(1).trim();
            if (returnStr.startsWith("(")) {
                if (!returnStr.endsWith(")")) {
                    returnStr = returnStr + ")";
                }
                returnStr = returnStr.substring(1);
                retCols = this.getColList(returnStr);
            } else if (returnStr.contains(" ")) {
                retCols = returnStr.substring(0, returnStr.indexOf(32));
            }
            retCols = "(" + retCols + ")";
        }
        return retCols;
    }

    private String getColList(String returnStrInp) {
        String returnStr = returnStrInp;
        String tempStr = QueryConversionUtility.doGetReplaceString(returnStr);
        if (tempStr.isEmpty()) {
            returnStr = returnStr.substring(0, returnStr.length() - 1);
        }
        ColumnSplitter splitter = new ColumnSplitter();
        List<String> columns = splitter.doGetAllColumns(returnStr);
        StringBuffer colList = new StringBuffer(128);
        for (String col : columns) {
            if (col.contains(" ")) {
                colList.append(col.substring(0, col.indexOf(32)));
                colList.append(",");
                continue;
            }
            colList.append(col).append(",");
        }
        colList.deleteCharAt(colList.length() - 1);
        return colList.toString();
    }

    public static String doAddTransactionForWithData(String outputSQL, String inputVal) {
        String output = outputSQL;
        StringBuffer outbuff = new StringBuffer(128);
        String firstTbl = null;
        String input = inputVal;
        if (input.matches("(?i).*?(?<!\\w)with\\s*(?:#S#\\d+#E#\\s*)*data(?!\\w).*") && output.matches("(?i).*?(?<!\\w)create\\s+.*?(?<!\\w)table(?!\\w).*?;insert\\s+into(?!\\w).*")) {
            outbuff.append("Begin").append(IGaussDBConstants.NEW_LINE);
            outbuff.append(output).append(IGaussDBConstants.NEW_LINE).append("end").append(";");
            outbuff.append(IGaussDBConstants.NEW_LINE).append("/");
            outbuff.append(IGaussDBConstants.NEW_LINE);
            if (input.matches("(?i).*?(?<!\\w)with\\s*(?:#S#\\d+#E#\\s*)*data(?!\\w).*\\s*.*(statistics|stat|stats)(?!\\w).*")) {
                Pattern pattern = Pattern.compile("(?i).*?(?<!\\w)create\\s+.*?(?<!\\w)table\\s*(\\$?\\s*\\{?\\w+\\s*\\}?\\s*\\.\\s*\\$?\\s*\\{?\\w+\\}?(?:\\s*\\$\\s*\\{.*?\\})?|\\$?\\s*\\{?\".*?\"\\s*\\}?\\s*\\.\\s*\\$?\\s*\\{?\".*?\"\\}?(?:\\s*\\$\\s*\\{.*?\\})?|\\$?\\s*\\{?\".*?\"\\s*\\}?\\s*\\.\\s*\\$?\\s*\\{?\\w+\\}?(?:\\s*\\$\\s*\\{.*?\\})?|\\$?\\s*\\{?\\w+\\s*\\}?\\s*\\.\\s*\\$?\\s*\\{?\".*?\"\\}?(?:\\s*\\$\\s*\\{.*?\\})?|\\$?\\s*\\{?\".*?\"\\}?(?:\\s*\\$\\s*\\{.*?\\})?|\\$?\\s*\\{?\\w+\\}?(?:\\s*\\$\\s*\\{.*?\\})?)");
                Matcher matcher = pattern.matcher(input);
                if (matcher.find()) {
                    firstTbl = matcher.group(1);
                }
                outbuff.append("ANALYZE " + firstTbl + " ;");
            }
            output = outbuff.toString();
        } else if (input.matches("(?i).*?(?<!\\w)with\\s*(?:#S#\\d+#E#\\s*)*data(?!\\w).*\\s*.*(statistics|stat|stats)(?!\\w).*") && !output.matches("(?i).*?(?<!\\w)create\\s+.*?(?<!\\w)table(?!\\w).*?;insert\\s+into(?!\\w).*")) {
            input = QueryConversionUtility.canonicalizeString(input);
            Pattern pattern = Pattern.compile("(?i).*?(?<!\\w)create\\s+.*?(?<!\\w)table\\s*(\\$?\\s*\\{?\\w+\\s*\\}?\\s*\\.\\s*\\$?\\s*\\{?\\w+\\}?(?:\\s*\\$\\s*\\{.*?\\})?|\\$?\\s*\\{?\".*?\"\\s*\\}?\\s*\\.\\s*\\$?\\s*\\{?\".*?\"\\}?(?:\\s*\\$\\s*\\{.*?\\})?|\\$?\\s*\\{?\".*?\"\\s*\\}?\\s*\\.\\s*\\$?\\s*\\{?\\w+\\}?(?:\\s*\\$\\s*\\{.*?\\})?|\\$?\\s*\\{?\\w+\\s*\\}?\\s*\\.\\s*\\$?\\s*\\{?\".*?\"\\}?(?:\\s*\\$\\s*\\{.*?\\})?|\\$?\\s*\\{?\".*?\"\\}?(?:\\s*\\$\\s*\\{.*?\\})?|\\$?\\s*\\{?\\w+\\}?(?:\\s*\\$\\s*\\{.*?\\})?)");
            Matcher matcher = pattern.matcher(input);
            if (matcher.find()) {
                firstTbl = matcher.group(1);
            }
            outbuff.append(output).append(IGaussDBConstants.NEW_LINE);
            outbuff.append("ANALYZE " + firstTbl + " ;");
            output = outbuff.toString();
        }
        return output;
    }

    public String doReplaceShortKeyword(String inputSql, String finderPattern, String replacingPattern, String replacementString) {
        String tempInput = inputSql.replaceAll("(?i)#S#\\d+#E#", "").trim();
        String result = inputSql;
        if ((tempInput = QueryConversionUtility.canonicalizeString(tempInput)).matches(finderPattern)) {
            result = inputSql.replaceFirst(replacingPattern, replacementString);
        }
        return result;
    }

    public String doChangeDeleteToTruncate(String outSql) {
        Pattern deletePat;
        Matcher deleteMatch;
        String output = outSql;
        String outputWoCmnt = output.replaceAll("(?i)#S#\\d+#E#", "").trim();
        if (outputWoCmnt.matches("(?i)delete(?!\\w)\\s+from\\s+.*?;") && outputWoCmnt.matches("(?i)delete(?!\\w)\\s+from\\s+(\\$?\\s*\\{?\\w+\\s*\\}?\\s*\\.\\s*\\$?\\s*\\{?\\w+\\}?(?:\\s*\\$\\s*\\{.*?\\})?|\\$?\\s*\\{?\".*?\"\\s*\\}?\\s*\\.\\s*\\$?\\s*\\{?\".*?\"\\}?(?:\\s*\\$\\s*\\{.*?\\})?|\\$?\\s*\\{?\".*?\"\\s*\\}?\\s*\\.\\s*\\$?\\s*\\{?\\w+\\}?(?:\\s*\\$\\s*\\{.*?\\})?|\\$?\\s*\\{?\\w+\\s*\\}?\\s*\\.\\s*\\$?\\s*\\{?\".*?\"\\}?(?:\\s*\\$\\s*\\{.*?\\})?|\\$?\\s*\\{?\".*?\"\\}?(?:\\s*\\$\\s*\\{.*?\\})?|\\$?\\s*\\{?\\w+\\}?(?:\\s*\\$\\s*\\{.*?\\})?)\\s*;") && (deleteMatch = (deletePat = Pattern.compile("(?i).*?(?<!\\w)(delete)(?!\\w).*?(?<!\\w)(from)(?!\\w).*?;.*")).matcher(output)).find()) {
            output = QueryConversionUtility.replace(output, deleteMatch.group(1), "truncate", true);
            output = QueryConversionUtility.replace(output, deleteMatch.group(2), "table", true);
        }
        return output;
    }

    public String changeTblSchemaValToGauss(String query, String colName) {
        Pattern colNamePattern = Pattern.compile("(?i)(?<!\\w)" + colName + "(?!\\w).*?=(.*?)((?<!\\w)(?:AND|THEN|OR|GROUP\\s+BY|HAVING|ORDER\\s+BY)(?!\\w)|$|;)");
        Matcher colNameMatch = colNamePattern.matcher(query);
        StringBuffer sbuf = new StringBuffer(128);
        int tempIdx = 0;
        int startIdx = 0;
        int endIdx = 0;
        while (colNameMatch.find()) {
            String colValue = colNameMatch.group(1);
            startIdx = colNameMatch.start(1);
            endIdx = colNameMatch.end(1);
            sbuf.append(query.substring(tempIdx, startIdx));
            sbuf.append("CASE WHEN TRIM(").append(colValue);
            sbuf.append(") LIKE '\"%'  THEN REPLACE(SUBSTR(").append(colValue);
            sbuf.append(", 2, LENGTH(").append(colValue);
            sbuf.append(")-2), '\"\"', '\"')").append("ELSE LOWER(").append(colValue);
            sbuf.append(") END").append(" ");
            tempIdx = endIdx;
        }
        sbuf.append(query.substring(endIdx));
        return sbuf.toString();
    }

    public String changeTblColNameValues(String query, String aliasInp) {
        Pattern dbcPattern = Pattern.compile("(?i)(\\w+)?\\.?(?<!\\w)((?<!\\w|')ColumnName|dbc\\s*\\.\\s*columns\\.ColumnName|ColumnType|dbc\\s*\\.\\s*columns\\.ColumnType|ColumnLength|dbc\\s*\\.\\s*columns\\.ColumnLength|DecimalTotalDigits|dbc\\s*\\.\\s*columns\\.DecimalTotalDigits|DecimalFractionalDigits|dbc\\s*\\.\\s*columns\\.DecimalFractionalDigits|databasename|dbc\\s*\\.\\s*columns\\.DatabaseName|tablename|dbc\\s*\\.\\s*columns\\.tablename|(?<!\\w|')ColumnId|dbc\\s*\\.\\s*columns\\.ColumnId|dbc\\s*\\.\\s*columns)(?!\\w)");
        Matcher dbcMatch = dbcPattern.matcher(query);
        StringBuffer qryBuf = new StringBuffer(128);
        int tempIdx = 0;
        this.alias = aliasInp;
        if (this.alias != null && this.alias.equalsIgnoreCase("on")) {
            this.alias = null;
        }
        while (dbcMatch.find()) {
            this.colNme = dbcMatch.group(2);
            String string = this.colNme = this.colNme.matches("(?i)dbc\\s*\\.\\s*columns(?!\\w).*") ? this.colNme.replace(" ", "") : this.colNme;
            if (this.alias == null && !this.colNme.contains("dbc.columns")) {
                this.colNme = "dbc.columns." + this.colNme;
            }
            int startIdx = dbcMatch.start(2);
            int endIdx = dbcMatch.end(2);
            this.columnAlias = dbcMatch.group(1);
            if (this.columnAlias != null) {
                this.colNme = this.colNme.replace(this.columnAlias, "");
            }
            this.replaceAliasValue(dbcMatch, query, tempIdx, startIdx, qryBuf);
            tempIdx = endIdx;
        }
        qryBuf.append(query.substring(tempIdx));
        return qryBuf.toString();
    }

    private void replaceAliasValue(Matcher dbcMatch, String query, int tempIdx, int startIdx, StringBuffer qryBuf) {
        String rplValue = this.colNme;
        if (this.columnAlias == null || this.columnAlias.equalsIgnoreCase(this.alias)) {
            boolean tCondition;
            rplValue = DBPropertyLoader.getStringProperty(QueryConversionUtility.toLower(this.colNme) + "Replace");
            boolean fCondition = this.columnAlias == null && this.alias != null;
            boolean sCondition = !this.colNme.equalsIgnoreCase("ColumnType") && !this.colNme.equalsIgnoreCase("dbc.columns") && !this.colNme.equalsIgnoreCase("dbc.indices");
            boolean bl = tCondition = !this.colNme.equalsIgnoreCase("dbc.tables");
            if (fCondition && sCondition && tCondition) {
                rplValue = this.alias + "." + rplValue;
            }
            String dataVal = TeradataUtility.doGetDataVal(this.colNme, this.columnAlias, this.alias, dbcMatch.group(1), rplValue);
            if (rplValue.contains("data_Type")) {
                rplValue = rplValue.replace("data_Type", dataVal);
            }
        } else if (this.alias != null && this.alias.equalsIgnoreCase(this.columnAlias)) {
            rplValue = DBPropertyLoader.getStringProperty(QueryConversionUtility.toLower(this.colNme) + "Replace");
        }
        this.doUpdateQueryBuffer(query, tempIdx, startIdx, qryBuf, rplValue);
    }

    private static String doGetDataVal(String colNme, String columnAlias, String alias, String groupOne, String rplValue) {
        String dataVal;
        if (colNme.matches("(?i)(dbc.columns.)?ColumnType")) {
            if (columnAlias == null) {
                String tempAlias;
                String string = alias != null ? alias : (tempAlias = groupOne != null ? groupOne : null);
                dataVal = tempAlias != null ? tempAlias + "." + "data_Type" : "data_Type";
            } else {
                dataVal = columnAlias + "." + "data_Type";
            }
        } else {
            dataVal = columnAlias != null ? columnAlias + "." + rplValue : rplValue;
        }
        return dataVal;
    }

    private void doUpdateQueryBuffer(String query, int tempIdx, int startIdx, StringBuffer qryBuf, String rplValue) {
        if (this.colNme.equalsIgnoreCase("ColumnType")) {
            if (query.substring(tempIdx, startIdx).contains(this.alias + ".")) {
                qryBuf.append(query.substring(tempIdx, startIdx).replace(this.alias + ".", "")).append(rplValue.isEmpty() ? this.colNme : rplValue);
            } else {
                qryBuf.append(query.substring(tempIdx, startIdx)).append(rplValue.isEmpty() ? this.colNme : rplValue);
            }
        } else {
            qryBuf.append(query.substring(tempIdx, startIdx)).append(rplValue.isEmpty() ? this.colNme : rplValue);
        }
    }

    public static String getFromTblName(String query) {
        Pattern fromPattern;
        Matcher fromMatch;
        String fromClause = null;
        if (query.matches("(?i).*(?:#S#\\d+#E#\\s*)*(?<!\\w)dbc\\s*(?:#S#\\d+#E#\\s*)*\\.\\s*(?:#S#\\d+#E#\\s*)*(?:columns|tables|indices)(?!\\w).*") && query.matches("(?i).*?(?<!\\w)select(?!\\w).*(?<!\\w)from(?!\\w).*") && (fromMatch = (fromPattern = Pattern.compile("(?i).*?(?<!\\w)select(?!\\w).*?(?<!\\w)from(?!\\w)(.*?)((?<!\\w)(?:where|qualify|group\\s+by|having|order\\s+by)(?!\\w)|;|$).*")).matcher(query)).find()) {
            fromClause = fromMatch.group(1);
        }
        return fromClause;
    }

    public String changeDBCColName(String column, String alias) {
        String col = column;
        Pattern dbcColPat = Pattern.compile("(?i)(\\w+)?\\.?(?<!\\w)((?:dbc\\s*\\.\\s*columns\\s*\\.\\s*)?(?:ColumnName|ColumnType|ColumnLength|DecimalTotalDigits|DecimalFractionalDigits|databasename|tablename|ColumnId))(?!\\w)");
        Matcher dbcColMatch = dbcColPat.matcher(col);
        String matchColValue = null;
        int stIdx = 0;
        int endIdx = 0;
        String alNme = null;
        if (dbcColMatch.find() && ((alNme = dbcColMatch.group(1)) == null || alNme.equalsIgnoreCase(alias))) {
            matchColValue = dbcColMatch.group(2);
            stIdx = dbcColMatch.start(2);
            endIdx = dbcColMatch.end(2);
            if (matchColValue.equalsIgnoreCase(col.replaceAll("(?i)#S#\\d+#E#", "").trim())) {
                matchColValue = matchColValue.matches("(?i)dbc\\s*\\.\\s*columns(?!\\w).*") ? matchColValue.replace(" ", "") : matchColValue;
                String aliasName = matchColValue.matches("(?i)dbc\\s*\\.\\s*columns(?!\\w).*") ? matchColValue.replaceFirst("(?i)dbc\\s*\\.\\s*columns\\s*.", "").trim() : matchColValue;
                col = col.substring(0, stIdx) + " " + DBPropertyLoader.getStringProperty(QueryConversionUtility.toLower(matchColValue) + "Replace") + " " + col.substring(endIdx) + " " + aliasName;
            } else {
                col = this.changeTblColNameValues(col, alias);
            }
        }
        return col;
    }
}

