/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.teradata;

import com.huawei.db.migration.exception.MigrationServiceException;
import com.huawei.db.migration.util.MessageLoader;
import com.huawei.db.migration.util.QueryConversionUtility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TeradataUtilityExt {
    public boolean tableChkInWhereClause(Map<String, String> parserMap) {
        boolean isUpdate = false;
        if (QueryConversionUtility.containsCheck(parserMap.get("sqlquery"), "update ")) {
            isUpdate = true;
        }
        ArrayList<String> columnList = new ArrayList<String>(10);
        ArrayList<String> tableList = new ArrayList<String>(10);
        this.updateTableList(parserMap, isUpdate, tableList);
        this.addTablesIntoLst(parserMap, tableList);
        if (parserMap.containsKey("endquery")) {
            String whereClause = parserMap.get("endquery").replaceAll("(?i)where ", "");
            String[] colSplit = whereClause.split("(?i)\\sand\\s|\\sor\\s");
            columnList.addAll(Arrays.asList(colSplit));
            this.doModifyDotCols(columnList, tableList);
        }
        this.addFromInTbl2(parserMap, isUpdate, tableList);
        boolean isSuccess = false;
        String table2 = parserMap.get("table2");
        if (table2 != null) {
            isSuccess = true;
        }
        return isSuccess;
    }

    private void updateTableList(Map<String, String> parserMap, boolean isUpdate, List<String> tableList) {
        if (parserMap.get("table1") != null) {
            tableList.add(parserMap.get("table1"));
        } else {
            this.replaceFromClauseEmpty(parserMap, isUpdate, tableList);
        }
    }

    private void addTablesIntoLst(Map<String, String> parserMap, List<String> tableList) {
        String tables = parserMap.get("table2");
        if (tables != null && !tables.trim().isEmpty()) {
            String[] tabs = tables.split(",");
            tableList.addAll(Arrays.asList(tabs));
        }
    }

    private void addFromInTbl2(Map<String, String> parserMap, boolean isUpdate, List<String> tableList) {
        String table2 = null;
        if (!tableList.isEmpty()) {
            tableList.remove(0);
        }
        if (tableList.size() >= 1) {
            table2 = tableList.get(0);
            if (isUpdate && !QueryConversionUtility.containsCheck(table2, "from ")) {
                table2 = "from " + table2;
                tableList.remove(0);
                tableList.add(0, table2);
            }
            table2 = QueryConversionUtility.doGetStrFrmListWithComma(tableList);
            parserMap.put("table2", table2);
        }
    }

    private void replaceFromClauseEmpty(Map<String, String> parserMap, boolean isUpdate, List<String> tableList) {
        String tab = parserMap.get("tables");
        if (!isUpdate) {
            tab = tab.replaceAll("(?i)from ", "");
        }
        tableList.add(tab);
        parserMap.put("table1", tab);
    }

    private void doModifyDotCols(List<String> columnList, List<String> tableList) {
        String temp = null;
        int listSize = columnList.size();
        for (int iIndex = 0; iIndex < listSize; ++iIndex) {
            temp = columnList.get(iIndex);
            if (!temp.contains(".")) continue;
            this.extractTable(tableList, temp);
        }
    }

    private void extractTable(List<String> tableList, String temp) {
        Pattern p1 = Pattern.compile("(?i)(.*?)(=|<=|>=|<\\s*>|>|<|\\seq\\s|\\sgt\\s|\\slt\\s|\\sle\\s|\\sge\\s|\\snot\\s*=|\\sne\\s)(.*)");
        Matcher m1 = p1.matcher(temp);
        String col1 = temp;
        String col2 = null;
        if (m1.find()) {
            col1 = m1.group(1);
            col2 = m1.group(3);
        }
        if (col1.contains(".")) {
            this.tableCheck(tableList, col1);
        }
        if (col2 != null && col2.contains(".")) {
            this.tableCheck(tableList, col2);
        }
    }

    private void tableCheck(List<String> tableList, String col1) {
        if (!col1.trim().startsWith("'") && !Character.isDigit(col1.trim().charAt(0))) {
            boolean flag;
            String table = "";
            String funcPattChk = "(?i)(.*)(?:\\(\\s*)?((?<!\\w)case\\s+|to_date\\s*\\(|replace\\s*\\(|to_char\\s*\\(|lpad\\s*\\(|rpad\\s*\\(|cast\\s*\\(|row_number\\s*(?:#S#\\d+#E#\\s*)*\\(|TO_TIMESTAMP\\s*\\(|mig_fn_castasint\\s*\\(|left\\s*\\(|right\\s*\\(|COALESCE\\s*\\(|MAX\\s*\\(|last_date\\s*\\(|MIN\\s*\\(|length\\s*\\(|SUBSTR\\s*\\(|SUM\\s*\\(|avg\\s*\\(|count\\s*\\(|rank\\s*(?:#S#\\d+#E#\\s*)*\\(|substring\\s*\\(|lower\\s*\\(|upper\\s*\\(|ltrim\\s*\\(|rtrim\\s*\\(|trim\\s*\\(|ZEROIFNULL\\s*\\(|NULLIFZERO\\s*\\(|mod\\s*\\(|char\\s*\\(|MaxDate\\s*\\(|TRANSACCTNUM\\s*\\(|ABS\\s*\\(|decode\\s*\\(|FIRST\\s*\\(|LAST\\s*\\(|MDIFF\\s*\\(|DISTINCT\\s*\\(|LAG\\s*\\(|LEFT\\s*\\(|GROUPING_ID\\s*\\(|\\w+_length\\s*\\()(.*)";
            if (!col1.matches(funcPattChk)) {
                table = this.getTblName(col1);
            }
            if (!(flag = this.getTablFlag(tableList, table)) && !table.trim().isEmpty()) {
                tableList.add(table);
            }
        }
    }

    private String getTblName(String col1Inp) {
        String col1 = col1Inp;
        col1 = col1.replaceAll("(?i)#S#\\d+#E#", "").trim();
        String[] col1Split = col1.split("\\.");
        String table = null;
        table = col1Split.length > 2 && col1Split[1].trim().matches("\\s*\\$\\s*\\{.*?\\}|\\w+|\\\"?\\$\\w+\\\"?") ? col1Split[0] + "." + col1Split[1] : col1Split[0].trim();
        return table;
    }

    private boolean getTablFlag(List<String> tableList, String table) {
        boolean flag = false;
        for (String tableName : tableList) {
            if (table.contains("(")) {
                flag = true;
                break;
            }
            if (!QueryConversionUtility.containsCheck(" " + tableName + " ", " " + table + " ") && !QueryConversionUtility.containsCheck(" " + tableName + " ", "__" + table + " ")) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public static boolean checkForValidInsertQry(String output) {
        String outputTmp = QueryConversionUtility.canonicalizeString(output);
        return !outputTmp.matches("(?i).*(?<!\\w)select(?!\\w).*?(?<!\\w)top(?!\\w).*?(?<!\\w)with\\s+ties(?!\\w).*");
    }

    public static String handlingTopWithTiesWithOutOrderBy(String query) throws MigrationServiceException {
        LinkedHashMap<String, String> overMap = new LinkedHashMap<String, String>(10);
        String modifiedQry = QueryConversionUtility.doReplaceOverStr(query, overMap);
        if (modifiedQry.matches("(?i).*(?<!\\w)select(?!\\w).*?(?<!\\w)top(?!\\w).*?(?<!\\w)with\\s+ties(?!\\w).*") && !modifiedQry.matches("(?i).*(?<!\\w)order\\s+by(?!\\w).*")) {
            throw new MigrationServiceException("[DSC_ERR_003_014] " + MessageLoader.getMessage("DSC_ERR_003_014"));
        }
        return query;
    }
}

