/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.teradata;

import com.huawei.db.migration.exception.MigrationServiceException;
import com.huawei.db.migration.util.ColumnSplitter;
import com.huawei.db.migration.util.MessageLoader;
import com.huawei.db.migration.util.QueryConversionUtility;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TitleNamedUtility {
    protected static final Set<Integer> LIST_THREAD = ConcurrentHashMap.newKeySet();
    private static final Pattern SELECT_PATTERN = Pattern.compile("(?i)(?<!\\w)(?:SELECT|DELETE|UPDATE)(?!\\w)(.*?)(?<!\\w|BOTH\\s)from(?!\\w)(.*?)(?<!\\w)(union.*?|not\\s*(?:#S#\\d+#E#\\s*)*?exists.*?|exists.*?|except.*?|where\\s.*?|group\\s+by.*?|having.*?|order\\s+by.*?|\\)|\\)*?;|$)");
    private static final Pattern NAMED_TITLE_AS_PATTERN = Pattern.compile("(?i)((#S#\\d+#E#\\s*)*(\\(\\s*(#S#\\d+#E#\\s*)*(NAMED|TITLE)\\s*(#S#\\d+#E#\\s*)*(##Quote##\\d+#|\\w+)\\s*(#S#\\d+#E#\\s*)*((\\)\\s*(#S#\\d+#E#\\s*)*\\(|,)\\s*(#S#\\d+#E#\\s*)*(NAMED|TITLE)\\s*(#S#\\d+#E#\\s*)*(##Quote##\\d+#|\\w+)\\s*(#S#\\d+#E#\\s*)*)?\\))\\s*(#S#\\d+#E#\\s*)*)(?:##COMMENT##\\d+#\\s*)?((?:(?<!\\w)as(?!\\w))?\\s*(#S#\\d+#E#\\s*)*(##Quote##\\d+#|\\b(?!from\\b)\\w+?\\b)\\s*(#S#\\d+#E#\\s*)*)?");
    private String namedAlias;
    private String titleAlias;
    private String asAlias;
    private String columnReplcmnt;
    private String namedComments;
    private String titleComments;
    private String asComments;
    private String preComments;
    private String postComments;

    public String doChangeNamedAlias(String inputSql, Map<String, String> quoteMap) {
        String outputQuery = inputSql.trim();
        if (QueryConversionUtility.containsCheck(outputQuery, "title") && QueryConversionUtility.containsCheck(outputQuery, "qualify")) {
            Thread currentThread = Thread.currentThread();
            LIST_THREAD.add((int)currentThread.getId());
        }
        if (inputSql.matches(".*?(?i)((#S#\\d+#E#\\s*)*(\\(\\s*(#S#\\d+#E#\\s*)*(NAMED|TITLE)\\s*(#S#\\d+#E#\\s*)*(##Quote##\\d+#|\\w+)\\s*(#S#\\d+#E#\\s*)*((\\)\\s*(#S#\\d+#E#\\s*)*\\(|,)\\s*(#S#\\d+#E#\\s*)*(NAMED|TITLE)\\s*(#S#\\d+#E#\\s*)*(##Quote##\\d+#|\\w+)\\s*(#S#\\d+#E#\\s*)*)?\\))\\s*(#S#\\d+#E#\\s*)*)(?:##COMMENT##\\d+#\\s*)?((?:(?<!\\w)as(?!\\w))?\\s*(#S#\\d+#E#\\s*)*(##Quote##\\d+#|\\b(?!from\\b)\\w+?\\b)\\s*(#S#\\d+#E#\\s*)*)?.*")) {
            boolean semiColonFlag = false;
            if (!outputQuery.endsWith(";")) {
                outputQuery = outputQuery + ";";
                semiColonFlag = true;
            }
            StringBuffer sb = new StringBuffer(128);
            HashMap<String, String> subQryMap = new HashMap<String, String>(10);
            ArrayList<String> outerQryColumnList = new ArrayList<String>(10);
            ArrayList<String> innerQryColumnList = new ArrayList<String>(10);
            List<String> subQueryList = QueryConversionUtility.getSubQueryList(outputQuery);
            if (!subQueryList.isEmpty()) {
                outputQuery = TitleNamedUtility.doRemoveSubQueryAlias(outputQuery, subQueryList, "(?i)\\(?\\s*(#S#\\d+#E#\\s*)*(?<!\\w)TITLE(?!\\w)\\s*(#S#\\d+#E#\\s*)*(?:\\'(.*?)\\'|##QUOTE##\\d+#)\\s*(#S#\\d+#E#\\s*)*\\)?");
            }
            String subQryPlchldr = "##SUBQRY##";
            outputQuery = this.doReplaceSubQuery(quoteMap, outputQuery, sb, subQryMap, outerQryColumnList, innerQryColumnList, subQueryList, subQryPlchldr);
            boolean topFlag = outputQuery.matches("(?i).*(?<!\\w)select(?!\\w).*?(?<!\\w)top(?!\\w).*?(?<!\\w)with\\s+ties(?!\\w).*");
            boolean qualifyFlag = QueryConversionUtility.containsCheck(outputQuery, "qualify");
            this.doImplementNamed(outputQuery, sb, outerQryColumnList, innerQryColumnList, quoteMap, topFlag, qualifyFlag);
            outputQuery = sb.toString();
            outputQuery = QueryConversionUtility.doReplaceFunctionVariables(outputQuery, subQryMap, subQryPlchldr);
            if (semiColonFlag) {
                outputQuery = outputQuery.trim().substring(0, outputQuery.length() - 1);
            }
        }
        return outputQuery;
    }

    private String doReplaceSubQuery(Map<String, String> quoteMap, String outputQueryInp, StringBuffer sb, Map<String, String> subQryMap, List<String> outerQryColumnList, List<String> innerQryColumnList, List<String> subQueryList, String subQryPlchldr) {
        String outputQuery = outputQueryInp;
        if (subQueryList.size() > 0) {
            int subQryCnt = 1;
            for (String sqlQry : subQueryList) {
                boolean topFlg = sqlQry.matches("(?i).*(?<!\\w)select(?!\\w).*?(?<!\\w)top(?!\\w).*?(?<!\\w)with\\s+ties(?!\\w).*");
                boolean qualifyFlg = QueryConversionUtility.containsCheck(sqlQry, "qualify");
                this.doImplementNamed(sqlQry, sb, outerQryColumnList, innerQryColumnList, quoteMap, topFlg, qualifyFlg);
                String modifSqlQry = sb.toString();
                sb.setLength(0);
                outputQuery = outputQuery.replace(sqlQry, modifSqlQry);
                subQryMap.put(subQryPlchldr + subQryCnt, modifSqlQry);
                outputQuery = outputQuery.replace(modifSqlQry, subQryPlchldr + subQryCnt);
                ++subQryCnt;
            }
        }
        return outputQuery;
    }

    private void doImplementNamed(String outputQuery, StringBuffer sb, List<String> outerQryColumnList, List<String> innerQryColumnList, Map<String, String> quoteMap, boolean topFlag, boolean qualifyFlag) {
        this.initializeNamed();
        boolean unionFlag = false;
        boolean brackerFlag = false;
        String column = null;
        int listCount = 0;
        int tempIndex = 0;
        ArrayList<String> outerSubQryColumnList = new ArrayList<String>(10);
        ArrayList<String> innerSubQryColumnList = new ArrayList<String>(10);
        Matcher selectMatcher = SELECT_PATTERN.matcher(outputQuery);
        ColumnSplitter splitter = new ColumnSplitter();
        while (selectMatcher.find()) {
            String columns = selectMatcher.group(1);
            int startIndex = selectMatcher.start(1);
            int endIndex = selectMatcher.end(1);
            unionFlag = this.setUnionFlag(unionFlag, selectMatcher);
            List<String> columnList = splitter.doGetAllColumns(columns);
            List<String> aliasList = this.getAliasList(columnList);
            boolean subQueryFlag = false;
            for (int iIndex = 0; iIndex < columnList.size(); ++iIndex) {
                Matcher namedTitleMatcher = NAMED_TITLE_AS_PATTERN.matcher(columnList.get(iIndex));
                column = this.getColumnValueAfterReplacement(columnList, iIndex);
                if (namedTitleMatcher.find()) {
                    subQueryFlag = this.handleTitleMatcher(outerQryColumnList, innerQryColumnList, quoteMap, topFlag, qualifyFlag, column, outerSubQryColumnList, innerSubQryColumnList, subQueryFlag, namedTitleMatcher);
                } else {
                    this.addQueryColumnList(outerQryColumnList, innerQryColumnList, column);
                    this.handleAlias(outerSubQryColumnList, innerSubQryColumnList, columnList, aliasList, iIndex);
                }
                if (!unionFlag) continue;
                sb.append(outputQuery.substring(tempIndex, startIndex)).append(" ").append(this.getElementFromList(outerQryColumnList, listCount)).append(" ");
                tempIndex = endIndex;
                ++listCount;
            }
            if (unionFlag) continue;
            this.handleSubQueryFlag(outerQryColumnList, innerQryColumnList, outerSubQryColumnList, innerSubQryColumnList, subQueryFlag);
            brackerFlag = this.doGetImplementedQuery(outputQuery, subQueryFlag, startIndex, endIndex, tempIndex, sb, outerQryColumnList, innerQryColumnList, unionFlag, brackerFlag);
            tempIndex = endIndex;
        }
        this.appendSb(outputQuery, sb, brackerFlag, tempIndex);
    }

    private void appendSb(String outputQuery, StringBuffer sb, boolean brackerFlag, int tempIndex) {
        sb.append(outputQuery.substring(tempIndex));
        if (brackerFlag) {
            sb.insert(sb.toString().trim().length() - 1, ")");
        }
    }

    private boolean setUnionFlag(boolean unionFlagParam, Matcher selectMatcher) {
        boolean unionFlag = unionFlagParam;
        if ("union".equalsIgnoreCase(selectMatcher.group(3))) {
            unionFlag = true;
        }
        return unionFlag;
    }

    private void initializeNamed() {
        this.namedAlias = null;
        this.titleAlias = null;
        this.asAlias = null;
        this.columnReplcmnt = null;
        this.namedComments = " ";
        this.titleComments = " ";
        this.asComments = " ";
        this.preComments = " ";
        this.postComments = " ";
    }

    private String getElementFromList(List<String> outerQryColumnList, int listCount) {
        if (listCount < outerQryColumnList.size()) {
            return outerQryColumnList.get(listCount);
        }
        throw new MigrationServiceException("[DSC_ERR_003_015] " + MessageLoader.getMessage("DSC_ERR_003_015"));
    }

    private boolean handleTitleMatcher(List<String> outerQryColumnList, List<String> innerQryColumnList, Map<String, String> quoteMap, boolean topFlag, boolean qualifyFlag, String column, List<String> outerSubQryColumnList, List<String> innerSubQryColumnList, boolean subQueryFlagInp, Matcher namedTitleMatcher) {
        boolean titleFlag = this.doUpdateAlias(quoteMap, namedTitleMatcher);
        boolean subQueryFlag = subQueryFlagInp;
        this.doGetComments(namedTitleMatcher, titleFlag);
        StringBuffer clmnBuffer = new StringBuffer(128);
        ArrayList<String> innerQryList = new ArrayList<String>(10);
        ArrayList<String> outerQryList = new ArrayList<String>(10);
        subQueryFlag = this.asAlias != null ? this.doImplementForAsNotNull(subQueryFlag, outerQryList, innerQryList, topFlag, qualifyFlag, column, clmnBuffer) : this.doImplementForAsNull(subQueryFlag, outerQryList, innerQryList, column, titleFlag, clmnBuffer);
        if (topFlag || qualifyFlag) {
            subQueryFlag = false;
        }
        this.addToQueryColumnList(outerQryColumnList, innerQryColumnList, innerQryList, outerQryList);
        this.addToSubQueryColumnList(outerSubQryColumnList, innerSubQryColumnList, innerQryList, outerQryList);
        return subQueryFlag;
    }

    private String getColumnValueAfterReplacement(List<String> columnList, int iIndex) {
        String column = columnList.get(iIndex);
        column = QueryConversionUtility.replaceAll(column, "(?i)((#S#\\d+#E#\\s*)*(\\(\\s*(#S#\\d+#E#\\s*)*(NAMED|TITLE)\\s*(#S#\\d+#E#\\s*)*(##Quote##\\d+#|\\w+)\\s*(#S#\\d+#E#\\s*)*((\\)\\s*(#S#\\d+#E#\\s*)*\\(|,)\\s*(#S#\\d+#E#\\s*)*(NAMED|TITLE)\\s*(#S#\\d+#E#\\s*)*(##Quote##\\d+#|\\w+)\\s*(#S#\\d+#E#\\s*)*)?\\))\\s*(#S#\\d+#E#\\s*)*)(?:##COMMENT##\\d+#\\s*)?((?:(?<!\\w)as(?!\\w))?\\s*(#S#\\d+#E#\\s*)*(##Quote##\\d+#|\\b(?!from\\b)\\w+?\\b)\\s*(#S#\\d+#E#\\s*)*)?", "");
        return column;
    }

    private void addQueryColumnList(List<String> outerQryColumnList, List<String> innerQryColumnList, String column) {
        outerQryColumnList.add(column);
        innerQryColumnList.add(column);
    }

    private void addToSubQueryColumnList(List<String> outerSubQryColumnList, List<String> innerSubQryColumnList, List<String> innerQryList, List<String> outerQryList) {
        outerSubQryColumnList.addAll(outerQryList);
        innerSubQryColumnList.addAll(innerQryList);
    }

    private void addToQueryColumnList(List<String> outerQryColumnList, List<String> innerQryColumnList, List<String> innerQryList, List<String> outerQryList) {
        outerQryColumnList.addAll(outerQryList);
        innerQryColumnList.addAll(innerQryList);
    }

    private List<String> getAliasList(List<String> columnList) {
        ArrayList<String> colList = new ArrayList<String>(10);
        colList.addAll(columnList);
        return QueryConversionUtility.doGetAliasList(colList);
    }

    private void handleAlias(List<String> outerSubQryColumnList, List<String> innerSubQryColumnList, List<String> columnList, List<String> aliasList, int iIndex) {
        String alias = aliasList.get(iIndex);
        String column = columnList.get(iIndex);
        if (QueryConversionUtility.equalCheck(column, alias)) {
            if (!column.trim().matches("(?i).*TIME\\s+('\\w+'|##QUOTE##\\d+#).*")) {
                alias = QueryConversionUtility.finderGroup(column, "(?i)((\\w+\\.)?(\\w+))", 3);
            }
        } else if (!QueryConversionUtility.containsCheck(column, alias)) {
            column = column + "as " + alias;
        }
        outerSubQryColumnList.add(alias);
        innerSubQryColumnList.add(column);
    }

    private void handleSubQueryFlag(List<String> outerQryColumnList, List<String> innerQryColumnList, List<String> outerSubQryColumnList, List<String> innerSubQryColumnList, boolean subQueryFlag) {
        if (subQueryFlag) {
            outerQryColumnList.clear();
            outerQryColumnList.addAll(outerSubQryColumnList);
            innerQryColumnList.clear();
            innerQryColumnList.addAll(innerSubQryColumnList);
        }
    }

    private boolean doUpdateAlias(Map<String, String> quoteMap, Matcher namedTitleMatcher) {
        boolean titleFlag = "title".equalsIgnoreCase(namedTitleMatcher.group(5));
        if (titleFlag) {
            this.titleAlias = namedTitleMatcher.group(7);
            this.namedAlias = namedTitleMatcher.group(15);
        } else {
            this.namedAlias = namedTitleMatcher.group(7);
            this.titleAlias = namedTitleMatcher.group(15);
        }
        if (this.titleAlias != null) {
            String titleAliasValue = QueryConversionUtility.getRplFromMap(this.titleAlias, quoteMap, "(##QUOTE##\\d+#)");
            if (titleAliasValue.replace("'", "").isEmpty()) {
                titleAliasValue = titleAliasValue.replaceFirst("'", "\" ");
            }
            titleAliasValue = titleAliasValue.replace("'", "\"");
            quoteMap.put(this.titleAlias, titleAliasValue);
        }
        this.asAlias = namedTitleMatcher.group(20);
        return titleFlag;
    }

    private boolean doImplementForAsNull(boolean subQueryFlagInp, List<String> outerQryColumnList, List<String> innerQryColumnList, String column, boolean titleFlag, StringBuffer clmnBuffer) {
        boolean subQueryFlag = subQueryFlagInp;
        if (titleFlag && this.namedAlias != null) {
            clmnBuffer.append(this.preComments).append(column).append(" as ").append(this.namedAlias).append(this.namedComments).append(this.titleComments).append(this.postComments);
            this.columnReplcmnt = clmnBuffer.toString();
            outerQryColumnList.add(this.columnReplcmnt);
            clmnBuffer.setLength(0);
        } else if (!titleFlag && this.titleAlias != null) {
            clmnBuffer.append(this.preComments).append(this.namedAlias).append(" as ").append(this.titleAlias).append(this.titleComments).append(this.postComments);
            this.columnReplcmnt = clmnBuffer.toString();
            outerQryColumnList.add(this.columnReplcmnt);
            clmnBuffer.setLength(0);
            clmnBuffer.append(column).append(" as ").append(this.namedAlias).append(this.namedComments);
            this.columnReplcmnt = clmnBuffer.toString();
            innerQryColumnList.add(this.columnReplcmnt);
            clmnBuffer.setLength(0);
            subQueryFlag = true;
        } else if (this.namedAlias != null && this.titleAlias == null) {
            clmnBuffer.append(this.preComments).append(column).append(" as ").append(this.namedAlias).append(this.namedComments).append(this.titleComments).append(this.postComments);
            this.columnReplcmnt = clmnBuffer.toString();
            outerQryColumnList.add(this.columnReplcmnt);
            clmnBuffer.setLength(0);
        } else if (titleFlag && this.namedAlias == null) {
            clmnBuffer.append(this.preComments).append(column).append(" as ").append(this.titleAlias).append(this.namedComments).append(this.titleComments).append(this.postComments);
            this.columnReplcmnt = clmnBuffer.toString();
            outerQryColumnList.add(this.columnReplcmnt);
            clmnBuffer.setLength(0);
        }
        return subQueryFlag;
    }

    private boolean doImplementForAsNotNull(boolean subQueryFlagInp, List<String> outerQryColumnList, List<String> innerQryColumnList, boolean topFlag, boolean qualifyFlag, String column, StringBuffer clmnBuffer) {
        boolean subQueryFlag = subQueryFlagInp;
        if (this.namedAlias == null && this.titleAlias == null) {
            outerQryColumnList.add(this.preComments + this.namedComments + this.titleComments + this.asAlias + this.asComments + this.postComments);
        } else if (this.namedAlias != null) {
            clmnBuffer.append(this.preComments).append(column).append(" as ").append(this.namedAlias).append(this.namedComments).append(this.titleComments).append(",").append(this.namedAlias).append(" as ").append(this.asAlias).append(this.asComments).append(this.postComments);
            this.columnReplcmnt = clmnBuffer.toString();
            clmnBuffer.setLength(0);
            if (topFlag || qualifyFlag) {
                if (qualifyFlag) {
                    clmnBuffer.append(column).append(" ~REM~OVE~ ").append(this.namedAlias).append(",").append(this.namedAlias).append(" as ").append(this.asAlias).append(this.asComments);
                    this.columnReplcmnt = clmnBuffer.toString();
                    clmnBuffer.setLength(0);
                }
                outerQryColumnList.add(this.columnReplcmnt);
            } else {
                clmnBuffer.append(this.asAlias).append(this.asComments);
                outerQryColumnList.add(clmnBuffer.toString());
                clmnBuffer.setLength(0);
            }
            innerQryColumnList.add(this.columnReplcmnt);
            subQueryFlag = true;
        } else if (this.titleAlias != null) {
            clmnBuffer.append(this.preComments).append(column).append(this.namedComments).append(this.titleComments).append(" as ").append(this.asAlias).append(this.asComments).append(this.postComments);
            this.columnReplcmnt = clmnBuffer.toString();
            outerQryColumnList.add(this.columnReplcmnt);
            clmnBuffer.setLength(0);
        }
        return subQueryFlag;
    }

    private void doGetComments(Matcher namedTitleMatcher, boolean titleFlag) {
        this.preComments = namedTitleMatcher.group(2) != null ? namedTitleMatcher.group(2) : "";
        this.namedComments = "" + namedTitleMatcher.group(4) + namedTitleMatcher.group(6) + namedTitleMatcher.group(8) + namedTitleMatcher.group(11);
        this.titleComments = "" + namedTitleMatcher.group(12) + namedTitleMatcher.group(14) + namedTitleMatcher.group(16);
        if (titleFlag) {
            this.titleComments = this.titleComments + namedTitleMatcher.group(17);
        } else {
            this.namedComments = this.namedComments + namedTitleMatcher.group(17);
        }
        this.postComments = namedTitleMatcher.group(21) != null ? namedTitleMatcher.group(21) : "";
        this.asComments = "" + namedTitleMatcher.group(19);
        this.namedComments = QueryConversionUtility.replaceAll(this.namedComments, "null", "");
        this.titleComments = QueryConversionUtility.replaceAll(this.titleComments, "null", "");
        this.asComments = QueryConversionUtility.replaceAll(this.asComments, "null", "");
    }

    private boolean doGetImplementedQuery(String outputQuery, boolean subQueryFlag, int startIndex, int endIndex, int tempIndex, StringBuffer sb, List<String> outerQryColumnList, List<String> innerQryColumnList, boolean unionFlag, boolean brackerFlagInp) {
        sb.append(outputQuery.substring(tempIndex, startIndex));
        sb.append(" ");
        boolean brackerFlag = brackerFlagInp;
        if (subQueryFlag) {
            int iIndex;
            brackerFlag = true;
            for (iIndex = 0; iIndex < outerQryColumnList.size(); ++iIndex) {
                sb.append(outerQryColumnList.get(iIndex) + ",");
            }
            sb.setLength(sb.length() - 1);
            sb.append(" ").append("from").append("(").append(" ").append("select").append(" ");
            for (iIndex = 0; iIndex < innerQryColumnList.size(); ++iIndex) {
                sb.append(innerQryColumnList.get(iIndex)).append(",");
            }
            sb.setLength(sb.length() - 1);
            sb.append(" ");
        } else {
            for (int iIndex = 0; iIndex < outerQryColumnList.size(); ++iIndex) {
                sb.append(outerQryColumnList.get(iIndex)).append(",");
            }
            sb.setLength(sb.length() - 1);
        }
        sb.append(" ");
        outerQryColumnList.clear();
        innerQryColumnList.clear();
        return brackerFlag;
    }

    private static String doRemoveSubQueryAlias(String outputQryInp, List<String> subQueryList, String aliasPattern) {
        String updatedsubQuery = null;
        Pattern pattern = Pattern.compile(aliasPattern);
        String outputQry = outputQryInp;
        for (int iIndex = 0; iIndex < subQueryList.size(); ++iIndex) {
            Matcher subQueryAliasMatcher = pattern.matcher(subQueryList.get(iIndex));
            while (subQueryAliasMatcher.find()) {
                updatedsubQuery = QueryConversionUtility.replaceAll(subQueryList.get(iIndex), aliasPattern, "");
                outputQry = outputQry.replace(subQueryList.get(iIndex), updatedsubQuery);
                subQueryList.remove(iIndex);
                subQueryList.add(iIndex, updatedsubQuery);
            }
        }
        return outputQry;
    }
}

