/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.util;

import com.huawei.db.migration.exception.MigrationServiceException;
import com.huawei.db.migration.util.ErrorLoggerUtility;
import com.huawei.db.migration.util.MessageLoader;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DBPropertyLoader {
    private static final Logger logger = LogManager.getLogger(DBPropertyLoader.class);
    private static ResourceBundle resourceBundle = null;

    public static void loadProperty(String propertyFile) throws MigrationServiceException {
        String propFileName = "jsons/" + propertyFile;
        resourceBundle = ResourceBundle.getBundle(propFileName);
        logger.debug("Property file has been loaded successfully: {}", (Object)propertyFile);
    }

    public static String getStringProperty(String propName) {
        String value;
        block3: {
            value = "";
            try {
                Object objStr;
                if (resourceBundle.containsKey(propName) && (objStr = resourceBundle.getObject(propName)) instanceof String) {
                    value = (String)objStr;
                }
            }
            catch (MissingResourceException e) {
                if (!logger.isInfoEnabled()) break block3;
                logger.info(ErrorLoggerUtility.getExceptionDetails(e) + "[DSC_ERR_004_047] " + MessageLoader.getMessage("DSC_ERR_004_047") + " Resource : " + resourceBundle.getBaseBundleName() + ". Property : " + propName);
            }
        }
        return value;
    }
}

