/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.util;

import com.huawei.db.migration.common.handlers.MigrationProcessor;
import com.huawei.db.migration.exception.MigrationServiceException;
import com.huawei.db.migration.util.MessageLoader;
import com.huawei.db.migration.util.QueryConversionUtility;

public class InterruptCharSequence
implements CharSequence {
    private CharSequence mInner;

    public InterruptCharSequence(CharSequence innerChar) {
        this.mInner = innerChar;
    }

    @Override
    public char charAt(int index) {
        if (Thread.currentThread().isInterrupted() || MigrationProcessor.isInterrupted().booleanValue()) {
            throw new MigrationServiceException(new InterruptedException("[DSC_ERR_004_001] " + MessageLoader.getMessage("DSC_ERR_004_001") + " Timeout value : " + QueryConversionUtility.getApplicationTimeout() + " hours."));
        }
        return this.mInner.charAt(index);
    }

    @Override
    public int length() {
        return this.mInner.length();
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return new InterruptCharSequence(this.mInner.subSequence(start, end));
    }

    @Override
    public String toString() {
        return this.mInner.toString();
    }
}

