/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.util;

import com.huawei.db.migration.util.QueryConversionUtility;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PlaceHolderUtility {
    private static final Pattern SINGLE_QUOTE_PATTERN = Pattern.compile(".*?(\\'.*?\\(.*?\\).*?\\')");
    private int openIndex = 0;
    private int closeIndex = 0;
    private int caseValue = 1;
    private int functionValue = 1;
    private int oprValue = 1;

    public String doGetPlaceholderColumns(List<String> columnArrays, String functionKeywords, Map<String, String> replaceValMap, boolean checkCloseBracket, boolean checkASColumn) {
        ArrayList<String> modifiedCols = new ArrayList<String>(columnArrays.size());
        for (String inputArrValue : columnArrays) {
            inputArrValue = inputArrValue + " ";
            Pattern patternFunction = Pattern.compile("(" + functionKeywords + ")", 2);
            Matcher matcher = patternFunction.matcher(inputArrValue);
            while (matcher.find()) {
                String functionName = matcher.group().trim();
                if ("case".equalsIgnoreCase(functionName)) {
                    this.openIndex = QueryConversionUtility.toLower(inputArrValue).indexOf("case ");
                    this.closeIndex = QueryConversionUtility.getLastIndex(inputArrValue, "end");
                    if (this.openIndex == -1 || this.closeIndex == -1) continue;
                    String sub = inputArrValue.substring(this.openIndex, this.closeIndex);
                    String placeholder = "_COLUMN__statement" + this.caseValue + "_";
                    inputArrValue = inputArrValue.replace(sub, placeholder);
                    replaceValMap.put(placeholder, sub);
                    ++this.caseValue;
                    continue;
                }
                int startIndex = matcher.start();
                this.closeIndex = inputArrValue.lastIndexOf(41);
                if (checkCloseBracket) {
                    Matcher singleQuoteMatcher = SINGLE_QUOTE_PATTERN.matcher(inputArrValue);
                    this.doFindLastClosebracket(singleQuoteMatcher);
                }
                if (this.closeIndex == -1 || startIndex >= this.closeIndex) continue;
                String sub = inputArrValue.substring(startIndex, this.closeIndex + 1);
                inputArrValue = QueryConversionUtility.doPutSpaceBeforeAs(this.closeIndex, inputArrValue, startIndex);
                String placeholder = "_COLUMN__function" + this.functionValue + "_";
                inputArrValue = inputArrValue.replace(sub, placeholder);
                replaceValMap.put(placeholder, sub);
                ++this.functionValue;
            }
            inputArrValue = this.evaluateArithmaticOperator(inputArrValue, replaceValMap, checkASColumn);
            modifiedCols.add(inputArrValue.trim());
        }
        columnArrays.clear();
        return String.join((CharSequence)",", modifiedCols);
    }

    public String doGetPlaceholderColumns(List<String> columnArrays, Map<String, String> replaceValMap, boolean checkCloseBracket, boolean checkASColumn) {
        return this.doGetPlaceholderColumns(columnArrays, "(?:\\(\\s*)?((?<!\\w)case\\s+|to_date\\s*\\(|replace\\s*\\(|to_char\\s*\\(|lpad\\s*\\(|rpad\\s*\\(|cast\\s*\\(|row_number\\s*(?:#S#\\d+#E#\\s*)*\\(|TO_TIMESTAMP\\s*\\(|mig_fn_castasint\\s*\\(|left\\s*\\(|right\\s*\\(|COALESCE\\s*\\(|MAX\\s*\\(|last_date\\s*\\(|MIN\\s*\\(|length\\s*\\(|SUBSTR\\s*\\(|SUM\\s*\\(|avg\\s*\\(|count\\s*\\(|rank\\s*(?:#S#\\d+#E#\\s*)*\\(|substring\\s*\\(|lower\\s*\\(|upper\\s*\\(|ltrim\\s*\\(|rtrim\\s*\\(|trim\\s*\\(|ZEROIFNULL\\s*\\(|NULLIFZERO\\s*\\(|mod\\s*\\(|char\\s*\\(|MaxDate\\s*\\(|TRANSACCTNUM\\s*\\(|ABS\\s*\\(|decode\\s*\\(|FIRST\\s*\\(|LAST\\s*\\(|MDIFF\\s*\\(|DISTINCT\\s*\\(|LAG\\s*\\(|LEFT\\s*\\(|GROUPING_ID\\s*\\(|\\w+_length\\s*\\()", replaceValMap, checkCloseBracket, checkASColumn);
    }

    private String evaluateArithmaticOperator(String inputArrVal, Map<String, String> replaceValMap, boolean checkASColumn) {
        String arithmaticExpressions = "\\+|\\-|\\*|\\/|\\%|\\^|\\||\\&";
        String inputArrValue = inputArrVal;
        if (inputArrValue.matches(".*(\\+|\\-|(?<!\\.)\\*|\\/|%|\\^|&|\\|).*")) {
            String cmntPlaceholderAtStart = "";
            String cmntPlaceholderAtEnd = "";
            if (!(!(inputArrValue = inputArrValue.trim()).contains("#S#") || checkASColumn && inputArrValue.contains("AS"))) {
                cmntPlaceholderAtStart = QueryConversionUtility.doGetStartCmnts(inputArrValue);
                cmntPlaceholderAtEnd = QueryConversionUtility.doGetEndCmnts(inputArrValue);
                inputArrValue = inputArrValue.replaceAll("(?i)#S#\\d+#E#", "");
            }
            if (QueryConversionUtility.containsCheck(inputArrValue, " as ")) {
                this.openIndex = QueryConversionUtility.toLower(inputArrValue).indexOf(" as");
                String sub = inputArrValue.substring(0, this.openIndex);
                String placeholder = "_COLUMN__operator" + this.oprValue + "_";
                inputArrValue = inputArrValue.replace(sub, placeholder);
                replaceValMap.put(placeholder, sub);
                ++this.oprValue;
            } else {
                String[] aliasChecker = inputArrValue.split(arithmaticExpressions);
                String sub = "";
                sub = aliasChecker.length > 0 && aliasChecker[aliasChecker.length - 1].trim().contains(" ") ? QueryConversionUtility.doGetColumnValue(inputArrValue, aliasChecker[aliasChecker.length - 1]) : inputArrValue;
                String placeholder = "_COLUMN__operator" + this.oprValue + "_";
                inputArrValue = inputArrValue.replace(sub, placeholder);
                replaceValMap.put(placeholder, sub);
                ++this.oprValue;
            }
            if (!cmntPlaceholderAtStart.isEmpty()) {
                inputArrValue = cmntPlaceholderAtStart + " " + inputArrValue;
            }
            if (!cmntPlaceholderAtEnd.isEmpty()) {
                inputArrValue = inputArrValue + " " + cmntPlaceholderAtEnd;
            }
        }
        return inputArrValue;
    }

    private void doFindLastClosebracket(Matcher singleQuoteMatcher) {
        if (singleQuoteMatcher.find()) {
            String singleQuote = singleQuoteMatcher.group();
            int startIndex1 = singleQuoteMatcher.start(1);
            int lastIndex1 = singleQuote.lastIndexOf(41);
            if (lastIndex1 == this.closeIndex) {
                this.closeIndex = singleQuote.lastIndexOf(41, startIndex1);
            }
        }
    }
}

