/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.util;

import com.huawei.db.migration.common.handlers.MigrationProcessor;
import com.huawei.db.migration.util.ApplicationProperty;
import com.huawei.db.migration.util.ApplicationPropertyLoader;
import com.huawei.db.migration.util.IGaussDBConstants;
import com.huawei.db.migration.util.MessageLoader;
import com.huawei.db.migration.util.QueryConversionUtility;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProgressUtil {
    private static final Logger logger = LogManager.getLogger(ProgressUtil.class);
    private static final int PROCESS_WAIT_TIME = 10000;
    private static final String[] KEYWORDS = new String[]{"COMMENT", "CREATE", "ALTER", "FUNCTION", "PROCEDURE", "SELECT", "INSERT", "UPDATE", "DELETE", "MERGE", "DROP", "PURGE"};
    private static final String[] KEYWORDS_ORA_T = new String[]{"PACKAGE"};
    private static int currStatementCount = 0;
    private static int prevPercentage = 0;
    private static int totalStatementCount = 0;
    private static int currFileCount = 0;
    private static int totalFileCount = 0;
    private static boolean runFileProgressBar = false;
    private static boolean isTimeout = false;

    public static boolean getRunFileBarStatus() {
        return runFileProgressBar;
    }

    public static void setRunFileBarStatus(boolean status) {
        runFileProgressBar = status;
    }

    public static void setAppTimeout() {
        isTimeout = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printProgress() {
        Logger logger = ProgressUtil.logger;
        synchronized (logger) {
            ProgressUtil.incrementProgressCounter();
            ProgressUtil.calculateProgress();
        }
    }

    private static void calculateProgress() {
        int currentPercentage;
        if (totalStatementCount > 0 && prevPercentage < (currentPercentage = currStatementCount * 100 / totalStatementCount)) {
            ProgressUtil.printConsoleMessage(currentPercentage, false);
            prevPercentage = currentPercentage;
        }
    }

    public static void reset() {
        currFileCount = 0;
        prevPercentage = 0;
    }

    private static void printConsoleMessage(int currentPercentage, boolean newLine) {
        if (!runFileProgressBar && !isTimeout) {
            QueryConversionUtility.printConsoleMessage("\rSchema Conversion Progress " + currentPercentage + "% completed", newLine);
        }
    }

    private static void incrementProgressCounter() {
        if (currStatementCount < totalStatementCount) {
            ++currStatementCount;
        }
        if (currStatementCount == totalStatementCount) {
            currFileCount = totalFileCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printStatementProgress(boolean increment) {
        Logger logger = ProgressUtil.logger;
        synchronized (logger) {
            if (currFileCount < totalFileCount && increment) {
                ++currFileCount;
            }
            if (totalFileCount > 0) {
                int currentPercentage = currFileCount * 100 / totalFileCount;
                if (!ApplicationPropertyLoader.getBooleanProperty("split_input")) {
                    QueryConversionUtility.printConsoleMessage("\rStatement count progress " + currentPercentage + "% completed [FILE(" + currFileCount + "/" + totalFileCount + ")]", currFileCount == totalFileCount);
                } else {
                    QueryConversionUtility.printConsoleMessage("\rStatement count progress " + currentPercentage + "% completed", currFileCount == totalFileCount);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateTotalCount(int count) {
        Logger logger = ProgressUtil.logger;
        synchronized (logger) {
            currStatementCount = (totalStatementCount += count) / 100;
        }
    }

    public static void updateTotalFiles(int count) {
        totalFileCount = count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void incrementFileCount() {
        Logger logger = ProgressUtil.logger;
        synchronized (logger) {
            if (currFileCount < totalFileCount) {
                ++currFileCount;
            }
            if (currFileCount == totalFileCount) {
                currStatementCount = totalStatementCount;
                ProgressUtil.printConsoleMessage(100, false);
            } else {
                ProgressUtil.printConsoleMessage(prevPercentage, false);
            }
        }
    }

    public static void completeProgress() {
        currStatementCount = totalStatementCount;
        currFileCount = totalFileCount;
        prevPercentage = 100;
        ProgressUtil.printConsoleMessage(100, true);
    }

    public static int getStatementCount() {
        return totalStatementCount;
    }

    public static void calculateStatementCount(Map<String, String> files) {
        ProgressUtil.printStatementProgress(false);
        ExecutorService executor = ProgressUtil.getExecutorService();
        ArrayList<Future<?>> futureList = ProgressUtil.scheduleMigrationThread(files, executor);
        try {
            ProgressUtil.clearExecutorService(executor, futureList);
        }
        catch (InterruptedException e) {
            MigrationProcessor.interrupt();
            logger.error("[DSC_ERR_004_044] " + MessageLoader.getMessage("DSC_ERR_004_044"));
        }
        totalStatementCount += totalStatementCount / 100;
        QueryConversionUtility.printConsoleMessage(IGaussDBConstants.NEW_LINE);
    }

    private static String executeCommand(String[] command) throws IOException, InterruptedException {
        ProcessBuilder pb = new ProcessBuilder("count_semicolon").redirectErrorStream(true).command(command);
        Process proc = pb.start();
        StringBuffer stdOutBuffer = new StringBuffer(128);
        try (InputStream is = proc.getInputStream();){
            int cData;
            int charMaxVal = 65535;
            while ((cData = is.read()) != -1) {
                if (cData == 10 || cData == 13 || cData > charMaxVal) continue;
                stdOutBuffer.append((char)cData);
            }
        }
        boolean retStatus = proc.waitFor(10000L, TimeUnit.MILLISECONDS);
        if (!retStatus) {
            QueryConversionUtility.printConsoleMessage("Error while waiting for other threads to complete.");
        }
        return stdOutBuffer.toString();
    }

    private static ExecutorService getExecutorService() {
        ExecutorService executor = null;
        int appThreadCount = QueryConversionUtility.doGetAppThreadCnt();
        executor = Executors.newFixedThreadPool(appThreadCount);
        return executor;
    }

    private static ArrayList<Future<?>> scheduleMigrationThread(Map<String, String> files, ExecutorService executor) {
        ArrayList futureList = new ArrayList(10);
        for (String filePath : files.values()) {
            futureList.add(executor.submit(new StatementCount(filePath)));
        }
        return futureList;
    }

    private static void clearExecutorService(ExecutorService executor, ArrayList<Future<?>> futureList) throws InterruptedException {
        executor.shutdown();
        executor.awaitTermination(QueryConversionUtility.getApplicationTimeout(), TimeUnit.HOURS);
        QueryConversionUtility.clearFutureList(futureList);
    }

    private static class StatementCount
    implements Runnable {
        private String filePath;

        public StatementCount(String path) {
            this.filePath = path;
        }

        @Override
        public void run() {
            boolean isWindows = QueryConversionUtility.containsCheck(System.getProperty("os.name"), "win");
            int count = 0;
            String[] keywords = KEYWORDS;
            if (QueryConversionUtility.isGaus100() && QueryConversionUtility.equalCheck("blogic", ApplicationProperty.getStringProperty("TYPE"))) {
                keywords = KEYWORDS_ORA_T;
            }
            for (String keyword : keywords) {
                try {
                    String[] command = new String[]{"find", "\"" + keyword + "\"", "", "/c", "/i"};
                    String grepCommand = "grep -ic \"" + keyword + "\"";
                    if (!isWindows) {
                        command = new String[]{"/bin/sh", "-c", grepCommand};
                    }
                    command[2] = isWindows ? this.filePath : grepCommand + " \"" + this.filePath + "\"";
                    String stdOutput = ProgressUtil.executeCommand(command);
                    String countStr = isWindows ? stdOutput.replaceAll(".*?(\\d+)$", "$1") : stdOutput;
                    count += Integer.parseInt(countStr);
                }
                catch (IOException | NumberFormatException ex) {
                    logger.error("[DSC_ERR_004_044] " + MessageLoader.getMessage("DSC_ERR_004_044") + " " + this.filePath);
                }
                catch (InterruptedException ex) {
                    MigrationProcessor.interrupt();
                    logger.error("[DSC_ERR_004_044] " + MessageLoader.getMessage("DSC_ERR_004_044") + " " + this.filePath);
                }
            }
            ProgressUtil.updateTotalCount(count);
            ProgressUtil.updateTotalCount(count / 100 * 2);
            try {
                List lines = FileUtils.readLines((File)new File(this.filePath), (String)"utf-8");
                int linescount = lines.size() / 100;
                lines.clear();
                ProgressUtil.updateTotalCount(linescount);
            }
            catch (IOException e) {
                logger.error("[DSC_ERR_004_044] " + MessageLoader.getMessage("DSC_ERR_004_044") + " " + this.filePath);
            }
            ProgressUtil.printStatementProgress(true);
        }
    }
}

