/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.util;

import com.huawei.db.migration.common.handlers.MigrationProcessor;
import com.huawei.db.migration.database.bo.IBulkSplitPatternsBO;
import com.huawei.db.migration.exception.MigrationServiceException;
import com.huawei.db.migration.filemerger.FileMergerExecutor;
import com.huawei.db.migration.util.ApplicationPropertyLoader;
import com.huawei.db.migration.util.MessageLoader;
import com.huawei.db.migration.util.ProgressUtil;
import com.huawei.db.migration.util.QueryConversionUtility;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class QueryUtilityExt {
    private static final Logger logger = LogManager.getLogger(QueryUtilityExt.class);

    public static String findMigrationType(List<IBulkSplitPatternsBO> bulkSplitPatterns, String migrationType, String input) {
        String migType = migrationType;
        for (IBulkSplitPatternsBO typeBO : bulkSplitPatterns) {
            Pattern pattern;
            Matcher matcher;
            boolean isExcludePatternValidation = QueryConversionUtility.excludePatternValidation(typeBO.getExcludePattern(), input);
            if (!isExcludePatternValidation || !(matcher = (pattern = Pattern.compile(typeBO.getFinderPattern(), 2)).matcher(input)).find()) continue;
            migType = typeBO.getName();
            break;
        }
        return migType;
    }

    public static List<Integer> findIndex(int index, String outputQuery, String functionName) {
        int count = 1;
        int ind = 0;
        ArrayList<Integer> list = new ArrayList<Integer>(10);
        for (int i = index; i >= 0; --i) {
            char checkChar = outputQuery.charAt(i);
            if (checkChar == ' ') continue;
            if (checkChar == ')') {
                ++count;
            } else if (checkChar == '(') {
                --count;
            }
            if (count != 0) continue;
            ind = i + 1;
            list.add(ind);
            break;
        }
        String subString = outputQuery.substring(0, ind);
        list.add(QueryConversionUtility.toLower(subString).lastIndexOf(functionName));
        return list;
    }

    public static String doGetStringFromGivenIndex(int strtIndex, String input) {
        String inputString = input;
        String neededString = "";
        int even = 0;
        boolean searchFlag = false;
        for (int iIndex = strtIndex; iIndex < inputString.length(); ++iIndex) {
            char ch = inputString.charAt(iIndex);
            if (ch == '(') {
                ++even;
                searchFlag = true;
            } else if (ch == ')') {
                --even;
            }
            if (even != 0 || !searchFlag) continue;
            neededString = inputString.substring(strtIndex, iIndex + 1);
            break;
        }
        return neededString;
    }

    public static String[] doGetStringFromGivenIndexAndGetEndIndex(int strtIndex, String input) {
        String[] strArr = new String[2];
        String inputString = input;
        String neededString = "";
        int even = 0;
        int endIndex = 0;
        boolean searchFlag = false;
        for (int iIndex = strtIndex; iIndex < inputString.length(); ++iIndex) {
            char ch = inputString.charAt(iIndex);
            if (ch == '(') {
                ++even;
                searchFlag = true;
            } else if (ch == ')') {
                --even;
            }
            if (even != 0 || !searchFlag) continue;
            neededString = inputString.substring(strtIndex, iIndex + 1);
            endIndex = iIndex;
            break;
        }
        strArr[0] = neededString;
        strArr[1] = String.valueOf(endIndex);
        return strArr;
    }

    public static void deleteFile(File filename) {
        boolean flag = false;
        if (filename.isDirectory()) {
            File[] filesInTarget = filename.listFiles();
            if (filesInTarget != null && filesInTarget.length > 0) {
                for (File file : filesInTarget) {
                    if (file.isDirectory()) {
                        QueryUtilityExt.deleteFile(file);
                    }
                    if (flag = file.delete()) continue;
                    logger.error("File " + file.getName() + "does not exist.");
                }
            }
            if (!(flag = filename.delete())) {
                logger.error("File " + filename.getName() + "does not exist.");
            }
        } else {
            flag = filename.delete();
            if (!flag) {
                logger.error("File " + filename.getName() + "does not exist.");
            }
        }
    }

    public static void mergeFiles(String sourceFolderLoc, String tarFolderLoc) {
        if (ApplicationPropertyLoader.getBooleanProperty("formattedSourceRequired")) {
            FileMergerExecutor.mergeFiles(tarFolderLoc, sourceFolderLoc, "formattedSource");
        }
        FileMergerExecutor.mergeFiles(tarFolderLoc, sourceFolderLoc, "output");
    }

    public static void handleInterruptedException(String fileName, RuntimeException ex) throws InterruptedException {
        MigrationServiceException mse;
        if (ex instanceof MigrationServiceException && (mse = (MigrationServiceException)ex).isInterrupted()) {
            logger.error("[DSC_ERR_004_039] " + MessageLoader.getMessage("DSC_ERR_004_039") + " " + fileName);
            throw new InterruptedException(ex.getMessage());
        }
    }

    public static void handleInterruptedException(InterruptedException objExp) {
        MigrationProcessor.interrupt();
        ProgressUtil.setAppTimeout();
        logger.error(objExp.getMessage());
        logger.error("[DSC_ERR_004_009] " + MessageLoader.getMessage("DSC_ERR_004_009"));
    }
}

