/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.common.config;

import com.huawei.hwclouds.migration.common.exception.ParserExceptionDef;
import com.huawei.hwclouds.migration.common.exception.ParserRuntimeException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PropertyLoader {
    private static final Logger LOGGER = LogManager.getLogger(PropertyLoader.class);

    public static Map<String, String> loadPropertyFile(String proFileName) {
        Map<String, String> propertyMap;
        block13: {
            StringBuffer sb = new StringBuffer();
            propertyMap = null;
            String configDir = FilenameUtils.normalize((String)System.getProperty("config.dir"));
            if (configDir == null || !new File(configDir).exists()) {
                throw new ParserRuntimeException(ParserExceptionDef.APPLICATION_ERROR, "Error while loading the property files from config directory.");
            }
            PropertyLoader.getConfigFolder(proFileName, sb, configDir);
            String propertyFileName = sb.toString();
            Properties objProp = new Properties();
            InputStream inputStream = null;
            try {
                propertyFileName = FilenameUtils.normalize((String)propertyFileName);
                if (propertyFileName == null) {
                    throw new ParserRuntimeException(ParserExceptionDef.APPLICATION_ERROR, "Error while loading the property file.");
                }
                File propFile = new File(propertyFileName);
                Path path = Paths.get(propFile.getCanonicalPath(), new String[0]);
                if (propFile.exists()) {
                    inputStream = new FileInputStream(path.toFile());
                    objProp.load(inputStream);
                    propertyMap = PropertyLoader.doGetPropsMap(objProp);
                    LOGGER.info("Successfully loaded Property file : {}", (Object)propertyFileName);
                    break block13;
                }
                throw new ParserRuntimeException(ParserExceptionDef.APPLICATION_ERROR, "Error while loading the property file.");
            }
            catch (IOException e) {
                LOGGER.error("Error while loading the property file.");
                throw new ParserRuntimeException(ParserExceptionDef.APPLICATION_ERROR, "Error while loading the property file.");
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        LOGGER.error("Error while loading the property file.");
                    }
                }
            }
        }
        return propertyMap;
    }

    private static void getConfigFolder(String proFileName, StringBuffer sb, String configDir) {
        File configFolder = new File(configDir);
        if (!configFolder.isDirectory() || !configFolder.canRead()) {
            throw new ParserRuntimeException(ParserExceptionDef.APPLICATION_ERROR, "Error while loading the property files from config directory, directory is not readable.");
        }
        sb.append(configFolder.toString()).append("/").append(proFileName).append(".").append("properties");
    }

    public static Map<String, String> doGetPropsMap(Properties objProp) {
        LinkedHashMap<String, String> propertyMap = new LinkedHashMap<String, String>(10);
        String key = null;
        Enumeration<Object> e = objProp.keys();
        while (e.hasMoreElements()) {
            Object objElement = e.nextElement();
            if (!(objElement instanceof String)) continue;
            key = (String)objElement;
            propertyMap.put(key, objProp.getProperty(key).trim());
        }
        return propertyMap;
    }

    public static void writePropertyFile(String proFileName, Map<String, String> propertyMap) throws ParserRuntimeException {
        StringBuffer fileName = PropertyLoader.getPropertyFileName(proFileName);
        String propertyFileName = fileName.toString();
        OutputStream outputStream = null;
        File propFile = null;
        try {
            propertyFileName = FilenameUtils.normalize((String)propertyFileName);
            if (propertyFileName == null) {
                throw new ParserRuntimeException(ParserExceptionDef.APPLICATION_ERROR, "Error while updating the property file");
            }
            propFile = new File(propertyFileName);
            if (!propFile.getParentFile().exists() && !propFile.getParentFile().mkdirs() || propFile.exists() || !propFile.createNewFile()) {
                LOGGER.error("created Property file failed: {}", (Object)propertyFileName);
                return;
            }
            LOGGER.info("Successfully created Property file : {}", (Object)propertyFileName);
            if (propFile.exists() && propFile.canWrite()) {
                outputStream = new FileOutputStream(propFile, false);
                Properties objProp = new Properties();
                for (Map.Entry<String, String> property : propertyMap.entrySet()) {
                    objProp.setProperty(property.getKey(), property.getValue());
                }
                objProp.store(outputStream, "File Updated");
                LOGGER.info("Successfully updated Property file : {}", (Object)propertyFileName);
            } else {
                LOGGER.info("Unable to update Property file : {}", (Object)propertyFileName);
            }
        }
        catch (IOException e) {
            LOGGER.error("Error while updating the property file :" + proFileName);
            throw new ParserRuntimeException(ParserExceptionDef.APPLICATION_ERROR, "Error while updating the property file");
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    LOGGER.error("Error while updating the property file :" + proFileName);
                }
            }
        }
    }

    public static StringBuffer getPropertyFileName(String proFileName) {
        StringBuffer fileName = new StringBuffer();
        String configDir = PropertyLoader.getConfigFolder();
        File configFolder = new File(configDir);
        if (!configFolder.isDirectory()) {
            throw new ParserRuntimeException(ParserExceptionDef.APPLICATION_ERROR, "Error while loading the property files from config directory, directory is not readable.");
        }
        fileName.append(configFolder.toString()).append("/").append(proFileName).append(".").append("properties");
        return fileName;
    }

    public static String getConfigFolder() {
        String folder = System.getProperty("user.dir");
        System.setProperty("config.dir", folder + "/config");
        String configDir = FilenameUtils.normalize((String)System.getProperty("config.dir"));
        if (configDir == null) {
            throw new ParserRuntimeException(ParserExceptionDef.APPLICATION_ERROR, "Error while loading the property files from config directory.");
        }
        return configDir;
    }
}

