/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle;

import com.github.vertical_blank.sqlformatter.SqlFormatter;
import com.github.vertical_blank.sqlformatter.languages.Dialect;
import com.huawei.db.migration.interfaces.DatabaseConvertor;
import com.huawei.db.migration.interfaces.ISqlString;
import com.huawei.hwclouds.migration.common.config.ApplicationPropertyLoader;
import com.huawei.hwclouds.migration.common.util.CommonUtils;
import com.huawei.hwclouds.migration.oracle.DWSMain;
import com.huawei.hwclouds.migration.oracle.OracleConvertor;
import com.huawei.hwclouds.migration.oracle.util.SqlString;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DWSMigration
implements Runnable {
    private static final Pattern PLSQL_CREATE_FINDER = Pattern.compile("(?i)^(CREATE)?[\\S+\\s+]*(FUNCTION|LIBRARY|PACKAGE BODY|PACKAGEBODY|PACKAGE|PROCEDURE|TRIGGER)(\\s+)(\\S+)(\\s+)?(\\(|IS|AS)(.*?)");
    private static final Pattern PLSQL_BEGIN_FINDER = Pattern.compile("(?i)[\\S+\\s+]*BEGIN(\\s?)");
    private static final Logger LOGGER = LogManager.getLogger(DWSMigration.class);
    private DatabaseConvertor convertor;
    private static int fileNumber = 0;
    private final File inputFile;
    private final String outputFile;
    private final int range;
    private final int countValidFiles;

    DWSMigration(File inFile, String outFile, int rangNum, int countValidFilesNum) {
        this.inputFile = inFile;
        this.outputFile = outFile;
        this.range = rangNum;
        this.countValidFiles = countValidFilesNum;
        this.convertor = new OracleConvertor(null);
    }

    @Override
    public void run() {
        LOGGER.info("Entry of the run method!");
        try {
            String resSql = DWSMigration.parseFile(this.inputFile, this.convertor, this.range);
            if (resSql == null) {
                DWSMain.FAILED_FILES.incrementAndGet();
                return;
            }
            boolean fileCreate = CommonUtils.createNewFile(this.outputFile, false);
            if (!fileCreate) {
                LOGGER.error("Error while creating file");
                return;
            }
            String encodingFormat = DWSMigration.getEncodingFormat();
            FileUtils.write((File)new File(this.outputFile), (CharSequence)resSql, (String)encodingFormat);
        }
        catch (Exception e) {
            LOGGER.error("Failed to parse " + this.inputFile.getName(), (Throwable)e);
            try {
                FileUtils.copyFile((File)this.inputFile, (File)new File(this.outputFile));
            }
            catch (IOException pe) {
                LOGGER.error("Failed to copy file " + this.inputFile.getName());
            }
            DWSMain.FAILED_FILES.incrementAndGet();
        }
        int percent = 100;
        this.incrementFileCounter();
        int status = this.countValidFiles > 0 ? fileNumber * 100 / this.countValidFiles : 0;
        DWSMain.printConsoleMessage(status + "% completed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static String parseFile(File inputFile, DatabaseConvertor convertor, Integer rangeNum) throws IOException {
        start = new Date().getTime();
        DWSMigration.LOGGER.info("start convert file {}", (Object)inputFile.getName());
        resSql = new StringBuilder();
        sb = new StringBuilder();
        encodingFormat = DWSMigration.getEncodingFormat();
        validLength = rangeNum;
        it = FileUtils.lineIterator((File)inputFile, (String)encodingFormat);
lbl8:
        // 2 sources

        try {
            while (it.hasNext()) {
                block12: {
                    line = it.nextLine();
                    if (line == null || !SqlString.isSqlComment(line)) break block12;
                    if (sb.length() == 0 && line.trim().startsWith("@")) {
                        sb.append(System.lineSeparator());
                    }
                    sb.append(line);
                    sb.append(System.lineSeparator());
                    if (!line.trim().startsWith("/*")) continue;
                    while (!line.trim().startsWith("*/") && !line.trim().endsWith("*/") && it.hasNext()) {
                        line = it.nextLine();
                        sb.append(line).append('\n');
                    }
                    ** GOTO lbl8
                }
                if ((line = DWSMigration.readPlSql(sb, it, line)) != null && (line.trim().endsWith(";") || line.trim().endsWith("/"))) {
                    length = line.trim().length();
                    if (length == 1) {
                        lastInput = sb.toString().trim();
                        sb.delete(0, sb.length());
                        sb.append(lastInput);
                    }
                    sb.append(line);
                    sb.append(System.lineSeparator());
                    inputLen = sb.length();
                    if (validLength != null && inputLen > validLength) {
                        DWSMigration.LOGGER.warn("Migration of the following file exceeds the max Sql Length: {}", (Object)inputFile.toString());
                        var13_13 = null;
                        return var13_13;
                    }
                    DWSMigration.convertSql(resSql, sb, convertor);
                    resSql.append(System.lineSeparator());
                    sb.delete(0, sb.length());
                    continue;
                }
                sb.append(line);
                if ((line == null || line.isEmpty()) && sb.toString().trim().isEmpty()) {
                    resSql.append(System.lineSeparator());
                    continue;
                }
                sb.append(System.lineSeparator());
            }
            DWSMigration.convertSql(resSql, sb, convertor);
            sb.delete(0, sb.length());
        }
        finally {
            LineIterator.closeQuietly((LineIterator)it);
            DWSMigration.LOGGER.info("complete convert file {}, spend {} ms", (Object)inputFile.getName(), (Object)(new Date().getTime() - start));
        }
        return resSql.toString();
    }

    private static String getEncodingFormat() {
        String encodingFormat;
        try {
            encodingFormat = ApplicationPropertyLoader.getStringProperty("encodingFormat");
        }
        catch (Exception e) {
            encodingFormat = "";
        }
        if (encodingFormat.equals("")) {
            encodingFormat = "UTF8";
            LOGGER.info("Files encoding is set to default UTF8");
        }
        LOGGER.info("Files encoding is set from configuration in Application properties file : {}", (Object)encodingFormat);
        return encodingFormat;
    }

    private void incrementFileCounter() {
        ++fileNumber;
    }

    private static String readPlSql(StringBuilder sb, LineIterator it, String line) {
        Matcher beginMatcher;
        String[] s = sb.toString().split("\r?\n");
        String plsql = "";
        for (String value : s) {
            if (SqlString.isSqlComment(value)) continue;
            plsql = plsql + value;
        }
        plsql = plsql + line;
        Matcher plsqlMatcher = PLSQL_CREATE_FINDER.matcher(plsql);
        String plsqlName = null;
        if (plsqlMatcher.matches() && it.hasNext()) {
            String type = plsqlMatcher.group(2).replace(" ", "");
            plsqlName = plsqlMatcher.group(4);
            if (plsqlName.contains(".")) {
                plsqlName = plsqlName.substring(plsqlName.lastIndexOf(".") + 1);
            }
            sb.append(line).append('\n');
            line = it.nextLine();
            while (!DWSMigration.plsqlEnd(plsqlName, type, line, sb) && it.hasNext() || line.endsWith("*/")) {
                sb.append(line).append('\n');
                if (!it.hasNext()) break;
                line = it.nextLine();
            }
        }
        if ((beginMatcher = PLSQL_BEGIN_FINDER.matcher(plsql)).matches()) {
            sb.append(line).append('\n');
            if (it.hasNext()) {
                line = it.nextLine();
                while (!line.trim().equalsIgnoreCase("END;") && it.hasNext()) {
                    sb.append(line).append('\n');
                    if (!it.hasNext()) break;
                    line = it.nextLine();
                }
            }
            if (line.trim().equalsIgnoreCase("END;") && it.hasNext()) {
                sb.append(line).append('\n');
                line = it.nextLine();
            }
        }
        return line;
    }

    private static void convertSql(StringBuilder resSql, StringBuilder sb, DatabaseConvertor convertor) {
        try {
            long start = new Date().getTime();
            convertor.reset();
            ISqlString str = null;
            String sourceSql = DWSMigration.handleSourceSql(sb);
            convertor.parse(sourceSql);
            str = convertor.convert();
            SqlFormatter.Formatter of = SqlFormatter.of((Dialect)Dialect.PostgreSql).extend(cfg -> cfg.withIndexedPlaceholderTypes(Collections.emptyList()).plusSpecialWordChars(Arrays.asList("$", "{", "}", "`", "*/")));
            resSql.append(SqlString.handleFlagSign(SqlString.handleErrorRes(of.format(str.toString()))));
        }
        catch (Exception e) {
            resSql.append("/* sql not support :").append(e.getMessage()).append("\r\n").append(sb.toString()).append("*/");
        }
    }

    private static String handleSourceSql(StringBuilder sb) {
        return sb.toString().replace("&apos;", "'");
    }

    private static boolean plsqlEnd(String plsqlName, String type, String line, StringBuilder sb) {
        String lineTrim = line.trim();
        String stringTrim = sb.toString().trim();
        return stringTrim.endsWith(";") && lineTrim.equalsIgnoreCase("/") && !lineTrim.endsWith("*/") || lineTrim.equalsIgnoreCase("END_PROC;") || lineTrim.equalsIgnoreCase("END;") && !type.equalsIgnoreCase("PACKAGEBODY") && stringTrim.endsWith(";") || lineTrim.equalsIgnoreCase("END " + plsqlName + ";");
    }
}

