/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle;

import com.huawei.hwclouds.migration.common.config.PropertyLoader;
import com.huawei.hwclouds.migration.common.util.ParserRuntimeException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DWSMigrationService {
    private static final Logger LOGGER = LogManager.getLogger(DWSMigrationService.class);
    private static final Map<String, Map<String, String>> PACKAGE_TYPE_MAP = new ConcurrentHashMap<String, Map<String, String>>(10);
    private static final Map<String, Map<String, String>> PACKAGE_OUTPUT_MAP = new ConcurrentHashMap<String, Map<String, String>>(10);

    public static void writePropertiesData(String propertiesFileName, Map<String, String> data) {
        try {
            PropertyLoader.writePropertyFile(propertiesFileName, data);
        }
        catch (ParserRuntimeException migExp) {
            LOGGER.error("Errored out while saving package and its corresponding function/procedure names.");
        }
    }

    public static Map<String, Map<String, String>> getPackageTypeMap() {
        return PACKAGE_TYPE_MAP;
    }

    public static Map<String, String> getPackageTypeMap(String packageName) {
        if (packageName == null || packageName.isEmpty()) {
            return null;
        }
        return PACKAGE_TYPE_MAP.get(packageName);
    }

    public static void addPackageType(String pkgName, Map<String, String> packageType) {
        PACKAGE_TYPE_MAP.put(pkgName, packageType);
    }

    public static Map<String, Map<String, String>> getPackageOutputMap() {
        return PACKAGE_OUTPUT_MAP;
    }

    public static Map<String, String> getPackageOutputMap(String packageName) {
        if (packageName == null || packageName.isEmpty()) {
            return null;
        }
        return PACKAGE_OUTPUT_MAP.get(packageName);
    }

    public static void addPackageOutput(String pkgName, Map<String, String> packageType) {
        PACKAGE_OUTPUT_MAP.put(pkgName, packageType);
    }
}

