/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle;

import com.huawei.db.migration.exception.ParserException;
import com.huawei.db.migration.interfaces.DatabaseConvertor;
import com.huawei.hwclouds.migration.common.config.ConvertConfig;
import com.huawei.hwclouds.migration.common.config.PropertyLoader;
import com.huawei.hwclouds.migration.oracle.DWSConfig;
import com.huawei.hwclouds.migration.oracle.DWSMigrationService;
import com.huawei.hwclouds.migration.oracle.UnParserContext;
import com.huawei.hwclouds.migration.oracle.config.PackageInfo;
import com.huawei.hwclouds.migration.oracle.nodes.SqlRoot;
import com.huawei.hwclouds.migration.oracle.parser.OracleEntranceParser;
import com.huawei.hwclouds.migration.oracle.util.ConfigUtil;
import com.huawei.hwclouds.migration.oracle.util.SqlDialect;
import com.huawei.hwclouds.migration.oracle.util.SqlString;
import com.huawei.hwclouds.migration.oracle.writer.SqlPrettyWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OracleConvertor
implements DatabaseConvertor {
    private static final Logger LOGGER = LogManager.getLogger(OracleConvertor.class);
    private SqlRoot root = null;
    private SqlDialect dialect = SqlDialect.DWS;
    private DWSConfig defaultConfig;
    private Map<String, ConvertConfig> tableConfigs = new HashMap<String, ConvertConfig>();

    public OracleConvertor(Map<String, DWSConfig> configs) {
        this(null, configs);
    }

    public OracleConvertor(DWSConfig dwsConfig, Map<String, DWSConfig> configs) {
        this.defaultConfig = dwsConfig == null ? DWSConfig.buildConfig() : dwsConfig;
        Map<String, DWSConfig> tableDefaultConfigs = DWSConfig.loadTableConfigs();
        for (Map.Entry<String, DWSConfig> et : tableDefaultConfigs.entrySet()) {
            this.tableConfigs.put(et.getKey().toUpperCase(Locale.US), et.getValue().clone().merge(this.defaultConfig));
        }
        if (configs != null) {
            for (Map.Entry<String, DWSConfig> et : configs.entrySet()) {
                this.tableConfigs.put(et.getKey().toUpperCase(Locale.US), et.getValue().clone().merge(this.defaultConfig));
            }
        }
    }

    public void parse(String sql) throws ParserException {
        OracleEntranceParser parser = new OracleEntranceParser();
        this.root = parser.parse(sql);
    }

    public SqlString convert() throws ParserException {
        if (this.root == null) {
            throw new ParserException("No Parse Sql Defined");
        }
        UnParserContext context = new UnParserContext();
        SqlPrettyWriter writer = new SqlPrettyWriter(this.dialect, this.defaultConfig, this.tableConfigs);
        this.root.unParse(writer, context);
        if (context.getPackageInfo() != null) {
            try {
                this.writerPackageMapper(context.getPackageInfo(), writer);
            }
            catch (IOException e) {
                LOGGER.error("Get package mapper error");
            }
        }
        return writer.toSqlString();
    }

    private String doResSqlReplace(Map<String, String> map, String s) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            s = s.replaceAll(entry.getKey(), entry.getValue());
        }
        return s;
    }

    private void writerPackageMapper(PackageInfo packageInfo, SqlPrettyWriter writer) throws IOException {
        ConvertConfig config = writer.getConfig("param.config.flag");
        boolean refresh = ConfigUtil.getConfigValue(config, "table.plsql.pkgRefresh", "false").equalsIgnoreCase("true");
        Map<String, String> typeMap = packageInfo.getTypeMap();
        Map<String, Map<String, String>> packageTypeMap = DWSMigrationService.getPackageTypeMap();
        if (!(typeMap.isEmpty() || !refresh && packageTypeMap.containsKey(packageInfo.getPkgName().toUpperCase(Locale.ROOT)))) {
            packageTypeMap.put(packageInfo.getPkgName().toUpperCase(Locale.ROOT), typeMap);
            DWSMigrationService.writePropertiesData("packageTypeMapper/" + packageInfo.getPkgName(), typeMap);
        }
        Map<String, String> outputMap = packageInfo.getOutputMap();
        Map<String, Map<String, String>> packageOutputMap = DWSMigrationService.getPackageOutputMap();
        if (!(outputMap.isEmpty() || !refresh && packageOutputMap.containsKey(packageInfo.getPkgName().toUpperCase(Locale.ROOT)))) {
            packageOutputMap.put(packageInfo.getPkgName().toUpperCase(Locale.ROOT), outputMap);
            DWSMigrationService.writePropertiesData("packageOutputMapper/" + packageInfo.getPkgName(), outputMap);
        }
    }

    public static void readPackageMapper() {
        block18: {
            try {
                File[] files;
                String packageOutputMapperPath;
                File packageOutputMapperFolder;
                File[] files2;
                String packageTypeMapperPath = PropertyLoader.getConfigFolder() + "/" + "packageTypeMapper";
                File packageTypeMapperFolder = new File(packageTypeMapperPath);
                if (packageTypeMapperFolder.exists() && packageTypeMapperFolder.isDirectory() && (files2 = packageTypeMapperFolder.listFiles()) != null) {
                    for (File file : files2) {
                        Properties prop = new Properties();
                        try (InputStream inputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
                            prop.load(inputStream);
                        }
                        Map<String, String> propertyMap = PropertyLoader.doGetPropsMap(prop);
                        String pkgName = file.getName().substring(0, file.getName().lastIndexOf("."));
                        DWSMigrationService.addPackageType(pkgName, propertyMap);
                    }
                }
                if (!(packageOutputMapperFolder = new File(packageOutputMapperPath = PropertyLoader.getConfigFolder() + "/" + "packageOutputMapper")).exists() || !packageOutputMapperFolder.isDirectory() || (files = packageTypeMapperFolder.listFiles()) == null) break block18;
                for (File file : files) {
                    Properties prop = new Properties();
                    try (InputStream inputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
                        prop.load(inputStream);
                    }
                    Map<String, String> propertyMap = PropertyLoader.doGetPropsMap(prop);
                    String pkgName = file.getName().substring(0, file.getName().lastIndexOf("."));
                    DWSMigrationService.addPackageOutput(pkgName, propertyMap);
                }
            }
            catch (IOException e) {
                LOGGER.error("Read package mapper error", (Throwable)e);
            }
        }
    }

    public void reset() {
        this.root = new SqlRoot();
    }
}

