/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle;

import com.huawei.hwclouds.migration.oracle.UnParserContext;
import com.huawei.hwclouds.migration.oracle.nodes.SqlCommentNode;
import com.huawei.hwclouds.migration.oracle.nodes.SqlNode;
import com.huawei.hwclouds.migration.oracle.nodes.SqlRoot;
import com.huawei.hwclouds.migration.oracle.writer.SqlWriter;

public interface UnParser<T extends SqlNode> {
    public void unParse(T var1, SqlWriter var2, UnParserContext var3);

    default public void unParseWithComment(T sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode instanceof SqlRoot) {
            this.unParse(sqlNode, writer, context);
            this.unParseComment((SqlRoot)sqlNode, writer);
            return;
        }
        if (sqlNode instanceof SqlCommentNode) {
            this.unParseComment((SqlCommentNode)sqlNode, writer);
            this.unParse(sqlNode, writer, context);
            return;
        }
        this.unParse(sqlNode, writer, context);
    }

    default public void unParseComment(SqlCommentNode comments, SqlWriter writer) {
        if (comments.getComments() == null || comments.getComments().isEmpty()) {
            return;
        }
        comments.getComments().stream().map(stream -> {
            if (stream.trim().startsWith("#")) {
                StringBuilder sb = new StringBuilder("--");
                int hashtagStart = 0;
                int hashtagEnd = 0;
                char[] cs = stream.toCharArray();
                for (int index = 0; index < cs.length; ++index) {
                    if (cs[index] == '#') {
                        if (hashtagStart == 0) {
                            hashtagStart = index;
                        }
                        if (hashtagStart == 0 || hashtagEnd == 0) continue;
                        sb.append(cs[index]);
                        continue;
                    }
                    if (hashtagStart != 0 && hashtagEnd == 0) {
                        hashtagEnd = index;
                    }
                    sb.append(cs[index]);
                }
                return sb.toString();
            }
            return stream;
        }).forEach(s -> writer.append((String)s));
    }
}

