/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.parser.util;

import com.huawei.hwclouds.migration.oracle.model.Expression;
import com.huawei.hwclouds.migration.oracle.model.Identifier;
import com.huawei.hwclouds.migration.oracle.nodes.SqlNodeList;
import com.huawei.hwclouds.migration.oracle.parser.OracleParser;
import com.huawei.hwclouds.migration.oracle.parser.visitor.ExpressionVisitor;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;

public class OptionCommonUtil {
    public static SqlNodeList<Identifier> optionColumn(List<OracleParser.ColumnNameContext> columnNames) {
        SqlNodeList<Identifier> columns = new SqlNodeList<Identifier>();
        for (int i = 0; i < columnNames.size(); ++i) {
            columns.addNode(new Identifier(columnNames.get(i).getText()));
        }
        return columns;
    }

    public static List<Expression> getSqlExpression(List<OracleParser.ExpressionContext> expressionList) {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        for (int i = 0; i < expressionList.size(); ++i) {
            expressions.add((Expression)new ExpressionVisitor().visit((ParseTree)expressionList.get(i)));
        }
        return expressions;
    }

    public static String getWriteClause(OracleParser.WriteClauseContext writeClause) {
        StringBuilder sb = new StringBuilder();
        sb.append("WRITE");
        if (writeClause.WAIT() != null) {
            sb.append(" WAIT");
        }
        if (writeClause.NOWAIT() != null) {
            sb.append(" NOWAIT");
        }
        if (writeClause.IMMEDIATE() != null) {
            sb.append(" IMMEDIATE");
        }
        if (writeClause.BATCH() != null) {
            sb.append(" BATCH");
        }
        return sb.toString();
    }
}

