/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.parser.visitor;

import com.huawei.hwclouds.migration.oracle.model.CreateSchema;
import com.huawei.hwclouds.migration.oracle.model.CreateSchemaDetail;
import com.huawei.hwclouds.migration.oracle.model.CreateTable;
import com.huawei.hwclouds.migration.oracle.model.CreateView;
import com.huawei.hwclouds.migration.oracle.model.Grant;
import com.huawei.hwclouds.migration.oracle.model.Identifier;
import com.huawei.hwclouds.migration.oracle.parser.OracleParser;
import com.huawei.hwclouds.migration.oracle.parser.visitor.AbstractVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.CreateTableVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.CreateViewVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.GrantStatementVisitor;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;

public class CreateSchemaVisitor
extends AbstractVisitor<CreateSchema> {
    private CreateSchema createSchema = new CreateSchema();

    @Override
    protected CreateSchema defaultResult() {
        return this.createSchema;
    }

    @Override
    public CreateSchema visitCreateSchema(OracleParser.CreateSchemaContext ctx) {
        this.createSchema.setAuthorization(ctx.AUTHORIZATION() != null);
        this.createSchema.setUserName(new Identifier(ctx.schemaName().getText()));
        List<OracleParser.SchemaOptionsContext> schemaOptionsContexts = ctx.schemaOptions();
        ArrayList<CreateSchemaDetail> schemaDetails = new ArrayList<CreateSchemaDetail>();
        for (int i = 0; i < schemaOptionsContexts.size(); ++i) {
            CreateSchemaDetail schemaDetail = new CreateSchemaDetail();
            OracleParser.SchemaOptionsContext schemaOptions = schemaOptionsContexts.get(0);
            if (schemaOptions.createTable() != null) {
                CreateTable createTable = (CreateTable)new CreateTableVisitor().visit((ParseTree)schemaOptions.createTable());
                schemaDetail.setCreateTable(createTable);
            } else if (schemaOptions.createView() != null) {
                CreateView createView = (CreateView)new CreateViewVisitor().visit((ParseTree)schemaOptions.createView());
                schemaDetail.setCreateView(createView);
            } else {
                Grant grant = (Grant)new GrantStatementVisitor().visit((ParseTree)schemaOptions.grantStatement());
                schemaDetail.setGrant(grant);
            }
            schemaDetails.add(schemaDetail);
        }
        this.createSchema.setSchemaDetails(schemaDetails);
        return this.defaultResult();
    }
}

