/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.parser.visitor;

import com.huawei.hwclouds.migration.oracle.model.CreateType;
import com.huawei.hwclouds.migration.oracle.model.ObjectTypeDef;
import com.huawei.hwclouds.migration.oracle.model.TypeBody;
import com.huawei.hwclouds.migration.oracle.model.TypeBodyElements;
import com.huawei.hwclouds.migration.oracle.model.TypeDefinition;
import com.huawei.hwclouds.migration.oracle.nodes.SqlNodeList;
import com.huawei.hwclouds.migration.oracle.parser.OracleParser;
import com.huawei.hwclouds.migration.oracle.parser.visitor.AbstractVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.ObjectTypeDefVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.TypeBodyElementsVisitor;
import org.antlr.v4.runtime.tree.ParseTree;

public class CreateTypeVisitor
extends AbstractVisitor<CreateType> {
    private CreateType createType = new CreateType();

    @Override
    protected CreateType defaultResult() {
        return this.createType;
    }

    @Override
    public CreateType visitCreateType(OracleParser.CreateTypeContext ctx) {
        this.createType.setExistReplace(ctx.REPLACE() != null);
        if (ctx.typeDefinition() != null) {
            this.createType.setTypeDefinition(this.getTypeDefinition(ctx.typeDefinition()));
        } else {
            this.createType.setTypeBody(this.getTypeBody(ctx.typeBody()));
        }
        return this.defaultResult();
    }

    private TypeDefinition getTypeDefinition(OracleParser.TypeDefinitionContext ctx) {
        TypeDefinition typeDefinition = new TypeDefinition();
        typeDefinition.setTypeName(ctx.typeName().getText());
        if (ctx.OID() != null) {
            typeDefinition.setOidString(ctx.CHAR_STRING().getText());
        }
        typeDefinition.setExistForce(ctx.FORCE() != null);
        if (ctx.objectTypeDef() != null) {
            typeDefinition.setObjectTypeDef((ObjectTypeDef)new ObjectTypeDefVisitor().visit((ParseTree)ctx.objectTypeDef()));
        }
        return typeDefinition;
    }

    private TypeBody getTypeBody(OracleParser.TypeBodyContext ctx) {
        TypeBody typeBody = new TypeBody();
        typeBody.setTypeName(ctx.typeName().getText());
        typeBody.setIsOrAs(ctx.IS() != null ? ctx.IS().getText() : ctx.AS().getText());
        SqlNodeList<TypeBodyElements> typeBodyElementsSqlNodeList = new SqlNodeList<TypeBodyElements>();
        for (int i = 0; i < ctx.typeBodyElements().size(); ++i) {
            typeBodyElementsSqlNodeList.addNode((TypeBodyElements)new TypeBodyElementsVisitor().visit((ParseTree)ctx.typeBodyElements().get(i)));
        }
        typeBody.setTypeBodyElementsSqlNodeList(typeBodyElementsSqlNodeList);
        return typeBody;
    }
}

