/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.parser.visitor;

import com.huawei.hwclouds.migration.oracle.model.Expression;
import com.huawei.hwclouds.migration.oracle.model.FunctionSubOptionClause;
import com.huawei.hwclouds.migration.oracle.model.Identifier;
import com.huawei.hwclouds.migration.oracle.model.ParallelEnableClause;
import com.huawei.hwclouds.migration.oracle.model.PartitionByClause;
import com.huawei.hwclouds.migration.oracle.model.ResultCacheClause;
import com.huawei.hwclouds.migration.oracle.model.StreamingClause;
import com.huawei.hwclouds.migration.oracle.model.TableName;
import com.huawei.hwclouds.migration.oracle.nodes.SqlNodeList;
import com.huawei.hwclouds.migration.oracle.parser.OracleParser;
import com.huawei.hwclouds.migration.oracle.parser.visitor.AbstractVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.ExpressionVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.TableNameVisitor;
import org.antlr.v4.runtime.tree.ParseTree;

public class FunctionSubOptionClauseVisitor
extends AbstractVisitor<FunctionSubOptionClause> {
    private FunctionSubOptionClause functionSubOptionClause = new FunctionSubOptionClause();

    @Override
    protected FunctionSubOptionClause defaultResult() {
        return this.functionSubOptionClause;
    }

    @Override
    public FunctionSubOptionClause visitFunctionSubOptionClause(OracleParser.FunctionSubOptionClauseContext ctx) {
        if (ctx.invokerRightsClause() != null) {
            if (ctx.invokerRightsClause().CURRENT_USER() != null) {
                this.functionSubOptionClause.setInvokerRightsClause("AUTHID CURRENT_USER");
            } else {
                this.functionSubOptionClause.setInvokerRightsClause("AUTHID DEFINER");
            }
        } else if (ctx.parallelEnableClause() != null) {
            this.getParallelEnableClause(ctx);
        } else if (ctx.resultCacheClause() != null) {
            ResultCacheClause resultCacheClause = new ResultCacheClause();
            resultCacheClause.setResultCache("RESULT_CACHE");
            if (ctx.resultCacheClause().reliesOnPart() != null) {
                SqlNodeList<TableName> reliesOnPartList = new SqlNodeList<TableName>();
                for (int i = 0; i < ctx.resultCacheClause().reliesOnPart().tableviewName().size(); ++i) {
                    reliesOnPartList.addNode((TableName)new TableNameVisitor().visit((ParseTree)ctx.resultCacheClause().reliesOnPart().tableviewName().get(i)));
                }
                resultCacheClause.setReliesOnPart(reliesOnPartList);
            }
            this.functionSubOptionClause.setResultCacheClause(resultCacheClause);
        } else {
            this.functionSubOptionClause.setExistDeterministic(true);
        }
        return this.defaultResult();
    }

    private void getParallelEnableClause(OracleParser.FunctionSubOptionClauseContext ctx) {
        ParallelEnableClause parallelEnableClause = new ParallelEnableClause();
        parallelEnableClause.setParallelEnable("PARALLEL_ENABLE");
        if (ctx.parallelEnableClause().partitionByClause() != null) {
            PartitionByClause partitionByClause = new PartitionByClause();
            OracleParser.PartitionByClauseContext partitionByClauseContext = ctx.parallelEnableClause().partitionByClause();
            partitionByClause.setExpression((Expression)new ExpressionVisitor().visit((ParseTree)partitionByClauseContext.expression()));
            if (partitionByClauseContext.ANY() != null) {
                partitionByClause.setPartitionType("ANY");
            } else {
                if (partitionByClauseContext.HASH() != null) {
                    partitionByClause.setPartitionType("HASH");
                } else if (partitionByClauseContext.RANGE() != null) {
                    partitionByClause.setPartitionType("RANGE");
                } else if (partitionByClauseContext.LIST() != null) {
                    partitionByClause.setPartitionType("LIST");
                }
                SqlNodeList<Identifier> parenColumnList = new SqlNodeList<Identifier>();
                for (int i = 0; i < partitionByClauseContext.parenColumnList().columnList().columnName().size(); ++i) {
                    parenColumnList.addNode(new Identifier(partitionByClauseContext.parenColumnList().columnList().columnName().get(i).getText()));
                }
                partitionByClause.setParenColumnList(parenColumnList);
                if (partitionByClauseContext.streamingClause() != null) {
                    StreamingClause streamingClause = new StreamingClause();
                    if (partitionByClauseContext.streamingClause().ORDER() != null) {
                        streamingClause.setOrderOrCluster("ORDER");
                    } else {
                        streamingClause.setOrderOrCluster("CLUSTER");
                    }
                    streamingClause.setExpression((Expression)new ExpressionVisitor().visit((ParseTree)partitionByClauseContext.streamingClause().expression()));
                    SqlNodeList<Identifier> parenColumnListInStreaming = new SqlNodeList<Identifier>();
                    for (int i = 0; i < partitionByClauseContext.streamingClause().parenColumnList().columnList().columnName().size(); ++i) {
                        parenColumnListInStreaming.addNode(new Identifier(partitionByClauseContext.streamingClause().parenColumnList().columnList().columnName().get(i).getText()));
                    }
                    partitionByClause.setStreamingClause(streamingClause);
                }
            }
            parallelEnableClause.setPartitionByClause(partitionByClause);
        }
        this.functionSubOptionClause.setParallelEnableClause(parallelEnableClause);
    }
}

