/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.parser.visitor;

import com.huawei.hwclouds.migration.common.util.ParserRuntimeException;
import com.huawei.hwclouds.migration.oracle.model.Grant;
import com.huawei.hwclouds.migration.oracle.model.GrantDetail;
import com.huawei.hwclouds.migration.oracle.model.GrantType;
import com.huawei.hwclouds.migration.oracle.model.Identifier;
import com.huawei.hwclouds.migration.oracle.nodes.SqlNodeList;
import com.huawei.hwclouds.migration.oracle.parser.OracleParser;
import com.huawei.hwclouds.migration.oracle.parser.visitor.AbstractVisitor;
import java.util.ArrayList;
import java.util.List;

public class GrantStatementVisitor
extends AbstractVisitor<Grant> {
    private Grant grant = new Grant();

    @Override
    protected Grant defaultResult() {
        return this.grant;
    }

    @Override
    public Grant visitGrantStatement(OracleParser.GrantStatementContext ctx) {
        List<OracleParser.ObjectPrivilegeDetailContext> objectPrivilegeDetails = ctx.objectPrivilegeDetail();
        if (objectPrivilegeDetails != null && objectPrivilegeDetails.size() > 0) {
            ArrayList<GrantDetail> grantDetails = new ArrayList<GrantDetail>();
            for (int i = 0; i < objectPrivilegeDetails.size(); ++i) {
                GrantDetail grantDetail = new GrantDetail();
                String type = objectPrivilegeDetails.get(i).objectPrivilege().getText();
                if (GrantType.find(type) == null) {
                    throw new ParserRuntimeException("Not supported");
                }
                grantDetail.setGrantType(GrantType.find(type));
                OracleParser.ParenColumnListContext parenColumnList = objectPrivilegeDetails.get(i).parenColumnList();
                if (parenColumnList != null && parenColumnList.columnList() != null) {
                    SqlNodeList<Identifier> columns = this.getColumnNames(parenColumnList.columnList());
                    grantDetail.setColumnNames(columns);
                }
                grantDetails.add(grantDetail);
            }
            this.grant.setGrantDetails(grantDetails);
        }
        if (ctx.grantObjectName() != null && ctx.grantObjectName().tableviewName() != null) {
            ArrayList<Identifier> onName = new ArrayList<Identifier>();
            String name = ctx.grantObjectName().tableviewName().getText();
            onName.add(new Identifier(name));
            this.grant.setOnName(onName);
        }
        List<OracleParser.GrantToDetailContext> grantToDetailContexts = ctx.grantToDetail();
        ArrayList<Identifier> toName = new ArrayList<Identifier>();
        for (int i = 0; i < grantToDetailContexts.size(); ++i) {
            OracleParser.GrantToDetailContext grantToDetail = grantToDetailContexts.get(0);
            if (grantToDetail.granteeName() != null) {
                toName.add(new Identifier(grantToDetail.granteeName().getText()));
                continue;
            }
            toName.add(new Identifier("PUBLIC"));
        }
        this.grant.setToName(toName);
        this.grant.setWithGrantOption(ctx.withGrantoption() != null);
        return this.defaultResult();
    }

    private SqlNodeList<Identifier> getColumnNames(OracleParser.ColumnListContext columnListContext) {
        SqlNodeList<Identifier> columnNames = new SqlNodeList<Identifier>();
        List<OracleParser.ColumnNameContext> columnNameContexts = columnListContext.columnName();
        for (int i = 0; i < columnNameContexts.size(); ++i) {
            columnNames.addNode(new Identifier(columnNameContexts.get(i).getText()));
        }
        return columnNames;
    }
}

