/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.parser.visitor;

import com.huawei.hwclouds.migration.oracle.model.Condition;
import com.huawei.hwclouds.migration.oracle.model.Expression;
import com.huawei.hwclouds.migration.oracle.model.Identifier;
import com.huawei.hwclouds.migration.oracle.model.JoinClause;
import com.huawei.hwclouds.migration.oracle.model.QueryPartitionClause;
import com.huawei.hwclouds.migration.oracle.model.SubQuery;
import com.huawei.hwclouds.migration.oracle.model.TableReference;
import com.huawei.hwclouds.migration.oracle.nodes.SqlNodeList;
import com.huawei.hwclouds.migration.oracle.parser.OracleParser;
import com.huawei.hwclouds.migration.oracle.parser.visitor.AbstractVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.ConditionVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.ExpressionVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.SubQueryVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.TableReferenceVisitor;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;

public class JoinClauseVisitor
extends AbstractVisitor<JoinClause> {
    @Override
    protected JoinClause defaultResult() {
        return null;
    }

    @Override
    public JoinClause visitJoinClause(OracleParser.JoinClauseContext ctx) {
        StringBuffer joinType;
        JoinClause joinClause = new JoinClause();
        if (ctx.joinPrePartition != null) {
            joinClause.setQueryPartitionClause(this.getJoinQueryPartition(ctx.joinPrePartition));
        }
        if (ctx.joinSufPartition != null) {
            joinClause.setJoinQueryPartition(this.getJoinQueryPartition(ctx.joinSufPartition));
        }
        if (ctx.joinOnPart() != null) {
            joinClause.setJoinOnPart((Condition)new ConditionVisitor().visit((ParseTree)ctx.joinOnPart().condition()));
        }
        joinClause.setSqlTableRef((TableReference)new TableReferenceVisitor().visit((ParseTree)ctx.tableRefAux()));
        if (ctx.joinUsingPart() != null) {
            List<OracleParser.ColumnNameContext> columnNames = ctx.joinUsingPart().parenColumnList().columnList().columnName();
            SqlNodeList<Identifier> columnNameList = new SqlNodeList<Identifier>();
            for (int i = 0; i < columnNames.size(); ++i) {
                columnNameList.addNode(new Identifier(columnNames.get(i).getText()));
            }
            joinClause.setJoinUsingPart(columnNameList);
        }
        if ((joinType = this.getJoinType(ctx)).length() != 0) {
            joinClause.setJoinType(joinType.toString());
        }
        return joinClause;
    }

    private StringBuffer getJoinType(OracleParser.JoinClauseContext ctx) {
        StringBuffer stringBuffer = new StringBuffer();
        if (ctx.CROSS() != null) {
            stringBuffer.append("CROSS ");
        }
        if (ctx.NATURAL() != null) {
            stringBuffer.append("NATURAL ");
        }
        if (ctx.INNER() != null) {
            stringBuffer.append("INNER ");
        }
        if (ctx.outerJoinType() != null) {
            stringBuffer.append(ctx.outerJoinType().outerJoinType1.getText());
            if (ctx.outerJoinType().OUTER() != null) {
                stringBuffer.append(" OUTER");
            }
        }
        return stringBuffer;
    }

    private QueryPartitionClause getJoinQueryPartition(OracleParser.QueryPartitionClauseContext joinPrePartition) {
        QueryPartitionClause queryPartitionClause = new QueryPartitionClause();
        queryPartitionClause.setBrackets(joinPrePartition.LEFT_PAREN() != null);
        if (joinPrePartition.expressions() != null) {
            SqlNodeList<Expression> expressions = new SqlNodeList<Expression>();
            List<OracleParser.ExpressionContext> expressionList = joinPrePartition.expressions().expression();
            for (int i = 0; i < expressionList.size(); ++i) {
                expressions.addNode((Expression)new ExpressionVisitor().visit((ParseTree)expressionList.get(i)));
            }
            queryPartitionClause.setExpressionList(expressions);
        }
        if (joinPrePartition.subQuery() != null) {
            queryPartitionClause.setSubQuery((SubQuery)new SubQueryVisitor().visit((ParseTree)joinPrePartition.subQuery()));
        }
        return queryPartitionClause;
    }
}

