/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.parser.visitor;

import com.huawei.hwclouds.migration.oracle.model.LobStorageClause;
import com.huawei.hwclouds.migration.oracle.model.LobStorageParameters;
import com.huawei.hwclouds.migration.oracle.model.StorageParameter;
import com.huawei.hwclouds.migration.oracle.nodes.SqlNodeList;
import com.huawei.hwclouds.migration.oracle.parser.OracleParser;
import com.huawei.hwclouds.migration.oracle.parser.visitor.AbstractVisitor;
import java.util.ArrayList;

public class LobStorageClauseVisitor
extends AbstractVisitor<LobStorageClause> {
    private LobStorageClause lobStorageClause = new LobStorageClause();

    @Override
    protected LobStorageClause defaultResult() {
        return this.lobStorageClause;
    }

    @Override
    public LobStorageClause visitLobStorageClause(OracleParser.LobStorageClauseContext ctx) {
        ArrayList<String> lobItem = new ArrayList<String>();
        for (int i = 0; i < ctx.lobItem().size(); ++i) {
            lobItem.add(ctx.lobItem().get(i).getText());
        }
        this.lobStorageClause.setLobItem(lobItem);
        SqlNodeList<StorageParameter> storageParameterSqlNodeList = new SqlNodeList<StorageParameter>();
        for (int i = 0; i < ctx.storageParameter().size(); ++i) {
            storageParameterSqlNodeList.addNode(this.dealWithStoragePara(ctx.storageParameter().get(i)));
        }
        this.lobStorageClause.setStorageParameterSqlNodeList(storageParameterSqlNodeList);
        return this.defaultResult();
    }

    private StorageParameter dealWithStoragePara(OracleParser.StorageParameterContext storageParameterContext) {
        StorageParameter storageParameter = new StorageParameter();
        if (storageParameterContext.lobStorageParameters().size() > 0) {
            SqlNodeList<LobStorageParameters> lobStorageParametersSqlNodeList = new SqlNodeList<LobStorageParameters>();
            for (int i = 0; i < storageParameterContext.lobStorageParameters().size(); ++i) {
                LobStorageParameters lobStorageParameters = new LobStorageParameters();
                if (storageParameterContext.lobStorageParameters().get(i).TABLESPACE() != null) {
                    lobStorageParameters.setTablespaceName(storageParameterContext.lobStorageParameters().get(i).idExpression().getText());
                } else if (storageParameterContext.lobStorageParameters().get(i).lobParameters() != null) {
                    if (storageParameterContext.lobStorageParameters().get(i).storageClause() != null) {
                        lobStorageParameters.setStorageClause(this.dealWithStorageClause(storageParameterContext.lobStorageParameters().get(i).storageClause()));
                    }
                    lobStorageParameters.setLobParameters(this.dealWithLobParameters(storageParameterContext.lobStorageParameters().get(i).lobParameters()));
                } else {
                    lobStorageParameters.setStorageClause(this.dealWithStorageClause(storageParameterContext.lobStorageParameters().get(i).storageClause()));
                }
                lobStorageParametersSqlNodeList.addNode(lobStorageParameters);
            }
            storageParameter.setLobStorageParametersSqlNodeList(lobStorageParametersSqlNodeList);
        } else {
            storageParameter.setParameter(storageParameterContext.getText());
        }
        return storageParameter;
    }

    private String dealWithLobParameters(OracleParser.LobParametersContext lobParametersContext) {
        String lobParameters = "";
        for (int i = 0; i < lobParametersContext.getChildCount(); ++i) {
            if (lobParametersContext.getChild(i).getChildCount() > 0) {
                for (int j = 0; j < lobParametersContext.getChild(i).getChildCount(); ++j) {
                    lobParameters = lobParameters + lobParametersContext.getChild(i).getChild(j).getText() + " ";
                }
                continue;
            }
            lobParameters = lobParameters + lobParametersContext.getChild(i).getText() + " ";
        }
        return lobParameters;
    }

    private String dealWithStorageClause(OracleParser.StorageClauseContext storageClauseContext) {
        String storageClause = "";
        for (int i = 0; i < storageClauseContext.getChildCount(); ++i) {
            storageClause = storageClause + storageClauseContext.getChild(i).getText() + " ";
        }
        return storageClause;
    }
}

