/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.parser.visitor;

import com.huawei.hwclouds.migration.oracle.model.ElementSpec;
import com.huawei.hwclouds.migration.oracle.model.ElementSpecOptions;
import com.huawei.hwclouds.migration.oracle.model.Expression;
import com.huawei.hwclouds.migration.oracle.model.ObjectMemberSpec;
import com.huawei.hwclouds.migration.oracle.model.TypeSpec;
import com.huawei.hwclouds.migration.oracle.nodes.SqlNodeList;
import com.huawei.hwclouds.migration.oracle.parser.OracleParser;
import com.huawei.hwclouds.migration.oracle.parser.visitor.AbstractVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.ElementSpecOptionsVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.ExpressionVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.TypeSpecVisitor;
import java.util.ArrayList;
import org.antlr.v4.runtime.tree.ParseTree;

public class ObjectMemberSpecVisitor
extends AbstractVisitor<ObjectMemberSpec> {
    private ObjectMemberSpec objectMemberSpec = new ObjectMemberSpec();

    @Override
    protected ObjectMemberSpec defaultResult() {
        return this.objectMemberSpec;
    }

    @Override
    public ObjectMemberSpec visitObjectMemberSpec(OracleParser.ObjectMemberSpecContext ctx) {
        if (ctx.identifier() != null) {
            this.objectMemberSpec.setIdentifier(ctx.identifier().getText());
            this.objectMemberSpec.setTypeSpec((TypeSpec)new TypeSpecVisitor().visit((ParseTree)ctx.typeSpec()));
            if (ctx.sqlObjectTypeAttr() != null) {
                this.objectMemberSpec.setSqlObjectTypeAttr((Expression)new ExpressionVisitor().visit((ParseTree)ctx.sqlObjectTypeAttr().expression()));
            }
        } else {
            OracleParser.ElementSpecContext elementSpecContext = ctx.elementSpec();
            ElementSpec elementSpec = new ElementSpec();
            if (elementSpecContext.modifierClause() != null) {
                OracleParser.ModifierClauseContext modifierClauseContext = elementSpecContext.modifierClause();
                String res = "";
                if (modifierClauseContext.NOT() != null) {
                    res = res + "NOT ";
                }
                res = modifierClauseContext.INSTANTIABLE() != null ? res + "INSTANTIABLE" : (modifierClauseContext.FINAL() != null ? res + "FINAL" : res + "OVERRIDING");
                elementSpec.setModifierClause(res);
            }
            SqlNodeList<ElementSpecOptions> elementSpecOptionsSqlNodeList = new SqlNodeList<ElementSpecOptions>();
            for (int i = 0; i < elementSpecContext.elementSpecOptions().size(); ++i) {
                elementSpecOptionsSqlNodeList.addNode((ElementSpecOptions)new ElementSpecOptionsVisitor().visit((ParseTree)elementSpecContext.elementSpecOptions().get(i)));
            }
            elementSpec.setElementSpecOptionsSqlNodeList(elementSpecOptionsSqlNodeList);
            if (elementSpecContext.pragmaClause() != null) {
                OracleParser.PragmaClauseContext pragmaClauseContext = elementSpecContext.pragmaClause();
                ArrayList<String> pragmaElements = new ArrayList<String>();
                for (int i = 0; i < pragmaClauseContext.pragmaElements().size(); ++i) {
                    pragmaElements.add(pragmaClauseContext.pragmaElements().get(i).getText());
                }
                elementSpec.setPragmaClause(pragmaElements);
            }
            this.objectMemberSpec.setElementSpec(elementSpec);
        }
        return this.defaultResult();
    }
}

