/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.parser.visitor;

import com.huawei.hwclouds.migration.oracle.model.Expression;
import com.huawei.hwclouds.migration.oracle.model.NestedTableTypeDef;
import com.huawei.hwclouds.migration.oracle.model.ObjectAsPart;
import com.huawei.hwclouds.migration.oracle.model.ObjectMemberSpec;
import com.huawei.hwclouds.migration.oracle.model.ObjectTypeDef;
import com.huawei.hwclouds.migration.oracle.model.SqlObjectType;
import com.huawei.hwclouds.migration.oracle.model.TypeSpec;
import com.huawei.hwclouds.migration.oracle.model.VarrayTypeDef;
import com.huawei.hwclouds.migration.oracle.nodes.SqlNodeList;
import com.huawei.hwclouds.migration.oracle.parser.OracleParser;
import com.huawei.hwclouds.migration.oracle.parser.visitor.AbstractVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.ExpressionVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.NestedTableTypeDefVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.ObjectMemberSpecVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.TypeSpecVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.VarrayTypeDefVisitor;
import java.util.ArrayList;
import org.antlr.v4.runtime.tree.ParseTree;

public class ObjectTypeDefVisitor
extends AbstractVisitor<ObjectTypeDef> {
    private ObjectTypeDef objectTypeDef = new ObjectTypeDef();

    @Override
    protected ObjectTypeDef defaultResult() {
        return this.objectTypeDef;
    }

    @Override
    public ObjectTypeDef visitObjectTypeDef(OracleParser.ObjectTypeDefContext ctx) {
        int i;
        if (ctx.invokerRightsClause() != null) {
            if (ctx.invokerRightsClause().CURRENT_USER() != null) {
                this.objectTypeDef.setInvokerRightsClause(" AUTHID CURRENT_USER");
            } else {
                this.objectTypeDef.setInvokerRightsClause(" AUTHID DEFINER");
            }
        }
        if (ctx.objectAsPart() != null) {
            this.objectTypeDef.setObjectAsPart(this.getObjectAsPart(ctx.objectAsPart()));
        } else {
            this.objectTypeDef.setObjectUnderPart((TypeSpec)new TypeSpecVisitor().visit((ParseTree)ctx.objectUnderPart().typeSpec()));
        }
        if (ctx.sqlObjectType() != null) {
            this.objectTypeDef.setSqlObjectType(this.getSqlObjectType(ctx.sqlObjectType()));
        }
        if (ctx.objectMemberSpec() != null && ctx.objectMemberSpec().size() > 0) {
            SqlNodeList<ObjectMemberSpec> objectMemberSpecSqlNodeList = new SqlNodeList<ObjectMemberSpec>();
            for (i = 0; i < ctx.objectMemberSpec().size(); ++i) {
                objectMemberSpecSqlNodeList.addNode((ObjectMemberSpec)new ObjectMemberSpecVisitor().visit((ParseTree)ctx.objectMemberSpec().get(i)));
            }
            this.objectTypeDef.setObjectMemberSpecSqlNodeList(objectMemberSpecSqlNodeList);
        }
        if (ctx.modifierClause() != null && ctx.modifierClause().size() > 0) {
            ArrayList<String> modifierClause = new ArrayList<String>();
            for (i = 0; i < ctx.modifierClause().size(); ++i) {
                String res = "";
                OracleParser.ModifierClauseContext modifierClauseContext = ctx.modifierClause().get(i);
                if (modifierClauseContext.NOT() != null) {
                    res = res + "NOT ";
                }
                res = modifierClauseContext.INSTANTIABLE() != null ? res + "INSTANTIABLE" : (modifierClauseContext.FINAL() != null ? res + "FINAL" : res + "OVERRIDING");
                modifierClause.add(res);
            }
            this.objectTypeDef.setModifierClause(modifierClause);
        }
        return this.defaultResult();
    }

    private SqlObjectType getSqlObjectType(OracleParser.SqlObjectTypeContext ctx) {
        SqlObjectType sqlObjectType = new SqlObjectType();
        sqlObjectType.setExpression((Expression)new ExpressionVisitor().visit((ParseTree)ctx.expression()));
        if (ctx.SQLDATA() != null) {
            sqlObjectType.setData("SQLDATA");
        } else if (ctx.CUSTOMDATUM() != null) {
            sqlObjectType.setData("CUSTOMDATUM");
        } else {
            sqlObjectType.setData("ORADATA");
        }
        return sqlObjectType;
    }

    private ObjectAsPart getObjectAsPart(OracleParser.ObjectAsPartContext ctx) {
        ObjectAsPart objectAsPart = new ObjectAsPart();
        objectAsPart.setIsOrAs(ctx.IS() != null ? ctx.IS().getText() : ctx.AS().getText());
        objectAsPart.setExistObject(ctx.OBJECT() != null);
        if (ctx.varrayTypeDef() != null) {
            objectAsPart.setVarrayTypeDef((VarrayTypeDef)new VarrayTypeDefVisitor().visit((ParseTree)ctx.varrayTypeDef()));
        } else if (ctx.nestedTableTypeDef() != null) {
            objectAsPart.setNestedTableTypeDef((NestedTableTypeDef)new NestedTableTypeDefVisitor().visit((ParseTree)ctx.nestedTableTypeDef()));
        }
        return objectAsPart;
    }
}

